/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.db.CallableStatementMetaData;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.StatementMetaData;
import com.ibm.ivj.db.ibeans.ErrorMessageDialog;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.ivj.db.uibeans.SpecsLocator;
import com.ibm.uvm.abt.edit.codeGeneration.CgClassDescription;
import com.ibm.uvm.abt.edit.codeGeneration.CgGenerationException;
import com.ibm.uvm.abt.edit.codeGeneration.CgMethodDescription;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

public class CommonUtil {
    public static final String dataVer = "/*V2.0";
    public static final String dataStart = "**start of SQL Assist data**";
    public static final String dataEnd = "**end of SQL Assist data**/";
    public static final String userCodeStart1 = "// user code begin {1}";
    public static final String userCodeEnd1 = "// user code end {1}";
    public static final String userCodeStart2 = "// user code begin {2}";
    public static final String userCodeEnd2 = "// user code end {2}";
    public static final String connectSpecClassName = "com.ibm.db.DatabaseConnection";
    public static final String logonSpecClassName = "com.ibm.db.base.DatabaseLogonSpec";
    public static final String querySpecClassName = "com.ibm.db.StatementMetaData";
    public static final String spSpecClassName = "com.ibm.db.CallableStatementMetaData";
    public static final String modifySpecClassName = "com.ibm.db.SQLStatementMetaData";
    public static final String dbAccessClassName = "com.ibm.ivj.db.uibeans.DatabaseAccess";
    public static final String[] driverName = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", "COM.ibm.db2.jdbc.net.DB2Driver", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle.jdbc.driver.OracleDriver", "com.sybase.jdbc.SybDriver"};
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";
    static Class class$java$lang$Throwable;
    static Class class$com$ibm$db$DataException;

    public static void buildCons(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public static String formatMsg(String string, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray[n] = "";
            }
            ++n;
        }
        return MessageFormat.format(string, objectArray);
    }

    public static String getClassName(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        String string2 = string.substring(0, string.lastIndexOf("."));
        return string2;
    }

    public static Frame getFrameForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return CommonUtil.getFrameForComponent(component.getParent());
    }

    public static String getMessage(String string) {
        return IBMIVJDBDialog.getText(string);
    }

    public static String getMethodName(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static void handleException(String string, Throwable throwable, Component component) {
        throwable.printStackTrace(System.out);
        String string2 = throwable.getMessage();
        if (string2 == null || string2.equals("")) {
            string2 = CommonUtil.getMessage(IBMIVJDBDialog.exceptSys);
        }
        if (component == null) {
            new ErrorMessageDialog(String.valueOf(string) + " - " + string2);
        } else {
            new ErrorMessageDialog(String.valueOf(string) + " - " + string2, component);
        }
    }

    public static void handleException(Throwable throwable, Component component) {
        throwable.printStackTrace(System.out);
        String string = throwable.getMessage();
        if (string == null || string.equals("")) {
            string = CommonUtil.getMessage(IBMIVJDBDialog.exceptSys);
        }
        if (component == null) {
            new ErrorMessageDialog(string);
        } else {
            new ErrorMessageDialog(string, component);
        }
    }

    public static DatabaseConnection invokeConnectionMethod(SpecsLocator specsLocator, Button button, Component component) {
        DatabaseConnection databaseConnection = null;
        try {
            databaseConnection = specsLocator.getConnectSpec();
        }
        catch (ClassNotFoundException classNotFoundException) {
            CommonUtil.handleException(CommonUtil.getMessage(IBMIVJDBDialog.noDBAClassException), classNotFoundException, component);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.noDBAClassException)) + ": " + specsLocator.getConnectBundleName(), noClassDefFoundError, component);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.noConnectionException)) + ": " + specsLocator.getConnectBundleName() + "." + specsLocator.getConnectName() + "()", noSuchMethodException, component);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.exceptSys)) + " " + CommonUtil.getMessage(IBMIVJDBDialog.invokeConnectionError) + ": " + specsLocator.getConnectBundleName() + "." + specsLocator.getConnectName() + "()", throwable, component);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, component);
        }
        return databaseConnection;
    }

    public static StatementMetaData invokeQueryMethod(SpecsLocator specsLocator, Button button, Button button2, Component component) {
        StatementMetaData statementMetaData = null;
        try {
            statementMetaData = specsLocator.getSqlSpec();
        }
        catch (ClassNotFoundException classNotFoundException) {
            CommonUtil.handleException(CommonUtil.getMessage(IBMIVJDBDialog.noDBAClassException), classNotFoundException, component);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.noDBAClassException)) + ": " + specsLocator.getSqlBundleName(), noClassDefFoundError, component);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.exceptSys)) + " " + CommonUtil.getMessage(IBMIVJDBDialog.invokeSqlError) + ": " + specsLocator.getSqlBundleName() + "." + specsLocator.getSqlName() + "()", throwable, component);
            if (button != null) {
                button.setEnabled(true);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.noSQLException)) + ": " + specsLocator.getSqlBundleName() + "." + specsLocator.getSqlName() + "()", noSuchMethodException, component);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, component);
        }
        return statementMetaData;
    }

    public static CallableStatementMetaData invokeSPMethod(SpecsLocator specsLocator, Button button, Button button2, Component component) {
        CallableStatementMetaData callableStatementMetaData = null;
        try {
            callableStatementMetaData = specsLocator.getCallableSpec();
        }
        catch (ClassNotFoundException classNotFoundException) {
            CommonUtil.handleException(CommonUtil.getMessage(IBMIVJDBDialog.noDBAClassException), classNotFoundException, component);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.noDBAClassException)) + ": " + specsLocator.getSqlBundleName(), noClassDefFoundError, component);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.exceptSys)) + " " + CommonUtil.getMessage(IBMIVJDBDialog.invokeSPError) + ": " + specsLocator.getSqlBundleName() + "." + specsLocator.getSqlName() + "()", throwable, component);
            if (button != null) {
                button.setEnabled(true);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            CommonUtil.handleException(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.noSQLException)) + ": " + specsLocator.getSqlBundleName() + "." + specsLocator.getSqlName() + "()", noSuchMethodException, component);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, component);
        }
        return callableStatementMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void methodCodeGen(String string, String string2, String string3, String string4, Component component) {
        int n;
        try {
            Class<?> clazz;
            CgClassDescription cgClassDescription = new CgClassDescription(Class.forName(string2));
            CgMethodDescription cgMethodDescription = new CgMethodDescription(string3, Class.forName(string));
            cgMethodDescription.setModifiers(9);
            cgMethodDescription.setMethodBody(string4);
            if (string.equals(connectSpecClassName)) {
                Class<?> clazz2 = class$com$ibm$db$DataException;
                if (clazz2 == null) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("com.ibm.db.DataException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz2 = class$com$ibm$db$DataException = clazz3;
                }
                cgMethodDescription.addException((Class)clazz2);
            }
            if ((clazz = class$java$lang$Throwable) == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("java.lang.Throwable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$java$lang$Throwable = clazz4;
            }
            cgMethodDescription.addException((Class)clazz);
            cgClassDescription.addMethod(cgMethodDescription);
            component.setCursor(Cursor.getPredefinedCursor(3));
            cgClassDescription.generate();
            component.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            CommonUtil.handleException(CommonUtil.getMessage(IBMIVJDBDialog.exceptMethodGen), classNotFoundException, component);
            component.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        catch (CgGenerationException cgGenerationException) {
            CommonUtil.handleException(CommonUtil.getMessage(IBMIVJDBDialog.exceptCodeGen), cgGenerationException, component);
            n = 0;
        }
        while (true) {
            if (n >= cgGenerationException.getErrors().length) {
                component.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            System.out.println("  " + cgGenerationException.getErrors()[n]);
            ++n;
        }
    }

    public static Canvas spacer(int n, int n2) {
        Canvas canvas = new Canvas();
        canvas.setSize(n, n2);
        return canvas;
    }

    public static Color vajColor() {
        return new Color(160, 160, 164);
    }

    public static Color vajColor1() {
        return new Color(160, 160, 164);
    }
}

