/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.ivj.db.ibeans.SPColumnObject;
import com.ibm.ivj.db.ibeans.SPObject;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.SchemaObject;
import com.ibm.sqlassist.common.TypeInfoObject;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;

public class DatabaseInfo {
    private DatabaseObject dbObject = null;
    private Vector procs = new Vector();
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseInfo() {
    }

    public DatabaseInfo(DatabaseObject databaseObject) {
        this.dbObject = databaseObject;
    }

    public void addProc(SPObject sPObject) {
        if (this.exists(sPObject)) {
            return;
        }
        String string = sPObject.getName();
        int n = 0;
        while (n < this.procs.size()) {
            SPObject sPObject2 = (SPObject)this.procs.elementAt(n);
            if (string.compareTo(sPObject2.getName()) < 0) {
                this.procs.insertElementAt(sPObject, n);
                return;
            }
            if (string.compareTo(sPObject2.getName()) == 0) {
                return;
            }
            ++n;
        }
        this.procs.addElement(sPObject);
    }

    private boolean exists(SPObject sPObject) {
        String string = sPObject.getName();
        int n = 0;
        while (n < this.procs.size()) {
            if (((SPObject)this.procs.elementAt(n)).getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public DatabaseObject getDBObject() {
        return this.dbObject;
    }

    public int getProc(String string) {
        int n = 0;
        while (n < this.getProcs().size()) {
            SPObject sPObject = (SPObject)this.getProcs().elementAt(n);
            if (sPObject.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Vector getProcs() {
        return this.procs;
    }

    private void processResultSet(ResultSet resultSet, String string) throws Exception {
        while (resultSet.next()) {
            this.addProc(new SPObject(this, resultSet, string));
        }
        resultSet.close();
    }

    void refreshProcList() throws Exception {
        this.procs.removeAllElements();
        SchemaObject schemaObject = null;
        boolean bl = true;
        int n = 0;
        while (n < this.dbObject.getSchemas().size()) {
            schemaObject = (SchemaObject)this.dbObject.getSchemas().elementAt(n);
            if (!schemaObject.getSelected()) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this.retrieveSP("%", "%");
        } else {
            n = 0;
            while (n < this.dbObject.getSchemas().size()) {
                schemaObject = (SchemaObject)this.dbObject.getSchemas().elementAt(n);
                if (schemaObject.getSelected()) {
                    this.retrieveSP(schemaObject.getName(), "%");
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.getProcs().size()) {
            ((SPObject)this.getProcs().elementAt(n)).retrieveColumns();
            ++n;
        }
    }

    public void retrieveSP(String string, String string2) throws UnsatisfiedLinkError, Exception {
        block11: {
            String string3;
            if (string == null) {
                string3 = this.dbObject.getLogin().toUpperCase();
            } else if (string.equals("")) {
                string3 = null;
            } else {
                string3 = string;
                if (!string3.startsWith("\"")) {
                    int n = 0;
                    while (n < this.dbObject.getSchemas().size()) {
                        SchemaObject schemaObject = (SchemaObject)this.dbObject.getSchemas().elementAt(n);
                        if (string3.equalsIgnoreCase(schemaObject.getName())) {
                            string3 = schemaObject.getName();
                            break;
                        }
                        ++n;
                    }
                }
            }
            DatabaseMetaData databaseMetaData = this.dbObject.getConnection().getMetaData();
            try {
                this.dbObject.setSupportsSchemas(databaseMetaData.supportsSchemasInTableDefinitions());
                this.dbObject.setSupportsMixedCaseQuotedIdentifiers(databaseMetaData.supportsMixedCaseQuotedIdentifiers());
                this.dbObject.setTypeInfo(new TypeInfoObject());
                this.dbObject.getTypeInfo().process(databaseMetaData.getTypeInfo());
            }
            catch (Exception exception) {}
            try {
                this.processResultSet(databaseMetaData.getProcedures(null, string3, string2), string);
            }
            catch (Exception exception) {
                if (this.procs.size() == 0 && string3 != null) break block11;
                throw exception;
            }
        }
    }

    public void setDBObject(DatabaseObject databaseObject) {
        this.dbObject = databaseObject;
    }

    public String toString(SPColumnObject sPColumnObject) {
        if (sPColumnObject == null) {
            return "";
        }
        String string = String.valueOf(sPColumnObject.getName()) + ", " + sPColumnObject.getTypeSize();
        return string;
    }
}

