/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.ivj.db.ibeans.QuerySpecification;
import com.ibm.uvm.abt.edit.DialogHelper;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ManualSQLDialog
extends Dialog
implements ActionListener,
WindowListener,
TextListener {
    private QuerySpecification parentRef = null;
    private Button ivjButtonCancel = null;
    private Button ivjButtonOK = null;
    private TextArea ivjTextArea = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public ManualSQLDialog(QuerySpecification querySpecification) {
        super(querySpecification.getParentFrame(), true);
        this.parentRef = querySpecification;
        try {
            this.initialize();
            DialogHelper.centerWindowOnComponent((Window)this, (Component)((Object)querySpecification));
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getButtonOK()) {
            this.connButtonOK();
        } else if (actionEvent.getSource() == this.getButtonCancel()) {
            this.dispose();
        }
    }

    private void connButtonOK() {
        try {
            this.generateSpecMethod();
            if (this.parentRef.getCreateQueryFlag()) {
                String string = this.parentRef.getQueryMethodName();
                this.parentRef.getPanelQuery().getChoice().add(string);
                this.parentRef.getPanelQuery().sortListItems();
                this.parentRef.getPanelQuery().selectListItem(string);
                this.parentRef.getPanelQuery().getButtonEdit().setEnabled(true);
                this.parentRef.getQueryEditor().getQLocator().setSqlName(string);
                this.parentRef.getQueryEditor().getQLocator().setSqlBundleName(this.parentRef.getQuerySpecPath());
            }
            this.parentRef.getQueryEditor().getSupport().firePropertyChange(null, null, null);
            this.dispose();
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    public void generateSpecMethod() {
        String string = this.getTextArea().getText();
        String string2 = null;
        String string3 = this.parentRef.getParentRef().getQueryType();
        string2 = string3.equals("Select") ? "com.ibm.db.StatementMetaData" : (string3.equals("Modify") ? "com.ibm.db.SQLStatementMetaData" : "com.ibm.db.CallableStatementMetaData");
        String string4 = "";
        int n = 0;
        while ((n = string.indexOf("\n")) >= 0) {
            string4 = n == 0 || string.charAt(n - 1) != '\r' ? string4.concat(string.substring(0, n)) : string4.concat(string.substring(0, n - 1));
            string4 = string4.concat("\\n");
            string = string.substring(n + 1);
        }
        string4 = string4.concat(string);
        int n2 = -1;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string4);
        while ((n2 = string4.indexOf("\"", n2 + 1)) != -1) {
            stringBuffer.insert(n2 + n3, "\\");
            ++n3;
        }
        this.parentRef.getPanelQuery().getTextArea().setText(new String(stringBuffer));
        String string5 = this.parentRef.getQueryMethodName();
        String string6 = "  String name = \"" + this.parentRef.getPanelQuery().getChoiceClass().getSelectedItem() + "." + string5 + "\";\n";
        string6 = String.valueOf(string6) + "  String statement = \"" + stringBuffer + "\";\n\n";
        string6 = String.valueOf(string6) + "  " + CommonUtil.getMethodName(string2) + " aSpec = null;\n";
        string6 = String.valueOf(string6) + "  try{\n";
        string6 = String.valueOf(string6) + "    aSpec = new " + CommonUtil.getMethodName(string2) + "();\n";
        string6 = String.valueOf(string6) + "    aSpec.setName(name);\n";
        string6 = String.valueOf(string6) + "    aSpec.setSQL(statement);\n";
        string6 = String.valueOf(string6) + this.generateUserCode();
        string6 = String.valueOf(string6) + "  }\n  catch(java.lang.Throwable e){\n";
        string6 = String.valueOf(string6) + this.generateUserCatchCode();
        string6 = String.valueOf(string6) + "    throw e;\n  }\n";
        string6 = String.valueOf(string6) + "  return aSpec;\n";
        String string7 = this.parentRef.getPanelQuery().getChoiceClass().getSelectedItem();
        CommonUtil.methodCodeGen(string2, string7, string5, string6, this);
    }

    private String generateUserCatchCode() {
        String string = "    // user code begin {2}";
        String string2 = this.parentRef.getMdSrcUser2();
        string = string2 != null ? String.valueOf(string) + string2 : String.valueOf(string) + " \n" + "    ";
        string = String.valueOf(string) + "// user code end {2}" + "\n";
        return string;
    }

    private String generateUserCode() {
        String string = "    // user code begin {1}";
        String string2 = this.parentRef.getMdSrcUser1();
        string = string2 != null ? String.valueOf(string) + string2 : String.valueOf(string) + " \n" + "    ";
        string = String.valueOf(string) + "// user code end {1}" + "\n";
        return string;
    }

    public Button getButtonCancel() {
        if (this.ivjButtonCancel == null) {
            try {
                this.ivjButtonCancel = new Button();
                this.ivjButtonCancel.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.Cancel));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjButtonCancel;
    }

    public Button getButtonOK() {
        if (this.ivjButtonOK == null) {
            try {
                this.ivjButtonOK = new Button();
                this.ivjButtonOK.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.OK));
                this.ivjButtonOK.setEnabled(false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjButtonOK;
    }

    public Insets getInsets() {
        return new Insets(40, 20, 20, 20);
    }

    public TextArea getTextArea() {
        if (this.ivjTextArea == null) {
            try {
                this.ivjTextArea = new TextArea("", 15, 40, 1);
                ((Component)this.ivjTextArea).setBackground(Color.white);
                this.ivjTextArea.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjTextArea;
    }

    private void initialize() {
        ((Component)this).setBackground(SystemColor.control);
        this.setForeground(Color.black);
        ((Component)this).setSize(500, 400);
        this.setTitle(CommonUtil.getMessage(IBMIVJDBDialog.SQLEditor));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.getTextArea(), gridBagConstraints);
        this.add(this.getTextArea());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 10, 0));
        panel.add(this.getButtonOK());
        panel.add(this.getButtonCancel());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 2, 1, 1, 0, 0);
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.addWindowListener(this);
        this.getButtonOK().addActionListener(this);
        this.getButtonCancel().addActionListener(this);
        this.getTextArea().addTextListener(this);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.getTextArea()) {
            if (this.getTextArea().getText().equals("")) {
                this.getButtonOK().setEnabled(false);
            } else {
                this.getButtonOK().setEnabled(true);
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

