/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.ivj.db.ibeans.ManualSQLDialog;
import com.ibm.ivj.db.ibeans.QuerySpecification;
import com.ibm.uvm.abt.edit.DialogHelper;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class NewSQLDialog
extends Dialog
implements ItemListener,
ActionListener,
WindowListener,
KeyListener,
TextListener {
    private QuerySpecification parentRef = null;
    private Button ivjButtonCancel = null;
    private Button ivjButtonOK = null;
    private CheckboxGroup ivjCheckboxGroup = null;
    private Checkbox ivjCheckboxAssist = null;
    private Checkbox ivjCheckboxManual = null;
    private Label ivjMsgLabel = null;
    private TextField ivjTextFieldName = null;
    private ManualSQLDialog ivjManualSQLFrame = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public NewSQLDialog(QuerySpecification querySpecification) {
        super(querySpecification.getParentFrame(), true);
        this.parentRef = querySpecification;
        try {
            this.initialize();
            DialogHelper.centerWindowOnComponent((Window)this, (Component)((Object)querySpecification));
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getButtonOK()) {
            this.connOKButton();
        } else if (actionEvent.getSource() == this.getButtonCancel()) {
            this.dispose();
        }
    }

    private void connOKButton() {
        try {
            String string = this.getTextFieldName().getText();
            this.parentRef.setQueryMethodName(string);
            if (this.getCheckboxAssist().getState()) {
                this.dispose();
                this.parentRef.connButtonNew();
            } else {
                this.dispose();
                this.getManualSQLFrame().getTextArea().setText("");
                this.getManualSQLFrame().show();
            }
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    public Button getButtonCancel() {
        if (this.ivjButtonCancel == null) {
            try {
                this.ivjButtonCancel = new Button();
                this.ivjButtonCancel.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.Cancel));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjButtonCancel;
    }

    public Button getButtonOK() {
        if (this.ivjButtonOK == null) {
            try {
                this.ivjButtonOK = new Button();
                this.ivjButtonOK.setLabel(CommonUtil.getMessage(IBMIVJDBDialog.OK));
                this.ivjButtonOK.setEnabled(false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjButtonOK;
    }

    public Checkbox getCheckboxAssist() {
        if (this.ivjCheckboxAssist == null) {
            try {
                this.ivjCheckboxAssist = new Checkbox(CommonUtil.getMessage(IBMIVJDBDialog.useAssist), true, this.getCheckboxGroup());
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjCheckboxAssist;
    }

    public CheckboxGroup getCheckboxGroup() {
        if (this.ivjCheckboxGroup == null) {
            try {
                this.ivjCheckboxGroup = new CheckboxGroup();
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjCheckboxGroup;
    }

    public Checkbox getCheckboxManual() {
        if (this.ivjCheckboxManual == null) {
            try {
                this.ivjCheckboxManual = new Checkbox(CommonUtil.getMessage(IBMIVJDBDialog.manualWrite), false, this.getCheckboxGroup());
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjCheckboxManual;
    }

    public Insets getInsets() {
        return new Insets(40, 30, 20, 30);
    }

    public ManualSQLDialog getManualSQLFrame() {
        if (this.ivjManualSQLFrame == null) {
            this.ivjManualSQLFrame = new ManualSQLDialog(this.parentRef);
        }
        return this.ivjManualSQLFrame;
    }

    Label getMsgLabel() {
        if (this.ivjMsgLabel == null) {
            this.ivjMsgLabel = new Label();
        }
        return this.ivjMsgLabel;
    }

    public TextField getTextFieldName() {
        if (this.ivjTextFieldName == null) {
            try {
                this.ivjTextFieldName = new TextField();
                ((TextComponent)this.ivjTextFieldName).setText("");
                ((Component)this.ivjTextFieldName).setBackground(Color.white);
                this.ivjTextFieldName.setForeground(Color.black);
                this.ivjTextFieldName.setColumns(50);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, this);
            }
        }
        return this.ivjTextFieldName;
    }

    private void initialize() {
        ((Component)this).setBackground(SystemColor.control);
        this.setForeground(Color.black);
        this.setTitle(CommonUtil.getMessage(IBMIVJDBDialog.NewSQL));
        this.setResizable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 20, 0);
        gridBagConstraints.anchor = 17;
        Label label = new Label(CommonUtil.getMessage(IBMIVJDBDialog.SQLName), 0);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 1, 0, 1, 1, 80, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(this.getTextFieldName(), gridBagConstraints);
        this.add(this.getTextFieldName());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 1, 2, 1, 100, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(this.getCheckboxAssist(), gridBagConstraints);
        this.add(this.getCheckboxAssist());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 2, 2, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(this.getCheckboxManual(), gridBagConstraints);
        this.add(this.getCheckboxManual());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 3, 2, 1, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagLayout.setConstraints(this.getMsgLabel(), gridBagConstraints);
        this.add(this.getMsgLabel());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 10, 0));
        panel.add(this.getButtonOK());
        panel.add(this.getButtonCancel());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 4, 2, 1, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.addWindowListener(this);
        this.getButtonOK().addActionListener(this);
        this.getButtonCancel().addActionListener(this);
        this.getTextFieldName().addTextListener(this);
        this.getCheckboxAssist().addItemListener(this);
        this.getCheckboxManual().addItemListener(this);
        this.getTextFieldName().addKeyListener(this);
        this.getCheckboxAssist().addKeyListener(this);
        this.getCheckboxManual().addKeyListener(this);
        this.pack();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getCheckboxAssist() || itemEvent.getSource() == this.getCheckboxManual()) {
            this.getTextFieldName().requestFocus();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && !this.getTextFieldName().getText().equals("")) {
            this.connOKButton();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.getTextFieldName()) {
            if (!this.getTextFieldName().getText().equals("") && this.validateName()) {
                this.getButtonOK().setEnabled(true);
            } else {
                this.getButtonOK().setEnabled(false);
            }
        }
    }

    private boolean validateName() {
        boolean bl = false;
        try {
            String string = this.getTextFieldName().getText();
            if (string.length() > 0) {
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    if (string.length() > 1) {
                        int n = 1;
                        while (n < string.length()) {
                            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                this.getMsgLabel().setText(CommonUtil.getMessage(IBMIVJDBDialog.errorSQLName));
            } else {
                this.getMsgLabel().setText("");
                String string2 = this.parentRef.getQuerySpecPath();
                bl = this.parentRef.methodExisting(this.getMsgLabel(), string2, string);
            }
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
        return !bl;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

