/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.UtilitiesBase;
import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.DatabaseInfo;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.ivj.db.ibeans.QueryBuilderDialog;
import com.ibm.ivj.db.ibeans.QuerySpecification;
import com.ibm.ivj.db.ibeans.SPColumnObject;
import com.ibm.ivj.db.ibeans.SPObject;
import com.ibm.ivj.db.ibeans.SPResultSet;
import com.ibm.ivj.db.ibeans.SPSchemaDialog;
import com.ibm.ivj.db.ibeans.SPTableCell;
import com.ibm.ivj.db.ibeans.SPTableModel;
import com.ibm.ivj.db.ibeans.SPTablePanel;
import com.ibm.ivj.db.ibeans.SPproperties;
import com.ibm.ivj.db.uibeans.Query;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.SchemaObject;
import com.ibm.uvm.abt.edit.DialogHelper;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SPBuilderDialog
extends JDialog
implements ChangeListener,
ItemListener,
ListSelectionListener,
ActionListener,
WindowListener {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";
    private JCheckBox ivjCheckboxSchema = null;
    private QueryBuilderDialog ivjBuilderFrame = null;
    private QuerySpecification specPanel = null;
    private JButton ivjButtonCancel = null;
    private JButton ivjButtonOK = null;
    private JButton ivjButtonBack = null;
    private JButton ivjButtonNext = null;
    private JButton viewSchema = null;
    private JButton buttonRun = null;
    private JPanel panelProc = null;
    private JPanel panelParam = null;
    private JPanel panelStmt = null;
    private SPTablePanel procTablePanel = null;
    private SPTablePanel paramTablePanel = null;
    private JTabbedPane tabPane = null;
    private TextArea ivjTextArea = null;
    private SQLAssistPanel panel = null;
    private TextField procStatusBar = null;
    private TextField stmtStatusBar = null;
    private TextField paramStatusBar = null;
    private Query currentQsp = null;
    private String[] procTitle = new String[]{CommonUtil.getMessage(IBMIVJDBDialog.colTitleName), CommonUtil.getMessage(IBMIVJDBDialog.colTitleParam), CommonUtil.getMessage(IBMIVJDBDialog.colTitleRemark)};
    private String[] paramTitle = new String[]{CommonUtil.getMessage(IBMIVJDBDialog.colTitleName), CommonUtil.getMessage(IBMIVJDBDialog.colTitleMode), CommonUtil.getMessage(IBMIVJDBDialog.colTitleSQLType), CommonUtil.getMessage(IBMIVJDBDialog.colTitleInValue)};
    private SPTableCell[][] procData = new SPTableCell[0][];
    private SPTableCell[][] paramData = new SPTableCell[0][];
    private int selectedProc = -1;
    private String selectedProcName = null;
    private String callStmt = null;
    private Vector rset = new Vector();
    private int currentSet = 0;
    private DatabaseInfo db = new DatabaseInfo();
    public static final int preferWidth = 730;
    public static final int preferHeight = 570;

    public SPBuilderDialog(QuerySpecification querySpecification) {
        super(querySpecification.getParentFrame(), true);
        this.specPanel = querySpecification;
        try {
            this.initialize();
            DialogHelper.centerWindowOnComponent((Window)((Object)this), (Component)((Object)querySpecification));
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getButtonNext()) {
            int n = this.getTabPane().getTabCount();
            int n2 = this.getTabPane().getSelectedIndex();
            this.getTabPane().setSelectedIndex(n2 + 1);
            this.getButtonBack().setEnabled(true);
            if (n2 + 1 == n - 1) {
                this.getButtonNext().setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.getButtonBack()) {
            this.getTabPane().getTabCount();
            int n = this.getTabPane().getSelectedIndex();
            this.getButtonNext().setEnabled(true);
            this.getTabPane().setSelectedIndex(n - 1);
            if (n - 1 == 0) {
                this.getButtonBack().setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.getButtonOK()) {
            this.connFinish();
        } else if (actionEvent.getSource() == this.getButtonCancel()) {
            this.connDisposeFrame();
        } else if (actionEvent.getSource() == this.getButtonViewSch()) {
            this.processSchemaButton();
        } else if (this.specPanel.getBuilderFrame().getPanel() != null && actionEvent.getSource() == this.specPanel.getBuilderFrame().getPanel().getGui().getFinishButton()) {
            SPResultSet sPResultSet = (SPResultSet)this.getRset().elementAt(this.currentSet);
            sPResultSet.setStatus(this.specPanel.getBuilderFrame().getPanel().getProperties().getStateArray());
            sPResultSet.addCurrentColumnType();
            sPResultSet.refreshRSetJTable();
            this.specPanel.getBuilderFrame().connDisposeFrame();
        } else if (this.specPanel.getBuilderFrame().getPanel() != null && actionEvent.getSource() == this.specPanel.getBuilderFrame().getPanel().getGui().getCancelButton()) {
            this.specPanel.getBuilderFrame().connDisposeFrame();
        }
        int n = this.getRset().size();
        int n3 = 0;
        while (n3 < n) {
            SPResultSet sPResultSet = (SPResultSet)this.getRset().elementAt(n3);
            this.currentSet = n3++;
            if (actionEvent.getSource() == sPResultSet.getButtonDefineSet()) {
                this.showSqlAssist(sPResultSet);
                break;
            }
            if (actionEvent.getSource() == sPResultSet.getButtonAddSet()) {
                this.addNewResultSetTab();
                break;
            }
            if (actionEvent.getSource() != sPResultSet.getButtonRemoveSet()) continue;
            this.removeResultSetTab(sPResultSet);
            break;
        }
    }

    private void addNewResultSetTab() {
        this.currentSet = this.getRset().size();
        int n = this.currentSet + 1;
        int n2 = 2 + this.currentSet;
        SPResultSet sPResultSet = new SPResultSet(this, n);
        this.addRset(sPResultSet);
        this.tabPane.insertTab("Result " + n, null, (Component)sPResultSet.getPanelResultSet(n), String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.resultSet)) + " " + n, n2);
        this.tabPane.setSelectedIndex(n2);
    }

    private SPResultSet addNewResultSetTab(int n) {
        SPResultSet sPResultSet = new SPResultSet(this, n);
        this.currentSet = this.getRset().size();
        int n2 = 2 + this.currentSet;
        this.addRset(sPResultSet);
        this.tabPane.insertTab("Result " + n, null, (Component)sPResultSet.getPanelResultSet(n), String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.resultSet)) + " " + n, n2);
        return sPResultSet;
    }

    private void addRset(SPResultSet sPResultSet) {
        this.rset.addElement(sPResultSet);
    }

    private void connDisposeFrame() {
        try {
            ((Window)((Object)this)).dispose();
            this.specPanel.setSPDialog(null);
            this.specPanel.setBuilderFrame(null);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
    }

    void connFinish() {
        try {
            this.refreshStmtTab();
            this.generateSpecMethod();
            if (this.specPanel.getCreateQueryFlag()) {
                String string = this.specPanel.getQueryMethodName();
                this.specPanel.getPanelQuery().getChoice().add(string);
                this.specPanel.getPanelQuery().sortListItems();
                this.specPanel.getPanelQuery().selectListItem(string);
                this.specPanel.getPanelQuery().getButtonEdit().setEnabled(true);
                this.specPanel.getQueryEditor().getQLocator().setSqlName(string);
                this.specPanel.getQueryEditor().getQLocator().setSqlBundleName(this.specPanel.getQuerySpecPath());
            }
            this.specPanel.getQueryEditor().getSupport().firePropertyChange(null, null, null);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
            this.connDisposeFrame();
            ((Component)((Object)this.specPanel)).getParent().setEnabled(true);
        }
        this.connDisposeFrame();
        ((Component)((Object)this.specPanel)).getParent().setEnabled(true);
    }

    private boolean createSqlPanel(DatabaseConnectionSpec databaseConnectionSpec) {
        boolean bl = false;
        DatabaseObject databaseObject = this.specPanel.getDBObj();
        this.panel = null;
        this.panel = new SQLAssistPanel();
        if (databaseObject != null) {
            if (databaseObject.getJdbcDriver().equals(databaseConnectionSpec.getDriverName()) && databaseObject.getJdbcServer().equals(databaseConnectionSpec.getDataSourceName())) {
                if (databaseConnectionSpec.getLogonSpec() == null) {
                    if (databaseObject.getLogin() == null && databaseObject.getPassword() == null) {
                        bl = true;
                    }
                } else {
                    if (databaseObject.getLogin().equals(databaseConnectionSpec.getLogonSpec().getId()) && databaseObject.getPassword().equals(databaseConnectionSpec.getLogonSpec().getPassword())) {
                        bl = true;
                    }
                    int n = databaseObject.getLogin().length();
                    int n2 = databaseConnectionSpec.getLogonSpec().getId().length();
                    int n3 = databaseObject.getPassword().length();
                    int n4 = databaseConnectionSpec.getLogonSpec().getPassword().length();
                    if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.panel.getQuery().setDatabase(databaseObject);
            }
        }
        this.panel.getGui().getCancelButton().addActionListener(this);
        this.panel.getGui().getFinishButton().addActionListener(this);
        return bl;
    }

    private void delRset(int n) {
        this.rset.removeElementAt(n);
    }

    private String generateBuilderInfoBlock(String[][][] stringArray) {
        String string = "/*V2.0\n**start of SQL Assist data**\n";
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(stringArray);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            CommonUtil.handleException(iOException, (Component)((Object)this));
        }
        try {
            string = String.valueOf(string) + UtilitiesBase.encodeData((byte[])UtilitiesBase.zipData(byArray), (int)50);
            string = String.valueOf(string) + "\n" + "**end of SQL Assist data**/" + "\n";
        }
        catch (DataException dataException) {
            CommonUtil.handleException(dataException, (Component)((Object)this));
        }
        return string;
    }

    private void generateSpecMethod() {
        Object object;
        int n;
        byte[] byArray = this.callStmt.getBytes();
        int n2 = 0;
        while (n2 < this.callStmt.length()) {
            if (byArray[n2] == 13) {
                byArray[n2] = 32;
            }
            ++n2;
        }
        String string = new String(byArray);
        int n3 = -1;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n3 = string.indexOf("\"", n3 + 1)) != -1) {
            stringBuffer.insert(n3 + n4, "\\");
            ++n4;
        }
        this.specPanel.getPanelQuery().getTextArea().setText(new String(stringBuffer));
        String string2 = this.specPanel.getQueryMethodName();
        String string3 = "  String name = \"" + this.specPanel.getPanelQuery().getChoiceClass().getSelectedItem() + "." + string2 + "\";\n";
        string3 = String.valueOf(string3) + "  String statement = \"{ " + stringBuffer + " }\";\n\n";
        string3 = String.valueOf(string3) + "  " + CommonUtil.getMethodName("com.ibm.db.CallableStatementMetaData") + " aSpec = null;\n";
        string3 = String.valueOf(string3) + "  try{\n";
        string3 = String.valueOf(string3) + "    aSpec = new " + CommonUtil.getMethodName("com.ibm.db.CallableStatementMetaData") + "();\n";
        string3 = String.valueOf(string3) + "    aSpec.setName(name);\n";
        string3 = String.valueOf(string3) + "    aSpec.setSQL(statement);\n\n";
        SPObject sPObject = (SPObject)this.db.getProcs().elementAt(this.selectedProc);
        Vector vector = sPObject.getColumns();
        int n5 = vector.size();
        n2 = 0;
        while (n2 < n5) {
            SPColumnObject sPColumnObject = (SPColumnObject)vector.elementAt(n2);
            n = sPColumnObject.getColumn_Type() == 5 ? 4 : sPColumnObject.getColumn_Type();
            string3 = String.valueOf(string3) + "    aSpec.addParameter(\"" + sPColumnObject.getName() + "\", " + sPColumnObject.getData_Type() + ", " + sPColumnObject.getData_Type() + ", " + n + ");\n";
            ++n2;
        }
        n = 1;
        n2 = 0;
        while (n2 < this.getRset().size()) {
            int n6;
            int n7;
            SPResultSet sPResultSet = (SPResultSet)this.getRset().elementAt(n2);
            if (this.getRset().size() == 1 && sPResultSet.getRsetData().length < 1) break;
            String string4 = "result" + n;
            string3 = String.valueOf(string3) + "\n    StatementMetaData " + string4 + " = new StatementMetaData();\n";
            string3 = n2 == 0 ? String.valueOf(string3) + "    aSpec.setNextMetaData(" + string4 + ");\n" : String.valueOf(string3) + "    result" + (n - 1) + ".setNextMetaData(" + string4 + ");\n";
            string3 = String.valueOf(string3) + "    " + string4 + ".setName(name + \"_" + string4 + "\");\n";
            object = new Vector();
            int n8 = 0;
            while (n8 < sPResultSet.getRsetData().length) {
                n7 = 0;
                String string5 = (String)sPResultSet.getRsetData()[n8][0].getValue();
                string5 = this.removeQuotes(string5);
                string3 = String.valueOf(string3) + "    " + string4 + ".addColumn(\"" + string5 + "\", " + (Integer)sPResultSet.getRsetData()[n8][2].getValue() + ", " + (Integer)sPResultSet.getRsetData()[n8][1].getValue() + ");\n";
                n6 = string5.indexOf(".");
                String string6 = n6 > 0 ? string5.substring(0, n6) : "";
                int n9 = 0;
                while (n9 < ((Vector)object).size()) {
                    String string7 = (String)((Vector)object).elementAt(n9);
                    if (string7.equals(string6)) {
                        n7 = 1;
                    }
                    ++n9;
                }
                if (n7 == 0) {
                    ((Vector)object).addElement(string6);
                }
                ++n8;
            }
            String string8 = "";
            if (this.getCheckBoxSchema().isSelected()) {
                string8 = sPObject.getName();
                n6 = string8.indexOf(".");
                string8 = n6 > 0 ? string8.substring(0, n6 + 1) : "";
            }
            n7 = 0;
            while (n7 < ((Vector)object).size()) {
                String string9 = (String)((Vector)object).elementAt(n7);
                string9 = this.removeQuotes(string9);
                string3 = String.valueOf(string3) + "    " + string4 + ".addTable(\"" + string8 + string9 + "\");\n";
                ++n7;
            }
            ++n2;
            ++n;
        }
        string3 = String.valueOf(string3) + this.generateUserCode();
        string3 = String.valueOf(string3) + "  }\n  catch(java.lang.Throwable e){\n";
        string3 = String.valueOf(string3) + this.generateUserCatchCode();
        string3 = String.valueOf(string3) + "    throw e;\n  }\n";
        string3 = String.valueOf(string3) + "  return aSpec;\n";
        string3 = String.valueOf(string3) + this.generateBuilderInfoBlock(this.getSPStateArray());
        object = this.specPanel.getPanelQuery().getChoiceClass().getSelectedItem();
        CommonUtil.methodCodeGen("com.ibm.db.CallableStatementMetaData", (String)object, string2, string3, (Component)((Object)this));
    }

    private String generateUserCatchCode() {
        String string = "    // user code begin {2}";
        String string2 = this.specPanel.getMdSrcUser2();
        string = string2 != null ? String.valueOf(string) + string2 : String.valueOf(string) + " \n" + "    ";
        string = String.valueOf(string) + "// user code end {2}" + "\n";
        return string;
    }

    private String generateUserCode() {
        String string = "    // user code begin {1}";
        String string2 = this.specPanel.getMdSrcUser1();
        string = string2 != null ? String.valueOf(string) + string2 : String.valueOf(string) + " \n" + "    ";
        string = String.valueOf(string) + "// user code end {1}" + "\n";
        return string;
    }

    public JButton getButtonBack() {
        if (this.ivjButtonBack == null) {
            try {
                this.ivjButtonBack = new JButton(CommonUtil.getMessage(IBMIVJDBDialog.buttonBack));
                this.ivjButtonBack.setEnabled(false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonBack;
    }

    public JButton getButtonCancel() {
        if (this.ivjButtonCancel == null) {
            try {
                this.ivjButtonCancel = new JButton(CommonUtil.getMessage(IBMIVJDBDialog.Cancel));
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonCancel;
    }

    public JButton getButtonNext() {
        if (this.ivjButtonNext == null) {
            try {
                this.ivjButtonNext = new JButton(CommonUtil.getMessage(IBMIVJDBDialog.buttonNext));
                this.ivjButtonNext.setEnabled(false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonNext;
    }

    public JButton getButtonOK() {
        if (this.ivjButtonOK == null) {
            try {
                this.ivjButtonOK = new JButton(CommonUtil.getMessage(IBMIVJDBDialog.finishButton));
                this.ivjButtonOK.setEnabled(false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjButtonOK;
    }

    public JButton getButtonViewSch() {
        if (this.viewSchema == null) {
            this.viewSchema = new JButton(CommonUtil.getMessage(IBMIVJDBDialog.viewSchema));
        }
        return this.viewSchema;
    }

    public JCheckBox getCheckBoxSchema() {
        if (this.ivjCheckboxSchema == null) {
            try {
                this.ivjCheckboxSchema = new JCheckBox(CommonUtil.getMessage(IBMIVJDBDialog.checkBoxSchemaName), true);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjCheckboxSchema;
    }

    public DatabaseInfo getDBInfo() {
        return this.db;
    }

    public JPanel getPanelParam() {
        if (this.panelParam == null) {
            this.panelParam = new JPanel();
            this.panelParam.setBackground(SystemColor.control);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panelParam.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 100, 100);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(60, 20, 20, 20);
            gridBagLayout.setConstraints((Component)((Object)this.getParamTablePanel()), gridBagConstraints);
            this.panelParam.add((Component)((Object)this.getParamTablePanel()));
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 1, 1, 1, 0, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 20, 20, 20);
            gridBagLayout.setConstraints(this.getParamStatusBar(), gridBagConstraints);
            this.panelParam.add(this.getParamStatusBar());
        }
        return this.panelParam;
    }

    public JPanel getPanelProc() {
        if (this.panelProc == null) {
            this.panelProc = new JPanel();
            this.panelProc.setBackground(SystemColor.control);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panelProc.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(30, 20, 5, 20);
            Label label = new Label(CommonUtil.getMessage(IBMIVJDBDialog.selectProcedure));
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.panelProc.add(label);
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 1, 1, 1, 100, 100);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 20, 5, 20);
            gridBagLayout.setConstraints((Component)((Object)this.getProcTablePanel()), gridBagConstraints);
            this.panelProc.add((Component)((Object)this.getProcTablePanel()));
            JPanel jPanel = new JPanel();
            jPanel.setBackground(SystemColor.control);
            jPanel.setLayout(new GridLayout(1, 2, 10, 0));
            jPanel.add((Component)this.getButtonViewSch());
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 2, 1, 1, 0, 0);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 20, 10, 20);
            gridBagLayout.setConstraints((Component)jPanel, gridBagConstraints);
            this.panelProc.add((Component)jPanel);
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 3, 1, 1, 0, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 20, 20, 20);
            gridBagLayout.setConstraints(this.getProcStatusBar(), gridBagConstraints);
            this.panelProc.add(this.getProcStatusBar());
        }
        return this.panelProc;
    }

    public JPanel getPanelStmt() {
        if (this.panelStmt == null) {
            this.panelStmt = new JPanel();
            this.panelStmt.setBackground(SystemColor.control);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panelStmt.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(30, 20, 5, 20);
            Label label = new Label(CommonUtil.getMessage(IBMIVJDBDialog.viewStmt));
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.panelStmt.add(label);
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 1, 1, 1, 100, 100);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 20, 5, 20);
            gridBagLayout.setConstraints(this.getTextArea(), gridBagConstraints);
            this.panelStmt.add(this.getTextArea());
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 2, 1, 1, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 10, 20);
            gridBagLayout.setConstraints((Component)this.getCheckBoxSchema(), gridBagConstraints);
            this.panelStmt.add((Component)this.getCheckBoxSchema());
            gridBagConstraints = new GridBagConstraints();
            CommonUtil.buildCons(gridBagConstraints, 0, 3, 1, 1, 0, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 20, 20, 20);
            gridBagLayout.setConstraints(this.getStmtStatusBar(), gridBagConstraints);
            this.panelStmt.add(this.getStmtStatusBar());
        }
        return this.panelStmt;
    }

    public TextField getParamStatusBar() {
        if (this.paramStatusBar == null) {
            this.paramStatusBar = new TextField();
            ((Component)this.paramStatusBar).setBackground(SystemColor.control);
        }
        return this.paramStatusBar;
    }

    public SPTablePanel getParamTablePanel() {
        if (this.paramTablePanel == null) {
            this.paramTablePanel = new SPTablePanel(this, this.paramTitle, this.paramData);
        }
        return this.paramTablePanel;
    }

    public TextField getProcStatusBar() {
        if (this.procStatusBar == null) {
            this.procStatusBar = new TextField();
            ((Component)this.procStatusBar).setBackground(SystemColor.control);
        }
        return this.procStatusBar;
    }

    public SPTablePanel getProcTablePanel() {
        if (this.procTablePanel == null) {
            this.procTablePanel = new SPTablePanel(this, this.procTitle, this.procData);
        }
        return this.procTablePanel;
    }

    public QuerySpecification getPropertyDialog() {
        return this.specPanel;
    }

    Vector getRset() {
        return this.rset;
    }

    public int getSelectedProc() {
        return this.selectedProc;
    }

    public QuerySpecification getSpecPanel() {
        return this.specPanel;
    }

    String[][][] getSPStateArray() {
        Object object;
        if (this.selectedProc < 0) {
            return null;
        }
        int n = this.getRset().size();
        String[][][] stringArray = new String[n + 1][][];
        SPproperties sPproperties = new SPproperties();
        sPproperties.put("5001", ((SPObject)this.db.getProcs().elementAt(this.selectedProc)).getName());
        sPproperties.put("5002", Integer.toString(n));
        if (this.getCheckBoxSchema().isSelected()) {
            sPproperties.put("5004", "1");
        } else {
            sPproperties.put("5004", "0");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.paramData.length) {
            String string = (String)this.paramData[n3][3].getValue();
            if (string != null && this.paramData[n3][3].getEditable() && !string.equals("")) {
                sPproperties.put("5006_{0}", "" + n3, new String[]{"" + n2});
                sPproperties.put("5007_{0}", string, new String[]{"" + n2});
                ++n2;
            }
            ++n3;
        }
        sPproperties.put("5005", "" + n2);
        int n4 = 0;
        n3 = 0;
        while (n3 < this.getDBInfo().getDBObject().getSchemas().size()) {
            object = (String[][])this.getDBInfo().getDBObject().getSchemas().elementAt(n3);
            if (((SchemaObject)object).getSelected()) {
                sPproperties.put("5009_{0}", "" + ((SchemaObject)object).getName(), new String[]{"" + n4});
                ++n4;
            }
            ++n3;
        }
        sPproperties.put("5008", "" + n4);
        n3 = 0;
        while (n3 < n) {
            object = (SPResultSet)this.getRset().elementAt(n3);
            stringArray[n3 + 1] = ((SPResultSet)object).getStatus();
            sPproperties.put("5003_{0}", "" + ((SPResultSet)object).getRNum(), new String[]{"" + n3});
            ++n3;
        }
        object = new String[((Hashtable)sPproperties).size()][2];
        int n5 = 0;
        Enumeration enumeration = ((Hashtable)sPproperties).keys();
        while (enumeration.hasMoreElements()) {
            object[n5][0] = (String)enumeration.nextElement();
            object[n5][1] = sPproperties.getProperty((String)object[n5][0]);
            ++n5;
        }
        stringArray[0] = object;
        return stringArray;
    }

    public TextField getStmtStatusBar() {
        if (this.stmtStatusBar == null) {
            this.stmtStatusBar = new TextField();
            ((Component)this.stmtStatusBar).setBackground(SystemColor.control);
        }
        return this.stmtStatusBar;
    }

    private JTabbedPane getTabPane() {
        try {
            if (this.tabPane == null) {
                this.tabPane = new JTabbedPane();
                this.tabPane.addTab(CommonUtil.getMessage(IBMIVJDBDialog.procTab), null, (Component)this.getPanelProc(), CommonUtil.getMessage(IBMIVJDBDialog.procTab));
                this.tabPane.addTab(CommonUtil.getMessage(IBMIVJDBDialog.paramTab), null, (Component)this.getPanelParam(), CommonUtil.getMessage(IBMIVJDBDialog.paramTab));
                SPResultSet sPResultSet = new SPResultSet(this, 1);
                this.addRset(sPResultSet);
                this.currentSet = 0;
                int n = this.currentSet + 1;
                this.tabPane.addTab("Result " + n, null, (Component)sPResultSet.getPanelResultSet(n), String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.resultSet)) + " " + n);
                this.tabPane.addTab(CommonUtil.getMessage(IBMIVJDBDialog.SQL), null, (Component)this.getPanelStmt(), CommonUtil.getMessage(IBMIVJDBDialog.SQL));
                this.tabPane.setBackground(SystemColor.control);
                this.tabPane.setForeground(Color.black);
                if (this.selectedProc == -1) {
                    this.tabPane.setEnabledAt(1, false);
                    this.tabPane.setEnabledAt(2, false);
                    this.tabPane.setEnabledAt(3, false);
                }
                this.tabPane.setSelectedIndex(0);
            }
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
        }
        return this.tabPane;
    }

    public TextArea getTextArea() {
        if (this.ivjTextArea == null) {
            try {
                this.ivjTextArea = new TextArea("", 10, 40, 1);
                this.ivjTextArea.setForeground(Color.black);
                this.ivjTextArea.setEditable(false);
            }
            catch (Throwable throwable) {
                CommonUtil.handleException(throwable, (Component)((Object)this));
            }
        }
        return this.ivjTextArea;
    }

    private void initialize() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(SystemColor.control);
        jPanel.setForeground(Color.black);
        ((Component)((Object)this)).setBackground(SystemColor.control);
        ((Component)((Object)this)).setForeground(Color.black);
        ((Dialog)((Object)this)).setTitle(CommonUtil.getMessage(IBMIVJDBDialog.procedureSel));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(new Color(160, 160, 164));
        jPanel2.setForeground(Color.black);
        jPanel2.add("North", CommonUtil.spacer(5, 5));
        jPanel2.add("Center", (Component)this.getTabPane());
        CommonUtil.buildCons(gridBagConstraints, 0, 0, 1, 1, 0, 100);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints((Component)jPanel2, gridBagConstraints);
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(SystemColor.control);
        jPanel3.setLayout(new GridLayout(1, 0, 10, 0));
        jPanel3.add((Component)this.getButtonBack());
        jPanel3.add((Component)this.getButtonNext());
        jPanel3.add((Component)this.getButtonOK());
        jPanel3.add((Component)this.getButtonCancel());
        gridBagConstraints = new GridBagConstraints();
        CommonUtil.buildCons(gridBagConstraints, 0, 2, 1, 1, 100, 0);
        gridBagConstraints.insets = new Insets(10, 0, 10, 5);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints((Component)jPanel3, gridBagConstraints);
        jPanel.add((Component)jPanel3);
        container.add("Center", (Component)jPanel);
        ((Window)((Object)this)).addWindowListener(this);
        this.getButtonBack().addActionListener((ActionListener)this);
        this.getButtonNext().addActionListener((ActionListener)this);
        this.getButtonOK().addActionListener((ActionListener)this);
        this.getButtonCancel().addActionListener((ActionListener)this);
        this.getButtonViewSch().addActionListener((ActionListener)this);
        this.getCheckBoxSchema().addItemListener((ItemListener)this);
        this.getTabPane().addChangeListener((ChangeListener)this);
        this.getProcTablePanel().getRowSM().addListSelectionListener((ListSelectionListener)this);
        ((Window)((Object)this)).pack();
        int n = ((Component)((Object)this)).getSize().width;
        if (n < 730) {
            n = 730;
        }
        jPanel.setPreferredSize(new Dimension(n, 570));
        ((Window)((Object)this)).pack();
        SPTablePanel sPTablePanel = null;
        int n2 = 0;
        while (n2 < 3) {
            if (n2 == 0) {
                sPTablePanel = this.getProcTablePanel();
            }
            if (n2 == 1) {
                sPTablePanel = this.getParamTablePanel();
            }
            if (n2 == 2) {
                SPResultSet sPResultSet = (SPResultSet)this.getRset().elementAt(0);
                sPTablePanel = sPResultSet.getRSetTablePanel();
            }
            int n3 = (((Component)((Object)this)).getSize().width - 40 - 20) / sPTablePanel.getColNames().length;
            int n4 = 0;
            while (n4 < sPTablePanel.getColNames().length) {
                sPTablePanel.getTableView().getColumnModel().getColumn(n4).setWidth(n3);
                ++n4;
            }
            ++n2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getCheckBoxSchema()) {
            this.refreshStmtTab();
        }
    }

    public void processSchemaButton() {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        SPSchemaDialog sPSchemaDialog = new SPSchemaDialog(this, false);
        ((Component)sPSchemaDialog).setVisible(true);
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void putSPStateArray(String[][][] stringArray) {
        if (stringArray != null) {
            int n;
            int n2;
            String string;
            Object object;
            SPproperties sPproperties = new SPproperties();
            String[][] stringArray2 = stringArray[0];
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray2[n3][0] == null || stringArray2[n3][1] == null) {
                    return;
                }
                sPproperties.put(stringArray2[n3][0], stringArray2[n3][1]);
                ++n3;
            }
            String string2 = sPproperties.getProperty("5008");
            int n4 = 0;
            if (string2 != null && !string2.equals("")) {
                n4 = Integer.parseInt(string2);
            }
            if (n4 > 0) {
                object = this.getDBInfo().getDBObject().getSchemas();
                n3 = 0;
                while (n3 < n4) {
                    string = sPproperties.getProperty("5009_{0}", "", new String[]{"" + n3});
                    n2 = 0;
                    while (n2 < ((Vector)object).size()) {
                        SchemaObject schemaObject = (SchemaObject)((Vector)object).elementAt(n2);
                        if (string.equals(schemaObject.getName())) {
                            schemaObject.setSelected(true);
                        }
                        ++n2;
                    }
                    ++n3;
                }
                try {
                    this.getDBInfo().refreshProcList();
                    this.refreshProcJTable();
                }
                catch (Exception exception) {
                    CommonUtil.handleException(exception, (Component)((Object)this));
                }
            }
            object = sPproperties.getProperty("5001");
            this.selectedProc = this.db.getProc((String)object);
            this.selectedProcName = object;
            if (this.selectedProc >= 0) {
                String string3;
                this.getTabPane().setEnabledAt(1, true);
                this.getTabPane().setEnabledAt(2, true);
                this.getTabPane().setEnabledAt(3, true);
                this.getButtonOK().setEnabled(true);
                this.getButtonNext().setEnabled(true);
                this.getProcTablePanel().getRowSM().setSelectionInterval(this.selectedProc, this.selectedProc);
                this.refreshParamJTable();
                string = sPproperties.getProperty("5005");
                if (string != null && !string.equals("") && (n2 = Integer.parseInt(string)) > 0) {
                    n3 = 0;
                    while (n3 < n2) {
                        int n5 = Integer.parseInt(sPproperties.getProperty("5006_{0}", "", new String[]{"" + n3}));
                        String string4 = sPproperties.getProperty("5007_{0}", "", new String[]{"" + n3});
                        this.paramData[n5][3] = new SPTableCell(true, 4, null, string4);
                        ++n3;
                    }
                }
                if ((string3 = sPproperties.getProperty("5004")).equals("1")) {
                    this.getCheckBoxSchema().setSelected(true);
                } else {
                    this.getCheckBoxSchema().setSelected(false);
                }
                this.refreshStmtTab();
            }
            if ((n = Integer.parseInt(sPproperties.getProperty("5002"))) > 0) {
                n3 = 0;
                while (n3 < n) {
                    SPResultSet sPResultSet;
                    if (n3 == 0) {
                        sPResultSet = (SPResultSet)this.getRset().elementAt(0);
                    } else {
                        String string5 = sPproperties.getProperty("5003_{0}", "", new String[]{"" + n3});
                        sPResultSet = this.addNewResultSetTab(Integer.parseInt(string5));
                    }
                    sPResultSet.setStatus(stringArray[n3 + 1]);
                    sPResultSet.refreshRSetJTable();
                    ++n3;
                }
            }
        }
    }

    void refreshParamJTable() {
        try {
            Vector vector = ((SPObject)this.db.getProcs().elementAt(this.selectedProc)).getColumns();
            int n = vector.size();
            this.paramData = new SPTableCell[n][4];
            int n2 = 0;
            while (n2 < n) {
                this.paramData[n2][0] = new SPTableCell(false, ((SPColumnObject)vector.elementAt(n2)).getName());
                int n3 = ((SPColumnObject)vector.elementAt(n2)).getColumn_Type();
                this.paramData[n2][1] = new SPTableCell(false, 30001, new Integer(n3));
                this.paramData[n2][2] = new SPTableCell(((SPColumnObject)vector.elementAt(n2)).getFormatType_Name());
                this.paramData[n2][3] = n3 != 1 && n3 != 2 ? new SPTableCell(false, CommonUtil.getMessage(IBMIVJDBDialog.noInput)) : new SPTableCell(true, "");
                ++n2;
            }
            this.getParamTablePanel().getSorter().setModel((TableModel)new SPTableModel(this.paramTitle, this.paramData));
            this.getParamTablePanel().getSorter().tableChanged(new TableModelEvent(this.getParamTablePanel().getSorter().getModel()));
            this.getProcTablePanel().getTableView().repaint();
        }
        catch (Exception exception) {
            CommonUtil.handleException(exception, (Component)((Object)this));
        }
    }

    public void refreshProcJTable() {
        int n;
        int n2 = this.db.getProcs().size();
        if (n2 > 0) {
            this.selectedProc = -1;
            this.procData = new SPTableCell[n2][3];
            n = 0;
            while (n < n2) {
                this.procData[n][0] = new SPTableCell(false, ((SPObject)this.db.getProcs().elementAt(n)).getName());
                this.procData[n][1] = new SPTableCell(false, ((SPObject)this.db.getProcs().elementAt(n)).getParamList());
                this.procData[n][2] = new SPTableCell(false, ((SPObject)this.db.getProcs().elementAt(n)).getRemarks());
                if (this.procData[n][0].getValue().equals(this.selectedProcName)) {
                    this.selectedProc = n;
                }
                ++n;
            }
        } else {
            this.procData = new SPTableCell[0][];
            this.selectedProc = -1;
        }
        this.getProcTablePanel().getSorter().setModel((TableModel)new SPTableModel(this.procTitle, this.procData));
        if (this.selectedProc == -1) {
            n = 1;
            while (n <= this.getTabPane().getTabCount() - 1) {
                this.getTabPane().setEnabledAt(n, false);
                ++n;
            }
            this.getButtonOK().setEnabled(false);
            this.getButtonNext().setEnabled(false);
        }
        this.getProcTablePanel().getRowSM().setSelectionInterval(this.selectedProc, this.selectedProc);
        this.getProcTablePanel().getSorter().tableChanged(new TableModelEvent(this.getProcTablePanel().getSorter().getModel()));
        this.getProcTablePanel().getTableView().repaint();
    }

    private void refreshStmtTab() {
        boolean bl = false;
        this.callStmt = "CALL ";
        String string = ((SPObject)this.db.getProcs().elementAt(this.selectedProc)).getName();
        if (this.getCheckBoxSchema().isSelected()) {
            this.callStmt = String.valueOf(this.callStmt) + string;
        } else {
            int n = string.indexOf(".");
            this.callStmt = String.valueOf(this.callStmt) + string.substring(n + 1, string.length());
        }
        Vector vector = ((SPObject)this.db.getProcs().elementAt(this.selectedProc)).getColumns();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SPColumnObject sPColumnObject = (SPColumnObject)vector.elementAt(n2);
            int n3 = sPColumnObject.getColumn_Type();
            if (n2 == 0 && n3 != 5) {
                this.callStmt = String.valueOf(this.callStmt) + "(";
            }
            if (bl && n2 == 1) {
                this.callStmt = String.valueOf(this.callStmt) + "(";
            }
            if (n3 != 5) {
                int n4;
                String string2;
                this.callStmt = n3 != 1 && n3 != 2 ? String.valueOf(this.callStmt) + ":" + sPColumnObject.getName() : ((string2 = (String)this.getParamTablePanel().getSorter().getValueAt(n2, 3)) == null || string2.equals("") ? String.valueOf(this.callStmt) + ":" + sPColumnObject.getName() : ((n4 = sPColumnObject.getGenericData_Type()) != 1 ? String.valueOf(this.callStmt) + string2 : String.valueOf(this.callStmt) + "'" + string2 + "'"));
                if (n2 != n - 1) {
                    this.callStmt = String.valueOf(this.callStmt) + ", ";
                }
            } else if (!bl) {
                this.callStmt = ":" + sPColumnObject.getName() + " = " + this.callStmt;
                bl = true;
            }
            if (n2 == n - 1 && n3 != 5) {
                this.callStmt = String.valueOf(this.callStmt) + ")";
            }
            ++n2;
        }
        this.getTextArea().setText("\n" + this.callStmt);
    }

    private String removeQuotes(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = string.indexOf("\"");
        if (n2 != -1) {
            do {
                stringBuffer = stringBuffer.append(string.substring(n, n + n2));
            } while ((n2 = string.substring(n += n2 + 1).indexOf("\"")) != -1);
            stringBuffer = stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        return string;
    }

    private void removeResultSetTab(SPResultSet sPResultSet) {
        if (this.currentSet != 0) {
            this.tabPane.removeTabAt(2 + this.currentSet);
            this.getRset().removeElementAt(this.currentSet);
            this.renumberResultSets(2 + this.currentSet);
            --this.currentSet;
            this.tabPane.setSelectedIndex(2 + this.currentSet);
        } else {
            if (this.getRset().size() > 1) {
                this.tabPane.removeTabAt(2 + this.currentSet);
                this.getRset().removeElementAt(this.currentSet);
                this.renumberResultSets(2 + this.currentSet);
            } else {
                SPTableCell[][] sPTableCellArray = new SPTableCell[][]{};
                sPResultSet.setRsetData(sPTableCellArray);
                sPResultSet.setStatus(null);
                sPResultSet.refreshRSetJTable();
            }
            this.tabPane.setSelectedIndex(2 + this.currentSet + 1);
            this.tabPane.setSelectedIndex(2 + this.currentSet);
        }
    }

    private void renumberResultSets(int n) {
        int n2 = n;
        while (n2 <= this.tabPane.getTabCount() - 2) {
            this.tabPane.setTitleAt(n2, "Result  " + (n2 - 1));
            Component component = this.tabPane.getComponentAt(n2);
            Component component2 = ((JPanel)component).getComponent(0);
            String string = CommonUtil.formatMsg(CommonUtil.getMessage(IBMIVJDBDialog.labelDefineSet), new Object[]{new Integer(n2 - 1)});
            if (n2 == 2) {
                string = String.valueOf(string) + "  " + CommonUtil.getMessage(IBMIVJDBDialog.labelDefineSet2);
            }
            ((Label)component2).setText(string);
            SPResultSet sPResultSet = (SPResultSet)this.getRset().elementAt(n2 - 2);
            sPResultSet.setRNum(n2 - 1);
            ++n2;
        }
    }

    private void showSqlAssist(SPResultSet sPResultSet) {
        try {
            ((TextComponent)sPResultSet.getStatusBar()).setText(CommonUtil.getMessage(IBMIVJDBDialog.displayAssist));
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            this.specPanel.getBuilderFrame().qbuilderMain(this.currentQsp, sPResultSet.getStatus(), true, true);
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            ((TextComponent)sPResultSet.getStatusBar()).setText("");
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, (Component)((Object)this));
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
            ((TextComponent)sPResultSet.getStatusBar()).setText("");
        }
    }

    public void spbuilderMain(Query query, String[][][] stringArray) throws Exception {
        query.getConnectionAlias().getConnectionSpec();
        this.currentQsp = query;
        try {
            this.specPanel.getBuilderFrame().qbuilderMain(this.currentQsp, null, false, false);
            this.db.setDBObject(this.specPanel.getDBObj());
            if (this.db.getDBObject() == null || this.db.getDBObject().getConnection() == null) {
                return;
            }
        }
        catch (Exception exception) {
            CommonUtil.handleException(exception, (Component)((Object)this));
            throw exception;
        }
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
        this.specPanel.getPanelQuery().getLabelEditorMsg().setText(CommonUtil.getMessage(IBMIVJDBDialog.retrievingSP));
        try {
            this.db.refreshProcList();
            this.refreshProcJTable();
            this.putSPStateArray(stringArray);
        }
        catch (Exception exception) {
            CommonUtil.handleException(exception, (Component)((Object)this));
            throw exception;
        }
        this.specPanel.getPanelQuery().getLabelEditorMsg().setText(CommonUtil.getMessage(IBMIVJDBDialog.displaySPbuilder));
        ((Dialog)((Object)this)).show();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getTabPane()) {
            this.refreshStmtTab();
            int n = this.getTabPane().getTabCount();
            int n2 = this.getTabPane().getSelectedIndex();
            if (n2 >= 1) {
                this.getButtonBack().setEnabled(true);
            } else {
                this.getButtonBack().setEnabled(false);
            }
            if (n2 != n - 1) {
                this.getButtonNext().setEnabled(true);
            } else {
                this.getButtonNext().setEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel == this.getProcTablePanel().getRowSM() && !listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            SPObject sPObject = (SPObject)this.db.getProcs().elementAt(n);
            String string = sPObject.getName();
            this.selectedProc = n;
            this.selectedProcName = string;
            int n2 = 1;
            while (n2 <= this.getTabPane().getTabCount() - 1) {
                this.getTabPane().setEnabledAt(n2, true);
                ++n2;
            }
            this.getButtonOK().setEnabled(true);
            this.getButtonNext().setEnabled(true);
            this.refreshParamJTable();
            this.refreshStmtTab();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.connDisposeFrame();
            ((Component)((Object)this.specPanel)).getParent().setEnabled(true);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

