/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.DatabaseInfo;
import com.ibm.ivj.db.ibeans.SPBuilderDialog;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.SchemaObject;
import com.ibm.uvm.abt.edit.DialogHelper;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class SPSchemaDialog
extends Dialog
implements ActionListener,
ItemListener,
WindowListener,
KeyListener {
    private DatabaseInfo dbinfo;
    private List availableList = new List(5, true);
    private List selectedList = new List(5, true);
    private Button addButton = new Button();
    private Button removeButton = new Button();
    private Button selectAllButton = new Button();
    private Button unselectAllButton = new Button();
    private Button okButton;
    private Button cancelButton;
    private TextField schemaTextField = new TextField();
    private Button addSchemaButton = new Button();
    private Vector newSchemas = new Vector();
    private boolean oldPromptSchemasAtLogon = false;
    private boolean dispTextField = false;
    private SPBuilderDialog parentRef = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SPSchemaDialog(SPBuilderDialog sPBuilderDialog, boolean bl) {
        super(sPBuilderDialog.getPropertyDialog().getParentFrame(), "", true);
        this.parentRef = sPBuilderDialog;
        this.dispTextField = bl;
        this.dbinfo = sPBuilderDialog.getDBInfo();
        int n = 0;
        while (n < this.dbinfo.getDBObject().getSchemas().size()) {
            SchemaObject schemaObject = (SchemaObject)this.dbinfo.getDBObject().getSchemas().elementAt(n);
            this.newSchemas.addElement(new SchemaObject(schemaObject.getName(), schemaObject.getSelected(), schemaObject.getLive()));
            ++n;
        }
        this.oldPromptSchemasAtLogon = this.dbinfo.getDBObject().getPromptSchemasAtLogon();
        this.dbinfo.getDBObject().setPromptSchemasAtLogon(false);
        this.build();
        DialogHelper.centerWindowOnComponent((Window)this, (Component)((Object)sPBuilderDialog.getPropertyDialog()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction(actionEvent);
    }

    public void addNotify() {
        super.addNotify();
        if (this.dispTextField) {
            this.getSchemaTextField().requestFocus();
        } else {
            this.availableList.requestFocus();
        }
    }

    private void addSchema(String string) {
        int n = 0;
        while (n < this.newSchemas.size()) {
            SchemaObject schemaObject = (SchemaObject)this.newSchemas.elementAt(n);
            if (schemaObject.getName().equalsIgnoreCase(string)) {
                schemaObject.setSelected(true);
                return;
            }
            ++n;
        }
        this.newSchemas.addElement(new SchemaObject(string, true, true));
    }

    private void build() {
        Panel panel;
        ((Component)this).setBackground(SystemColor.control);
        this.setForeground(Color.black);
        this.getAddButton().setLabel(SQLAssistStrings.getText(SQLAssistStrings.Add_Button));
        this.getAddSchemaButton().setLabel(SQLAssistStrings.getText(SQLAssistStrings.Add_Button));
        this.getRemoveButton().setLabel(SQLAssistStrings.getText(SQLAssistStrings.Remove_Button));
        this.getSelectAllButton().setLabel(SQLAssistStrings.getText(SQLAssistStrings.SelectAll_Button));
        this.getUnselectAllButton().setLabel(SQLAssistStrings.getText(SQLAssistStrings.UnselectAll_Button));
        this.setTitle(SQLAssistStrings.getText(SQLAssistStrings.SchemaDialog_Title));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(2, 2));
        PanelObject panelObject = new PanelObject(SQLAssistStrings.getText(SQLAssistStrings.SchemasAvailable_Label));
        panelObject.add("Center", this.getAvailableList());
        panel2.add("Center", panelObject);
        Panel panel3 = new Panel();
        if (this.dispTextField) {
            panel3.setLayout(new GridLayout(4, 1, 10, 10));
        } else {
            panel3.setLayout(new GridLayout(5, 1, 10, 10));
            panel3.add(new Label());
        }
        panel3.add(this.getAddButton());
        panel3.add(this.getRemoveButton());
        panel3.add(this.getSelectAllButton());
        panel3.add(this.getUnselectAllButton());
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout(5, 5));
        panel4.add("Center", panel3);
        panel4.add("North", new Label());
        if (!this.dispTextField) {
            panel4.add("South", new Label());
        }
        panel4.add("East", new Label());
        panel4.add("West", new Label());
        PanelObject panelObject2 = new PanelObject(SQLAssistStrings.getText(SQLAssistStrings.SchemasSelected_Label), 0);
        panelObject2.add("Center", this.getSelectedList());
        Panel panel5 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel5.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        panel5.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        panel5.add(panel4);
        gridBagLayout.setConstraints(panel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        panel5.add(panelObject2);
        gridBagLayout.setConstraints(panelObject2, gridBagConstraints);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(5, 5));
        if (this.dispTextField) {
            panel = new PanelObject(SQLAssistStrings.getText(SQLAssistStrings.EnterSchema_Label));
            panel.add("Center", this.getSchemaTextField());
            panel.add("East", this.getAddSchemaButton());
            panel6.add("North", panel);
            this.getSchemaTextField().addKeyListener(this);
        }
        panel6.add("Center", panel5);
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new Button(SQLAssistStrings.getText(SQLAssistStrings.OK_Button));
        this.cancelButton = new Button(SQLAssistStrings.getText(SQLAssistStrings.Cancel_Button));
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout());
        panel7.add("North", SQLAssistUtils.spacer(10));
        panel7.add("East", panel);
        Panel panel8 = new Panel();
        panel8.setLayout(new BorderLayout(5, 5));
        panel8.add("North", new Label(SQLAssistStrings.getText(SQLAssistStrings.SchemasPanel_Title)));
        panel8.add("Center", panel6);
        panel8.add("South", panel7);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panel8);
        this.add("North", SQLAssistUtils.spacer(5));
        this.add("South", SQLAssistUtils.spacer(5));
        this.add("East", SQLAssistUtils.spacer(5));
        this.add("West", SQLAssistUtils.spacer(5));
        this.getAvailableList().addItemListener(this);
        this.getSelectedList().addItemListener(this);
        this.getAddButton().addActionListener(this);
        this.getAddSchemaButton().addActionListener(this);
        this.getRemoveButton().addActionListener(this);
        this.getSelectAllButton().addActionListener(this);
        this.getUnselectAllButton().addActionListener(this);
        this.getAvailableList().addKeyListener(this);
        this.getSelectedList().addKeyListener(this);
        this.getAddButton().addKeyListener(this);
        this.getAddSchemaButton().addKeyListener(this);
        this.getRemoveButton().addKeyListener(this);
        this.getSelectAllButton().addKeyListener(this);
        this.getUnselectAllButton().addKeyListener(this);
        this.okButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.setResizable(true);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.height < 350 || dimension.width < 525) {
            if (dimension.height < 350) {
                dimension.height = 350;
            }
            if (dimension.width < 525) {
                dimension.width = 525;
            }
            ((Component)this).setSize(dimension);
        }
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(this);
        this.refresh();
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getAddSchemaButton() {
        return this.addSchemaButton;
    }

    public List getAvailableList() {
        return this.availableList;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getOkButton() {
        return this.okButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public TextField getSchemaTextField() {
        return this.schemaTextField;
    }

    public Button getSelectAllButton() {
        return this.selectAllButton;
    }

    public List getSelectedList() {
        return this.selectedList;
    }

    public Button getUnselectAllButton() {
        return this.unselectAllButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.refreshButtons();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.performAction(keyEvent);
        } else if (keyEvent.getKeyCode() == 27) {
            this.terminate();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.refreshButtons();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void performAction(AWTEvent aWTEvent) {
        if (aWTEvent.getSource().equals(this.getAddButton())) {
            this.populateAddList();
        } else if (aWTEvent.getSource().equals(this.getAddSchemaButton())) {
            this.processSchemaTextField();
        } else if (aWTEvent.getSource().equals(this.getRemoveButton())) {
            this.populateRemoveList();
        } else if (aWTEvent.getSource().equals(this.getSelectAllButton())) {
            this.processSelect(true);
        } else if (aWTEvent.getSource().equals(this.getUnselectAllButton())) {
            this.processSelect(false);
        } else if (aWTEvent.getSource().equals(this.getOkButton())) {
            this.processOkButton();
        } else if (aWTEvent.getSource().equals(this.getCancelButton())) {
            this.terminate();
        } else if (aWTEvent.getSource().equals(this.getSchemaTextField())) {
            this.processSchemaTextField();
        }
    }

    public void populateAddList() {
        String[] stringArray = this.getAvailableList().getSelectedItems();
        int n = stringArray.length - 1;
        while (n > -1) {
            SQLAssistUtils.selectSchemaObject(this.newSchemas, stringArray[n], true);
            --n;
        }
        this.refresh();
    }

    private void populateRemoveList() {
        String[] stringArray = this.getSelectedList().getSelectedItems();
        int n = stringArray.length - 1;
        while (n > -1) {
            SQLAssistUtils.selectSchemaObject(this.newSchemas, stringArray[n], false);
            --n;
        }
        this.refresh();
    }

    private void processOkButton() {
        try {
            ((TextComponent)this.parentRef.getProcStatusBar()).setText(SQLAssistStrings.getText(SQLAssistStrings.RetrievingDatabaseDetails_Msg));
            ((Component)this).setVisible(false);
            this.dbinfo.getDBObject().setSchemas(this.newSchemas);
            this.dbinfo.refreshProcList();
            this.parentRef.refreshProcJTable();
            this.terminate();
            ((TextComponent)this.parentRef.getProcStatusBar()).setText("");
        }
        catch (Exception exception) {
            CommonUtil.handleException(exception, this);
            ((TextComponent)this.parentRef.getProcStatusBar()).setText("");
        }
    }

    private void processSchemaTextField() {
        String string = this.getSchemaTextField().getText();
        if (string.equals("")) {
            return;
        }
        string = string.replace(';', ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.addSchema(stringTokenizer.nextToken().trim());
        }
        ((TextComponent)this.getSchemaTextField()).setText("");
        this.refresh();
    }

    private void processSelect(List list, boolean bl) {
        int n = 0;
        while (n < list.getItemCount()) {
            if (bl != list.isIndexSelected(n)) {
                if (bl) {
                    list.select(n);
                } else {
                    list.deselect(n);
                }
            }
            ++n;
        }
    }

    private void processSelect(boolean bl) {
        this.processSelect(this.getAvailableList(), bl);
        this.processSelect(this.getSelectedList(), bl);
        this.refreshButtons();
    }

    private void refresh() {
        this.getAvailableList().removeAll();
        this.getSelectedList().removeAll();
        int n = 0;
        while (n < this.newSchemas.size()) {
            SchemaObject schemaObject = (SchemaObject)this.newSchemas.elementAt(n);
            if (!schemaObject.getSelected()) {
                this.getAvailableList().addItem(schemaObject.getName());
            } else {
                this.getSelectedList().addItem(schemaObject.getName());
            }
            ++n;
        }
        this.refreshButtons();
    }

    private void refreshButtons() {
        if (this.getAvailableList().getSelectedIndexes().length > 0) {
            this.getAddButton().setEnabled(true);
        } else {
            this.getAddButton().setEnabled(false);
        }
        if (this.getSelectedList().getSelectedIndexes().length > 0) {
            this.getRemoveButton().setEnabled(true);
        } else {
            this.getRemoveButton().setEnabled(false);
        }
        if (this.getAvailableList().getItemCount() > 0 || this.getSelectedList().getItemCount() > 0) {
            this.getSelectAllButton().setEnabled(true);
            this.getUnselectAllButton().setEnabled(true);
        } else {
            this.getSelectAllButton().setEnabled(false);
            this.getUnselectAllButton().setEnabled(false);
        }
        if (this.getSelectedList().getItemCount() > 0) {
            this.getOkButton().setEnabled(true);
        } else {
            this.getOkButton().setEnabled(false);
        }
        if (this.getSchemaTextField().getText().equals("")) {
            this.getAddSchemaButton().setEnabled(false);
        } else {
            this.getAddSchemaButton().setEnabled(true);
        }
    }

    public void setAddButton(Button button) {
        this.addButton = button;
    }

    public void setAddSchemaButton(Button button) {
        this.addSchemaButton = button;
    }

    public void setAvailableList(List list) {
        this.availableList = list;
    }

    public void setCancelButton(Button button) {
        this.cancelButton = button;
    }

    public void setOkButton(Button button) {
        this.okButton = button;
    }

    public void setRemoveButton(Button button) {
        this.removeButton = button;
    }

    public void setSchemaTextField(TextField textField) {
        this.schemaTextField = textField;
    }

    public void setSelectAllButton(Button button) {
        this.selectAllButton = button;
    }

    public void setSelectedList(List list) {
        this.selectedList = list;
    }

    public void setUnselectAllButton(Button button) {
        this.unselectAllButton = button;
    }

    public void terminate() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.terminate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

