/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.CheckboxComparator;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.ListboxColumn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class SQLAssistTableNamePatternDialog
extends Dialog
implements ActionListener,
WindowListener,
KeyListener,
TextListener,
ItemListener {
    private SQLAssistPanel resource;
    private TextField values;
    private Button okButton;
    private Button cancelButton;
    private MCLB availableMappingsListbox;
    private String[] originalTable_Type;
    private String originalTableNamePattern;
    private String[] newTable_Type;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistTableNamePatternDialog(SQLAssistPanel sQLAssistPanel) {
        super(sQLAssistPanel.getGui().getParentFrame(), "", true);
        this.resource = sQLAssistPanel;
        this.originalTable_Type = this.resource.getQuery().getTable_Type();
        this.originalTableNamePattern = this.resource.getQuery().getTableNamePattern();
        this.build();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.processOkButton();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.processCancelButton();
        }
    }

    private void build() {
        this.availableMappingsListbox = new MCLB(this.resource, false);
        this.availableMappingsListbox.addColumn("");
        this.availableMappingsListbox.addColumn(this.resource.getString(SQLAssistStrings.TableType_Label));
        ListboxColumn listboxColumn = this.availableMappingsListbox.getColumnInfo(0);
        listboxColumn.setWidth(10);
        listboxColumn = this.availableMappingsListbox.getColumnInfo(1);
        listboxColumn.setWidth(225);
        SelectionSorter selectionSorter = new SelectionSorter();
        selectionSorter.setComparator(new CheckboxComparator());
        listboxColumn.setSorter(selectionSorter);
        this.populateAvailableMappingsListbox();
        this.setTitle(this.resource.getString(SQLAssistStrings.TableNamePatternDialog_Title));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label(this.resource.getString(SQLAssistStrings.EnterTableNamePattern_Label)));
        this.values = new TextField(this.resource.getQuery().getTableNamePattern());
        this.values.setSelectionStart(this.values.getText().length());
        this.values.setSelectionEnd(this.values.getText().length());
        panel2.add("Center", this.values);
        panel.add("North", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(10, 10));
        if (this.availableMappingsListbox.getRowCount() > 0) {
            panel3.add("Center", this.availableMappingsListbox);
        }
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new Button(this.resource.getString(SQLAssistStrings.OK_Button));
        this.cancelButton = new Button(this.resource.getString(SQLAssistStrings.Cancel_Button));
        panel4.add(this.okButton);
        panel4.add(this.cancelButton);
        this.okButton.setEnabled(false);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel5.add("East", panel4);
        panel3.add("South", panel5);
        panel.add("Center", panel3);
        if (this.resource.getOptions().getDialogBackgroundColor() != null) {
            ((Component)this).setBackground(this.resource.getOptions().getDialogBackgroundColor());
            panel.setBackground(this.resource.getOptions().getDialogBackgroundColor());
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", panel);
        this.add("North", SQLAssistUtils.spacer(10));
        this.add("South", SQLAssistUtils.spacer(10));
        this.add("East", SQLAssistUtils.spacer(10));
        this.add("West", SQLAssistUtils.spacer(10));
        this.setResizable(true);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.height < 250 || dimension.width < 300) {
            if (dimension.height < 250) {
                dimension.height = 250;
            }
            if (dimension.width < 300) {
                dimension.width = 300;
            }
            ((Component)this).setSize(dimension);
        }
        this.enableButtons();
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.values.addKeyListener(this);
        this.okButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.values.addTextListener(this);
        this.addWindowListener(this);
    }

    private void enableButtons() {
        boolean bl = true;
        if (this.values.getText().equals("")) {
            bl = false;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.availableMappingsListbox.getRowCount()) {
            Object[] objectArray = this.availableMappingsListbox.getRow(n);
            Checkbox checkbox = (Checkbox)objectArray[1];
            checkbox.addKeyListener(this);
            String string = checkbox.getLabel();
            if (checkbox.getState()) {
                vector.addElement(string);
            }
            ++n;
        }
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
            this.newTable_Type = stringArray;
        } else {
            this.newTable_Type = null;
            bl = false;
        }
        this.okButton.setEnabled(bl);
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getOkButton() {
        return this.okButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableButtons();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.okButton.isEnabled()) {
            this.processOkButton();
        } else if (keyEvent.getKeyCode() == 27 && this.resource.getOptions().getSupportEscapeCancelDialog()) {
            this.processCancelButton();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void populateAvailableMappingsListbox() {
        String[] stringArray = this.resource.getQuery().getTable_Type();
        String string = SQLAssistUtils.arrayToString(stringArray);
        this.availableMappingsListbox.removeAllRows();
        try {
            int n = 0;
            while (n < this.resource.getQuery().getDatabase().getAllTable_Type().size()) {
                String string2 = (String)this.resource.getQuery().getDatabase().getAllTable_Type().elementAt(n);
                Checkbox checkbox = new Checkbox(string2);
                if (string.equals("") || string.indexOf(";" + checkbox.getLabel() + ";") > -1) {
                    checkbox.setState(true);
                }
                checkbox.addItemListener(this);
                Object[] objectArray = new Object[]{" ", checkbox};
                this.availableMappingsListbox.addRow(objectArray);
                ++n;
            }
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(exception);
        }
    }

    private void processCancelButton() {
        this.resource.getQuery().setTable_Type(this.originalTable_Type);
        this.resource.getQuery().setTableNamePattern(this.originalTableNamePattern);
        this.terminate();
    }

    private void processOkButton() {
        this.resource.getQuery().setTable_Type(this.newTable_Type);
        this.resource.getQuery().getDatabase().setTable_Type(this.newTable_Type);
        if (!this.values.getText().equals("")) {
            this.resource.getQuery().setTableNamePattern(this.values.getText());
        }
        this.terminate();
    }

    public void setCancelButton(Button button) {
        this.cancelButton = button;
    }

    public void setOkButton(Button button) {
        this.okButton = button;
    }

    public void terminate() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.enableButtons();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.terminate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

