/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistConditionPanel;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class SQLAssistValueLookupDialog
extends Dialog
implements ActionListener,
ItemListener,
TextListener,
KeyListener,
WindowListener {
    private SQLAssistPanel resource;
    private SQLAssistConditionPanel conditionPanel;
    private List valuesList;
    private ColumnTextField searchForTextField;
    private Button searchButton;
    private Button useValueButton;
    private Button okButton;
    private Checkbox caseCheckbox;
    private Choice maxChoice;
    private int maxResults = 25;
    private Vector origValues;
    private TextField statusbar;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistValueLookupDialog(SQLAssistPanel sQLAssistPanel, SQLAssistConditionPanel sQLAssistConditionPanel) {
        super(sQLAssistPanel.getGui().getParentFrame(), "", true);
        this.resource = sQLAssistPanel;
        this.conditionPanel = sQLAssistConditionPanel;
        this.origValues = (Vector)this.conditionPanel.getValuesMultiColumnListbox().getRowTextFieldVector().clone();
        this.build();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.terminate();
        } else if (actionEvent.getSource().equals(this.useValueButton)) {
            this.processUseValueButton();
        } else if (actionEvent.getSource().equals(this.searchButton)) {
            this.processSearchButton();
        }
    }

    private void build() {
        this.setTitle(this.resource.getString(SQLAssistStrings.ValueLookup_Title, new Object[]{this.conditionPanel.getCurrentColumn().getName()}));
        this.valuesList = new List();
        if (!this.conditionPanel.getCurrentTypeArray()[this.conditionPanel.getOperatorList().getSelectedIndex()][3].equals("1")) {
            this.valuesList.setMultipleMode(true);
            this.useValueButton = new Button(this.resource.getString(SQLAssistStrings.UseValues_Button));
        } else {
            this.useValueButton = new Button(this.resource.getString(SQLAssistStrings.UseValue_Button));
        }
        this.searchForTextField = new ColumnTextField(this.resource, this.conditionPanel.getCurrentColumn(), false);
        this.searchButton = new Button(this.resource.getString(SQLAssistStrings.FindNow_Button));
        String string = this.resource.getOptions().getReferToAsOK() ? this.resource.getString(SQLAssistStrings.OK_Button) : this.resource.getString(SQLAssistStrings.Close_Button);
        this.okButton = new Button(string);
        this.maxChoice = new Choice();
        this.maxChoice.addItem(this.resource.getString(SQLAssistStrings.All_Text));
        this.maxChoice.addItem("25");
        this.maxChoice.addItem("50");
        this.maxChoice.addItem("100");
        this.maxChoice.addItem("250");
        this.maxChoice.addItem("500");
        this.maxChoice.select(String.valueOf(this.maxResults));
        this.caseCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.CaseSensitive_Text));
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.SearchFor_Label));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1, 5, 5));
        panel.add(this.searchForTextField);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("West", new Label(this.resource.getString(SQLAssistStrings.MaximumHits_Label)));
        panel3.add("Center", this.maxChoice);
        panel2.add("West", panel3);
        panel2.add("East", this.caseCheckbox);
        panel.add("South", panel2);
        panelObject.add("Center", panel);
        PanelObject panelObject2 = new PanelObject(this.resource.getString(SQLAssistStrings.AvailableValues_Label));
        panelObject2.add("Center", this.valuesList);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 3, 10, 10));
        panel4.add(this.searchButton);
        panel4.add(this.useValueButton);
        panel4.add(this.okButton);
        this.useValueButton.setEnabled(false);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel5.add("East", panel4);
        this.statusbar = new TextField();
        this.statusbar.setEditable(false);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(5, 5));
        panel6.add("Center", this.resource.getGui().buildStatusbarPanel(this.statusbar, false));
        panel6.add("South", panel5);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout(5, 5));
        panel7.add("North", panelObject);
        panel7.add("Center", panelObject2);
        panel7.add("South", panel6);
        if (this.resource.getOptions().getDialogBackgroundColor() != null) {
            ((Component)this).setBackground(this.resource.getOptions().getDialogBackgroundColor());
            panel7.setBackground(this.resource.getOptions().getDialogBackgroundColor());
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", panel7);
        this.add("North", SQLAssistUtils.spacer(10));
        this.add("South", SQLAssistUtils.spacer(10));
        this.add("East", SQLAssistUtils.spacer(10));
        this.add("West", SQLAssistUtils.spacer(10));
        this.setResizable(true);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.height < 350 || dimension.width < 525) {
            if (dimension.height < 350) {
                dimension.height = 350;
            }
            if (dimension.width < 525) {
                dimension.width = 525;
            }
            ((Component)this).setSize(dimension);
        }
        this.searchButton.addActionListener(this);
        this.useValueButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.valuesList.addItemListener(this);
        this.searchForTextField.addTextListener(this);
        this.addWindowListener(this);
        this.valuesList.addKeyListener(this);
        this.searchForTextField.addKeyListener(this);
        this.searchButton.addKeyListener(this);
        this.useValueButton.addKeyListener(this);
        this.okButton.addKeyListener(this);
        this.caseCheckbox.addKeyListener(this);
        this.maxChoice.addKeyListener(this);
        this.setStatus(this.resource.getString(SQLAssistStrings.ClickFindNow_Msg));
    }

    public Button getOkButton() {
        return this.okButton;
    }

    public Button getSearchButton() {
        return this.searchButton;
    }

    public Button getUseValueButton() {
        return this.useValueButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.valuesList) {
            int n = 0;
            if (this.valuesList.isMultipleMode()) {
                n = this.valuesList.getSelectedIndexes().length;
            } else if (this.valuesList.getSelectedIndex() > -1) {
                n = 1;
            }
            int n2 = this.conditionPanel.getCurrentValueType().equals("B") ? this.resource.getOptions().getMaxRows() * 2 : (this.conditionPanel.getCurrentValueType().equals("M") ? this.resource.getOptions().getMaxRows() : 1);
            if (n > n2) {
                this.setStatus(this.resource.getString(SQLAssistStrings.MaxValuesSelected_Msg, new Object[]{"" + n2}));
                return;
            }
            if (n > 0) {
                this.useValueButton.setEnabled(true);
                if (this.valuesList.isMultipleMode()) {
                    this.setStatus(this.resource.getString(SQLAssistStrings.ClickUseValues_Msg));
                } else {
                    this.setStatus(this.resource.getString(SQLAssistStrings.ClickUseValue_Msg));
                }
            } else {
                this.setStatus();
                this.useValueButton.setEnabled(false);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.processSearchButton();
        } else if (keyEvent.getKeyCode() == 27 && this.resource.getOptions().getSupportEscapeCancelDialog()) {
            this.terminate();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void processSearchButton() {
        this.maxResults = this.maxChoice.getSelectedItem().equals(this.resource.getString(SQLAssistStrings.All_Text)) ? 0 : Integer.parseInt(this.maxChoice.getSelectedItem());
        this.setStatus(this.resource.getString(SQLAssistStrings.Searching_Msg));
        this.valuesList.removeAll();
        boolean bl = this.caseCheckbox.getState();
        String string = this.searchForTextField.getText();
        if (!bl) {
            string = string.toUpperCase();
        }
        String string2 = SQLAssistUtils.quoteString(this.resource.getQuery().getName(this.conditionPanel.getCurrentTable(), false));
        String string3 = SQLAssistUtils.quoteString(String.valueOf(string2) + "." + this.conditionPanel.getCurrentColumn().getName());
        String string4 = "SELECT DISTINCT " + string3 + " FROM ";
        string4 = String.valueOf(string4) + string2;
        if (!string.equals("")) {
            string4 = String.valueOf(string4) + " WHERE ";
            if (this.conditionPanel.getCurrentColumn().getGenericData_Type() == 1) {
                string4 = bl ? String.valueOf(string4) + string3 + " " : String.valueOf(string4) + "TRANSLATE(" + string3 + ") ";
                string4 = string.indexOf("%") < 0 ? String.valueOf(string4) + "LIKE '%" + string + "%'" : String.valueOf(string4) + "LIKE '" + string + "'";
            } else {
                string4 = String.valueOf(string4) + string3 + " >= " + string;
            }
        }
        string4 = String.valueOf(string4) + " ORDER BY " + string3;
        try {
            this.processSearchResults(this.resource.getQuery().getDatabase().execute(string4, this.resource.getOptions().getQueryTimeout(), this.maxResults));
        }
        catch (SQLException sQLException) {
            this.resource.getGui().handleException(sQLException);
        }
    }

    private void processSearchResults(ResultSet resultSet) {
        if (resultSet == null) {
            this.setStatus(this.resource.getString(SQLAssistStrings.NoFieldsFound_Msg));
            return;
        }
        int n = 0;
        try {
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string != null) {
                    if (this.conditionPanel.getCurrentColumn().getData_Type() == 12) {
                        string = string.trim();
                    }
                    this.valuesList.addItem(string);
                    if (++n < this.maxResults || this.maxResults <= 0) continue;
                    this.setStatus(this.resource.getString(SQLAssistStrings.MaxLimitReached_Msg, new Object[]{"" + this.maxResults}));
                    return;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            this.resource.getGui().handleException(sQLException);
        }
        this.setStatus(this.resource.getString(SQLAssistStrings.SearchComplete_Msg, new Object[]{"" + n}));
    }

    private synchronized void processUseValueButton() {
        this.conditionPanel.getValuesMultiColumnListbox().removeAll();
        String[] stringArray = this.valuesList.getSelectedItems();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.resource.getOptions().getMaxRows();
        if (this.conditionPanel.getCurrentValueType().equals("B")) {
            n3 *= 2;
        }
        int n4 = 0;
        while (n4 < stringArray.length && n4 < n3) {
            if (this.conditionPanel.getCurrentValueType().equals("B")) {
                if (!bl) {
                    bl = true;
                    n = n2;
                } else {
                    bl = false;
                    n = n2 + this.resource.getOptions().getMaxRows();
                    ++n2;
                }
            } else {
                n = n4;
            }
            ColumnTextField columnTextField = (ColumnTextField)this.conditionPanel.getValuesMultiColumnListbox().getRowTextFieldVector().elementAt(n);
            columnTextField.setText(stringArray[n4]);
            columnTextField.setIsVariable(false);
            this.conditionPanel.getValuesMultiColumnListbox().rebuildCondition();
            ++n4;
        }
    }

    public void setOkButton(Button button) {
        this.okButton = button;
    }

    public void setSearchButton(Button button) {
        this.searchButton = button;
    }

    public void setStatus() {
        this.setStatus("");
    }

    public void setStatus(String string) {
        ((TextComponent)this.statusbar).setText(string);
    }

    public void setUseValueButton(Button button) {
        this.useValueButton = button;
    }

    private void terminate() {
        this.setStatus();
        this.dispose();
    }

    public void textValueChanged(TextEvent textEvent) {
        String string = this.searchForTextField.getText();
        if (string.equals("")) {
            this.setStatus();
        } else {
            this.setStatus(this.resource.getString(SQLAssistStrings.SearchFor_Msg, new Object[]{String.valueOf(this.conditionPanel.getCurrentTable().getName(false)) + "." + this.conditionPanel.getCurrentColumn().getName(), string}));
            if (this.valuesList.getItemCount() > 0) {
                int[] nArray = this.valuesList.getSelectedIndexes();
                int n = 0;
                while (n < nArray.length) {
                    this.valuesList.deselect(nArray[n]);
                    ++n;
                }
                n = 0;
                while (n < this.valuesList.getItemCount()) {
                    if (this.valuesList.getItem(n).toUpperCase().startsWith(string.toUpperCase())) {
                        this.valuesList.select(n);
                        break;
                    }
                    ++n;
                }
            }
        }
        if (!string.equals("") && this.conditionPanel.getCurrentColumn().getGenericData_Type() != 1 && this.conditionPanel.getCurrentColumn().getGenericData_Type() != 4 && this.conditionPanel.getCurrentColumn().getGenericData_Type() != 2 && this.conditionPanel.getCurrentColumn().getGenericData_Type() != -2) {
            this.searchButton.setEnabled(false);
        } else {
            this.searchButton.setEnabled(true);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.terminate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

