/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SQLAssistVariableDialog
extends Dialog
implements ActionListener,
WindowListener,
TextListener,
KeyListener {
    private SQLAssistPanel resource;
    private ColumnTextField columnTextField;
    private ColumnTextField variableTF;
    private Button okButton;
    private Button resetButton;
    private Button cancelButton;
    private boolean oldIsVariable = false;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistVariableDialog(SQLAssistPanel sQLAssistPanel, ColumnTextField columnTextField) {
        super(sQLAssistPanel.getGui().getParentFrame(), "", true);
        this.resource = sQLAssistPanel;
        this.columnTextField = columnTextField;
        this.oldIsVariable = this.columnTextField.getIsVariable();
        this.build();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.processOkButton();
        } else if (actionEvent.getSource().equals(this.resetButton)) {
            this.processResetButton();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.processCancelButton();
        }
    }

    private void build() {
        this.setTitle();
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.Variable_Label, new String[]{this.getReferToAs()}), 10);
        this.variableTF = new ColumnTextField(this.resource, this.columnTextField.getColumnObject(), this.columnTextField.getText());
        this.variableTF.setIsVariable(true);
        this.variableTF.setIsLocked(true);
        this.variableTF.setSelectionStart(this.variableTF.getText().length());
        this.variableTF.setSelectionEnd(this.variableTF.getText().length());
        panelObject.add("Center", this.variableTF);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 10, 10));
        this.okButton = new Button(this.resource.getString(SQLAssistStrings.OK_Button));
        this.resetButton = new Button(this.resource.getString(SQLAssistStrings.Reset_Button));
        this.cancelButton = new Button(this.resource.getString(SQLAssistStrings.Cancel_Button));
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        panel.add(this.resetButton);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("East", panel);
        panelObject.add("South", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("North", panelObject);
        if (this.resource.getOptions().getDialogBackgroundColor() != null) {
            ((Component)this).setBackground(this.resource.getOptions().getDialogBackgroundColor());
            panel3.setBackground(this.resource.getOptions().getDialogBackgroundColor());
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", panel3);
        this.add("North", SQLAssistUtils.spacer(10));
        this.add("South", SQLAssistUtils.spacer(10));
        this.add("East", SQLAssistUtils.spacer(10));
        this.add("West", SQLAssistUtils.spacer(10));
        this.setResizable(true);
        this.pack();
        this.variableTF.addTextListener(this);
        this.variableTF.addKeyListener(this);
        this.okButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.resetButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.resetButtons();
        this.addWindowListener(this);
        this.variableTF.setVariableFont();
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getOkButton() {
        return this.okButton;
    }

    private String getReferToAs() {
        String string = this.resource.getOptions().getReferToAsVariable() ? this.resource.getString(SQLAssistStrings.variable_Text) : this.resource.getString(SQLAssistStrings.parameter_Text);
        return string;
    }

    public Button getResetButton() {
        return this.resetButton;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() == this.variableTF && !this.variableTF.getText().equals("")) {
            this.processOkButton();
        } else if (keyEvent.getKeyCode() == 27 && this.resource.getOptions().getSupportEscapeCancelDialog()) {
            this.processCancelButton();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void processCancelButton() {
        this.columnTextField.setIsVariable(this.oldIsVariable);
        this.terminate();
    }

    private void processOkButton() {
        String string = this.variableTF.getText();
        if (string.equals("")) {
            this.columnTextField.setIsVariable(false);
        } else {
            this.columnTextField.setIsVariable(true);
        }
        this.columnTextField.setText(string);
        this.terminate();
    }

    private void processResetButton() {
        String string = this.variableTF.getText();
        if (string.length() > this.columnTextField.getColumnObject().getSize()) {
            string = string.substring(0, this.columnTextField.getColumnObject().getSize());
        }
        this.columnTextField.setIsVariable(false);
        this.columnTextField.setVariableFont();
        this.columnTextField.setText(string);
        this.terminate();
    }

    private void resetButtons() {
        if (this.variableTF.getText().equals("") || !this.columnTextField.getIsVariable()) {
            this.resetButton.setEnabled(false);
        } else {
            this.resetButton.setEnabled(true);
        }
    }

    public void setCancelButton(Button button) {
        this.cancelButton = button;
    }

    public void setOkButton(Button button) {
        this.okButton = button;
    }

    public void setResetButton(Button button) {
        this.resetButton = button;
    }

    private void setTitle() {
        if (this.columnTextField.getIsVariable()) {
            this.setTitle(this.resource.getString(SQLAssistStrings.VariableExisting_Title, new String[]{this.getReferToAs()}));
        } else {
            this.setTitle(this.resource.getString(SQLAssistStrings.VariableNew_Title, new String[]{this.getReferToAs()}));
        }
    }

    private void terminate() {
        this.columnTextField.setVariableFont();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.resetButtons();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.terminate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

