/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import com.ibm.sqlassist.common.TypeInfoObject;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ColumnObject {
    private TableObject tableObject = null;
    private int data_Type = -1;
    private String type_Name;
    private int size = -1;
    private int decimal_digits = -1;
    private String defaultValue;
    private boolean isRequired = false;
    private int genericData_Type = 1111;
    private String name;
    public static final int GENERIC_CHAR = 1;
    public static final int GENERIC_INTEGER = 4;
    public static final int GENERIC_DECIMAL = 2;
    public static final int GENERIC_BINARY = -2;
    public static final int GENERIC_DATE = 91;
    public static final int GENERIC_TIME = 92;
    public static final int GENERIC_TIMESTAMP = 93;
    public static final int GENERIC_OTHER = 1111;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public ColumnObject(TableObject tableObject, ResultSet resultSet, boolean bl) throws SQLException {
        this.setTableObject(tableObject);
        this.setName(resultSet.getString(4));
        if (this.getName() != null) {
            this.setName(this.getName().trim());
        }
        this.data_Type = resultSet.getInt(5);
        this.size = resultSet.getInt(7);
        try {
            this.type_Name = resultSet.getString(6);
        }
        catch (Exception exception) {
            this.setType_Name(null);
        }
        try {
            String string = resultSet.getString(9);
            if (string != null && !string.equals("")) {
                this.decimal_digits = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {}
        this.setDefaultValue(null);
        if (bl) {
            try {
                if (!resultSet.getString(18).equalsIgnoreCase("YES")) {
                    this.isRequired = true;
                }
            }
            catch (Exception exception) {}
        } else {
            this.isRequired = false;
        }
        this.determineGenericData_Type();
        if (this.getGenericData_Type() != 1 && this.getGenericData_Type() != 2) {
            this.setSize(-1);
        }
        if (this.getData_Type() == -1 || this.getData_Type() == 8 || this.getData_Type() == 6 || this.getData_Type() == 7) {
            this.setSize(-1);
        }
    }

    public ColumnObject(String string) {
        this(string, 1);
    }

    public ColumnObject(String string, int n) {
        this(string, n, -1, null, false, null);
    }

    public ColumnObject(String string, int n, int n2, String string2, boolean bl, TypeInfoObject typeInfoObject) {
        this.name = string;
        this.data_Type = n;
        this.size = n2;
        this.defaultValue = string2;
        this.isRequired = bl;
        if (typeInfoObject != null) {
            this.setType_Name(typeInfoObject.getType_Name(this.getData_Type()));
        }
        if (this.getType_Name() == null) {
            this.setType_Name("");
        }
        this.determineGenericData_Type();
    }

    private void determineGenericData_Type() {
        switch (this.data_Type) {
            case -1: 
            case 1: 
            case 12: {
                this.setGenericData_Type(1);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setGenericData_Type(4);
                break;
            }
            case 2: 
            case 3: {
                this.setGenericData_Type(2);
                break;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: {
                this.setGenericData_Type(-2);
                break;
            }
            case 9: 
            case 91: {
                this.setGenericData_Type(91);
                this.setSize(-1);
                this.setDecimal_digits(-1);
                break;
            }
            case 10: 
            case 92: {
                this.setGenericData_Type(92);
                this.setSize(-1);
                this.setDecimal_digits(-1);
                break;
            }
            case 11: 
            case 93: {
                this.setGenericData_Type(93);
                this.setSize(-1);
                this.setDecimal_digits(-1);
                break;
            }
            default: {
                this.setGenericData_Type(1111);
                break;
            }
        }
    }

    public int getData_Type() {
        return this.data_Type;
    }

    public int getDecimal_digits() {
        return this.decimal_digits;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getGenericData_Type() {
        return this.genericData_Type;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public String getName() {
        return this.name;
    }

    public String getNameQuoted() {
        return SQLAssistUtils.quoteString(this.getName());
    }

    public String getNameTypeSize() {
        return String.valueOf(this.getName()) + ", " + this.getTypeSize();
    }

    public int getSize() {
        return this.size;
    }

    public TableObject getTableObject() {
        return this.tableObject;
    }

    public String getType_Name() {
        return this.type_Name;
    }

    public String getTypeSize() {
        if (this.getType_Name() == null) {
            return "";
        }
        String string = "" + this.getType_Name();
        if (this.getSize() > 0) {
            string = String.valueOf(string) + "(" + this.getSize();
            if (this.getDecimal_digits() >= 0) {
                string = String.valueOf(string) + "," + this.getDecimal_digits();
            }
            string = String.valueOf(string) + ")";
        }
        return string;
    }

    public boolean quoteValue() {
        switch (this.getGenericData_Type()) {
            case 1: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public void setData_Type(int n) {
        this.data_Type = n;
    }

    public void setDecimal_digits(int n) {
        this.decimal_digits = n;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setGenericData_Type(int n) {
        this.genericData_Type = n;
    }

    public void setIsRequired(boolean bl) {
        this.isRequired = bl;
    }

    public void setName(String string) {
        this.name = this.getTableObject() == null || this.getTableObject().getDatabaseObject() == null ? string : this.getTableObject().getDatabaseObject().quote(string);
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setTableObject(TableObject tableObject) {
        this.tableObject = tableObject;
    }

    public void setType_Name(String string) {
        this.type_Name = string;
    }
}

