/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistConditionPanel;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.webrunner.widget.ListboxColumn;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ConditionMultiColumnListbox
extends MCLB
implements TextListener,
FocusListener {
    private String[][] results = new String[][]{{""}};
    private String[][] resultsNames = new String[][]{{""}};
    private boolean[][] resultsIsVariable = new boolean[][]{{false}};
    private Vector rowTextFieldVector;
    private ColumnTextField currentColumnTextField;
    private SQLAssistPanel resource;
    private SQLAssistConditionPanel sqlAssistConditionPanel;
    private int type = -1;
    private ColumnObject columnObject;
    public static final int NONE = 0;
    public static final int ONE = 1;
    public static final int MANY = 2;
    public static final int BETWEEN = 3;
    private String[][] headers = new String[][]{{""}, {"Value"}, {"Values"}, {"Value 1", "&", "Value 2"}};
    private ColumnObject lastColumnObject;
    private int lastType = -1;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restrictfd Rights -\nUse, duplication or disclosure restrictfd by\nGSA ADP Schedule Contract with IBM Corp.";

    public ConditionMultiColumnListbox(SQLAssistPanel sQLAssistPanel, SQLAssistConditionPanel sQLAssistConditionPanel) {
        super(sQLAssistPanel, false);
        this.resource = sQLAssistPanel;
        this.sqlAssistConditionPanel = sQLAssistConditionPanel;
        this.rowTextFieldVector = new Vector(this.resource.getOptions().getMaxRows() * 2, this.resource.getOptions().getMaxRows() * 2);
        this.setCaptionBarVisible(false);
    }

    public void build(ColumnObject columnObject, int n) {
        if (columnObject == this.lastColumnObject && n == this.lastType) {
            return;
        }
        this.lastColumnObject = columnObject;
        this.lastType = n;
        this.columnObject = columnObject;
        this.type = n;
        boolean bl = false;
        if (this.rowTextFieldVector.size() == 0) {
            bl = true;
        }
        int n2 = 0;
        while (n2 < this.resource.getOptions().getMaxRows() * 2) {
            ColumnTextField columnTextField = new ColumnTextField(this.resource, this.columnObject, this.getRowTextFieldVectorText(n2, true));
            columnTextField.setIsVariable(this.getRowTextFieldVectorIsVariable(n2));
            columnTextField.addTextListener(this);
            columnTextField.addFocusListener(this);
            if (bl) {
                this.rowTextFieldVector.addElement(columnTextField);
            } else {
                this.rowTextFieldVector.setElementAt(columnTextField, n2);
            }
            ++n2;
        }
        this.setUpdate(false);
        this.removeAllRows();
        this.removeAllColumns();
        this.addColumns(this.headers[this.type]);
        if (this.columnObject == null) {
            this.setUpdate(true);
            return;
        }
        switch (this.type) {
            case 0: {
                this.setUpdate(true);
                return;
            }
            case 1: 
            case 2: {
                ListboxColumn listboxColumn = this.getColumnInfo(0);
                listboxColumn.setWidth(300);
                listboxColumn.setResizable(true);
                break;
            }
            case 3: {
                ListboxColumn listboxColumn = this.getColumnInfo(0);
                listboxColumn.setWidth(80);
                listboxColumn.setResizable(true);
                listboxColumn = this.getColumnInfo(1);
                listboxColumn.setWidth(15);
                listboxColumn.setResizable(false);
                listboxColumn = this.getColumnInfo(2);
                listboxColumn.setWidth(80);
                listboxColumn.setResizable(true);
                break;
            }
        }
        this.addRows(this.buildRowsArray(this.type));
        this.rebuildCondition();
        this.setUpdate(true);
    }

    private Object[][] buildRowsArray(int n) {
        Object[][] objectArray = new Object[this.resource.getOptions().getMaxRows()][3];
        int n2 = n == 1 ? 1 : this.resource.getOptions().getMaxRows();
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3][0] = this.rowTextFieldVector.elementAt(n3);
            if (n == 3) {
                objectArray[n3][1] = this.resource.getString(SQLAssistStrings.Ampersand_Char);
                objectArray[n3][2] = this.rowTextFieldVector.elementAt(n3 + this.resource.getOptions().getMaxRows());
            } else {
                try {
                    ColumnTextField columnTextField = (ColumnTextField)this.rowTextFieldVector.elementAt(n3 + this.resource.getOptions().getMaxRows());
                    if (columnTextField.getIsVariable()) {
                        columnTextField.setText("");
                    }
                }
                catch (Exception exception) {}
            }
            ++n3;
        }
        return objectArray;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof ColumnTextField) {
            this.currentColumnTextField = (ColumnTextField)focusEvent.getSource();
            this.sqlAssistConditionPanel.getVariableButton().setEnabled(true);
            if (this.currentColumnTextField.getIsVariable() && this.resource.getOptions().getDisplayVariableButton()) {
                this.sqlAssistConditionPanel.processVariableButton();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public ColumnTextField getCurrentColumnTextField() {
        return this.currentColumnTextField;
    }

    public String[][] getResults() {
        return this.results;
    }

    public boolean[][] getResultsIsVariable() {
        return this.resultsIsVariable;
    }

    public String[][] getResultsNames() {
        return this.resultsNames;
    }

    public Vector getRowTextFieldVector() {
        return this.rowTextFieldVector;
    }

    public boolean getRowTextFieldVectorIsVariable(int n) {
        if (n >= this.rowTextFieldVector.size()) {
            return false;
        }
        try {
            ColumnTextField columnTextField = (ColumnTextField)this.rowTextFieldVector.elementAt(n);
            return columnTextField.getIsVariable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getRowTextFieldVectorText(int n) {
        return this.getRowTextFieldVectorText(n, false);
    }

    public String getRowTextFieldVectorText(int n, boolean bl) {
        if (n >= this.rowTextFieldVector.size()) {
            return "";
        }
        String string = "";
        try {
            ColumnTextField columnTextField = (ColumnTextField)this.rowTextFieldVector.elementAt(n);
            string = columnTextField.getText();
        }
        catch (Exception exception) {}
        return string;
    }

    public void rebuildCondition() {
        this.results = new String[this.resource.getOptions().getMaxRows()][2];
        this.resultsNames = new String[this.resource.getOptions().getMaxRows()][2];
        this.resultsIsVariable = new boolean[this.resource.getOptions().getMaxRows()][2];
        int n = 0;
        while (n < this.resource.getOptions().getMaxRows()) {
            this.results[n][0] = this.getRowTextFieldVectorText(n);
            this.results[n][1] = this.getRowTextFieldVectorText(n + this.resource.getOptions().getMaxRows());
            this.resultsNames[n][0] = this.getRowTextFieldVectorText(n, true);
            this.resultsNames[n][1] = this.getRowTextFieldVectorText(n + this.resource.getOptions().getMaxRows(), true);
            this.resultsIsVariable[n][0] = this.getRowTextFieldVectorIsVariable(n);
            this.resultsIsVariable[n][1] = this.getRowTextFieldVectorIsVariable(n + this.resource.getOptions().getMaxRows());
            ++n;
        }
        this.sqlAssistConditionPanel.populateDescriptionTextArea();
    }

    public void refreshFonts() {
        if (this.rowTextFieldVector != null) {
            int n = 0;
            while (n < this.rowTextFieldVector.size()) {
                ((ColumnTextField)this.rowTextFieldVector.elementAt(n)).setVariableFont();
                ++n;
            }
        }
    }

    public void removeAll() {
        int n = 0;
        while (n < this.rowTextFieldVector.size()) {
            ColumnTextField columnTextField = (ColumnTextField)this.rowTextFieldVector.elementAt(n);
            columnTextField.setText("");
            columnTextField.setIsVariable(false);
            ++n;
        }
        this.lastColumnObject = null;
        this.lastType = -1;
    }

    public void setCurrentColumnTextField(ColumnTextField columnTextField) {
        this.currentColumnTextField = columnTextField;
    }

    public void setResults(String[][] stringArray) {
        this.results = stringArray;
    }

    public void setResultsIsVariable(boolean[][] blArray) {
        this.resultsIsVariable = blArray;
    }

    public void setResultsNames(String[][] stringArray) {
        this.resultsNames = stringArray;
    }

    public void setRowTextFieldVector(Vector vector) {
        this.rowTextFieldVector = vector;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.rebuildCondition();
    }
}

