/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class TableObject {
    private DatabaseObject databaseObject;
    private Vector columns = new Vector();
    private boolean isAlias = false;
    private int aliasIndex = 1;
    private String schema;
    private String remarks;
    private boolean live = true;
    private String name;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public TableObject() {
    }

    public TableObject(DatabaseObject databaseObject, String string, String string2, boolean bl) {
        this.setDatabaseObject(databaseObject);
        this.setSchema(string2);
        this.setName(string);
        this.setLive(bl);
    }

    public TableObject(DatabaseObject databaseObject, ResultSet resultSet, String string) throws SQLException {
        this.setDatabaseObject(databaseObject);
        this.setSchema(resultSet.getString(2));
        this.setName(resultSet.getString(3));
        this.setRemarks(resultSet.getString(5));
        if (this.getRemarks() == null) {
            this.setRemarks("");
        }
        if (this.getSchema() != null) {
            this.setSchema(this.schema.trim());
        }
        if (this.getName() != null) {
            this.setName(this.name.trim());
        }
        if (this.getRemarks() != null) {
            this.setRemarks(this.remarks.trim());
            if (!this.getRemarks().equals("") && !this.getDatabaseObject().getHasRemarks()) {
                this.getDatabaseObject().setHasRemarks(true);
            }
        }
    }

    public void addColumn(ColumnObject columnObject) {
        this.columns.addElement(columnObject);
    }

    public TableObject createAlias() {
        TableObject tableObject = new TableObject();
        this.setAliasIndex(this.getAliasIndex() + 1);
        tableObject.setDatabaseObject(this.getDatabaseObject());
        tableObject.setName(this.getName(false));
        tableObject.setColumns(this.getColumns());
        tableObject.setAliasIndex(this.getAliasIndex());
        tableObject.setIsAlias(true);
        return tableObject;
    }

    public int getAliasIndex() {
        return this.aliasIndex;
    }

    public ColumnObject getColumn(String string) {
        int n = 0;
        while (n < this.columns.size()) {
            ColumnObject columnObject = (ColumnObject)this.columns.elementAt(n);
            if (columnObject.getName().equals(string)) {
                return columnObject;
            }
            ++n;
        }
        return null;
    }

    public Vector getColumns() {
        return this.columns;
    }

    public DatabaseObject getDatabaseObject() {
        return this.databaseObject;
    }

    public boolean getIsAlias() {
        return this.isAlias;
    }

    public String[] getItemNames() {
        if (this.getColumns() == null || this.getColumns().size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.getColumns().size()];
        int n = 0;
        while (n < this.getColumns().size()) {
            stringArray[n] = ((ColumnObject)this.getColumns().elementAt(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public String[][] getItems() {
        if (this.getColumns() == null || this.getColumns().size() == 0) {
            return null;
        }
        String[][] stringArray = new String[this.getColumns().size()][2];
        int n = 0;
        while (n < this.getColumns().size()) {
            stringArray[n][0] = ((ColumnObject)this.getColumns().elementAt(n)).getName();
            stringArray[n][1] = "" + ((ColumnObject)this.getColumns().elementAt(n)).getData_Type();
            ++n;
        }
        return stringArray;
    }

    public boolean getLive() {
        return this.live;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean bl) {
        String string = !bl || this.aliasIndex == 1 ? this.name : (!this.isAlias && this.aliasIndex > 1 ? String.valueOf(this.name) + "_1" : (this.isAlias ? String.valueOf(this.name) + "_" + this.aliasIndex : this.name));
        if (this.schema != null && !this.isAlias && this.aliasIndex <= 1) {
            string = String.valueOf(this.schema) + "." + string;
        }
        return string;
    }

    public String getNameQuoted() {
        return this.getNameQuoted(true);
    }

    public String getNameQuoted(boolean bl) {
        return SQLAssistUtils.quoteString(this.getName(bl));
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getSchema() {
        return this.schema;
    }

    private void processResultSet(ResultSet resultSet) throws Exception {
        while (resultSet.next()) {
            this.addColumn(new ColumnObject(this, resultSet, this.databaseObject.getSupportsNonNullableColumns()));
        }
        resultSet.close();
    }

    public void reset() {
        this.isAlias = false;
        this.aliasIndex = 1;
    }

    public void retrieveColumns() throws Exception {
        boolean bl = false;
        String string = "";
        if (this.schema == null || this.schema.equals("")) {
            if (this.databaseObject.getLogin() != null) {
                string = this.databaseObject.getLogin().toUpperCase();
            }
            bl = true;
        } else {
            string = this.schema;
        }
        this.setColumns(new Vector());
        DatabaseMetaData databaseMetaData = this.databaseObject.getConnection().getMetaData();
        try {
            this.processResultSet(databaseMetaData.getColumns(null, string, DatabaseObject.nonQuote(this.name), "%"));
        }
        catch (Exception exception) {
            if (this.columns.size() == 0 && string != null) {
                bl = true;
            }
            throw exception;
        }
        if (this.columns.size() == 0 && bl && string != null) {
            this.processResultSet(databaseMetaData.getColumns(null, null, DatabaseObject.nonQuote(this.name), "%"));
        }
    }

    public void setAliasIndex(int n) {
        this.aliasIndex = n;
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public void setDatabaseObject(DatabaseObject databaseObject) {
        this.databaseObject = databaseObject;
    }

    public void setIsAlias(boolean bl) {
        this.isAlias = bl;
    }

    public void setLive(boolean bl) {
        this.live = bl;
    }

    public void setName(String string) {
        this.name = this.getDatabaseObject() == null ? string : this.getDatabaseObject().quote(string);
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }
}

