/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.sql.ResultSet;
import java.util.Vector;

public class TypeInfoObject {
    private Vector data_Types = new Vector();
    private Vector type_Names = new Vector();
    private int[] SMALLINT = new int[]{5, 4, 3, 7, 8, 1, -5, -6, 2};
    private int[] INTEGER = this.SMALLINT;
    private int[] DECIMAL = this.SMALLINT;
    private int[] REAL = new int[]{5, 4, 3, 7, 8};
    private int[] DOUBLE = this.REAL;
    private int[] CHAR = new int[]{5, 4, 3, 7, 1, 12, -1, -2, -3, -4, 91, 92, 93};
    private int[] VARCHAR = this.CHAR;
    private int[] LONGVARCHAR = new int[]{1, 12, -1, -4};
    private int[] BINARY = new int[]{-2, -3, -4, -7};
    private int[] VARBINARY = this.BINARY;
    private int[] LONGVARBINARY = this.BINARY;
    private int[] DATE = new int[]{1, 12, 91};
    private int[] TIME = new int[]{1, 12, 92};
    private int[] TIMESTAMP = new int[]{1, 12, 91, 92, 93};
    private int[] BIGINT = this.SMALLINT;
    private int[] BIT = this.BINARY;
    private int[] FLOAT = this.REAL;
    private int[] NULL = new int[]{0};
    private int[] NUMERIC = this.SMALLINT;
    private int[] TINYINT = this.SMALLINT;
    private static final String UNKNOWN = "?";
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public TypeInfoObject() {
        this.type_Names = new Vector();
        this.data_Types = new Vector();
        this.add("BIGINT", -5);
        this.add("BINARY", -2);
        this.add("BIT", -7);
        this.add("CHAR", 1);
        this.add("DATE", 91);
        this.add("DECIMAL", 3);
        this.add("DOUBLE", 8);
        this.add("FLOAT", 6);
        this.add("INTEGER", 4);
        this.add("LONGVARBINARY", -4);
        this.add("LONGVARCHAR", -1);
        this.add("NULL", 0);
        this.add("NUMERIC", 2);
        this.add("OTHER", 1111);
        this.add("REAL", 7);
        this.add("SMALLINT", 5);
        this.add("TIME", 92);
        this.add("TIMESTAMP", 93);
        this.add("TINYINT", -6);
        this.add("VARBINARY", -3);
        this.add("VARCHAR", 12);
    }

    private void add(String string, int n) {
        this.add(string, "" + n);
    }

    private void add(String string, String string2) {
        int n = this.data_Types.indexOf(string2);
        if (n == -1) {
            this.type_Names.addElement(String.valueOf(string) + " (" + SQLAssistStrings.getText(SQLAssistStrings.Type_Text) + " " + string2 + ")");
            this.data_Types.addElement(string2);
        }
    }

    private String buildTypeText(String string) {
        return String.valueOf(this.getType_Name(string)) + " (" + SQLAssistStrings.getText(SQLAssistStrings.Type_Text) + " " + string + ")";
    }

    private boolean checkDuplicateNames() {
        int n = 0;
        while (n < this.type_Names.size() - 1) {
            String string = (String)this.type_Names.elementAt(n);
            if (this.type_Names.indexOf(string, n + 1) > -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String[] ensureContainsType(int n, String[] stringArray) {
        if (SQLAssistUtils.contains(stringArray, this.getType_Name(n))) {
            return stringArray;
        }
        if (stringArray == null) {
            return new String[]{this.getType_Name(n)};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        stringArray2[stringArray.length] = this.getType_Name(n);
        return stringArray2;
    }

    public int[] getBIGINT() {
        return this.BIGINT;
    }

    public int[] getBINARY() {
        return this.BINARY;
    }

    public int[] getBIT() {
        return this.BIT;
    }

    public int[] getCHAR() {
        return this.CHAR;
    }

    public int getData_Type(String string) {
        int n = this.type_Names.indexOf(string);
        if (n > -1) {
            return Integer.parseInt((String)this.data_Types.elementAt(n));
        }
        int n2 = 0;
        while (n2 < this.type_Names.size()) {
            String string2 = (String)this.type_Names.elementAt(n2);
            if (string2.startsWith(string)) {
                return Integer.parseInt((String)this.data_Types.elementAt(n2));
            }
            ++n2;
        }
        return 1111;
    }

    public Vector getData_Types() {
        return this.data_Types;
    }

    public int[] getDATE() {
        return this.DATE;
    }

    public int[] getDECIMAL() {
        return this.DECIMAL;
    }

    public int[] getDOUBLE() {
        return this.DOUBLE;
    }

    public int[] getFLOAT() {
        return this.FLOAT;
    }

    public int[] getINTEGER() {
        return this.INTEGER;
    }

    public int[] getLONGVARBINARY() {
        return this.LONGVARBINARY;
    }

    public int[] getLONGVARCHAR() {
        return this.LONGVARCHAR;
    }

    public String[] getMappedTypes(int n) {
        String[] stringArray = null;
        switch (n) {
            case 5: {
                stringArray = this.mapToString(this.SMALLINT);
                break;
            }
            case 4: {
                stringArray = this.mapToString(this.INTEGER);
                break;
            }
            case 7: {
                stringArray = this.mapToString(this.REAL);
                break;
            }
            case 8: {
                stringArray = this.mapToString(this.DOUBLE);
                break;
            }
            case 1: {
                stringArray = this.mapToString(this.CHAR);
                break;
            }
            case 12: {
                stringArray = this.mapToString(this.VARCHAR);
                break;
            }
            case -1: {
                stringArray = this.mapToString(this.LONGVARCHAR);
                break;
            }
            case -2: {
                stringArray = this.mapToString(this.BINARY);
                break;
            }
            case -3: {
                stringArray = this.mapToString(this.VARBINARY);
                break;
            }
            case -4: {
                stringArray = this.mapToString(this.LONGVARBINARY);
                break;
            }
            case 9: 
            case 91: {
                stringArray = this.mapToString(this.DATE);
                break;
            }
            case 10: 
            case 92: {
                stringArray = this.mapToString(this.TIME);
                break;
            }
            case 11: 
            case 93: {
                stringArray = this.mapToString(this.TIMESTAMP);
                break;
            }
            case -5: {
                stringArray = this.mapToString(this.BIGINT);
                break;
            }
            case -7: {
                stringArray = this.mapToString(this.BIT);
                break;
            }
            case 6: {
                stringArray = this.mapToString(this.FLOAT);
                break;
            }
            case 0: {
                stringArray = this.mapToString(this.NULL);
                break;
            }
            case 2: {
                stringArray = this.mapToString(this.NUMERIC);
                break;
            }
            case -6: {
                stringArray = this.mapToString(this.TINYINT);
                break;
            }
            case 3: {
                stringArray = this.mapToString(this.DECIMAL);
                break;
            }
        }
        if (stringArray != null) {
            return this.ensureContainsType(n, stringArray);
        }
        String[] stringArray2 = new String[this.type_Names.size()];
        int n2 = 0;
        while (n2 < this.type_Names.size()) {
            stringArray2[n2] = (String)this.type_Names.elementAt(n2);
            ++n2;
        }
        return stringArray2;
    }

    public int[] getNULL() {
        return this.NULL;
    }

    public int[] getNUMERIC() {
        return this.NUMERIC;
    }

    public int[] getREAL() {
        return this.REAL;
    }

    public int[] getSMALLINT() {
        return this.SMALLINT;
    }

    public int[] getTIME() {
        return this.TIME;
    }

    public int[] getTIMESTAMP() {
        return this.TIMESTAMP;
    }

    public int[] getTINYINT() {
        return this.TINYINT;
    }

    public String getType_Name(int n) {
        return this.getType_Name("" + n);
    }

    public String getType_Name(String string) {
        int n = this.data_Types.indexOf(string);
        if (n > -1) {
            return (String)this.type_Names.elementAt(n);
        }
        n = this.data_Types.indexOf("1111");
        if (n > -1) {
            return (String)this.type_Names.elementAt(n);
        }
        return UNKNOWN;
    }

    public Vector getType_Names() {
        return this.type_Names;
    }

    public int[] getVARBINARY() {
        return this.VARBINARY;
    }

    public int[] getVARCHAR() {
        return this.VARCHAR;
    }

    private String[] mapToString(int[] nArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < this.getData_Types().size()) {
            n = Integer.parseInt((String)this.getData_Types().elementAt(n2));
            String string = this.getType_Name(n);
            if (!string.equals(UNKNOWN) && SQLAssistUtils.contains(nArray, n) && !vector.contains(string)) {
                vector.addElement(string);
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public void process(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                this.add(resultSet.getString(1), resultSet.getString(2));
            }
            resultSet.close();
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < this.type_Names.size() - 1) {
            String string = (String)this.type_Names.elementAt(n);
            String string2 = (String)this.data_Types.elementAt(n);
            int n2 = n;
            while (n2 < this.type_Names.size()) {
                String string3 = (String)this.type_Names.elementAt(n2);
                String string4 = (String)this.data_Types.elementAt(n2);
                if (string.compareTo(string3) > 0) {
                    this.type_Names.setElementAt(string3, n);
                    this.data_Types.setElementAt(string4, n);
                    this.type_Names.setElementAt(string, n2);
                    this.data_Types.setElementAt(string2, n2);
                    string = (String)this.type_Names.elementAt(n);
                    string2 = (String)this.data_Types.elementAt(n);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setBIGINT(int[] nArray) {
        this.BIGINT = nArray;
    }

    public void setBINARY(int[] nArray) {
        this.BINARY = nArray;
    }

    public void setBIT(int[] nArray) {
        this.BIT = nArray;
    }

    public void setCHAR(int[] nArray) {
        this.CHAR = nArray;
    }

    public void setData_Types(Vector vector) {
        this.data_Types = vector;
    }

    public void setDATE(int[] nArray) {
        this.DATE = nArray;
    }

    public void setDECIMAL(int[] nArray) {
        this.DECIMAL = nArray;
    }

    public void setDOUBLE(int[] nArray) {
        this.DOUBLE = nArray;
    }

    public void setFLOAT(int[] nArray) {
        this.FLOAT = nArray;
    }

    public void setINTEGER(int[] nArray) {
        this.INTEGER = nArray;
    }

    public void setLONGVARBINARY(int[] nArray) {
        this.LONGVARBINARY = nArray;
    }

    public void setLONGVARCHAR(int[] nArray) {
        this.LONGVARCHAR = nArray;
    }

    public void setNULL(int[] nArray) {
        this.NULL = nArray;
    }

    public void setNUMERIC(int[] nArray) {
        this.NUMERIC = nArray;
    }

    public void setREAL(int[] nArray) {
        this.REAL = nArray;
    }

    public void setSMALLINT(int[] nArray) {
        this.SMALLINT = nArray;
    }

    public void setTIME(int[] nArray) {
        this.TIME = nArray;
    }

    public void setTIMESTAMP(int[] nArray) {
        this.TIMESTAMP = nArray;
    }

    public void setTINYINT(int[] nArray) {
        this.TINYINT = nArray;
    }

    public void setType_Names(Vector vector) {
        this.type_Names = vector;
    }

    public void setVARBINARY(int[] nArray) {
        this.VARBINARY = nArray;
    }

    public void setVARCHAR(int[] nArray) {
        this.VARCHAR = nArray;
    }
}

