/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.FocusController;
import com.ibm.jos.lap.InsetsPanel;
import com.ibm.jos.lap.TextLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;

public class ConfirmDialog
extends Dialog {
    public static final String YES_COMMAND = "yes";
    public static final String NO_COMMAND = "no";
    public static final String CANCEL_COMMAND = "cancel";
    Frame parent;
    String[] message;
    Button yesButton;
    Button noButton;
    Button cancelButton;
    Button focusButton;
    TextLabel textLabel;
    Panel controlPanel;
    InsetsPanel contentPanel;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ConfirmDialog(Frame parent) {
        super(parent);
        this.initialize();
    }

    public ConfirmDialog(Frame parent, String title) {
        super(parent, title);
        this.initialize();
    }

    public ConfirmDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initialize();
    }

    public ConfirmDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initialize();
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.yesButton != null) {
            this.yesButton.addActionListener(actionListener);
        }
        if (this.noButton != null) {
            this.noButton.addActionListener(actionListener);
        }
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(actionListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.yesButton != null) {
            this.yesButton.addKeyListener(keyListener);
        }
        if (this.noButton != null) {
            this.noButton.addKeyListener(keyListener);
        }
        if (this.cancelButton != null) {
            this.cancelButton.addKeyListener(keyListener);
        }
    }

    private void initialize() {
        this.textLabel = new TextLabel();
        this.controlPanel = new Panel();
        this.contentPanel = new InsetsPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.textLabel, "Center");
        this.contentPanel.add((Component)this.controlPanel, "South");
        this.add(this.contentPanel);
    }

    public void setActionCommand(String yesComd, String noComd, String cancelComd) {
        if (this.yesButton != null) {
            this.yesButton.setActionCommand(yesComd);
        }
        if (this.noButton != null) {
            this.noButton.setActionCommand(noComd);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setActionCommand(cancelComd);
        }
    }

    public void setButtonLabels(String yesLabel, String noLabel, String cancelLabel) {
        if (this.yesButton != null) {
            this.yesButton.setLabel(yesLabel);
        }
        if (this.noButton != null) {
            this.noButton.setLabel(noLabel);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setLabel(cancelLabel);
        }
    }

    public void setButtonNames(String yesName, String noName, String cancelName) {
        if (yesName != null) {
            this.yesButton = new Button(yesName);
            this.yesButton.setName(yesName);
            this.yesButton.setActionCommand(yesName);
            this.controlPanel.add(this.yesButton);
            if (this.focusButton == null) {
                this.focusButton = this.yesButton;
            }
        }
        if (noName != null) {
            this.noButton = new Button(noName);
            this.noButton.setName(noName);
            this.noButton.setActionCommand(noName);
            this.controlPanel.add(this.noButton);
            this.noButton.setName(noName);
            if (this.focusButton == null) {
                this.focusButton = this.noButton;
            }
        }
        if (cancelName != null) {
            this.cancelButton = new Button(cancelName);
            this.cancelButton.setName(cancelName);
            this.cancelButton.setActionCommand(CANCEL_COMMAND);
            this.controlPanel.add(this.cancelButton);
            if (this.focusButton == null) {
                this.focusButton = this.cancelButton;
            }
        }
    }

    public void setContentInsets(Insets insets) {
        this.contentPanel.setInsets(insets);
    }

    public void setDefaultFocus(String button) {
        if (this.yesButton != null && button.equals(this.yesButton.getName())) {
            this.focusButton = this.yesButton;
        }
        if (this.noButton != null && button.equals(this.noButton.getName())) {
            this.focusButton = this.noButton;
        }
        if (this.cancelButton != null && button.equals(this.cancelButton.getName())) {
            this.focusButton = this.cancelButton;
        }
        FocusController focusMan = new FocusController();
        focusMan.addComponent(this);
        focusMan.removeComponent(this.focusButton);
        focusMan.setFocusComponent(this.focusButton);
    }

    public void setMessage(String[] message) {
        this.message = message;
        if (this.textLabel == null) {
            this.textLabel = new TextLabel(message);
        } else {
            this.textLabel.setText(message);
        }
    }

    public void setMessage(String message) {
        String[] tmpMessage = new String[]{message};
        this.setMessage(tmpMessage);
    }
}

