/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.hursley.devtools.Commandline;
import com.ibm.hursley.devtools.InvalidCommandlineArgument;
import com.ibm.jos.lap.LAPConstants;
import com.ibm.jos.lap.LAPFacade;
import com.ibm.jos.lap.LAPManager;
import com.ibm.jos.lap.LAPPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;

public class LAP
extends Applet
implements LAPManager {
    public static final String STATUS_OPT = "t";
    public static final String LA_PATH_OPT = "l";
    public static final String MASTER_PATH_OPT = "m";
    public static final String STATUS_PATH_OPT = "s";
    public static final String REVALIDATE_OPT = "revalidate";
    public static final String NO_PRINT_OPT = "no_print";
    public static final String NO_EXPORT_OPT = "no_export";
    public static final String WIN_STYLE_OPT = "win_style";
    public static final String WIN_COLOR_OPT = "win_color";
    public static final String DIALOG_SIZE_OPT = "dialog_size";
    public static final String FONT_NAME_OPT = "font_name";
    public static final String FONT_STYLE_OPT = "font_style";
    public static final String FONT_SIZE_OPT = "font_size";
    private String flags = "";
    private String[] longFlags = new String[]{""};
    private String options = "tlsm";
    private String[] longOptions = new String[]{"no_export", "no_print", "win_style", "win_color", "dialog_size", "font_name", "font_size", "font_style"};
    private LAPFacade lapFacade;
    private LAPPanel lapComponent;
    private int cmdStatus = 1;
    private String laPath;
    private String mPath;
    private String statusPath;
    private boolean noExport = false;
    private boolean noPrint = false;
    private String function;
    private boolean withBorder = false;
    private Frame lapFrame;
    private int winX = 0;
    private int winY = 0;
    private int winWidth;
    private int winHeight;
    private Color winColor = LAPConstants.WIN_COLOR;
    private String winStyle = "1";
    private Font lapFont;
    private String fontName = "SanSerif";
    private int fontStyle = 0;
    private int fontSize;
    private int dialogWidth = 500;
    private int dialogHeight = 400;
    private Dialog lapDialog;
    private Color dialogColor = LAPConstants.LAP_COLOR;
    private int dialogX;
    private int dialogY;
    private String winColorString;
    private String fontStyleString;
    private String fontSizeString;
    private String dialogSizeString;
    private int xCenter;
    private int yCenter;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LAP() {
    }

    public LAP(String[] args) {
        this.parseArgs(args);
        if (this.function == null || this.function.equals("a")) {
            this.function = "a";
            this.lapFacade = new LAPFacade(this, this.laPath, this.mPath, this.statusPath);
            this.lapFacade.setExportLA(!this.noExport);
            this.doLAP();
        }
    }

    private void appletStatusChanged(int status) {
        switch (status) {
            case 91: {
                this.validate();
                break;
            }
            case 9: {
                this.getAppletContext().showDocument(this.lapFacade.getAcceptedURL());
                break;
            }
            case 3: {
                this.getAppletContext().showDocument(this.lapFacade.getDeclinedURL());
                break;
            }
        }
    }

    private void applicationStatusChanged(int status) {
        switch (status) {
            case 91: {
                String title = this.lapFacade.getLAPTitle();
                this.lapFrame.setTitle(title);
                this.lapDialog.setTitle(title);
                if (this.lapDialog.isVisible()) {
                    this.lapDialog.validate();
                } else {
                    ((Component)this.lapFrame).setVisible(true);
                    ((Component)this.lapDialog).setVisible(true);
                }
                this.lapDialog.validate();
                break;
            }
            case 9: {
                this.exit(9);
                break;
            }
            case 3: {
                this.exit(3);
                break;
            }
            default: {
                this.exit(status);
            }
        }
    }

    private void doLAP() {
        if (this.lapFacade.getStatus() == 9 || this.cmdStatus == 9) {
            this.exit(9);
        }
        if (this.cmdStatus == 5) {
            this.lapFacade.setStatus(9);
            this.exit(9);
        }
        if (!this.lapFacade.licenseIsValid()) {
            this.exit(11);
        }
        this.parseParameters();
        this.lapFrame.setTitle(this.lapFacade.getLAPTitle());
        this.lapFrame.setIconImage(this.lapFacade.getImage("icon.gif"));
        ((Component)this.lapFrame).setFont(new Font(this.fontName, this.fontStyle, this.lapFrame.getFont().getSize()));
        ((Component)this.lapFrame).setBackground(this.winColor);
        ((Component)this.lapFrame).setLocation(this.winX, this.winY);
        ((Component)this.lapFrame).setSize(this.winWidth, this.winHeight);
        if (this.winWidth > 0 && this.winHeight > 0) {
            ((Component)this.lapFrame).setVisible(true);
        }
        this.lapComponent = this.lapFacade.getLAPPanel();
        this.lapComponent.setInsets(10, 20, 10, 20);
        this.lapComponent.setParentFrame(this.lapFrame);
        if (this.fontSize > 0) {
            this.lapComponent.setFontSize(this.fontSize);
        }
        this.lapDialog = new Dialog(this.lapFrame, true);
        this.lapDialog.setTitle(this.lapFacade.getLAPTitle());
        ((Component)this.lapDialog).setBackground(this.dialogColor);
        ((Component)this.lapDialog).setLocation(this.dialogX, this.dialogY);
        ((Component)this.lapDialog).setSize(this.dialogWidth, this.dialogHeight);
        this.lapDialog.setResizable(false);
        this.lapDialog.add(this.lapComponent);
        ((Component)this.lapDialog).setVisible(true);
        this.lapDialog.validate();
        this.lapDialog.addWindowListener(new WindowAdapter(this){
            /* synthetic */ LAP this$0;

            public void windowActivated(WindowEvent event) {
                LAP.access$lapDialog(this.this$0).requestFocus();
            }
            {
                this.this$0 = this$0;
            }
        });
        this.lapDialog.addWindowListener(new WindowAdapter(this){
            /* synthetic */ LAP this$0;

            public void windowDeiconified(WindowEvent event) {
                LAP.access$lapDialog(this.this$0).requestFocus();
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private void exit(int code) {
        System.out.println("Exited with: " + code);
        System.exit(code);
    }

    public Insets getInsets() {
        Insets inst = super.getInsets();
        return new Insets(inst.top + 5, inst.left + 5, inst.bottom + 5, inst.right + 5);
    }

    public void init() {
        String bd;
        URL docBase;
        this.function = "w";
        this.getCodeBase();
        URL laURL = docBase = this.getDocumentBase();
        this.laPath = this.getParameter("la_path");
        if (!this.laPath.endsWith("/")) {
            this.laPath = String.valueOf(this.laPath) + "/";
        }
        if ((bd = this.getParameter("border")) != null && bd.toLowerCase().equals("yes")) {
            this.withBorder = true;
        }
        try {
            laURL = new URL(docBase, this.laPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Missing resources");
            this.stop();
        }
        this.lapFacade = new LAPFacade(this, laURL);
        this.lapComponent = this.lapFacade.getLAPPanel();
        this.setLayout(new BorderLayout());
        this.add(this.lapComponent);
    }

    private boolean isCmdStatusValid(int status) {
        return status == 1 || status == 5 || status == 9;
    }

    public static void main(String[] args) {
        new LAP(args);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.withBorder) {
            Dimension d = this.getSize();
            g.drawLine(1, 1, d.width - 2, 1);
            g.drawLine(1, d.height - 2, d.width - 2, d.height - 2);
            g.drawLine(1, 1, 1, d.height - 2);
            g.drawLine(d.width - 2, 1, d.width - 2, d.height - 2);
        }
    }

    private void parseArgs(String[] args) {
        try {
            Commandline cline = new Commandline(args, this.flags, this.options, this.longFlags, this.longOptions);
            if (cline.hasOption(LA_PATH_OPT) && cline.hasOption(STATUS_PATH_OPT)) {
                this.validatePaths(cline);
            } else {
                this.exit(17);
            }
            if (cline.hasOption(STATUS_OPT)) {
                this.validateCmdStatus(cline.getOption(STATUS_OPT));
            }
            if (cline.hasOption(MASTER_PATH_OPT)) {
                this.mPath = cline.getOption(MASTER_PATH_OPT);
            }
            if (cline.hasOption(NO_PRINT_OPT)) {
                this.noPrint = true;
            }
            if (cline.hasOption(NO_EXPORT_OPT)) {
                this.noExport = true;
            }
            if (cline.hasOption(WIN_STYLE_OPT)) {
                this.winStyle = cline.getOption(WIN_STYLE_OPT);
            }
            if (cline.hasOption(WIN_COLOR_OPT)) {
                this.winColorString = cline.getOption(WIN_COLOR_OPT);
            }
            if (cline.hasOption(DIALOG_SIZE_OPT)) {
                this.dialogSizeString = cline.getOption(DIALOG_SIZE_OPT);
            }
            if (cline.hasOption(FONT_NAME_OPT)) {
                this.fontName = cline.getOption(FONT_NAME_OPT);
            }
            if (cline.hasOption(FONT_STYLE_OPT)) {
                this.fontStyleString = cline.getOption(FONT_STYLE_OPT);
            }
            if (cline.hasOption(FONT_SIZE_OPT)) {
                this.fontSizeString = cline.getOption(FONT_SIZE_OPT);
            }
        }
        catch (InvalidCommandlineArgument invalidCommandlineArgument) {
            this.exit(18);
        }
    }

    private void parseParameters() {
        StringTokenizer st;
        this.lapFrame = new Frame();
        this.lapFrame.addNotify();
        Toolkit tk = this.lapFrame.getToolkit();
        Dimension dim = tk.getScreenSize();
        this.winWidth = dim.width;
        this.winHeight = dim.height;
        this.xCenter = this.winWidth / 2;
        this.yCenter = this.winHeight / 2;
        if (this.winStyle.equals("0")) {
            this.winX = this.winWidth / 2;
            this.winY = this.winHeight / 2;
            this.winWidth = 0;
            this.winHeight = 0;
        } else if (this.winStyle.equals("2")) {
            Insets wInsets = this.lapFrame.getInsets();
            this.winX = -wInsets.left;
            this.winY = -wInsets.top;
            this.winWidth = this.winWidth + wInsets.left + wInsets.right;
            this.winHeight = this.winHeight + wInsets.top + wInsets.bottom;
        }
        if (this.dialogSizeString != null) {
            st = new StringTokenizer(this.dialogSizeString, ";");
            try {
                int w = Integer.parseInt(st.nextToken());
                int h = Integer.parseInt(st.nextToken());
                if (w > 0 && w <= dim.width && h > 0 && h <= dim.height) {
                    this.dialogWidth = w;
                    this.dialogHeight = h;
                }
            }
            catch (Exception exception) {}
        }
        this.dialogX = (dim.width - this.dialogWidth) / 2;
        this.dialogY = (dim.height - this.dialogHeight) / 2;
        if (this.winColorString != null) {
            st = new StringTokenizer(this.winColorString, ";");
            try {
                int r = Integer.parseInt(st.nextToken());
                int g = Integer.parseInt(st.nextToken());
                int b = Integer.parseInt(st.nextToken());
                this.winColor = new Color(r, g, b);
            }
            catch (Exception exception) {}
        }
        if (this.fontStyleString != null) {
            this.fontStyle = this.fontStyleString.toLowerCase(Locale.ENGLISH).equals("plain") ? 0 : (this.fontStyleString.toLowerCase(Locale.ENGLISH).equals("italic") ? 2 : (this.fontStyleString.toLowerCase(Locale.ENGLISH).equals("bold") ? 1 : 0));
        }
        if (this.fontSizeString != null) {
            try {
                int fs = Integer.parseInt(this.fontSizeString);
                if (fs > 0) {
                    this.fontSize = fs;
                    this.lapFont = new Font(this.fontName, this.fontStyle, this.fontSize);
                } else {
                    this.fontSizeString = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void statusChanged(int status) {
        if (this.function.equals("w")) {
            this.appletStatusChanged(status);
        } else {
            this.applicationStatusChanged(status);
        }
    }

    private void validateCmdStatus(String cmdStatusString) {
        try {
            this.cmdStatus = Integer.parseInt(cmdStatusString);
        }
        catch (NumberFormatException numberFormatException) {
            this.exit(18);
        }
        if (!this.isCmdStatusValid(this.cmdStatus)) {
            this.exit(18);
        }
    }

    private void validatePaths(Commandline cline) {
        File fStatus;
        this.laPath = cline.getOption(LA_PATH_OPT);
        this.statusPath = cline.getOption(STATUS_PATH_OPT);
        if (this.laPath.equals("") || this.statusPath.equals("")) {
            this.exit(17);
        }
        File fLaD = new File(this.laPath);
        File fStatusD = new File(this.statusPath);
        if (!fLaD.exists()) {
            this.exit(19);
        }
        if (!fStatusD.exists()) {
            this.exit(20);
        }
        if (!(fStatus = new File(fStatusD, "status.dat")).exists()) {
            try {
                new FileOutputStream(fStatus.toString(), true).close();
                fStatus.delete();
            }
            catch (IOException iOException) {
                this.exit(21);
            }
        }
    }

    static Dialog access$lapDialog(LAP lAP) {
        return lAP.lapDialog;
    }
}

