/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.ConfirmDialog;
import com.ibm.jos.lap.FocusController;
import com.ibm.jos.lap.FocusPinnedButton;
import com.ibm.jos.lap.ImagePanel;
import com.ibm.jos.lap.InsetsPanel;
import com.ibm.jos.lap.LAPConstants;
import com.ibm.jos.lap.LAPResources;
import com.ibm.jos.lap.LayoutPanel;
import com.ibm.jos.lap.LicenseAcceptanceProcess;
import com.ibm.jos.lap.TextLabel;
import com.ibm.jos.lap.TextPrinter;
import com.ibm.jos.lap.Traversable;
import com.ibm.jos.lap.TraversableButton;
import com.ibm.jos.lap.TraversablePanel;
import com.ibm.jos.lap.TraversableTextArea;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class LAPPanel
extends InsetsPanel
implements Traversable {
    private boolean isApplet = false;
    private boolean printable = true;
    private boolean noControll = false;
    private String[] textLines;
    private Image iconImage;
    private Image logoImage;
    private Frame parentFrame;
    private int fontSize;
    private LAPTaskDistributor controller;
    private TextLabel heading;
    static final int TOP_REGION = 1;
    static final int CENTER_REGION = 2;
    static final int BOTTOM_REGION = 3;
    private TraversableTextArea laView;
    private TraversableButton languageButton;
    private FocusPinnedButton acceptButton;
    private TraversableButton declineButton;
    private TraversableButton printButton;
    private Button yesButton;
    private Button noButton;
    private Panel controlPanel;
    private ConfirmDialog declinedDlg;
    private LAPResources lapResources;
    private LicenseAcceptanceProcess model;
    protected String logoFileName = "logo.gif";
    protected String languageButName = "language";
    protected String acceptButName = "accept";
    protected String declineButName = "decline";
    protected String printButName = "print";
    protected String yesButName = "yes";
    protected String noButName = "no";
    private final String baseVersion = "1.1.6";
    private boolean focusTraversable = true;
    private boolean textAreaReusable = true;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LAPPanel(LicenseAcceptanceProcess model) {
        this.model = model;
        this.initialize();
    }

    private void acceptDbg() {
        this.acceptButton.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public void addNotify() {
        this.layoutPanel();
        this.display();
        super.addNotify();
    }

    private void confirmDecline() {
        if (this.parentFrame == null) {
            this.parentFrame = new Frame();
            this.parentFrame.addNotify();
            ((Component)this.parentFrame).setVisible(false);
        }
        this.declinedDlg = new ConfirmDialog(this.parentFrame, this.model.getLAPResources().getText(0), true);
        this.declinedDlg.setButtonNames(this.yesButName, this.noButName, null);
        this.declinedDlg.setMessage(this.lapResources.getMessage(31));
        this.declinedDlg.setContentInsets(new Insets(10, 20, 10, 20));
        this.declinedDlg.setButtonLabels(this.lapResources.getText(16), this.lapResources.getText(17), null);
        this.declinedDlg.setDefaultFocus(this.noButName);
        this.declinedDlg.addActionListener(this.controller);
        this.declinedDlg.addKeyListener(this.controller);
        ((Component)this.declinedDlg).setFont(this.getFont());
        ((Component)this.declinedDlg).setBackground(this.getBackground());
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle bounds = this.getBounds();
        bounds = this.isApplet ? new Rectangle((dim.width - 360) / 2, (dim.height - 250) / 2, 360, 280) : new Rectangle((dim.width - 360) / 2, (dim.height - 250) / 2, 360, 250);
        ((Component)this.declinedDlg).setBounds(bounds);
        this.declinedDlg.setResizable(false);
        this.declinedDlg.addWindowListener(new WindowAdapter(this){
            /* synthetic */ LAPPanel this$0;

            public void windowClosed(WindowEvent event) {
                if (LAPPanel.access$acceptButton(this.this$0) != null) {
                    LAPPanel.access$acceptButton(this.this$0).setEnabled(true);
                    LAPPanel.access$acceptButton(this.this$0).requestFocus();
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        ((Component)this.declinedDlg).setVisible(true);
    }

    private void disableButtons() {
        if (this.declineButton != null) {
            this.declineButton.setEnabled(false);
        }
        if (this.acceptButton != null) {
            this.acceptButton.setEnabled(false);
        }
        if (this.printButton != null) {
            this.printButton.setEnabled(false);
        }
        if (this.languageButton != null) {
            this.languageButton.setEnabled(false);
        }
    }

    private void display() {
        Font currentFont = new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFontSize());
        ((Component)this).setFont(currentFont);
        if (this.heading != null) {
            this.setHeading(currentFont);
        }
        this.setContents(currentFont);
        if (!this.noControll) {
            this.setControls(currentFont);
        }
        this.invalidateAll();
        this.validate();
    }

    private void enableButtons() {
        if (this.declineButton != null) {
            this.declineButton.setEnabled(true);
        }
        if (this.acceptButton != null) {
            this.acceptButton.setEnabled(true);
        }
        if (this.printButton != null) {
            this.printButton.setEnabled(true);
        }
        if (this.languageButton != null) {
            this.languageButton.setEnabled(true);
        }
    }

    public void focusAccept() {
    }

    private int getFontSize() {
        if (this.fontSize > 0) {
            return this.fontSize;
        }
        return this.model.getLAPResources().getFontSize();
    }

    private String getLanguageLabel() {
        return "View in " + this.model.getNextLocale().getDisplayLanguage(LAPConstants.DEFAULT_LOCALE);
    }

    private String getLicenseAgreement() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("");
        this.textLines = this.model.getLicenseAgreement(this.getLocale());
        int i = 0;
        while (i < this.textLines.length) {
            sb.append(this.textLines[i]);
            sb.append(lineSeparator);
            ++i;
        }
        return sb.toString();
    }

    public LicenseAcceptanceProcess getModel() {
        return this.model;
    }

    private void initialize() {
        this.setLocale(this.model.getCurrentLocale());
        this.lapResources = this.model.getLAPResources();
        this.lapResources.setLocale(this.getLocale());
    }

    private void invalidateAll() {
        this.laView.invalidate();
        if (this.languageButton != null) {
            this.languageButton.invalidate();
        }
        if (this.acceptButton != null) {
            this.acceptButton.invalidate();
        }
        if (this.declineButton != null) {
            this.declineButton.invalidate();
        }
        if (this.printButton != null) {
            this.printButton.invalidate();
        }
    }

    public boolean isTraversable() {
        return this.focusTraversable;
    }

    private void layoutPanel() {
        this.controller = new LAPTaskDistributor(this);
        this.heading = new TextLabel();
        this.heading.setInsets(new Insets(0, 0, 25, 0));
        ImagePanel ip = null;
        this.logoImage = this.lapResources.getImage(this.logoFileName, this);
        if (this.logoImage != null) {
            ip = new ImagePanel(this.logoImage);
        }
        LayoutPanel topPanel = new LayoutPanel();
        topPanel.setDeepLayout(true);
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)this.heading, "Center");
        if (ip != null) {
            topPanel.add((Component)ip, "East");
        }
        this.laView = new TraversableTextArea("", 0, 0, 1);
        ((Component)this.laView).setBackground(this.getBackground());
        this.laView.setEditable(false);
        this.laView.addKeyListener(this.controller);
        this.controlPanel = new TraversablePanel();
        if (!this.noControll) {
            this.acceptButton = new FocusPinnedButton();
            this.acceptButton.setName(this.acceptButName);
            this.acceptButton.addActionListener(this.controller);
            this.acceptButton.addKeyListener(this.controller);
            this.declineButton = new TraversableButton();
            this.declineButton.setName(this.declineButName);
            this.declineButton.addActionListener(this.controller);
            this.declineButton.addKeyListener(this.controller);
            InsetsPanel pla = new InsetsPanel(0, 30, 0, 30);
            pla.add(this.acceptButton);
            pla.add(this.declineButton);
            if (this.model.isMultiLanguage()) {
                this.languageButton = new TraversableButton();
                this.languageButton.setName(this.languageButName);
                this.languageButton.addActionListener(this.controller);
                this.languageButton.addKeyListener(this.controller);
                this.controlPanel.add(this.languageButton);
            }
            this.controlPanel.add(pla);
            if (this.printable && this.versionOk()) {
                this.printButton = new TraversableButton();
                this.printButton.setName(this.printButName);
                this.printButton.addActionListener(this.controller);
                this.printButton.addKeyListener(this.controller);
                this.controlPanel.add(this.printButton);
            }
            if (!this.focusTraversable) {
                this.laView.setFocusTraversable(false);
                this.declineButton.setFocusTraversable(false);
                if (this.languageButton != null) {
                    this.languageButton.setFocusTraversable(false);
                }
                if (this.printButton != null) {
                    this.printButton.setFocusTraversable(false);
                }
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)this.laView, "Center");
        if (!this.noControll) {
            this.add((Component)this.controlPanel, "South");
            FocusController focusMan = new FocusController();
            if (this.acceptButton != null) {
                focusMan.addComponent(this);
                focusMan.removeComponent(this.acceptButton);
                focusMan.setFocusComponent(this.acceptButton);
            }
        }
    }

    public void onAccept() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.declinedDlg == null || !this.declinedDlg.isVisible()) {
            this.model.setStatus(9);
        }
        if (this.declinedDlg != null && this.declinedDlg.isVisible()) {
            this.declinedDlg.toFront();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void onDecline() {
        this.disableButtons();
        this.confirmDecline();
    }

    public void onLanguage() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setLocale(this.model.nextLocale());
        this.lapResources.setLocale(this.getLocale());
        ((Component)this).setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFontSize()));
        if (!this.textAreaReusable) {
            this.updateLicense();
        }
        this.display();
        this.model.setStatus(91);
        this.setCaretPosition(0);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onNo() {
        this.enableButtons();
        if (this.parentFrame != null) {
            this.parentFrame.toFront();
        }
        this.declinedDlg.dispose();
        this.declinedDlg = null;
    }

    private void onPrint() {
        TextPrinter lapv = new TextPrinter(this.textLines);
        lapv.setMargin(1.0, 1.0, 1.0, 1.0);
        lapv.setFont(this.getFont());
        lapv.print();
    }

    private void onYes() {
        if (this.acceptButton != null) {
            this.acceptButton.setEnabled(true);
        }
        this.declinedDlg.dispose();
        this.declinedDlg = null;
        this.getModel().setStatus(3);
    }

    public void setAsApplet() {
        this.isApplet = true;
        this.printable = false;
    }

    private void setCaretPosition(int pos) {
        this.laView.setCaretPosition(0);
    }

    private void setContents(Font currentFont) {
        this.laView.setText(this.getLicenseAgreement());
        this.laView.setFont(currentFont);
    }

    private void setControls(Font currentFont) {
        this.acceptButton.setLabel(this.lapResources.getText(13));
        this.acceptButton.setFont(currentFont);
        this.declineButton.setLabel(this.lapResources.getText(14));
        this.declineButton.setFont(currentFont);
        if (this.model.isMultiLanguage()) {
            this.languageButton.setLabel(this.getLanguageLabel());
            this.languageButton.setFont(currentFont);
        }
        if (this.printable && this.versionOk()) {
            this.printButton.setLabel(this.lapResources.getText(15));
            this.printButton.setFont(currentFont);
        }
    }

    public void setFocusTraversable(boolean value) {
        this.focusTraversable = value;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    private void setHeading(Font currentFont) {
        this.heading.setText(this.lapResources.getText(1));
        ((Component)this.heading).setFont(currentFont);
        this.heading.setBounds(10, 10, 400, 50);
    }

    public void setLogo(Image logo) {
        this.logoImage = logo;
        this.logoFileName = null;
    }

    public void setNoControll() {
        this.noControll = true;
    }

    public void setParentFrame(Frame parent) {
        this.parentFrame = parent;
    }

    public void setPrintable(boolean value) {
        this.printable = value;
    }

    public void setTextAreaReusable(boolean value) {
        this.textAreaReusable = value;
    }

    private void updateLicense() {
        this.remove(this.laView);
        this.laView = new TraversableTextArea("", 0, 0, 1);
        ((Component)this.laView).setBackground(this.getBackground());
        this.laView.setEditable(false);
        this.laView.addKeyListener(this.controller);
        if (!this.focusTraversable) {
            this.laView.setFocusTraversable(false);
        }
        this.add((Component)this.laView, "Center");
    }

    protected boolean versionOk() {
        return true;
    }

    static FocusPinnedButton access$acceptButton(LAPPanel lAPPanel) {
        return lAPPanel.acceptButton;
    }

    static void access$onNo(LAPPanel lAPPanel) {
        lAPPanel.onNo();
    }

    static void access$onYes(LAPPanel lAPPanel) {
        lAPPanel.onYes();
    }

    static void access$onPrint(LAPPanel lAPPanel) {
        lAPPanel.onPrint();
    }

    class LAPTaskDistributor
    extends KeyAdapter
    implements ActionListener {
        /* synthetic */ LAPPanel this$0;

        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10) {
                this.dispatchTo(ke.getComponent().getName());
            } else if (ke.getKeyCode() == 9) {
                ke.getComponent().transferFocus();
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof Component) {
                this.dispatchTo(((Component)source).getName());
            }
        }

        private void dispatchTo(String compName) {
            if (compName.equals(this.this$0.languageButName)) {
                this.this$0.onLanguage();
            } else if (compName.equals(this.this$0.acceptButName)) {
                this.this$0.onAccept();
            } else if (compName.equals(this.this$0.declineButName)) {
                this.this$0.onDecline();
            } else if (compName.equals(this.this$0.printButName)) {
                LAPPanel.access$onPrint(this.this$0);
            } else if (compName.equals(this.this$0.yesButName)) {
                LAPPanel.access$onYes(this.this$0);
            } else if (compName.equals(this.this$0.noButName)) {
                LAPPanel.access$onNo(this.this$0);
            }
        }

        /* synthetic */ LAPTaskDistributor(LAPPanel this$0) {
            this.this$0 = this$0;
        }
    }
}

