/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import java.awt.FontMetrics;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class TextBreaker {
    private FontMetrics fontMetrics;
    private Locale locale;
    private int width;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextBreaker() {
    }

    public TextBreaker(FontMetrics aFontMetrics, Locale aLocale, int aWidth) {
        this.setWidth(aWidth);
        this.setLocale(aLocale);
        this.setFontMetrics(aFontMetrics);
    }

    public String[] getTextLines(String[] paragraphs) {
        if (paragraphs == null) {
            return null;
        }
        Vector<String> aVector = new Vector<String>();
        int np = paragraphs.length;
        int ip = 0;
        while (ip < np) {
            String paragraph = paragraphs[ip];
            BreakIterator boundary = BreakIterator.getLineInstance(this.locale);
            boundary.setText(paragraph);
            int start = boundary.first();
            int end = boundary.next();
            int lineLength = 0;
            StringBuffer aStringBuffer = new StringBuffer("");
            int subLength = 0;
            while (end != -1) {
                String ts = paragraph.substring(start, end);
                subLength = this.fontMetrics.stringWidth(ts);
                if (lineLength + subLength > this.width) {
                    aVector.addElement(aStringBuffer.toString());
                    aStringBuffer = new StringBuffer(ts);
                    lineLength = subLength;
                } else {
                    aStringBuffer.append(ts);
                    lineLength += subLength;
                }
                start = end;
                end = boundary.next();
            }
            aVector.addElement(aStringBuffer.toString());
            ++ip;
        }
        aVector.trimToSize();
        Object[] textLines = new String[aVector.size()];
        aVector.copyInto(textLines);
        return textLines;
    }

    public String[] getTextLines(String target) {
        String[] st = new String[]{target};
        return this.getTextLines(st);
    }

    public void setFontMetrics(FontMetrics aFontMetric) {
        this.fontMetrics = aFontMetric;
    }

    public void setLocale(Locale aLocale) {
        this.locale = aLocale;
    }

    public void setWidth(int aWidth) {
        this.width = aWidth;
    }
}

