/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.InsetsPanel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class TextLabel
extends InsetsPanel {
    private String[] inputLines;
    private String[] textLines;
    private int panelWidth = 100;
    private int panelHeight = 10;
    private boolean formatted = false;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextLabel() {
    }

    public TextLabel(String[] input) {
        this.inputLines = input;
    }

    public TextLabel(String s) {
        this.inputLines = new String[1];
        this.inputLines[0] = s;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.panelHeight);
    }

    private String[] getTextLines() {
        if (this.inputLines == null) {
            return null;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Locale locale = this.getLocale();
        int effectiveWidth = this.panelWidth - this.getInsets().left - this.getInsets().right;
        Vector<String> v = new Vector<String>();
        int np = this.inputLines.length;
        int ip = 0;
        while (ip < np) {
            String paragraph = this.inputLines[ip];
            BreakIterator boundary = BreakIterator.getLineInstance(locale);
            boundary.setText(paragraph);
            int start = boundary.first();
            int end = boundary.next();
            int lineLength = 0;
            StringBuffer sb = new StringBuffer("");
            int subLength = 0;
            while (end != -1) {
                String ts = paragraph.substring(start, end);
                subLength = fontMetrics.stringWidth(ts);
                if (lineLength + subLength > effectiveWidth) {
                    v.addElement(sb.toString());
                    sb = new StringBuffer(ts);
                    lineLength = subLength;
                } else {
                    sb.append(ts);
                    lineLength += subLength;
                }
                start = end;
                end = boundary.next();
            }
            v.addElement(sb.toString());
            ++ip;
        }
        v.trimToSize();
        Object[] textLines = new String[v.size()];
        v.copyInto(textLines);
        return textLines;
    }

    public void paint(Graphics g) {
        if (this.textLines != null) {
            int lines = this.textLines.length;
            int x = this.getInsets().left;
            int y = this.getInsets().top;
            int lineAdvance = this.getFontMetrics(this.getFont()).getHeight();
            int i = 0;
            while (i < lines) {
                g.drawString(this.textLines[i], x, y += lineAdvance);
                ++i;
            }
        }
    }

    private void reformat() {
        if (this.textLines == null || this.panelWidth != this.getSize().width || this.panelHeight != this.getSize().height) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            if (fm != null) {
                this.panelWidth = this.getSize().width;
                this.textLines = this.getTextLines();
                this.panelHeight = this.textLines.length * fm.getHeight() + this.getInsets().top + this.getInsets().bottom;
            } else {
                this.textLines = null;
            }
            this.invalidate();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.reformat();
    }

    public void setText(String[] orig) {
        this.inputLines = orig;
        this.textLines = null;
        this.reformat();
    }

    public void setText(String orig) {
        String[] temp = new String[]{orig};
        this.setText(temp);
    }
}

