/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.juggler;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.ImageProducer;
import java.net.URL;

public class Juggler
extends Applet
implements Runnable {
    private transient Image[] images;
    private transient Thread animationThread;
    private int rate = 125;
    private transient int loop;
    private boolean stopped = true;

    public synchronized void start() {
        this.startJuggling();
    }

    public synchronized void stop() {
        this.stopJuggling();
    }

    private void initialize() {
        this.images = new Image[5];
        int n = 0;
        while (n < 5) {
            String string = "Juggler" + n + ".gif";
            this.images[n] = this.loadImage(string);
            if (this.images[n] == null) {
                System.err.println("Couldn't load image " + string);
                return;
            }
            ++n;
        }
    }

    private Image loadImage(String string) {
        try {
            URL uRL = this.getClass().getResource(string);
            return this.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void paint(Graphics graphics) {
        int n = this.loop % 4 + 1;
        if (this.stopped) {
            n = 0;
        }
        if (this.images == null || n >= this.images.length) {
            return;
        }
        Image image = this.images[n];
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public synchronized void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.notify();
    }

    public synchronized void startJuggling() {
        if (this.images == null) {
            this.initialize();
        }
        if (this.animationThread == null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
        this.stopped = false;
        this.notify();
    }

    public synchronized void stopJuggling() {
        this.stopped = true;
        this.loop = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null || this.images == null) {
            return;
        }
        Image image = this.images[0];
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void startJuggling(ActionEvent actionEvent) {
        this.startJuggling();
    }

    public void stopJuggling(ActionEvent actionEvent) {
        this.stopJuggling();
    }

    public int getAnimationRate() {
        return this.rate;
    }

    public void setAnimationRate(int n) {
        this.rate = n;
    }

    public Dimension getMinimumSize() {
        return new Dimension(144, 125);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.minimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void run() {
        try {
            while (true) {
                Object object = this;
                synchronized (object) {
                    while (this.stopped || !this.isEnabled()) {
                        this.wait();
                    }
                }
                ++this.loop;
                object = this.getGraphics();
                Image image = this.images[this.loop % 4 + 1];
                if (object != null && image != null) {
                    ((Graphics)object).drawImage(image, 0, 0, this);
                }
                Thread.sleep(this.rate);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

