/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnectionAfterEventMulticaster;
import com.ibm.db.DatabaseConnectionAfterListener;
import com.ibm.db.DatabaseConnectionBeforeEventMulticaster;
import com.ibm.db.DatabaseConnectionBeforeListener;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.LogonDialog;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.DatabaseLogonSpec;
import java.awt.Component;
import java.awt.Frame;
import java.beans.Beans;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseConnection
implements Serializable {
    protected DatabaseConnectionSpec fieldConnectionSpec = null;
    protected boolean fieldAutoCommit = true;
    protected boolean fieldPromptUID = false;
    protected transient com.ibm.db.base.DatabaseConnection connection = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected transient DatabaseConnectionBeforeListener aDatabaseConnectionBeforeListener = null;
    protected transient DatabaseConnectionAfterListener aDatabaseConnectionAfterListener = null;
    private boolean externallyManaged = false;
    protected transient String databaseName = null;
    protected transient boolean supportsPositionedUpdate = false;
    protected transient boolean supportsPositionedDelete = false;
    protected transient boolean supportsMixedCaseIdentifiers = false;
    protected transient boolean supportsMixedCaseQuotedIdentifiers = false;
    public static final int POOL_TYPE_NONE = 0;
    public static final int POOL_TYPE_WEBSPHERE = 1;
    static final long serialVersionUID = -613251554871044618L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public DatabaseConnection() {
        this.initialize();
    }

    protected DatabaseConnection(DatabaseConnectionSpec databaseConnectionSpec) {
        this.fieldConnectionSpec = databaseConnectionSpec;
        this.initialize();
    }

    public DatabaseConnection(Connection connection) throws com.ibm.db.DataException {
        try {
            if (connection.isClosed()) {
                String string = Utilities.logMessage(IBMDBMessages.connectionClosed);
                throw new com.ibm.db.DataException(string, 208);
            }
            this.connection = new com.ibm.db.base.DatabaseConnection(connection);
            this.obtainConnectionMetaDataInfo();
            this.externallyManaged = true;
        }
        catch (SQLException sQLException) {
            String string = Utilities.logSQLException(sQLException);
            throw new com.ibm.db.DataException(string, sQLException);
        }
        this.initialize();
    }

    public void addDatabaseConnectionAfterListener(DatabaseConnectionAfterListener databaseConnectionAfterListener) {
        this.aDatabaseConnectionAfterListener = DatabaseConnectionAfterEventMulticaster.add(this.aDatabaseConnectionAfterListener, databaseConnectionAfterListener);
    }

    public void addDatabaseConnectionBeforeListener(DatabaseConnectionBeforeListener databaseConnectionBeforeListener) {
        this.aDatabaseConnectionBeforeListener = DatabaseConnectionBeforeEventMulticaster.add(this.aDatabaseConnectionBeforeListener, databaseConnectionBeforeListener);
    }

    public synchronized void commit() throws com.ibm.db.DataException {
        if (!this.isConnected()) {
            String string = Utilities.logMessage(IBMDBMessages.noActiveConnection);
            throw new com.ibm.db.DataException(string, 226);
        }
        try {
            this.fireAboutToCommit(new DataEvent(this));
        }
        catch (DataRuntimeException dataRuntimeException) {
            if (dataRuntimeException.getException() != null) {
                throw (com.ibm.db.DataException)dataRuntimeException.getException();
            }
            throw dataRuntimeException;
        }
        try {
            this.connection.commitTransaction();
        }
        catch (SQLException sQLException) {
            String string = Utilities.logSQLException(sQLException);
            throw new com.ibm.db.DataException(string, sQLException);
        }
        this.fireCommitted(new DataEvent(this));
    }

    public synchronized boolean connect() throws com.ibm.db.DataException {
        Object[] objectArray;
        if (this.externallyManaged) {
            String string = Utilities.logMessage(IBMDBMessages.externallyManaged);
            throw new com.ibm.db.DataException(string, 209);
        }
        if (this.isConnected()) {
            String string = Utilities.logMessage(IBMDBMessages.alreadyConnected);
            throw new com.ibm.db.DataException(string, 245);
        }
        this.fireAboutToConnect(new DataEvent(this));
        if (this.getPromptUID()) {
            if (Beans.isGuiAvailable()) {
                objectArray = new LogonDialog((Component)new Frame());
                if (!objectArray.promptAndSetUID(this.fieldConnectionSpec)) {
                    return false;
                }
            } else {
                String string = Utilities.logMessage(IBMDBMessages.noGui);
                throw new com.ibm.db.DataException(string, 228);
            }
        }
        try {
            this.connection = this.fieldConnectionSpec.connect();
            if (this.connection != null) {
                objectArray = this.connection.getConnectionMetaData();
                if (!this.fieldAutoCommit && !objectArray.supportsTransactions()) {
                    this.disconnect();
                    String string = Utilities.logMessage(IBMDBMessages.noTransactions);
                    throw new com.ibm.db.DataException(string, 239);
                }
                this.connection.setAutoCommit(this.fieldAutoCommit);
                this.obtainConnectionMetaDataInfo();
            }
        }
        catch (DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
        }
        catch (ClassNotFoundException classNotFoundException) {
            objectArray = new Object[]{this.fieldConnectionSpec.getDriverName()};
            String string = Utilities.logMessage(IBMDBMessages.driverNotFound, objectArray);
            throw new com.ibm.db.DataException(string, 236);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            objectArray = new Object[]{this.fieldConnectionSpec.getDriverName()};
            String string = Utilities.logMessage(IBMDBMessages.driverNotFound, objectArray);
            throw new com.ibm.db.DataException(string, 236);
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            String string2 = null;
            if (string.equals("08004")) {
                string2 = Utilities.logMessage(IBMDBMessages.badUidPwd);
            }
            String string3 = Utilities.logSQLException(sQLException);
            if (string2 == null) {
                string2 = string3;
            }
            throw new com.ibm.db.DataException(string2, sQLException);
        }
        this.fireConnected(new DataEvent(this));
        return true;
    }

    public synchronized void disconnect() throws com.ibm.db.DataException {
        if (!this.isConnected()) {
            String string = Utilities.logMessage(IBMDBMessages.noActiveConnection);
            throw new com.ibm.db.DataException(string, 226);
        }
        this.fireAboutToDisconnect(new DataEvent(this));
        if (!this.externallyManaged) {
            try {
                if (!this.fieldConnectionSpec.disconnect()) {
                    this.connection.disconnect();
                }
            }
            catch (DataException dataException) {
                Utilities.logBaseException(dataException);
                throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Object[] objectArray = new Object[]{this.fieldConnectionSpec.getDriverName()};
                String string = Utilities.logMessage(IBMDBMessages.driverNotFound, objectArray);
                throw new com.ibm.db.DataException(string, 236);
            }
            catch (SQLException sQLException) {
                String string = Utilities.logSQLException(sQLException);
                throw new com.ibm.db.DataException(string, sQLException);
            }
        }
        this.connection = null;
        this.fireDisconnected(new DataEvent(this));
    }

    protected void fireAboutToCommit(DataEvent dataEvent) {
        if (this.aDatabaseConnectionBeforeListener == null) {
            return;
        }
        this.aDatabaseConnectionBeforeListener.aboutToCommit(dataEvent);
    }

    protected void fireAboutToConnect(DataEvent dataEvent) {
        if (this.aDatabaseConnectionBeforeListener == null) {
            return;
        }
        this.aDatabaseConnectionBeforeListener.aboutToConnect(dataEvent);
    }

    protected void fireAboutToDisconnect(DataEvent dataEvent) {
        if (this.aDatabaseConnectionBeforeListener == null) {
            return;
        }
        this.aDatabaseConnectionBeforeListener.aboutToDisconnect(dataEvent);
    }

    protected void fireAboutToRollback(DataEvent dataEvent) {
        if (this.aDatabaseConnectionBeforeListener == null) {
            return;
        }
        this.aDatabaseConnectionBeforeListener.aboutToRollback(dataEvent);
    }

    protected void fireCommitted(DataEvent dataEvent) {
        if (this.aDatabaseConnectionAfterListener == null) {
            return;
        }
        this.aDatabaseConnectionAfterListener.committed(dataEvent);
    }

    protected void fireConnected(DataEvent dataEvent) {
        if (this.aDatabaseConnectionAfterListener == null) {
            return;
        }
        this.aDatabaseConnectionAfterListener.connected(dataEvent);
    }

    protected void fireDisconnected(DataEvent dataEvent) {
        if (this.aDatabaseConnectionAfterListener == null) {
            return;
        }
        this.aDatabaseConnectionAfterListener.disconnected(dataEvent);
    }

    protected void fireRolledBack(DataEvent dataEvent) {
        if (this.aDatabaseConnectionAfterListener == null) {
            return;
        }
        this.aDatabaseConnectionAfterListener.rolledBack(dataEvent);
    }

    public boolean getAutoCommit() {
        return this.fieldAutoCommit;
    }

    protected com.ibm.db.base.DatabaseConnection getConnection() {
        return this.connection;
    }

    public String getConnectionAlias() {
        return this.fieldConnectionSpec.getAlias();
    }

    public int getConnectionPoolType() {
        return this.fieldConnectionSpec.getConnectionPoolType();
    }

    public DatabaseConnectionSpec getConnectionSpec() {
        return this.fieldConnectionSpec;
    }

    public String getDataSourceName() {
        return this.fieldConnectionSpec.getDataSourceName();
    }

    public String getDriverName() {
        return this.fieldConnectionSpec.getDriverName();
    }

    public DatabaseMetaData getJDBCMetaData() throws com.ibm.db.DataException {
        if (this.isConnected()) {
            try {
                return this.connection.getJdbcConnection().getMetaData();
            }
            catch (SQLException sQLException) {
                String string = Utilities.logSQLException(sQLException);
                throw new com.ibm.db.DataException(string, sQLException);
            }
        }
        return null;
    }

    private String getPassword() {
        return this.fieldConnectionSpec.getLogonSpec().getPassword();
    }

    public boolean getPromptUID() {
        return this.fieldConnectionSpec.getPromptUID();
    }

    public Properties getProperties() {
        return this.fieldConnectionSpec.getProps();
    }

    public String getUserID() {
        return this.fieldConnectionSpec.getLogonSpec().getId();
    }

    protected static void handleSQLException(SQLException sQLException) throws com.ibm.db.DataException {
        String string = Utilities.logSQLException(sQLException);
        throw new com.ibm.db.DataException(string, sQLException);
    }

    private void initialize() {
        if (this.fieldConnectionSpec == null) {
            try {
                this.fieldConnectionSpec = new DatabaseConnectionSpec("", "");
            }
            catch (Throwable throwable) {
                String string = Utilities.logMessage(IBMDBMessages.noConnectionSpec);
                throw new DataRuntimeException(string);
            }
        }
        if (this.fieldConnectionSpec.getLogonSpec() == null) {
            try {
                DatabaseLogonSpec databaseLogonSpec = new DatabaseLogonSpec("", "");
                this.fieldConnectionSpec.setLogonSpec(databaseLogonSpec);
            }
            catch (Throwable throwable) {
                String string = Utilities.logMessage(IBMDBMessages.noLogonSpec);
                throw new DataRuntimeException(string);
            }
        }
    }

    public boolean isConnected() throws com.ibm.db.DataException {
        boolean bl = false;
        try {
            if (this.connection != null) {
                bl = this.connection.isConnected();
            }
        }
        catch (SQLException sQLException) {
            DatabaseConnection.handleSQLException(sQLException);
        }
        return bl;
    }

    public boolean isExternallyManaged() {
        return this.externallyManaged;
    }

    protected void obtainConnectionMetaDataInfo() throws com.ibm.db.DataException {
        try {
            DatabaseMetaData databaseMetaData = this.getJDBCMetaData();
            this.supportsPositionedUpdate = databaseMetaData.supportsPositionedUpdate();
            this.supportsPositionedDelete = databaseMetaData.supportsPositionedDelete();
            this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
            this.supportsMixedCaseQuotedIdentifiers = databaseMetaData.supportsMixedCaseQuotedIdentifiers();
            this.databaseName = this.getJDBCMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            String string = Utilities.logSQLException(sQLException);
            throw new com.ibm.db.DataException(string, sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public void removeDatabaseConnectionAfterListener(DatabaseConnectionAfterListener databaseConnectionAfterListener) {
        this.aDatabaseConnectionAfterListener = DatabaseConnectionAfterEventMulticaster.remove(this.aDatabaseConnectionAfterListener, databaseConnectionAfterListener);
    }

    public void removeDatabaseConnectionBeforeListener(DatabaseConnectionBeforeListener databaseConnectionBeforeListener) {
        this.aDatabaseConnectionBeforeListener = DatabaseConnectionBeforeEventMulticaster.remove(this.aDatabaseConnectionBeforeListener, databaseConnectionBeforeListener);
    }

    public synchronized void rollback() throws com.ibm.db.DataException {
        if (!this.isConnected()) {
            String string = Utilities.logMessage(IBMDBMessages.noActiveConnection);
            throw new com.ibm.db.DataException(string, 226);
        }
        this.fireAboutToRollback(new DataEvent(this));
        try {
            this.connection.rollbackTransaction();
        }
        catch (SQLException sQLException) {
            String string = Utilities.logSQLException(sQLException);
            throw new com.ibm.db.DataException(string, sQLException);
        }
        this.fireRolledBack(new DataEvent(this));
    }

    public synchronized void setAutoCommit(boolean bl) throws com.ibm.db.DataException {
        this.fieldAutoCommit = bl;
        if (this.isConnected()) {
            try {
                DatabaseMetaData databaseMetaData = this.connection.getConnectionMetaData();
                if (!this.fieldAutoCommit && !databaseMetaData.supportsTransactions()) {
                    this.fieldAutoCommit = true;
                    String string = Utilities.logMessage(IBMDBMessages.noTransactions);
                    throw new com.ibm.db.DataException(string, 239);
                }
                this.connection.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                String string = Utilities.logSQLException(sQLException);
                throw new com.ibm.db.DataException(string, sQLException);
            }
        }
    }

    public void setConnectionAlias(String string) {
        this.fieldConnectionSpec.setAlias(string);
    }

    public void setConnectionPoolType(int n) throws com.ibm.db.DataException {
        try {
            this.fieldConnectionSpec.setConnectionPoolType(n);
        }
        catch (DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new com.ibm.db.DataException(dataException.getMessage(), 113);
        }
    }

    protected void setConnectionSpec(DatabaseConnectionSpec databaseConnectionSpec) {
        this.fieldConnectionSpec = databaseConnectionSpec;
    }

    public void setDataSourceName(String string) {
        this.fieldConnectionSpec.setDataSourceName(string);
    }

    public void setDriverName(String string) {
        this.fieldConnectionSpec.setDriverName(string);
    }

    public void setPassword(String string) {
        this.fieldConnectionSpec.getLogonSpec().setPassword(string);
    }

    public void setPassword(String string, boolean bl) throws com.ibm.db.DataException {
        try {
            this.fieldConnectionSpec.getLogonSpec().setPassword(string, bl);
        }
        catch (DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
        }
    }

    public void setPromptUID(boolean bl) {
        this.fieldConnectionSpec.setPromptUID(bl);
    }

    public void setProperties(Properties properties) {
        this.fieldConnectionSpec.setProps(properties);
    }

    public void setUserID(String string) {
        this.fieldConnectionSpec.getLogonSpec().setId(string);
    }
}

