/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.JDBCConnectionManager;
import com.ibm.db.base.UtilitiesBase;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DatabaseConnection {
    private DatabaseConnectionSpec connSpec;
    private Connection jdbcConnection;
    private JDBCConnectionManager databaseManager;
    private boolean externallyManaged = false;
    private transient Hashtable dbSearchTypeInfo;
    transient Class websphereJdbcConnPoolAccess = null;
    protected transient Method getIBMJdbcConn = null;
    protected transient Object websphereConnection = null;
    protected transient Method getJdbcConn = null;
    protected transient Method releaseIBMConn = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";
    static Class class$java$lang$String;

    public DatabaseConnection(JDBCConnectionManager jDBCConnectionManager) {
        this.setDatabaseManager(jDBCConnectionManager);
    }

    public DatabaseConnection(Connection connection) throws SQLException {
        this.setJdbcConnection(connection);
        this.externallyManaged = true;
    }

    public void commitTransaction() throws SQLException {
        this.getJdbcConnection().commit();
    }

    public void connectToDataSource() throws SQLException, DataException {
        if (this.getConnectionSpec().getConnectionPoolType() == 1) {
            this.obtainWebsphereConnection();
        } else {
            String string = this.getConnectionSpec().getLogonSpec().getId();
            String string2 = this.getConnectionSpec().getLogonSpec().getPassword();
            if (this.getConnectionSpec().getProps() == null) {
                this.setJdbcConnection(DriverManager.getConnection(this.getConnectionUrl(), string, string2));
            } else {
                Properties properties = (Properties)((Hashtable)this.getConnectionSpec().getProps()).clone();
                ((Hashtable)properties).put("user", string);
                ((Hashtable)properties).put("password", string2);
                this.setJdbcConnection(DriverManager.getConnection(this.getConnectionUrl(), properties));
            }
        }
        this.getSearchTypeInfo();
    }

    public void disconnect() throws SQLException, DataException, NullPointerException {
        block4: {
            if (this.websphereConnection != null) {
                this.releaseWebsphereConnection();
            } else {
                try {
                    this.getJdbcConnection().close();
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().equals("25000")) break block4;
                    this.rollbackTransaction();
                    this.getJdbcConnection().close();
                }
            }
        }
        this.setJdbcConnection(null);
    }

    public synchronized int executeQuerySpec(DatabaseQuerySpec databaseQuerySpec) throws SQLException, DataException {
        String string = databaseQuerySpec.getStatement();
        if (string != null) {
            Statement statement = this.getJdbcConnection().createStatement();
            int n = statement.executeUpdate(string);
            statement.close();
            return n;
        }
        String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.noSQL);
        throw new DataException(string2, 106);
    }

    public synchronized int executeQuerySpecWithValues(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) throws SQLException, DataException {
        String string = databaseQuerySpec.getStatement();
        if (string != null) {
            PreparedStatement preparedStatement = this.getJdbcConnection().prepareStatement(string);
            this.setInputValues(databaseRow, preparedStatement, databaseQuerySpec);
            int n = preparedStatement.executeUpdate();
            preparedStatement.close();
            return n;
        }
        String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.noSQL);
        throw new DataException(string2, 106);
    }

    public String getAlias() {
        return this.getConnectionSpec().getAlias();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getJdbcConnection().getAutoCommit();
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        return this.getJdbcConnection().getMetaData();
    }

    public DatabaseConnectionSpec getConnectionSpec() {
        return this.connSpec;
    }

    private String getConnectionUrl() {
        return this.getConnectionSpec().getDataSourceName();
    }

    protected JDBCConnectionManager getDatabaseManager() {
        return this.databaseManager;
    }

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    protected void getOutputValues(DatabaseRow databaseRow, PreparedStatement preparedStatement, DatabaseQuerySpec databaseQuerySpec) throws DataException, SQLException {
        Enumeration enumeration = databaseRow.getColumnNames();
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseTypeField databaseTypeField = null;
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            databaseTypeField = databaseCompoundType.fieldAt(n);
            if (databaseTypeField.getMode() == 4 || databaseTypeField.getMode() == 2) {
                Object object = databaseCompoundType.fieldAt(n).getObject((CallableStatement)preparedStatement, n);
                databaseRow.put((String)e, object);
            }
            ++n;
        }
    }

    protected Hashtable getSearchTypeInfo() throws SQLException {
        if (this.dbSearchTypeInfo == null) {
            this.dbSearchTypeInfo = new Hashtable();
            ResultSet resultSet = this.jdbcConnection.getMetaData().getTypeInfo();
            while (resultSet.next()) {
                this.dbSearchTypeInfo.put(resultSet.getString(1), new Integer(resultSet.getInt(9)));
            }
            resultSet.close();
        }
        return this.dbSearchTypeInfo;
    }

    public boolean isConnected() throws SQLException {
        if (this.jdbcConnection == null) {
            return false;
        }
        return !this.jdbcConnection.isClosed();
    }

    protected void obtainWebsphereConnection() throws DataException {
        block21: {
            try {
                if (this.getIBMJdbcConn != null) break block21;
                this.websphereJdbcConnPoolAccess = Class.forName("com.ibm.servlet.connmgr.WebsphereJdbcConnPoolAccess");
                Class[] classArray = new Class[4];
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    try {
                        clazz = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class<?> clazz3 = class$java$lang$String;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                Class<?> clazz4 = class$java$lang$String;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[3] = clazz4;
                this.getIBMJdbcConn = this.websphereJdbcConnPoolAccess.getMethod("getIBMJdbcConnection", classArray);
            }
            catch (Exception exception) {
                String string = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
                throw new DataException(string, 112);
            }
        }
        String string = this.getConnectionSpec().getDriverName();
        String string2 = this.getConnectionSpec().getDataSourceName();
        String string3 = this.getConnectionSpec().getLogonSpec().getId();
        String string4 = this.getConnectionSpec().getLogonSpec().getPassword();
        try {
            this.websphereConnection = this.getIBMJdbcConn.invoke((Object)this.websphereJdbcConnPoolAccess, string, string2, string3, string4);
        }
        catch (Exception exception) {
            String string5 = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
            throw new DataException(string5, 112);
        }
        try {
            Object object;
            if (this.websphereConnection != null) {
                if (this.getJdbcConn == null) {
                    object = Class.forName("com.ibm.servlet.connmgr.IBMJdbcConn");
                    this.getJdbcConn = ((Class)object).getMethod("getJdbcConnection", new Class[0]);
                }
            } else {
                String string6 = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
                throw new DataException(string6, 112);
            }
            object = (Connection)this.getJdbcConn.invoke(this.websphereConnection, new Object[0]);
            this.setJdbcConnection((Connection)object);
        }
        catch (Exception exception) {
            UtilitiesBase.logMessage(exception.toString());
            String string7 = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
            throw new DataException(string7, 112);
        }
    }

    protected void registerOutputParameters(DatabaseRow databaseRow, PreparedStatement preparedStatement, DatabaseQuerySpec databaseQuerySpec) throws SQLException {
        Enumeration enumeration = databaseRow.getColumnNames();
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseTypeField databaseTypeField = null;
        int n = 1;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            databaseTypeField = databaseCompoundType.fieldAt(n);
            if (databaseTypeField.getMode() == 4 || databaseTypeField.getMode() == 2) {
                n2 = databaseTypeField.getSQLType();
                if (n2 == 2 || n2 == 3) {
                    ((CallableStatement)preparedStatement).registerOutParameter(n, n2, databaseTypeField.getScale());
                } else {
                    ((CallableStatement)preparedStatement).registerOutParameter(n, n2);
                }
            }
            ++n;
        }
    }

    protected void releaseWebsphereConnection() throws DataException {
        try {
            if (this.releaseIBMConn == null) {
                Class<?> clazz = Class.forName("com.ibm.servlet.connmgr.IBMJdbcConn");
                this.releaseIBMConn = clazz.getMethod("releaseIBMConnection", new Class[0]);
            }
            this.releaseIBMConn.invoke(this.websphereConnection, new Object[0]);
            this.websphereConnection = null;
        }
        catch (Exception exception) {
            String string = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
            throw new DataException(string, 112);
        }
    }

    public DatabaseResultTable resultTableFromQuerySpec(DatabaseQuerySpec databaseQuerySpec) throws SQLException, DataException {
        return new DatabaseResultTable(this, databaseQuerySpec);
    }

    public DatabaseResultTable resultTableFromQuerySpec(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) throws SQLException, DataException {
        return new DatabaseResultTable(this, databaseQuerySpec, databaseRow);
    }

    public DatabaseResultTable resultTableOnResultSet(ResultSet resultSet) throws SQLException, DataException {
        return new DatabaseResultTable(this, resultSet);
    }

    public void rollbackTransaction() throws SQLException {
        this.getJdbcConnection().rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.getJdbcConnection().setAutoCommit(bl);
    }

    public void setConnectionSpec(DatabaseConnectionSpec databaseConnectionSpec) {
        this.connSpec = databaseConnectionSpec;
    }

    protected void setDatabaseManager(JDBCConnectionManager jDBCConnectionManager) {
        this.databaseManager = jDBCConnectionManager;
    }

    protected void setInputValues(DatabaseRow databaseRow, PreparedStatement preparedStatement, DatabaseQuerySpec databaseQuerySpec) throws SQLException {
        Enumeration enumeration = databaseRow.getColumnNames();
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseTypeField databaseTypeField = null;
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            int n2 = databaseRow.getColumnIndex((String)e);
            Object object = databaseRow.getAtIndex(n2);
            if (databaseCompoundType == null) {
                preparedStatement.setObject(n, object);
            } else {
                databaseTypeField = databaseCompoundType.fieldAt(n);
                if ((databaseTypeField.getMode() == 1 || databaseTypeField.getMode() == 2) && databaseRow.colWasChanged(n2)) {
                    databaseTypeField.setObject(object, preparedStatement, n);
                }
            }
            ++n;
        }
    }

    protected void setJdbcConnection(Connection connection) {
        this.jdbcConnection = connection;
    }
}

