/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.JDBCConnectionManager;
import com.ibm.db.base.UtilitiesBase;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DatabaseResultTable {
    private PreparedStatement aStmt;
    private boolean isOpen;
    private DatabaseQuerySpec qSpec;
    private Vector qSpecVector = new Vector();
    private Enumeration qSpecEnum = this.qSpecVector.elements();
    private DatabaseConnection conn;
    private boolean atEnd;
    private DatabaseCompoundType rowStruct;
    private ResultSet resultSet;
    private int resultCount = 0;
    private int updateCount = -1;
    private boolean afterLastResult = false;
    private transient Hashtable dbSearchTypeInfo;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseResultTable(DatabaseConnection databaseConnection, DatabaseQuerySpec databaseQuerySpec) throws SQLException, DataException {
        this.setConnection(databaseConnection);
        this.setQuerySpec(databaseQuerySpec);
        this.prepare();
    }

    public DatabaseResultTable(DatabaseConnection databaseConnection, DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) throws SQLException, DataException {
        this.setConnection(databaseConnection);
        this.setQuerySpec(databaseQuerySpec);
        this.prepare(databaseRow);
    }

    public DatabaseResultTable(DatabaseConnection databaseConnection, ResultSet resultSet) throws SQLException, DataException {
        this.setConnection(databaseConnection);
        this.setResultSet(resultSet);
    }

    public void addQuerySpec(DatabaseQuerySpec databaseQuerySpec) {
        this.qSpecVector.addElement(databaseQuerySpec);
    }

    public synchronized void cancel() throws SQLException {
        this.aStmt.cancel();
    }

    private void checkSearchLevel(String string, DatabaseTypeField databaseTypeField) throws SQLException {
        if (this.dbSearchTypeInfo == null) {
            this.dbSearchTypeInfo = this.conn.getSearchTypeInfo();
        }
        if ((Integer)this.dbSearchTypeInfo.get(string) <= 1) {
            databaseTypeField.setSearchable(false);
        } else {
            databaseTypeField.setSearchable(true);
        }
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        this.setAtEnd(true);
        this.setIsOpen(false);
        if (this.resultSet != null) {
            ResultSet resultSet = this.resultSet;
            this.resultSet = null;
            resultSet.close();
        }
    }

    public synchronized void closeStatement() throws SQLException {
        this.setAtEnd(true);
        this.setIsOpen(false);
        if (this.aStmt != null) {
            PreparedStatement preparedStatement = this.aStmt;
            this.aStmt = null;
            preparedStatement.close();
        }
    }

    public int columnCount() {
        return this.getRowStruct().size();
    }

    public String[] columnNames() {
        DatabaseCompoundType databaseCompoundType = this.getRowStruct();
        int n = 0;
        n = databaseCompoundType.size();
        String[] stringArray = new String[n];
        int n2 = 1;
        while (n2 <= n) {
            stringArray[n2 - 1] = databaseCompoundType.fieldAt(n2).getName();
            ++n2;
        }
        return stringArray;
    }

    private void describe() throws SQLException, DataException {
        DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType();
        ResultSetMetaData resultSetMetaData = this.getResultSet().getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            this.describeCol(n2, databaseCompoundType, resultSetMetaData);
            ++n2;
        }
        this.setRowStruct(databaseCompoundType);
    }

    private void describeCol(int n, DatabaseCompoundType databaseCompoundType, ResultSetMetaData resultSetMetaData) throws SQLException, DataException {
        Hashtable hashtable;
        Class clazz;
        DatabaseTypeField databaseTypeField = null;
        int n2 = resultSetMetaData.getColumnType(n);
        String string = resultSetMetaData.getColumnTypeName(n);
        String string2 = resultSetMetaData.getColumnName(n);
        if (string2 == null) {
            string2 = resultSetMetaData.getColumnLabel(n);
        }
        if ((clazz = (Class)(hashtable = JDBCConnectionManager.getSQLTypeTable()).get(new Integer(n2))) == null) {
            Object[] objectArray = new Object[]{new Integer(n2).toString(), string2};
            String string3 = UtilitiesBase.getMessage(IBMDBBaseMessages.badSQLType, objectArray);
            DataException dataException = new DataException(string3, 107);
            dataException.setMessageArgs(objectArray);
            throw dataException;
        }
        try {
            databaseTypeField = (DatabaseTypeField)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        databaseTypeField.setName(string2);
        databaseTypeField.setScale(resultSetMetaData.getScale(n));
        databaseTypeField.setLength(resultSetMetaData.getColumnDisplaySize(n));
        databaseTypeField.setSQLType(n2);
        databaseTypeField.setSQLTypeName(string);
        this.checkSearchLevel(string, databaseTypeField);
        databaseTypeField.setMode(2);
        databaseCompoundType.addFieldWithProposedName(databaseTypeField);
    }

    public void execute() throws SQLException, DataException {
        boolean bl = false;
        if (!this.hasResultSet()) {
            bl = this.aStmt.execute();
            this.updateCount = this.aStmt.getUpdateCount();
            if (this.updateCount != -1) {
                this.isOpen = false;
                ++this.resultCount;
            } else if (bl) {
                this.fetchResultSet();
            } else {
                this.isOpen = false;
                this.afterLastResult = true;
            }
        }
    }

    public void execute(DatabaseRow databaseRow) throws SQLException, DataException {
        boolean bl = false;
        if (!this.hasResultSet()) {
            this.conn.setInputValues(databaseRow, this.aStmt, this.qSpec);
            bl = this.aStmt.execute();
            this.updateCount = this.aStmt.getUpdateCount();
            if (this.updateCount != -1) {
                this.isOpen = false;
                ++this.resultCount;
            } else if (bl) {
                this.fetchResultSet();
            } else {
                this.isOpen = false;
                this.afterLastResult = true;
            }
        }
    }

    protected DatabaseRow fetchNextRow() throws SQLException, DataException {
        DatabaseRow databaseRow = this.newEmptyRow();
        databaseRow.gatherValues(this);
        return databaseRow;
    }

    private void fetchResultSet() throws SQLException, DataException {
        block8: {
            if (this.qSpecEnum.hasMoreElements()) {
                this.qSpec = (DatabaseQuerySpec)this.qSpecEnum.nextElement();
                if (this.qSpec != null) {
                    this.setRowStruct(this.qSpec.getOutputShape());
                }
            }
            this.setResultSet(this.aStmt.getResultSet());
            if (this.resultSet == null) {
                this.isOpen = false;
                this.afterLastResult = true;
            } else {
                this.isOpen = true;
                ++this.resultCount;
                try {
                    if (this.getRowStruct() == null) {
                        this.describe();
                    } else {
                        this.fillInColumnShape();
                    }
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().equals("07005")) break block8;
                    this.isOpen = false;
                    --this.resultCount;
                    this.afterLastResult = true;
                }
            }
        }
    }

    protected void fillInColumnShape() throws SQLException, DataException {
        DatabaseCompoundType databaseCompoundType = this.getRowStruct();
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        DatabaseTypeField databaseTypeField = null;
        String string = null;
        if (databaseCompoundType.size() != resultSetMetaData.getColumnCount()) {
            Object[] objectArray = new Object[]{new Integer(resultSetMetaData.getColumnCount()), new Integer(databaseCompoundType.size())};
            String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.inconsistentColumnCount, objectArray);
            DataException dataException = new DataException(string2, 102);
            dataException.setMessageArgs(objectArray);
            throw dataException;
        }
        int n = 1;
        while (n <= databaseCompoundType.size()) {
            databaseTypeField = databaseCompoundType.fieldAt(n);
            int n2 = resultSetMetaData.getColumnType(n);
            int n3 = databaseTypeField.getSQLType();
            if (!(n3 == n2 || n3 == 9 && n2 == 91 || n3 == 10 && n2 == 92 || n3 == 11 && n2 == 93 || n3 == 3 && n2 == 2 || n3 == 1 && n2 == 12)) {
                Object[] objectArray = new Object[]{new Integer(n), new Integer(n3), new Integer(n2)};
                String string3 = UtilitiesBase.getMessage(IBMDBBaseMessages.inconsistentColumnType, objectArray);
                DataException dataException = new DataException(string3, 103);
                dataException.setMessageArgs(objectArray);
                throw dataException;
            }
            string = resultSetMetaData.getColumnTypeName(n);
            databaseTypeField.setSQLTypeName(string);
            this.checkSearchLevel(string, databaseTypeField);
            if (databaseTypeField.getScale() == 0) {
                databaseTypeField.setScale(resultSetMetaData.getScale(n));
            }
            if (databaseTypeField.getLength() == 0) {
                databaseTypeField.setLength(resultSetMetaData.getColumnDisplaySize(n));
            }
            ++n;
        }
    }

    public boolean getAfterLastResult() {
        return this.afterLastResult;
    }

    private DatabaseConnection getConnection() {
        return this.conn;
    }

    public String getCursorName() throws SQLException {
        return this.getResultSet().getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public Object getParameter(int n, DatabaseTypeField databaseTypeField) throws SQLException {
        Object object = null;
        if (databaseTypeField.getMode() == 4 || databaseTypeField.getMode() == 2) {
            object = databaseTypeField.getObject((CallableStatement)this.aStmt, n);
            boolean bl = ((CallableStatement)this.aStmt).wasNull();
            if (bl) {
                object = null;
            }
        }
        return object;
    }

    private DatabaseQuerySpec getQuerySpec() {
        return this.qSpec;
    }

    private int getResultCount() {
        return this.resultCount;
    }

    protected ResultSet getResultSet() {
        return this.resultSet;
    }

    public DatabaseCompoundType getRowStruct() {
        return this.rowStruct;
    }

    private PreparedStatement getStatement() {
        return this.aStmt;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    protected boolean hasResultSet() {
        return this.getResultSet() != null;
    }

    public boolean isAtEnd() {
        return this.atEnd;
    }

    public static boolean isCallStatement(String string) throws DataException {
        if (string == null || string.length() == 0) {
            String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.noSQL);
            throw new DataException(string2, 106);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{} \t\n\r");
        String string3 = stringTokenizer.nextToken().toUpperCase();
        if (string3.equals("CALL")) {
            return true;
        }
        return (string3.startsWith(":") || string3.equals("?")) && (string3 = stringTokenizer.nextToken()).equals("=") && (string3 = stringTokenizer.nextToken().toUpperCase()).equals("CALL");
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public static boolean isSelectStatement(String string) throws DataException {
        if (string == null || string.length() == 0) {
            String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.noSQL);
            throw new DataException(string2, 106);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toUpperCase();
            if (string3.equals("SELECT") || string3.equals("WITH") || string3.equals("VALUES")) {
                return true;
            }
            if (string3.equals("(")) continue;
            return false;
        }
        return false;
    }

    public DatabaseRow newEmptyRow() {
        return new DatabaseRow(this.getRowStruct());
    }

    public boolean next() throws SQLException {
        return this.getResultSet() != null && this.getResultSet().next();
    }

    public synchronized Object nextElement() throws SQLException, DataException {
        return this.fetchNextRow();
    }

    public void nextResult() throws SQLException, DataException {
        boolean bl = false;
        bl = this.aStmt.getMoreResults();
        this.updateCount = this.aStmt.getUpdateCount();
        if (this.updateCount != -1) {
            this.isOpen = false;
            ++this.resultCount;
        } else if (bl) {
            this.fetchResultSet();
        } else {
            this.isOpen = false;
            this.afterLastResult = true;
        }
    }

    protected void prepare() throws SQLException, DataException {
        boolean bl = false;
        if (!this.hasResultSet()) {
            String string = this.qSpec.getStatement();
            bl = DatabaseResultTable.isCallStatement(string);
            if (bl) {
                this.setStatement(this.conn.getJdbcConnection().prepareCall(string));
            } else {
                this.setStatement(this.conn.getJdbcConnection().prepareStatement(string));
            }
            this.afterLastResult = false;
            this.resultCount = 0;
            this.isOpen = false;
        }
    }

    protected void prepare(DatabaseRow databaseRow) throws SQLException, DataException {
        boolean bl = false;
        if (!this.hasResultSet()) {
            String string = this.qSpec.getStatement();
            bl = DatabaseResultTable.isCallStatement(string);
            if (bl) {
                this.setStatement(this.conn.getJdbcConnection().prepareCall(string));
                this.conn.registerOutputParameters(databaseRow, this.aStmt, this.qSpec);
            } else {
                this.setStatement(this.conn.getJdbcConnection().prepareStatement(string));
            }
            this.afterLastResult = false;
            this.resultCount = 0;
            this.isOpen = false;
        }
    }

    public void refresh() throws SQLException, DataException {
        this.qSpec = (DatabaseQuerySpec)this.qSpecVector.elementAt(0);
        this.qSpecEnum = this.qSpecVector.elements();
        if (this.getStatement() != null) {
            if (this.getResultSet() != null) {
                this.getResultSet().close();
            }
            this.afterLastResult = false;
            this.resultCount = 0;
            this.isOpen = false;
            this.execute();
        } else {
            this.prepare();
            this.execute();
        }
    }

    public void refresh(DatabaseRow databaseRow) throws SQLException, DataException {
        this.qSpec = (DatabaseQuerySpec)this.qSpecVector.elementAt(0);
        this.qSpecEnum = this.qSpecVector.elements();
        if (this.getStatement() != null) {
            if (this.getResultSet() != null) {
                this.getResultSet().close();
            }
            this.afterLastResult = false;
            this.resultCount = 0;
            this.isOpen = false;
            this.execute(databaseRow);
        } else {
            this.prepare(databaseRow);
            this.execute(databaseRow);
        }
    }

    private void setAtEnd(boolean bl) {
        this.atEnd = bl;
    }

    private void setConnection(DatabaseConnection databaseConnection) {
        this.conn = databaseConnection;
    }

    private void setIsOpen(boolean bl) {
        this.isOpen = bl;
    }

    private void setQuerySpec(DatabaseQuerySpec databaseQuerySpec) {
        this.qSpec = databaseQuerySpec;
        this.qSpecVector = new Vector();
        this.qSpecVector.addElement(this.qSpec);
        this.qSpecEnum = this.qSpecVector.elements();
        if (this.qSpec != null) {
            this.setRowStruct(this.qSpec.getOutputShape());
        }
    }

    private void setResultCount(int n) {
        this.resultCount = n;
    }

    private void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    private void setRowStruct(DatabaseCompoundType databaseCompoundType) {
        this.rowStruct = databaseCompoundType;
    }

    private void setStatement(PreparedStatement preparedStatement) {
        this.aStmt = preparedStatement;
    }

    public void setTimeout(int n) throws SQLException {
        block2: {
            try {
                this.aStmt.setQueryTimeout(n);
            }
            catch (SQLException sQLException) {
                if (n == 0) break block2;
                throw sQLException;
            }
        }
    }
}

