/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.selector;

import com.ibm.db.selector.ColumnSelector;
import com.ibm.db.selector.IBMSelectorMessages;
import com.ibm.db.selector.Selector;
import com.ibm.db.selector.SelectorException;
import com.ibm.db.selector.Utilities;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.table.TableModel;

public abstract class SingleColumnSelector
extends Selector {
    static final String PROPERTY_COLUMN_NAME = "columnName";
    static final String PROPERTY_COLUMN_NUMBER = "columnNumber";
    private String fColumnName = null;
    int fColumnNumber = 0;
    private transient int fColumnNumberFromName = 0;
    transient boolean fColumnNumberResolved = false;
    static final long serialVersionUID = -2615617835005286730L;

    SingleColumnSelector() {
    }

    SingleColumnSelector(TableModel tableModel) {
        super(tableModel);
    }

    boolean checkReady() {
        int n;
        boolean bl = super.checkReady();
        if (bl && ((n = this.getActualColumnNumber()) < 0 || n >= this.getModel().getColumnCount())) {
            Integer n2 = new Integer(this.getColumnNumber());
            this.setColumnNumber(n < 0 ? 0 : this.getModel().getColumnCount() - 1, true);
            throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_ColNumber_, new Object[]{n2}), 203);
        }
        return bl;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1998).\n\n";
    }

    int getActualColumnNumber() {
        int n = this.fColumnNumber;
        if (this.useColumnName()) {
            TableModel tableModel;
            if (!this.fColumnNumberResolved && (tableModel = this.getModel()) != null && tableModel.getColumnCount() > 0) {
                int n2 = tableModel.getColumnCount();
                int n3 = 0;
                while (n3 < n2 && !this.fColumnName.equals(tableModel.getColumnName(n3))) {
                    ++n3;
                }
                if (n3 < n2) {
                    this.fColumnNumberFromName = n3;
                    this.fColumnNumberResolved = true;
                } else {
                    String string = this.fColumnName;
                    this.fColumnName = null;
                    this.fColumnNumber = n2 - 1;
                    this.fColumnNumberFromName = -1;
                    throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_ColumnName, new Object[]{string}), 202);
                }
            }
            n = this.fColumnNumberFromName;
        }
        return n;
    }

    public String getColumnName() {
        return this.fColumnName;
    }

    public String[] getColumnNames() {
        this.checkReady();
        return new String[]{this.getModel().getColumnName(this.getActualColumnNumber())};
    }

    public int getColumnNumber() {
        return this.getIndexFromOne() ? this.fColumnNumber + 1 : this.fColumnNumber;
    }

    public void setColumnName(String string) {
        boolean bl = false;
        if (string != this.fColumnName) {
            if (string != null) {
                if (!(string = string.trim().toUpperCase()).equals(this.fColumnName)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.fCheckReadyDone = false;
            this.fColumnNumberResolved = false;
            String string2 = this.fColumnName;
            this.fColumnName = string;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_COLUMN_NAME, string2, this.fColumnName);
            this.notifyData();
            if (this instanceof ColumnSelector) {
                ((ColumnSelector)this).fireListDataEvent(new ListDataEvent((Object)this, 0, 0, this.getRows() - 1));
            }
        }
    }

    public void setColumnNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setColumnNumber(n, true);
    }

    private void setColumnNumber(int n, boolean bl) {
        if (this.fColumnNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fColumnNumber;
            this.fColumnNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_COLUMN_NUMBER, new Integer(n2), new Integer(this.fColumnNumber));
            if (!this.useColumnName() && bl) {
                this.notifyData();
                if (this instanceof ColumnSelector) {
                    ColumnSelector columnSelector = (ColumnSelector)this;
                    columnSelector.fireListDataEvent(new ListDataEvent((Object)columnSelector, 0, 0, columnSelector.getSize() - 1));
                }
            }
        }
    }

    public void setModel(TableModel tableModel) {
        this.fColumnNumberResolved = false;
        super.setModel(tableModel);
    }

    private boolean useColumnName() {
        return this.fColumnName != null && this.fColumnName.trim().length() > 0;
    }
}

