/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.uibeans;

import com.ibm.db.DataException;
import com.ibm.ivj.db.uibeans.DBNavigator;
import com.ibm.ivj.db.uibeans.ExceptionEvent;
import com.ibm.ivj.db.uibeans.IBMIVJDBMessages;
import com.ibm.ivj.db.uibeans.Select;
import com.ibm.ivj.db.uibeans.Utilities;

class DBActions
implements Runnable {
    int buttonPressed;
    DBNavigator navigator;
    static final int FIRST = 1;
    static final int PREV = 2;
    static final int NEXT = 3;
    static final int LAST = 4;
    static final int INSERT = 5;
    static final int DELETE = 6;
    static final int REFRESH = 7;
    static final int COMMIT = 8;
    static final int ROLLBACK = 9;
    static final int EXECUTE = 10;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    protected DBActions(DBNavigator dBNavigator, int n) {
        this.navigator = dBNavigator;
        this.buttonPressed = n;
    }

    public void run() {
        try {
            try {
                Select select = this.navigator.getModel();
                if (select == null) {
                    String string = Utilities.logMessage(IBMIVJDBMessages.noSelect);
                    throw new DataException(string, 501);
                }
                if (this.buttonPressed == 1) {
                    select.firstRow();
                } else if (this.buttonPressed == 2) {
                    select.previousRow();
                } else if (this.buttonPressed == 3) {
                    select.nextRow();
                } else if (this.buttonPressed == 4) {
                    select.lastRow();
                } else if (this.buttonPressed == 5) {
                    select.newRow(true);
                } else if (this.buttonPressed == 6) {
                    select.deleteRow();
                } else if (this.buttonPressed == 7) {
                    select.refresh();
                } else if (this.buttonPressed == 8) {
                    select.commit();
                } else if (this.buttonPressed == 9) {
                    select.rollback();
                } else if (this.buttonPressed == 10) {
                    select.execute();
                }
            }
            catch (DataException dataException) {
                ExceptionEvent exceptionEvent = new ExceptionEvent(this.navigator, dataException);
                this.navigator.fireExceptionOccurred(exceptionEvent);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                ExceptionEvent exceptionEvent = new ExceptionEvent(this.navigator, runtimeException);
                this.navigator.fireExceptionOccurred(exceptionEvent);
            }
            catch (Error error) {
                error.printStackTrace();
                throw error;
            }
        }
        catch (Throwable throwable) {
            Object var2_9 = null;
            this.navigator.enableButtons();
            throw throwable;
        }
        Object var2_10 = null;
        this.navigator.enableButtons();
    }
}

