/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.uibeans;

import com.ibm.db.CallableStatement;
import com.ibm.db.DataEvent;
import com.ibm.db.DataException;
import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnectionAfterListener;
import com.ibm.db.DatabaseConnectionBeforeListener;
import com.ibm.db.SelectResult;
import com.ibm.db.SelectStatement;
import com.ibm.db.StatementAfterListener;
import com.ibm.db.StatementBeforeListener;
import com.ibm.db.StatementMetaData;
import com.ibm.db.StatementResultAfterListener;
import com.ibm.db.StatementResultBeforeListener;
import com.ibm.db.StatementResultValueChangeListener;
import com.ibm.ivj.db.uibeans.IBMIVJDBMessages;
import com.ibm.ivj.db.uibeans.Query;
import com.ibm.ivj.db.uibeans.Select;
import com.ibm.ivj.db.uibeans.Utilities;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class ProcedureCall
extends Select
implements Serializable,
DatabaseConnectionAfterListener,
DatabaseConnectionBeforeListener,
StatementAfterListener,
StatementBeforeListener,
PropertyChangeListener,
StatementResultAfterListener,
StatementResultBeforeListener,
StatementResultValueChangeListener,
TableModel {
    static final long serialVersionUID = -2238375279797567073L;
    private static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(C) Copyright IBM Corp. 1999 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static Class class$com$ibm$ivj$db$uibeans$ProcedureCall;

    public void cancelAction() throws DataException {
        if (this.executing) {
            this.fieldSelectStatement.cancelExecution();
            this.executing = false;
        } else {
            SelectResult selectResult = null;
            int n = ((CallableStatement)this.fieldSelectStatement).getCurrentResultInCache();
            if (n > 0) {
                selectResult = ((CallableStatement)this.fieldSelectStatement).getCacheResultAt(n);
            }
            if (selectResult == null) {
                String string = Utilities.logMessage(IBMIVJDBMessages.notExecuting);
                throw new DataException(string, 246);
            }
            selectResult.cancelAction();
        }
    }

    public Enumeration columnNames() throws DataException {
        return this.getResultSetMetaData().getColumnNames();
    }

    public void columnValueSet(PropertyChangeEvent propertyChangeEvent) {
        String string = String.valueOf(this.getCurrentMetaData());
        String string2 = "Result" + string + "_" + propertyChangeEvent.getPropertyName();
        this.firePropertyChange(string2, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        this.firePropertyChange(String.valueOf(string2) + "_String", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if (this.aTableModelListener != null) {
            int n = this.fieldSelectStatement.getMetaData().getColumnIndex(propertyChangeEvent.getPropertyName());
            this.fireTableChanged(new TableModelEvent((TableModel)this, this.getCurrentRow(), this.getCurrentRow(), n - 1));
        }
    }

    protected void currentResultChange(PropertyChangeEvent propertyChangeEvent) {
        int n = (Integer)propertyChangeEvent.getNewValue();
        this.setResult(this.fieldSelectStatement.getResult());
        if (propertyChangeEvent.getOldValue() != null) {
            int n2 = (Integer)propertyChangeEvent.getOldValue();
            this.firePropertyChange("currentResult", new Integer(n2), new Integer(n));
        } else {
            this.firePropertyChange("currentResult", null, new Integer(n));
        }
        this.fireAllColumnsChange(propertyChangeEvent);
        if (this.aTableModelListener != null) {
            this.fireTableChanged(new TableModelEvent((TableModel)this, -1));
        }
        this.firePropertyChange("currentRow", null, new Integer(this.getCurrentRow()));
        this.firePropertyChange("currentRowInCache", null, new Integer(this.getCurrentRowInCache()));
    }

    protected void currentResultInCacheChange(PropertyChangeEvent propertyChangeEvent) {
        int n = (Integer)propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getOldValue() != null) {
            int n2 = (Integer)propertyChangeEvent.getOldValue();
            this.firePropertyChange("currentResultInCache", new Integer(n2), new Integer(n));
        } else {
            this.firePropertyChange("currentResultInCache", null, new Integer(n));
        }
    }

    protected void currentRowChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.executing) {
            return;
        }
        super.currentRowChange(propertyChangeEvent);
    }

    protected void currentRowInCacheChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.executing) {
            return;
        }
        super.currentRowInCacheChange(propertyChangeEvent);
    }

    public void deleteRow() throws DataException {
        this.getRequiredResult().deleteRow();
    }

    public void execute() throws DataException {
        this.executing = true;
        try {
            this.fieldSelectStatement.execute();
        }
        catch (DataException dataException) {
            this.executing = false;
            throw dataException;
        }
        this.executing = false;
    }

    public void executed(DataEvent dataEvent) {
        this.fireExecuted(new DataEvent(this));
        this.fireAllParametersChange();
    }

    protected void fireAllColumnsChange(PropertyChangeEvent propertyChangeEvent) {
        StatementMetaData statementMetaData = this.fieldSelectStatement.getMetaData();
        String string = String.valueOf(this.getCurrentMetaData());
        Object object = null;
        int n = 1;
        while (n <= statementMetaData.getColumnCount()) {
            String string2 = statementMetaData.getColumnName(n);
            string2 = "Result" + string + "_" + string2;
            object = this.getCurrentRow() < 0 || this.getCurrentRowInCache() < 0 ? null : this.getColumnValue(n - 1);
            this.firePropertyChange(string2, null, object);
            this.firePropertyChange(String.valueOf(string2) + "_String", null, object);
            ++n;
        }
    }

    protected void fireAllParametersChange() {
        StatementMetaData statementMetaData = ((CallableStatement)this.fieldSelectStatement).getRootMetaData();
        Object object = null;
        int n = 1;
        while (n <= statementMetaData.getParameterCount()) {
            if (statementMetaData.getParameterMode(n) == 4 || statementMetaData.getParameterMode(n) == 2) {
                String string = statementMetaData.getParameterName(n);
                try {
                    object = this.getParameter(n);
                }
                catch (DataException dataException) {
                    object = "Error";
                }
                this.firePropertyChange("Parm_" + string, null, object);
                this.firePropertyChange("Parm_" + string + "_String", null, object);
            }
            ++n;
        }
    }

    protected void fireParameterChanged(int n, Object object) {
        StatementMetaData statementMetaData = ((CallableStatement)this.fieldSelectStatement).getRootMetaData();
        int n2 = statementMetaData.getParameterMode(n);
        if (n2 != 1) {
            String string = "Parm_" + statementMetaData.getParameterName(n);
            this.firePropertyChange(string, null, object);
            this.firePropertyChange(String.valueOf(string) + "_String", null, object);
        }
    }

    protected void fireParameterChanged(String string, Object object) {
        StatementMetaData statementMetaData = ((CallableStatement)this.fieldSelectStatement).getRootMetaData();
        int n = statementMetaData.getParameterMode(string);
        if (n != 1) {
            String string2 = "Parm_" + string;
            this.firePropertyChange(string2, null, object);
            this.firePropertyChange(String.valueOf(string2) + "_String", null, object);
        }
    }

    public void firstResult() throws DataException {
        ((CallableStatement)this.fieldSelectStatement).firstResult();
    }

    public void firstRow() throws DataException {
        this.getRequiredResult().firstRow();
    }

    public CallableStatement getCallableStatement() {
        return (CallableStatement)this.fieldSelectStatement;
    }

    public Class getColumnClass(int n) {
        return this.getResultSetMetaData().getColumnClass(n + 1);
    }

    public Class getColumnClass(String string) {
        return this.getResultSetMetaData().getColumnClass(string);
    }

    public int getColumnCount() {
        return this.getResultSetMetaData().getColumnCount();
    }

    public int getColumnIndex(String string) {
        return this.getResultSetMetaData().getColumnIndex(string) - 1;
    }

    public String getColumnName(int n) {
        return this.getResultSetMetaData().getColumnName(n + 1);
    }

    public Object getColumnValue(int n) {
        if (this.fieldResult == null && (this.isExecuted() || this.executing)) {
            String string = Utilities.logMessage(IBMIVJDBMessages.noResultSets);
            throw new DataRuntimeException(string);
        }
        return super.getColumnValue(n);
    }

    public Object getColumnValue(String string) {
        if (this.fieldResult == null && (this.isExecuted() || this.executing)) {
            String string2 = Utilities.logMessage(IBMIVJDBMessages.noResultSets);
            throw new DataRuntimeException(string2);
        }
        return super.getColumnValue(string);
    }

    public String getColumnValueToString(int n) {
        if (this.fieldResult == null && (this.isExecuted() || this.executing)) {
            String string = Utilities.logMessage(IBMIVJDBMessages.noResultSets);
            throw new DataRuntimeException(string);
        }
        return super.getColumnValueToString(n);
    }

    public String getColumnValueToString(String string) {
        if (this.fieldResult == null && (this.isExecuted() || this.executing)) {
            String string2 = Utilities.logMessage(IBMIVJDBMessages.noResultSets);
            throw new DataRuntimeException(string2);
        }
        return super.getColumnValueToString(string);
    }

    protected int getCurrentMetaData() {
        StatementMetaData statementMetaData = ((CallableStatement)this.fieldSelectStatement).getRootMetaData();
        int n = this.getCurrentResult();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if ((statementMetaData = statementMetaData.getNextMetaData()) == null) break;
            ++n2;
        }
        return n2;
    }

    public int getCurrentResult() {
        return ((CallableStatement)this.fieldSelectStatement).getCurrentResult();
    }

    public int getCurrentResultInCache() {
        return ((CallableStatement)this.fieldSelectStatement).getCurrentResultInCache();
    }

    public int getCurrentRow() {
        if (this.fieldResult != null) {
            return this.fieldResult.getCurrentRow() - 1;
        }
        return -1;
    }

    public int getCurrentRowInCache() {
        if (this.fieldResult != null) {
            return this.fieldResult.getCurrentRowInCache() - 1;
        }
        return -1;
    }

    public BeanInfo getInstanceBeanInfo() {
        BeanInfo beanInfo = null;
        try {
            Class<?> clazz = Class.forName("com.ibm.ivj.db.uibeans.ProcedureCallBeanInfo");
            Object[] objectArray = new Object[]{this};
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$com$ibm$ivj$db$uibeans$ProcedureCall;
            if (clazz2 == null) {
                try {
                    clazz2 = class$com$ibm$ivj$db$uibeans$ProcedureCall = Class.forName("com.ibm.ivj.db.uibeans.ProcedureCall");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class[] classArray2 = classArray;
            Method method = clazz.getDeclaredMethod("getInstanceBeanInfo", classArray2);
            beanInfo = (BeanInfo)method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return beanInfo;
    }

    public int getMaximumResultsInCache() {
        return ((CallableStatement)this.fieldSelectStatement).getMaximumResultsInCache();
    }

    public int getNumPacketsInCache() {
        if (this.fieldResult != null) {
            return this.fieldResult.getNumPacketsInCache();
        }
        return 0;
    }

    public int getNumResults() {
        return ((CallableStatement)this.fieldSelectStatement).getNumResults();
    }

    public int getNumResultsInCache() {
        return ((CallableStatement)this.fieldSelectStatement).getNumResultsInCache();
    }

    public int getNumRows() {
        if (this.fieldResult != null) {
            return this.fieldResult.getNumRows();
        }
        return 0;
    }

    public int getNumRowsInCache() {
        if (this.fieldResult != null) {
            return this.fieldResult.getNumRowsInCache();
        }
        return 0;
    }

    public Query getProcedure() {
        return new Query(this.getDatabaseConnection(), this.getStatementMetaData());
    }

    private SelectResult getRequiredResult() throws DataException {
        if (!this.isExecuted() && !this.executing) {
            String string = Utilities.logMessage(IBMIVJDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldResult == null) {
            String string = Utilities.logMessage(IBMIVJDBMessages.noResultSets);
            throw new DataException(string, 243);
        }
        return this.fieldResult;
    }

    public SelectResult getResult() {
        return this.fieldResult;
    }

    protected StatementMetaData getResultSetMetaData() {
        StatementMetaData statementMetaData = this.fieldSelectStatement.getMetaData();
        if (this.getCurrentResult() == 0 && ((statementMetaData = statementMetaData.getNextMetaData()) == null || statementMetaData.getNextMetaData() != null)) {
            statementMetaData = new StatementMetaData();
        }
        return statementMetaData;
    }

    public int getRowCount() {
        if (this.fieldResult != null) {
            return this.fieldResult.getNumRowsInCache();
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (!this.isExecuted() && !this.executing) {
                return null;
            }
            return this.getRequiredResult().getCacheValueAt(n + 1, n2 + 1);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public boolean isEnd() {
        if (this.fieldResult != null) {
            return this.fieldResult.isEnd();
        }
        return false;
    }

    public boolean isFillResultCacheOnExecute() {
        return ((CallableStatement)this.fieldSelectStatement).isFillResultCacheOnExecute();
    }

    public boolean isLastResult() {
        return ((CallableStatement)this.fieldSelectStatement).isLastResult();
    }

    public boolean isMaxRowsReached() {
        if (this.fieldResult != null) {
            try {
                return this.fieldResult.isMaxRowsReached();
            }
            catch (DataException dataException) {
                return false;
            }
        }
        return false;
    }

    public void lastResult() throws DataException {
        ((CallableStatement)this.fieldSelectStatement).lastResult();
    }

    public void lastRow() throws DataException {
        this.getRequiredResult().lastRow();
    }

    public void lockRow() throws DataException {
        this.getRequiredResult().lockRow();
    }

    public void newRow(boolean bl) throws DataException {
        this.getRequiredResult().newRow(bl);
    }

    protected SelectStatement newSelectStatement() {
        CallableStatement callableStatement = null;
        try {
            callableStatement = new CallableStatement(true);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{"ProcedureCall", "CallableStatement"};
            String string = Utilities.logMessage(IBMIVJDBMessages.noStatement, objectArray);
            throw new DataRuntimeException(string);
        }
        return callableStatement;
    }

    public void nextPacket() throws DataException {
        this.getRequiredResult().nextPacket();
    }

    public void nextResult() throws DataException {
        ((CallableStatement)this.fieldSelectStatement).nextResult();
    }

    public void nextRow() throws DataException {
        this.getRequiredResult().nextRow();
    }

    public void previousResult() throws DataException {
        ((CallableStatement)this.fieldSelectStatement).previousResult();
    }

    public void previousRow() throws DataException {
        this.getRequiredResult().previousRow();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.getResult()) {
            if (propertyChangeEvent.getPropertyName().equals("currentRow")) {
                this.currentRowChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getPropertyName().equals("currentRowInCache")) {
                this.currentRowInCacheChange(propertyChangeEvent);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("currentResult")) {
            this.currentResultChange(propertyChangeEvent);
        } else if (propertyChangeEvent.getPropertyName().equals("currentResultInCache")) {
            this.currentResultInCacheChange(propertyChangeEvent);
        }
    }

    public void refresh() throws DataException {
        this.executing = true;
        try {
            this.fieldSelectStatement.refresh();
        }
        catch (DataException dataException) {
            this.executing = false;
            throw dataException;
        }
        this.executing = false;
    }

    public void restoreRow() throws DataException {
        this.getRequiredResult().restoreRow();
    }

    public void setColumnValue(int n, Object object) throws DataException {
        this.getRequiredResult().setColumnValue(n + 1, object);
    }

    public void setColumnValue(String string, Object object) throws DataException {
        this.getRequiredResult().setColumnValue(string, object);
    }

    public void setColumnValueFromString(int n, String string) throws DataException {
        if (!(this.isExecuted() || string != null && string.length() != 0)) {
            return;
        }
        this.getRequiredResult().setColumnValueFromString(n + 1, string);
    }

    public void setColumnValueFromString(String string, String string2) throws DataException {
        if (!(this.isExecuted() || string2 != null && string2.length() != 0)) {
            return;
        }
        this.getRequiredResult().setColumnValueFromString(string, string2);
    }

    public void setCurrentResult(int n) throws DataException {
        ((CallableStatement)this.fieldSelectStatement).setCurrentResult(n);
    }

    public void setCurrentResultInCache(int n) throws DataException {
        this.setCurrentResult(n + this.getCurrentResult() - this.getCurrentResultInCache());
    }

    public void setCurrentRow(int n) throws DataException {
        if (n == -1 && this.getCurrentRow() == -1) {
            return;
        }
        this.getRequiredResult().setCurrentRow(n + 1);
    }

    public void setCurrentRowInCache(int n) throws DataException {
        this.setCurrentRow(n + this.getCurrentRow() - this.getCurrentRowInCache());
    }

    public void setFillResultCacheOnExecute(boolean bl) {
        ((CallableStatement)this.fieldSelectStatement).setFillResultCacheOnExecute(bl);
    }

    public void setMaximumResultsInCache(int n) {
        ((CallableStatement)this.fieldSelectStatement).setMaximumResultsInCache(n);
    }

    public void setParameter(int n, Object object) throws DataException {
        this.fieldSelectStatement.setParameter(n, object);
        this.fireParameterChanged(n, object);
    }

    public void setParameter(String string, Object object) throws DataException {
        this.fieldSelectStatement.setParameter(string, object);
        this.fireParameterChanged(string, object);
    }

    public void setParameterFromString(int n, String string) throws DataException {
        this.fieldSelectStatement.setParameterFromString(n, string);
        this.fireParameterChanged(n, (Object)string);
    }

    public void setParameterFromString(String string, String string2) throws DataException {
        this.fieldSelectStatement.setParameterFromString(string, string2);
        this.fireParameterChanged(string, (Object)string2);
    }

    public void setProcedure(Query query) {
        this.setStatementMetaData(query.getSQLSpec());
        this.setDatabaseConnection(query.getConnectionAlias());
    }

    protected void setSelectStatement(SelectStatement selectStatement) {
        if (this.fieldSelectStatement != null) {
            ((CallableStatement)this.fieldSelectStatement).removePropertyChangeListener(this);
        }
        super.setSelectStatement(selectStatement);
        if (this.fieldSelectStatement != null) {
            ((CallableStatement)this.fieldSelectStatement).addPropertyChangeListener(this);
        }
    }

    public void unlockRow() throws DataException {
        this.getRequiredResult().unlockRow();
    }

    public void updateRow() throws DataException {
        this.getRequiredResult().updateRow();
    }
}

