/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.uibeans;

import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.StatementMetaData;
import com.ibm.ivj.db.uibeans.IBMIVJDBMessages;
import com.ibm.ivj.db.uibeans.Utilities;
import java.io.Serializable;

public class Query
implements Serializable {
    private DatabaseConnection fieldConnectionAlias = null;
    private StatementMetaData fieldSQLSpec = null;
    static final long serialVersionUID = 8441734882189679981L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public Query(DatabaseConnection databaseConnection, StatementMetaData statementMetaData) {
        this.fieldConnectionAlias = databaseConnection;
        this.fieldSQLSpec = statementMetaData;
    }

    public DatabaseConnection getConnectionAlias() {
        if (this.fieldConnectionAlias == null) {
            try {
                this.fieldConnectionAlias = new DatabaseConnection();
            }
            catch (Throwable throwable) {
                String string = Utilities.logMessage(IBMIVJDBMessages.noConnection);
                throw new DataRuntimeException(string);
            }
        }
        return this.fieldConnectionAlias;
    }

    public StatementMetaData getSQLSpec() {
        if (this.fieldSQLSpec == null) {
            try {
                this.fieldSQLSpec = new StatementMetaData();
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{"Query", "StatementMetaData"};
                String string = Utilities.logMessage(IBMIVJDBMessages.noStatement, objectArray);
                throw new DataRuntimeException(string);
            }
        }
        return this.fieldSQLSpec;
    }

    public void setConnectionAlias(DatabaseConnection databaseConnection) {
        this.fieldConnectionAlias = databaseConnection;
    }

    public void setSQLSpec(StatementMetaData statementMetaData) {
        this.fieldSQLSpec = statementMetaData;
    }
}

