/*
 * @(#)alloc_cache.h	1.4 98/02/04
 *
 * Copyright 1993-1997 Sun Microsystems, Inc. 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A.  All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * CopyrightVersion 1.2
 *
 */

/*
 * Per-thread allocation cache
 */

#ifndef	_ALLOC_CACHE_H_
#define	_ALLOC_CACHE_H_

#ifdef JMS_TRL

/* Default cache (refill) size */
#define	ALLOC_CACHE_SIZE	1536
/* Default maximum local allocation size, must be less than cache size */
#define	ALLOC_LOCAL_SIZE	(ALLOC_CACHE_SIZE/4)

/*
 * Per-thread structure
 */
struct alloc_cache {
    volatile char	cache_busy;
    char	cache_pad[3];
    long	cache_size;
    JHandle    *cache_block;
    long        safe_low;
    long        safe_high;
};

/* Cache (refill) size */
extern long allocCacheSize;

/* Allocations smaller than this are attempted from local cache.  Use
   0 to turn off local allocation.  Must be less than cache size. */
extern long allocLocalSize;

/* Callback when thread exits */
extern void allocCacheCleanup(struct alloc_cache *);

#else /* JMS_TRL */ /* SUN */

/* Default cache (refill) size */
#define	ALLOC_CACHE_SIZE	1024
/* Default maximum local allocation size, must be less than cache size */
#define	ALLOC_LOCAL_SIZE	(ALLOC_CACHE_SIZE/4)
/* Default handle cache refill count */
#define	ALLOC_HANDLE_COUNT	(ALLOC_CACHE_SIZE/8/3)

/*
 * Per-thread structure
 */
struct alloc_cache {
    volatile char	cache_busy;
    char	cache_pad[3];
    long	cache_size;
    void	*cache_tail;
    void	*cache_handles;
};

/* Cache (refill) size */
extern long allocCacheSize;

/* Allocations smaller than this are attempted from local cache.  Use
   0 to turn off local allocation.  Must be less than cache size. */
extern long allocLocalSize;

/* Cache handle refill count */
extern long allocHandleCount;

/* Callback when thread exits */
extern void allocCacheCleanup(struct alloc_cache *);
#endif  /* JMS_TRL */

#endif /* _ALLOC_CACHE_H */
