/*****************************************************************************/
/*                    Copyright (c) IBM Corporation 1997                     */
/*****************************************************************************/

/*****************************************************************************/
/* Change activity:                                                          */
/*                                                                           */
/*   Flag  Reason  Release  Date  Origin Description                         */
/*   ---- -------- ------- ------ ------ -----------                         */
/*   $L0=  005220   n116   980402 hdspp: JDK 1.1.3 port                      */
/*                                                                           */
/*****************************************************************************/

#ifndef _WIN32_FLOAT_H_
#define _WIN32_FLOAT_H_

#undef	float_t
#undef	double_t

#define NAN_CHECK(l,r,x) (!_isnan((l))&&!_isnan((r))) ? (x : 0)

typedef	float			float_t;
typedef	double			double_t;

#define	DBL_DEF(a,b,c,d)	double_t a = (b)
#define	DBL_VAL(a,b,c  )	(a)
#define	FLT_DEF(a,b,c  )	float_t  a = (b)

#define	int2dbl(a)		((double_t)(a))
#define	int2flt(a)		((float_t)(a))

#define	dbl2int(a)		((int)(a))
#define	flt2int(a)		((int)(a))

#define	dbl2flt(a)		((float)(a))

#define	flt2dbl(a)		((double)(a))

#define	str2flt(a,b)		(float_t)strtod(a,b)
#define	str2dbl(a,b)		strtod(a,b)

char *  flt2str(char *buf, const char * pattern, float_t f);
char *	dbl2str(char *buf, const char * pattern, double_t d);

#define	dbl_neg(a)		(-(a))
#define	dbl_copysign(a,b)	(copysign((a),(b)))
#define	dbl_add(a,b)		((a)+(b))
#define	dbl_sub(a,b)		((a)-(b))
#define	dbl_mul(a,b)		((a)*(b))
#define	dbl_div(a,b)		((a)/(b))

#define	dbl_eqz(a)		((a)==0.0)
#define	dbl_ltz(a)		((a)<0.0)
#define	dbl_gez(a)		((a)>=0.0)
#define	dbl_eq(a,b)		((a) == (b))
#define	dbl_ne(a,b)		((a) != (b))
#define	dbl_ge(a,b)		((a) >= (b))
#define	dbl_le(a,b)		((a) <= (b))
#define	dbl_lt(a,b)		((a) <  (b))
#define	dbl_gt(a,b)		((a) >  (b))

#define	flt_neg(a)		(-(a))
#define	flt_add(a,b)		((a)+(b))
#define	flt_sub(a,b)		((a)-(b))
#define	flt_mul(a,b)		((a)*(b))
#define	flt_div(a,b)		((a)/(b))

#define	flt_eqz(a)		((a)==0.0)
#define	flt_ltz(a)		((a)<0.0)
#define	flt_gez(a)		((a)>=0.0)
#define	flt_eq(a,b)		((a) == (b))
#define	flt_ne(a,b)		((a) != (b))
#define	flt_ge(a,b)		((a) >= (b))
#define	flt_le(a,b)		((a) <= (b))
#define	flt_lt(a,b)		((a) <  (b))
#define	flt_gt(a,b)		((a) >  (b))

#define	tofloat(a)		((float_t)(a))
#define	todouble(a)		((double_t)(a))
#define	flt2nat(a)		((a))
#define	dbl2nat(a)		((a))

#define	dbl_cos			cos
#define	dbl_sin			sin
#define	dbl_tan			tan
#define	dbl_asin		asin
#define	dbl_acos		acos
#define	dbl_atan		atan
#define	dbl_exp			exp
#define	dbl_log			log
#define	dbl_sqrt		sqrt
#define	dbl_ceil		ceil
#define	dbl_floor		floor
#define	dbl_rint		rint
#define	dbl_atan2		atan2
#define	dbl_pow			pow
#define	dbl_fmod		fmod
#define	dbl_fabs		abs
#define	dbl_rem			remainder

#define	flt_fmod		fmod

#define	dbl_zero_const		((double_t)0)
#define dbl_one_const		((double_t)1)

#define	flt_zero_const		((float_t)0)
#define flt_one_const		((float_t)1)

#define	PosZerod		((double_t)0)
#define	PosOned			((double_t)1)
#define	PosInfd			((double_t)INF)
#define	PosZerof		((float_t)0)
#define	PosOnef			((float_t)1)
#define	PosInff			((float_t)INF)

#define	NegZerod		-((double_t)0)
#define	NegOned			-((double_t)1)
#define	NegInfd			-((double_t)INF)
#define	NegZerof		-((float_t)0)
#define	NegOnef			-((float_t)1)
#define	NegInff			-((float_t)INF)

#define IS_NAN(x) 		_isnan(x)
#define IS_NAND(x)		IS_NAN(x)
#define IS_NANF(x)		IS_NAN(x)

#define	NaNd			((double_t)NAN)
#define	NaNf			((float_t)NAN)

#endif
