package bench;
class Random
{
    private static final int HistoryMax = 54;

    private int[] History;
    private int HistoryPtr;
    private int LowerPtr;

    public Random()
    {
      History = new int[HistoryMax+1];
      setUpHistory((int)System.currentTimeMillis());
    }

    private void setUpHistory (int seed)
    {
      int x, i;

      x = seed;
      for (i=0; i<=HistoryMax; i++)
      {
        x = x*314159262 + 17;
        History[i] = x / 0x10000;
      }

      HistoryPtr = HistoryMax;
      LowerPtr = 23;
     }

    public int nextInt()
    {
      int res;

      if (HistoryPtr == 0)
        if (LowerPtr == 0)
          setUpHistory (12345);
        else
        {
          HistoryPtr = HistoryMax;
          LowerPtr--;
        }
      else
      {
        HistoryPtr--;
        if (LowerPtr == 0)
          LowerPtr = HistoryMax;
        else
          LowerPtr--;
      }

      res = History[HistoryPtr] + History[LowerPtr];
      History[HistoryPtr] = res;

      return res;
    }

}