module: Internals
author: chiles@cs.cmu.edu
synopsis: This file implements some extensions to the Gwydion Dylan
          implementation.
copyright: See below.
rcs-header: $Header: /afs/cs.cmu.edu/project/gwydion/hackers/nkramer/mindy/mindy-1.3/libraries/streams/RCS/internals.dylan,v 1.9 94/11/04 14:40:20 chiles Exp $

//======================================================================
//
// Copyright (c) 1994  Carnegie Mellon University
// All rights reserved.
// 
// Use and copying of this software and preparation of derivative
// works based on this software are permitted, including commercial
// use, provided that the following conditions are observed:
// 
// 1. This copyright notice must be retained in full on any copies
//    and on appropriate parts of any derivative works.
// 2. Documentation (paper or online) accompanying any system that
//    incorporates this software, or any part of it, must acknowledge
//    the contribution of the Gwydion Project at Carnegie Mellon
//    University.
// 
// This software is made available "as is".  Neither the authors nor
// Carnegie Mellon University make any warranty about the software,
// its performance, or its conformity to any specification.
// 
// Bug reports, questions, comments, and suggestions should be sent by
// E-mail to the Internet address "gwydion-bugs@cs.cmu.edu".
//
//======================================================================
//



///
/// Classes and types.
///

define constant <byte> =
  limited(<fixed-integer>, min: 0, max: 255);


///
/// As methods.
///

define method as (result :: singleton(<byte>), object :: <byte-character>)
    => result :: <byte>;
  as(<integer>, object);
end method;

define method as (result :: singleton(<byte-string>), object :: <byte-vector>)
    => result :: <byte-string>;
  let len :: <fixed-integer> = object.size;
  let res :: <byte-string> = make(<byte-string>, size: len);
  copy-bytes(res, 0, object, 0, len);
end method;

define method as (result :: singleton(<byte-vector>), object :: <byte-string>)
    => result :: <byte-vector>;
  let len :: <fixed-integer> = object.size;
  let res :: <byte-vector> = make(<byte-vector>, size: len);
  copy-bytes(res, 0, object, 0, len);
end method;


///
/// Utilities.
///

/// call-fd-function -- Exported.
///
/// This function applies the fd function to the arguments and tests the
/// error code.  If there is no error, return the function's values;
/// otherwise, signal an error with the unix description of the error.
///
/// If we had macros, this function would be a macro and require no
/// overhead.  It also would allow type propagation so that calls to these
/// fd functions within expression (that is, not bound to a type-declared
/// variable) would have the benefit of the return types of the fd
/// functions.  As it is, we have to allocate a rest argument, do multiple
/// function calls, and so on.  For now, assume the system call incurs more
/// overhead, especially if William really implemented rest args as
/// more-args.
///
/// IGNORE MULTIPLE VALUES FOR NOW.
///
define method call-fd-function (fun :: <function>, #rest args)
  let (res, err) = apply(fun, args);
  if (err) error(fd-error-string(err)) end;
  res;
end;
