(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
(* This is the utility program which takes the error    *)
(* message file for Gardens Point Modula and processes  *)
(* it into the form necessary for use by O2InOut        *)

(* Format of the text file is:                          *)
(*      textFile = {comment | message} nul.             *)
(*      comment  = 'line not starting with number'.     *)
(*      message  = number errMess.                      *)
(*      number   = 'an ascii decimal number'.           *)

(* Format of the output table is:                       *)
(*      outTable = index textFile.                      *)
(*      index    = ARRAY[0 .. 512] OF CARDINAL;         *)
(* each index entry is an index into the output table   *)
(* and indexes the corresponding number.errMess string  *)
(*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

MODULE O2ErrLst;

(*
  Revisions:

  24-Mar-92  jrh  Remove 'old' format
		  (input o2errs.txt -> output o2errlst.dat);
		  'new' format with verbose error message text is
		  input errmess.txt -> output o2errlst.dat2.
  12-Nov-92  jrh  Further size increase.
  28-Feb-94  pms  Further size and index increase 5300 & 600
  02-Mar-94  pms  Error list file now o2errlst.dat same as pc and native code.
*)

  IMPORT SYSTEM;
  FROM Terminal IMPORT WriteString, WriteLn, Write, WriteCard;
  FROM ProgArgs IMPORT UNIXexit, EnvironString;
  FROM PathLookup IMPORT FindAndOpen;
  FROM UxFiles IMPORT Open, OpenMode, Create, Close,
             ReadNBytes, WriteByte, File;

  CONST bytesInWord = 4;
  CONST eol      = 12C;
        fileSize = 53000; (* >= bytes in o2errs.txt *)
        indexSiz = 600;
        chrStart = indexSiz * bytesInWord;
        totalSiz = chrStart + fileSize; (*  9000 @ 10-Apr-89 *)
					(* 10000 @ 16-Aug-89 *)
					(* 50000      Mar-92 *)
					(* 52048      Nov-92 *)
                                        (* 55400      Mar-94 *)

  VAR   ch    : CHAR;
        ok    : BOOLEAN;
        read  : CARDINAL;
        ix,lx : CARDINAL;
        total : CARDINAL;
        table : RECORD
                  CASE (* no tag *) : BOOLEAN OF
                  | TRUE  : index : ARRAY [1 .. indexSiz] OF CARDINAL;
                  | FALSE : chars : ARRAY [0 .. totalSiz] OF CHAR;
                  END;
                END;
        pathStr, absName : ARRAY [0 .. 131] OF CHAR;
        errFile, outFile : File;

BEGIN
  FindAndOpen(".","o2errs.txt",absName,errFile);
  IF errFile = NIL THEN
    EnvironString("PATH",pathStr);
    FindAndOpen(pathStr,"o2errs.txt",absName,errFile);
  END;
  IF errFile <> NIL THEN
    WriteString("Reading ");
    WriteString(absName); WriteLn;
  ELSE
    WriteString("**** o2errs.txt not found ****");
    WriteLn; UNIXexit(1);
  END;
  FOR ix := 1 TO indexSiz DO table.index[ix] := 0 END;
  Create(outFile,"o2errlst.dat",ok);
  IF NOT ok THEN
    WriteString("**** Can't create o2errlst.dat ****");
    WriteLn; UNIXexit(1);
  END;
  ReadNBytes(errFile,
             SYSTEM.ADR(table.chars[chrStart]),
             fileSize,
             read);
  Close(errFile,ok);
  ix := chrStart;
  ch := table.chars[ix];
  WHILE ch <> 0C DO (* another line *)
    lx := ix;
    WHILE ch = " " DO (* skip leading blanks *)
      INC(ix); ch := table.chars[ix];
    END;
    (*
       now, is there a number starting the line?
    *)
    IF ("0" <= ch) AND (ch <= "9") THEN
      total := 0;
      WHILE ("0" <= ch) AND (ch <= "9") DO
        total := total * 10 + ORD(ch) - ORD("0");
        INC(ix); ch := table.chars[ix];
      END;
      table.index[total] := lx;        
    END;
    (*
       now find end of line
    *)
    WHILE (ch <> eol) AND (ch <> 0C) DO
      INC(ix); ch := table.chars[ix];
    END;
    IF ch = eol THEN INC(ix); ch := table.chars[ix] END;
  END; (* while *)  
  FOR ix := 0 TO chrStart + read DO 
    WriteByte(outFile,table.chars[ix]);
  END;
  Close(outFile,ok);
END O2ErrLst.

