IMPLEMENTATION MODULE MetrGCode;

FROM Streams    IMPORT StdOut;
FROM YaflParser IMPORT NonTerminal;
FROM YaflGC    IMPORT YaflGC;
FROM Streams   IMPORT StdOut, StdErr;
FROM YaflAsGC  IMPORT AssertionGC;

------------------------------
-- Generic Code Generators.
------------------------------              
FROM YaflGType             IMPORT TypeCodeGenerator; 
FROM YaflGClass            IMPORT ClassDeclCodeGenerator;


------------------------------
-- Non Terminals.
------------------------------
FROM YaflParser            IMPORT NonTerminal, LimitedWalker;
FROM YaflPredefined        IMPORT PredefClass,
                                  PredefNoChangeMethod;
FROM YaflModules           IMPORT CompilationUnit,
                                  DefinitionModule,
                                  ImplementationModule;
FROM YaflDesignator        IMPORT Desig;
FROM YaflMethods           IMPORT Formal,
                                  FormalList;
FROM YaflClasses           IMPORT ClassDeclaration;
FROM YaflClImplementation  IMPORT ClassImplementation;
FROM YaflMetImplementation IMPORT MethodImplementation;

------------------------------

  CLASS MetrCodeGeneratorCreator;
    INHERITS CodeGeneratorCreator;

    REDEFINE METHOD CreateImplModuleCG(NT: ImplementationModule): MetrImplModuleCodeGenerator;
      BEGIN 
      RESULT.CREATE(NT);
      END CreateImplModuleCG;

    REDEFINE METHOD CreateClassImplCG(NT: ClassImplementation): MetrClassImplCodeGenerator;
      BEGIN 
      RESULT.CREATE(NT);
      END CreateClassImplCG;

    REDEFINE METHOD CreateMethImplCG (NT: MethodImplementation): MetrMethImplCodeGenerator;
      BEGIN 
      RESULT.CREATE(NT);
      END CreateMethImplCG;

    REDEFINE METHOD WhatAmI: ARRAY OF CHAR;
      BEGIN 
      RESULT := "Metrics Generation";
      END WhatAmI;

  END MetrCodeGeneratorCreator;

END MetrGCode;
