
/**************
 * yafl_rnt.h *
 **************
 * Common header file included in all .c files generated by the 
 * YAFL compiler. It includes most of the conditional processing,
 * depending on compilation options, the environment (UNIX, DOS, etc...)
 * and the compiler (Ansi or K&R).
 *
 * It also includes several macros which ease the code generation process
 * by avoiding verbatim expansion of trivial structures.
 */

#ifndef YAFL_RNT_H
#define YAFL_RNT_H 1
#define YAM 1

#ifndef YAFL_USR
#include <yafl_usr.h>
#endif

#ifdef YAFL_WINDOWS
#include <windows.h>
#endif

/* somewhere in Microsoft stuff there is a definition for THIS */
/* this is a problem for us */
#ifdef THIS
#undef THIS
#endif

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#ifdef YUSELONG
typedef long YINT;
typedef long yint;
typedef unsigned long yuint;
#else
typedef int YINT;
typedef int yint;
typedef unsigned yuint;
#endif

#ifndef OS2
#ifdef __OS2__
#define OS2 1
#endif  
#endif

#ifdef __STDC__
#define YAFL_ANSI 1
#endif

#ifndef YAFL_ANSI
#ifdef MVS
#define YAFL_ANSI 1
#endif
#endif

typedef unsigned char ychar;

typedef unsigned int uint;

#ifndef UNIX
#ifdef COHERENT
#define UNIX 1
#endif
#ifdef unix
#define UNIX 1
#endif
#endif

#ifdef YAFL_ANSI /*******************************************/
#define YARGS(x) x
typedef void * obj_ptr;
#define VOID void
#define YPARAMS0 (void)
#define YPARAMS2(t,e) (t e)
#define YPARAMS4(t1,e1,t2,e2) (t1 e1, t2 e2)
#define YPARAMS6(t1,e1,t2,e2,t3,e3) (t1 e1, t2 e2, t3 e3)
#define YPARAMS8(t1,e1,t2,e2,t3,e3,t4,e4) (t1 e1, t2 e2, t3 e3, t4 e4)
#define YPARAMS10(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5) \
                (t1 e1, t2 e2, t3 e3, t4 e4, t5 e5)
#define YPARAMS12(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6) \
                (t1 e1, t2 e2, t3 e3, t4 e4, t5 e5, t6 e6)
#define YPARAMS14(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6,t7,e7) \
                (t1 e1, t2 e2, t3 e3, t4 e4, t5 e5, t6 e6, t7 e7)
#define YPARAMS16(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6,t7,e7,t8,e8) \
                (t1 e1, t2 e2, t3 e3, t4 e4, t5 e5, t6 e6, t7 e7,  \
                 t8 e8)
#define YPARAMS18(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6,t7,e7,t8,e8, \
                 t9,e9) \
                (t1 e1, t2 e2, t3 e3, t4 e4, t5 e5, t6 e6, t7 e7, \
                 t8 e8, t9 e9)
                
#else /********************************************************/
#define YARGS(x) ()
#define VOID   int 
typedef char * obj_ptr;
#define YPARAMS0 ()
#define YPARAMS2(t,e) (e) t e;
#define YPARAMS4(t1,e1,t2,e2) (e1, e2) t1 e1; t2 e2;
#define YPARAMS6(t1,e1,t2,e2,t3,e3) \
                (e1,e2,e3) t1 e1; t2 e2; t3 e3;
#define YPARAMS8(t1,e1,t2,e2,t3,e3,t4,e4) \
                (e1, e2, e3, e4) t1 e1; t2 e2; t3 e3; t4 e4;
#define YPARAMS10(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5) \
                (e1, e2, e3, e4, e5) \
                t1 e1; t2 e2; t3 e3; t4 e4; t5 e5;
#define YPARAMS12(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6) \
                (e1, e2, e3, e4, e5, e6) \
                t1 e1; t2 e2; t3 e3; t4 e4; t5 e5; \
		t6 e6;
#define YPARAMS14(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6,t7,e7) \
                (e1, e2, e3, e4, e5, e6, e7) \
                t1 e1; t2 e2; t3 e3; t4 e4; t5 e5; \
		t6 e6; t7 e7;
#define YPARAMS16(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6,t7,e7,t8,e8) \
                (e1, e2, e3, e4, e5, e6, e7, e8) \
                t1 e1; t2 e2; t3 e3; t4 e4; t5 e5; \
		t6 e6; t7 e7; t8 e8;
#define YPARAMS18(t1,e1,t2,e2,t3,e3,t4,e4,t5,e5,t6,e6,t7,e7,t8,e8, \
                t9,e9) \
                (e1, e2, e3, e4, e5, e6, e7, e8) \
                t1 e1; t2 e2; t3 e3; t4 e4; t5 e5; \
		t6 e6; t7 e7; t8 e8; t9 e9;
                
#endif /****************************************************/
#ifdef MVS
#define allocation_count    Y_____1
#define boolean_func        Y_____2
#define char_func           Y_____3
#define class_name          Y_____4
#define clone_func          Y_____5
#define d_pointer           Y_____6
#define default_clone       Y_____7
#define do_exception        Y_____8
#define double_func         Y_____9
#define dual_size           Y____10
#define elem_size           Y____11
#define emit_stderr         Y____12
#define emit_stdout         Y____13
#define entry_type          Y____14
#define fail_assert         Y____15
#define fail_bad_class      Y____16
#define fail_case           Y____17
#define fail_void_mth       Y____18
#define fail_void_obj       Y____19
#define fail_what           Y____20
#define first_sig           Y____21
#define garbage_collect     Y____22
#define get_max_alloc_mem   Y____23
#define get_stdin           Y____24
#define get_total_alloc_mem Y____25
#define get_trace_entry     Y____26
#define inherited           Y____27
#define kill_func           Y____28
#define method_ref          Y____30
#define minimal_dual        Y____31
#define module_name         Y____32
#define new_string          Y____33
#define obj_ptr_func        Y____34
#define once_inst           Y____35
#define push_context        Y____36
#define register_class      Y____37
#define requires_marking    Y____38
#define set_max_alloc_mem   Y____39
#define set_trace_entries   Y____40
#define snake_yam           Y____41
#define system_argc         Y____42
#define system_argv         Y____43
#define trace_entries       Y____44
#define univ_clone          Y____45
#define univ_concat         Y____46
#define univ_concat3        Y____47
#define univ_concat4        Y____48
#define univ_concat5        Y____49
#define univ_slice          Y____50
#define v_pointer           Y____51
#define void_func           Y____52
#define yafl_err_line_nr    Y____53
#define yafl_error_code     Y____54
#define yafl_exit_code      Y____55
#define yafl_terminate      Y____56
#define yafl_err            Y____57
#define reserve_dual_dummy  Y____58
#define YAM_PushInt         Y____59
#define YAM_PushReal        Y____60
#define YAM_PushChar        Y____61
#define YAM_PushBoolean     Y____62
#define YAM_PushObjPtr      Y____63
#define reserve_field_dummy Y____64
#define emit_stdout_ptr     Y____65
#define emit_stderr_ptr     Y____66
#define dbx_add_module      Y____67
#define dbx_add_field       Y____68
#define dbx_add_method      Y____69
#define dbx_add_local       Y____70

#define dbx_yafl_init       Y____71
#define dbx_yafl_begin      Y____72
#define dbx_yafl_term       Y____73
#define dbx_yafl_err        Y____74

#define last_class          Y____80
#define last_class_all      Y____81
#define last_class_sig      Y____82
#define variable_address    Y____83
#define variable_level      Y____84
#define variable_type       Y____85
#define alloc_parallel_dual Y____86
#define mois_init           Y____87

#define init_dbx_modu       Y___100
#define init_dbx_call       Y___101
#define init_dbx_type       Y___102
#define init_dbx_worl       Y___103
#define init_dbx_file       Y___104
#define init_dbx_curr       Y___105
#define init_dbx_brea       Y___106
#define init_dbx_watc       Y___107
#define init_dbx_sign       Y___108
#define init_dbx_io         Y___109
#define init_dbx_out        Y___110
#define init_dbx_ctrl       Y___111
#define init_dbx_cfg        Y___112

#define find_next_class     Y___200
#define find_next_metho     Y___201
#define find_next_field     Y___202
#define find_next_local     Y___203
#define find_next_call      Y___204
#define find_next_once      Y___205
#define find_next_module    Y___206

#define find_prev_class     Y___300
#define find_prev_metho     Y___301
#define find_prev_field     Y___302
#define find_prev_local     Y___303
#define find_prev_call      Y___304
#define find_prev_once      Y___305
#define find_prev_module    Y___306

#define dispose_breakpoint  Y___401
#define dispose_context     Y___402
#define dispose_stack       Y___403
#define dispose_list        Y___404
#define dispose_variable    Y___405
#define dispose_watch       Y___406

#define push_object         Y___501
#define push_objarr         Y___502

#define current_breakpoint  Y___601
#define current_class       Y___602
#define current_method      Y___603
#define current_field       Y___604
#define current_local       Y___605
#define current_call        Y___606
#define current_line        Y___607
#define current_watch       Y___608
#define current_context     Y___609
#define current_elem        Y___610

#define set_current_breakpoint  Y___701
#define set_current_class       Y___702
#define set_current_method      Y___703
#define set_current_field       Y___704
#define set_current_local       Y___705
#define set_current_call        Y___706
#define set_current_line        Y___707
#define set_current_watch       Y___708
#define set_current_context     Y___709
#define set_current_elem        Y___710

#define context_local      Y___801
#define context_method     Y___802
#define context_name       Y___803
#define context_once       Y___804
#define context_call       Y___805
#define context_parts      Y___806

#define change_top_class   Y___900
#define change_top_field   Y___901
#define change_top_subscript Y___902

#define highlight_on       Y___950
#define highlight_off      Y___951

#define term_dbx_modu      Y__1000
#define term_dbx_call      Y__1001
#define term_dbx_type      Y__1002
#define term_dbx_ctrl      Y__1003
#define term_dbx_file      Y__1004
#define term_dbx_worl      Y__1005
#define term_dbx_curr      Y__1006
#define term_dbx_brea      Y__1007
#define term_dbx_watc      Y__1008
#define term_dbx_sign      Y__1009
#define term_dbx_out       Y__1010
#define term_dbx_io        Y__1011
#define term_dbx_rnt       Y__1012
#define term_dbx_cfg       Y__1013

#define try_change_call        Y__1100
#define try_change_local1      Y__1101
#define try_change_local2      Y__1102
#define try_change_field       Y__1103
#define try_change_once        Y__1104
#define try_change_all         Y__1105
#define try_change_class       Y__1106
#define try_change_subscript   Y__1107
#define try_change_field1      Y__1108
#define try_change_field2      Y__1109

#define line_in_method    Y__1200
#define line_in_class     Y__1201

#define search_class      Y__1300
#define search_call       Y__1301

#define reset_context     Y__1400
#define reset_counter     Y__1401

#define first_class       Y__1500
#define first_class_all   Y__1501
#define next_class        Y__1502
#define next_class_all    Y__1503
#define prev_class        Y__1504
#define prev_class_all    Y__1505

#define list_methods           Y__1600
#define list_method_hierarchy  Y__1601

#define list_classes           Y__1602
#define list_class_hierarchy   Y__1603

#define strright               Y__1700
#define strrightchar           Y__1701

#define breakpoint_line        Y__1800
#define breakpoint_module      Y__1801
#define breakpoint_class       Y__1802
#define breakpoint_method      Y__1803
#define breakpoint_string      Y__1804
#define breakpoint_action      Y__1805
#define breakpoint_counter     Y__1806
#define breakpoint_evaluate    Y__1807
#define breakpoint_step        Y__1808

#define yafl_debug_mode        Y__1900
#define yafl_step_mode         Y__1901

#define print_module_list      	Y__2000
#define append_module	       	Y__2001
#define check_ymelt	       	Y__2002
#define append_method	       	Y__2003
#define get_method	       	Y__2004
#define print_method_list      	Y__2005
#define get_module	       	Y__2006
#define print_module_class_list Y__2007

#define y_sql_execute		     Y__2100
#define y_sql_create		     Y__2101
#define y_sql_column_integer	     Y__2102
#define y_sql_column_real	     Y__2103
#define y_sql_column_char	     Y__2104
#define y_sql_column_boolean	     Y__2105
#define y_sql_column_string	     Y__2106
#define y_sql_column_date	     Y__2107
#define y_sql_column_decimal	     Y__2108
#define y_sql_column_blob	     Y__2109
#define y_sql_column_rowid	     Y__2110
#define y_sql_integer		     Y__2111
#define y_sql_real		     Y__2112
#define y_sql_char		     Y__2113
#define y_sql_boolean		     Y__2114
#define y_sql_date		     Y__2115
#define y_sql_decimal		     Y__2116
#define y_sql_blob		     Y__2117
#define y_sql_rowid		     Y__2118
#define y_sql_select_statement	     Y__2119
#define y_sql_multi_select	     Y__2120
#define y_sql_simple_select	     Y__2121
#define y_sql_select_clause	     Y__2122
#define y_sql_select_list	     Y__2123
#define y_sql_select_item	     Y__2124
#define y_sql_from_list		     Y__2125
#define y_sql_from_item		     Y__2126
#define y_sql_group_by_list	     Y__2127
#define y_sql_group_by_item	     Y__2128
#define y_sql_order_by_list	     Y__2129
#define y_sql_order_by_item	     Y__2130
#define y_sql_into_temp_clause	     Y__2131
#define y_sql_insert_statement	     Y__2132
#define y_sql_delete_statement	     Y__2133
#define y_sql_update_statement	     Y__2134
#define y_sql_set_clause	     Y__2135
#define y_sql_fetch_statement	     Y__2136
#define y_sql_variable_list	     Y__2137
#define y_sql_variable		     Y__2138
#define y_sql_declare		     Y__2139
#define y_sql_for_update_clause		     Y__2140
#define y_sql_normal_condition		     Y__2141
#define y_sql_between_condition		     Y__2142
#define y_sql_in_condition		     Y__2143
#define y_sql_like_condition		     Y__2144
#define y_sql_matches_condition		     Y__2145
#define y_sql_null_condition		     Y__2146
#define y_sql_rel_select_condition	     Y__2147
#define y_sql_in_select_condition	     Y__2148
#define y_sql_exists_select_condition	     Y__2149
#define y_sql_table_list		     Y__2150
#define y_sql_table_name		     Y__2151
#define y_sql_column_list		     Y__2152
#define y_sql_column_name		     Y__2153
#define y_sql_expression		     Y__2154
#define y_sql_function			     Y__2155
#define y_sql_param_list		     Y__2156
#define y_sql_param			     Y__2157
#define y_sql_value_list		     Y__2158
#define y_sql_integer_literal		     Y__2159
#define y_sql_real_literal		     Y__2160
#define y_sql_char_literal		     Y__2161
#define y_sql_boolean_literal		     Y__2162
#define y_sql_string_literal		     Y__2163
#define y_sql_void_literal		     Y__2164
#define y_sql_class_literal		     Y__2165
#define y_sql_ext_expr_list		     Y__2166
#define y_sql_ext_expression		     Y__2167
#define y_sql_cursor			     Y__2168

#define y_db2_transfer_null		     Y__2200
#define y_db2_transfer_null_error	     Y__2201
#define y_db2_transfer_boolean_error	     Y__2202
#define y_db2_transfer_char_error	     Y__2203
#define y_db2_transfer_type_error	     Y__2204

#define transfer_integer 		     Y__2300
#define transfer_real 			     Y__2301
#define transfer_char 			     Y__2302
#define transfer_boolean 		     Y__2303
#define transfer_null_real 		     Y__2304
#define transfer_null_boolean 		     Y__2305
#define transfer_null_char 		     Y__2306
#define transfer_null_integer 		     Y__2307
#define transfer_date 			     Y__2308
#define transfer_decimal 		     Y__2309
#define transfer			     Y__2310

#endif
                                  
#define ASSIGN_OBJ_PTR(l,r) l = r 
#define AssignObjPtr ASSIGN_OBJ_PTR

extern int system_argc;
extern char ** system_argv;

#define FIELD_DUMMY_SIZE 32

typedef struct FIELD_INFO
              {
                 char    * name;
                 VOID    * field_dual;
                 unsigned level;
                 unsigned offset;
                 obj_ptr once;
                 /* link to the next one */
                 struct FIELD_INFO * next, *prev;
                 VOID * dual;
                 int visible;
                 char dummy[FIELD_DUMMY_SIZE];
               } FIELD_INFO;

/* added just for the debugger */
typedef struct LOCAL_INFO
        {
          char *name;
          struct minimal_dual *type; 
          unsigned level;
          struct LOCAL_INFO *next,*prev;
          struct METHOD_INFO *method;
          VOID *once;      /* NULL iif non-once local */
          unsigned offset; /* of the local in the context structure */
        } LOCAL_INFO;



typedef struct METHOD_INFO 
        {
        char   		*name;
        int    		arity;
        struct minimal_dual *return_dual;    
        int     	return_array_level;
        int             original_num;

        struct METHOD_INFO *next, *prev;                                    
        unsigned beginline, endline;
        struct minimal_dual *class;
        struct METHOD_INFO *method; /* enclosing method, if any */
        struct METHOD_INFO *first_inner, *last_inner;
        struct METHOD_INFO *next_inner, *prev_inner;
        int bp_count;
        struct LOCAL_INFO *first_local, *last_local;
        unsigned offset;
        yint (*pre_context_free)();           
        yint (*pre_context_dep)();           
        yint (*post_func)();
        VOID (*compute_old)();
		int    has_precond;
        /*struct METHOD_INFO *entry;  /* original method coresponding to this */
        struct METHOD_INFO *base;   /* method implementation redefined by this */
        } METHOD_INFO;
        
#define dbx_method METHOD_INFO
                        
typedef union 	       
             {
             yint    (*int_func)();
             ychar   (*char_func)();
             int     (*boolean_func)();
             VOID    (*void_func)();
             double  (*double_func)();
             obj_ptr (*obj_ptr_func)();
             } universal_func;

typedef struct method_ref {
                 universal_func current;
               } method_ref;

#define DUAL_DUMMY_SIZE 60

typedef struct minimal_dual {
                 int       first_sig,
                           last_sig,
                           elem_size,
                           dual_size;
                 unsigned  inst_count,
                           shadow_count; /* Instance counting fields */
                 unsigned  orig_meth_count,
                           inh_meth_count;
                 int       requires_marking;          
                 char      *class_name;
    		     char      *module_name; /* To be erased */
                 struct module_dual *module_entry;
                 obj_ptr   inherited;   /* Class derivation bush informations */
                 obj_ptr   first_son;
	  	         obj_ptr   brother;
                 FIELD_INFO *first_field, 
                            *last_field;
                 METHOD_INFO *first_method,
                             *last_method;
                 char     dummy[DUAL_DUMMY_SIZE];	/* Filler info */
                 obj_ptr  XRMEs;
                 VOID     (*clone_func) ();
                 VOID     (*kill_func) ();
                 int      *mark_tab;  	/* offsets array used for 
                                           generic marking */
                 obj_ptr  **once_tab;
                 obj_ptr  *once_inst;

 /* To_Delete
                add_method_ref  *parallel_dual;
		 union    {
                          char        dummy[128];
                          class_ymelt_stuff stuff;
                          } ymelt;
END To_Delete */

                 struct minimal_dual *next, *prev;
                 unsigned beginline, endline;
                 struct module_dual *module;
                 obj_ptr *once_ptr;
               } minimal_dual;
               
#define dbx_class minimal_dual

/* the dummy field that is defined in the minimal_dual structure is 
 * not used by YAFL; it is meant to be used by extensions to the YAFL 
 * compiler, such as SQLYAFL or PYCK, to store any additional information 
 * required for a given class; when the runtime of such an extension wishes 
 * to use a portion of the dummy space, it must use the appropriate 
 * reservation function so that conflicts can be detected 
*/

typedef struct module_dual
	{
	char		*name;
        /* Profiling information */
        unsigned        line_count;
        unsigned        *y_profile_lines;
        /* Debugging information */
        char            *source_file_name;
        unsigned        *line_numbers;
   	minimal_dual    *first_class, *last_class;
	} module_dual;

#define dbx_module module_dual

/**********************************************************/

#define maxmodnamelength 32

/**********************************************************/
/* DATA DICTIONNARY FIELDS				  */
/**********************************************************/

typedef struct INDEX_MODULE
    {
    char		*name;
    char		*path;
    char		to_interprete;
    char		yam_loaded;
    struct INDEX_MODULE	*next;
    struct INDEX_MODULE	*prec;
    } INDEX_MODULE;

typedef struct 
    {
    INDEX_MODULE *first;
    INDEX_MODULE *last;
    } INDEX_MODULE_LIST;

/**********************************************************/

void reserve_dual_dummy YARGS((unsigned offset,
                          unsigned size));

/* these functions must be used to store and retrieve data in */
/* the dummy space of a given dual */
void put_dual_dummy YARGS((minimal_dual *dual,
                       unsigned offset,
                       unsigned size,
                       obj_ptr data)) ;

void get_dual_dummy YARGS((minimal_dual *dual,
                       unsigned offset,
                       unsigned size,
                       obj_ptr data)) ;

/* a similar mechanism now exists for the FIELD_INFO structure too */
void reserve_field_dummy YARGS((unsigned offset,
                          unsigned size));

/* these functions must be used to store and retrieve data 
   in the dummy space of a given field */
void put_field_dummy YARGS((FIELD_INFO *field,
                       unsigned offset,
                       unsigned size,
                       obj_ptr data)) ;

void get_field_dummy YARGS((FIELD_INFO *field,
                       unsigned offset,
                       unsigned size,
                       obj_ptr data)) ;

/* To_Delete
VOID append_method YARGS((minimal_dual * in_dual,
                          char *         name,
                          int            arity, 
                          minimal_dual * return_dual,
                          int            ret_arrlevel,
                          int            original_num));
END To_Delete */
/* #define append_method(a,b,c,d,e,f) */
                          
METHOD_INFO *get_method YARGS((minimal_dual * dual,
                                char *         name));

/* These functions are for the module dictionary */
module_dual*	get_module_by_name  	YARGS((char*));
module_dual*    get_module              YARGS((unsigned));
void		register_module	    	YARGS((module_dual*));
unsigned        get_module_count            YARGS((void));
void		dump_module_dictionary			YARGS((void));


#define YD_VIRTUAL YD_VIRT
#define YD_BOOLEAN YD_BOOL
#define YD_INTEGER YD_INT

extern minimal_dual *YDP_CHAR, *YDP_INT, *YDP_REAL, *YDP_BOOL, *YDP_VIRT;
extern minimal_dual YD_CHAR, YD_INT, YD_REAL, YD_BOOL, YD_VIRT;
       
#define ARRAY_SIZE_BITS 22
#define ARRAY_LEVEL_BITS 4
#define MARKED_BITS 2  /* This one cannot be set to a lower value */
#define KILL_EXECUTED_BITS 1

/*
#define ALIGN_HEADER
*/
     /* Uncomment ALIGN_HEADER if you have severe alignment constraints
        (such as on MIPS machines) */

typedef struct {
                 int           _array_size    Y_PACK_MACRO(ARRAY_SIZE_BITS) ;
                 unsigned      _array_level   Y_PACK_MACRO(ARRAY_LEVEL_BITS) ;
                 unsigned      _marked        Y_PACK_MACRO(MARKED_BITS) ;
                 unsigned      _kill_executed 
                                          Y_PACK_MACRO(KILL_EXECUTED_BITS) ;
                 VOID         *next_ptr;
                 minimal_dual *dual;
#ifdef ALIGN_HEADER
                 int filler;               
#endif
               } header;       
               
#define HEADER_ARRAY_SIZE(h)  ((h)->_array_size)               
#define HEADER_ARRAY_LEVEL(h) ((h)->_array_level)               
#define HEADER_MARKED(h)      ((h)->_marked)               
#define KILL_EXECUTED(h)      ((h)->_kill_executed)

#define SET_HEADER_MARKED(h,i)((h)->_marked=(i))
#define CLEAR_HEADER_MARKED(h) ((h)->_marked=0)
#define SET_KILL_EXECUTED(h)   ((h)->_kill_executed=1)		 
#define CLEAR_KILL_EXECUTED(h) ((h)->_kill_executed=0)		 

FIELD_INFO *add_field YARGS((char *name,
                      minimal_dual *type,
                      unsigned level,
                      obj_ptr once,
                      unsigned offset,
                      minimal_dual *dual,
                      int visible));
 
FIELD_INFO *dual_get_field YARGS((minimal_dual *dual,
                                int pos));
                              
/*
*
*  Yafl's runtime error codes
*
*/
#define	YERR_ASSERT	    -1001
#define	YERR_VOID_MTH	-1002
#define	YERR_VOID_OBJ	-1003
#define	YERR_BAD_CLAS	-1004
#define	YERR_VOID_ARR	-1005
#define	YERR_FOR_STEP	-1006
#define	YERR_IDX_ARR	-1007
#define	YERR_VOID_WHAT	-1008
#define	YERR_BAD_WHAT	-1009
#define	YERR_BAD_CASE	-1010
#define	YERR_DUAL_OVFL	-1011
#define YERR_NO_MEM     -1012
#define YERR_BAD_ARRAY  -1013
#define YERR_BAD_CLONE  -1014
#define YERR_BAD_ARRAY_SIZE  -1015
#define YERR_VERSION  -1016
#define	YERR_PREC	  -1017
#define	YERR_POST	  -1018

void yafl_err YARGS((int code));

void yafl_terminate YARGS((void));

void fail_assert YARGS((char* 	module, 
		        int	line));
void fail_void_mth YARGS((char*  module, 
                          char*  class, 
                          char*  method, 
                          obj_ptr p));
void fail_void_obj YARGS((char* module, 
                          char* class, 
                          char* method));
void fail_bad_class YARGS((char* module, 
                           char* class, 
                           char* method));
void fail_void_array YARGS((void));
void fail_for_step YARGS((char* module, 
                          int   line_nr));
void fail_idx_array YARGS((YINT max, 
                           YINT got));
void fail_what YARGS((char*   module, 
                      int     line_nr, 
                      obj_ptr weapon));
void fail_case YARGS((char* module, 
                      int   line_nr, 
                      YINT  weapon));
void fail_dual_overflow YARGS((char* module, 
                               char* class, 
                               char* method));
void fail_version YARGS((char *importing,
                         minimal_dual* dual));
void fail_prec YARGS((void));
void fail_post YARGS((void));

int is_in YARGS((obj_ptr        p, 
                 minimal_dual*  m));

obj_ptr univ_clone YARGS((obj_ptr p));
obj_ptr univ_slice YARGS((obj_ptr   p, 
                          YINT      from, 
                          YINT      len));
obj_ptr univ_concat YARGS((obj_ptr p, 
                           obj_ptr q));
obj_ptr univ_concat3 YARGS((obj_ptr p, 
                            obj_ptr q,
                            obj_ptr r));
obj_ptr univ_concat4 YARGS((obj_ptr p, 
                            obj_ptr q,
                            obj_ptr r,
                            obj_ptr s));
obj_ptr univ_concat5 YARGS((obj_ptr p, 
                            obj_ptr q,
                            obj_ptr r,
                            obj_ptr s,
                            obj_ptr t));
void    default_clone YARGS((obj_ptr p, 
                             obj_ptr q));

obj_ptr array_element YARGS((obj_ptr  p, 
                             YINT     elem_nr));

obj_ptr y_alloc YARGS((YINT      ar_size,
                       int       level,
                       obj_ptr   dual_ptr));
obj_ptr y_realloc YARGS((obj_ptr ptr));
	

void register_class YARGS((minimal_dual* dual));
void number_classes YARGS((void));
void dump_classes YARGS((void));
void yafl_init YARGS((int pass));
yint last_class_sig YARGS((void));
minimal_dual * get_class_dual YARGS((int sig));
void alloc_parallel_dual YARGS((minimal_dual* dual));


void mois_init YARGS((int phase));


void     garbage_collect YARGS((void));
obj_ptr  new_string YARGS((char*  a));
void     enter_pool YARGS((obj_ptr p));
void     flush_pool YARGS((void));

#define HEADER_SIZE (sizeof (header))
#define HEADER(x) (((header *)(x))-1)
/* #define ALIGN(x) (4*((x+3)/4)) */
#define ALIGN 4

/**************************
  For debugging purposes only...
**************************/
extern header * get_header YARGS((obj_ptr p));
/*
  #undef HEADER
  #define HEADER get_header
*/  
/**************************/

#define DUAL_OF(x) (HEADER(x)->dual)
#define FIRST_SIG(x) (DUAL_OF(x)->first_sig)
#define LAST_SIG(x) (DUAL_OF(x)->last_sig)

#ifndef NULL
#define NULL ((VOID*)0L)
#endif
extern minimal_dual   YP_CHAR, YP_INTEGER, YP_BOOLEAN, YP_REAL;
#define TRUE 1
#define FALSE 0

extern int yafl_line_nr;
void enter_method YARGS((char* mod, 
                         char* cl, 
                         char* mth));
void exit_method YARGS((void));
void dump_trace YARGS((void));
yint univ_high YARGS((obj_ptr p));

#ifdef YDEBUG_MODE /************************************/

#ifndef YCHECK_ARRAY
#define YCHECK_ARRAY
#endif

#ifndef YCHECK_METHOD
#define YCHECK_METHOD
#endif

#ifndef YCHECK_VOID_OBJ
#define YCHECK_VOID_OBJ
#endif

#ifndef YCHECK_VOID_METH
#define YCHECK_VOID_METH
#endif

#ifndef YCHECK_WHAT
#define YCHECK_WHAT
#endif

#ifndef YCHECK_CASE
#define YCHECK_CASE
#endif

#ifndef YCHECK_DUAL
#define YCHECK_DUAL
#endif

#ifndef YCHECK_ASSERT
#define YCHECK_ASSERT
#endif

#ifndef YCHECK_DEBUG
#define YCHECK_DEBUG
#endif

#ifndef YCHECK_VERSION
#define YCHECK_VERSION
#endif

#ifndef YCHECK_PRE_CONDITION 
#define YCHECK_PRE_CONDITION 
#endif

#ifndef YCHECK_POST_CONDITION 
#define YCHECK_POST_CONDITION 
#endif

#ifndef YCHECK_CLASS_INVARIANT 
#define YCHECK_CLASS_INVARIANT 
#endif

#ifndef YCHECK_LOOP_INVARIANT 
#define YCHECK_LOOP_INVARIANT
#endif


#endif /************************************************/

#ifdef YTRACE_MODE
#define SET_LINE(x)                 yafl_line_nr=x
#define ENTER_METHOD(x,y,z)         enter_method(x,y,z)
#define EXIT_METHOD                 exit_method()
#else
#define SET_LINE(x)                 
#define ENTER_METHOD(x,y,z)
#define EXIT_METHOD
#endif

#ifdef YPROFILE_MODE
#undef SET_LINE

extern int yafl_profile;
static unsigned y_profile_lines[Y_SOURCE_LINES];

#define SET_LINE(x)   {if(yafl_profile)y_profile_lines[x]++;}
#endif

#ifdef YCHECK_DUAL
#define D_OVRFL(x) (((obj_ptr*)v_stack) - \
                  ((obj_ptr*)d_stack) <= (100 + x))
#define CHECK_DUAL_OVFL(SIZE,Mod,Cl,Meth)   if(((obj_ptr*)v_stack)-\
	((obj_ptr*)d_stack) <= (200 + SIZE)) \
        fail_dual_overflow(Mod,Cl,Meth);
#else
#define D_OVRFL(x)
#define CHECK_DUAL_OVFL(SIZE,Mod,Cl,Meth)
#endif

#ifdef YCHECK_ARRAY
#define HIGH(x)     univ_high(x)
#define ARRAY_ELEMENT(Arr,Typ,ElNr) (*((Typ*)array_element(Arr,ElNr)))
#else
#define HIGH(x)                      HEADER_ARRAY_SIZE((((header *)(x))-1))
#define ARRAY_ELEMENT(Arr,Type,ElNr) (((Type*)Arr)[ElNr])
#endif

#ifdef YFORCE_STRUCT
#define LOCAL(i)   CONTEXT.i
#else
#define LOCAL(i)   i
#endif

extern obj_ptr ** d_stack, *v_stack;
#ifdef Y_DISABLE_GC
#define SAVE_VSTACK(p)    
#define SAVE_DSTACK(p)    
#define RESTORE_VSTACK(p) 
#define RESTORE_DSTACK(p) 
#define REG(x)            
#define VREG(x)           
#define FLYVREG(x) x          

#else

#define SAVE_VSTACK(p) ((p)=v_stack);
#define SAVE_DSTACK(p) ((p)=d_stack);
#define RESTORE_VSTACK(p) (v_stack=(p));
#define RESTORE_DSTACK(p) (d_stack=(p));
/*
#define REG(x)  ((*d_stack++)=(x));assert(v_stack>d_stack);
*/           
/*
#define DUAL_DEPTH ((obj_ptr*)v_stack-(obj_ptr*)d_stack) 
#define CDO3   if ((DUAL_DEPTH < 1000) && (DUAL_DEPTH % 128 == 0)) \
                  printf ("CDO3 %d\n", DUAL_DEPTH);
#define CDO2 if (DUAL_DEPTH <= 200) {dump_trace();exit(1);}
*/
#define REG(x)  ((*d_stack++)=(x)) 
#define VREG(x) ((*v_stack--)=(x)) 
#define FLYVREG(x)  ((*v_stack--)=(x))
#endif

#ifdef YCHECK_VERSION
#define CHECK_VERSION(importing,dual,e_size,d_size)      \
  if((dual->elem_size != e_size) ||  \
     (dual->dual_size != d_size))    \
       fail_version(importing,dual);
       
#else
#define CHECK_VERSION(importing,dual,elem_size,dual_size)
#endif

#define OFFSET(Struct,Field) ((char*)&Struct.Field-(char*)&Struct)

#define DISTANCE(obj1,obj2) (((char*)&(obj1))-((char*)&(obj2)))

#ifdef INLINE_MEMSET     

#define y_memset(ptr,val,count)  { char *p = (char*) ptr;  \
                                 int i;                  \
                                 for (i=0; i<count; i++) \
                                   *p++ = val;           \
                               }
                                 

#else  /* memset is not defined; hence, one must make sure it is 
          made visible */ 
#define y_memset memset          

#ifdef YAFL_ANSI
#ifndef MEMSET_DEFINED
extern VOID * memset YARGS((void*     buf, 
                            int       val, 
                            unsigned  count));
#endif               
#endif
#endif

#define ZERO(x)  y_memset(&x,0,sizeof(x))

#define assertp(x) assert(x!=NULL)

#define YAFL_DEBUG_RUN    0
#define YAFL_DEBUG_STEP   1
#define YAFL_DEBUG_MOVE   2
#define YAFL_DEBUG_LEAVE  3
#define YAFL_DEBUG_TRACE  4
#define YAFL_DEBUG_END    5

typedef struct {
                 char *mod,
                      *cl,
                      *mth;
                 int  line_nr;
                 int  free_dual_stack;
               } entry_type;

extern void (*emit_stdout_ptr)();
extern void (*emit_stderr_ptr)();
extern char *(*get_stdin_ptr)();
extern void emit_stdout YARGS((char* a));
extern void emit_nl YARGS((void));
extern void emit_stderr YARGS((char* a));
extern char *get_stdin YARGS((char* a));

/* 
*   The set_user_prefix_size function can be used to set a number of
*   bytes which will be allocated in front of every YAFL allocation
*   performed. Hence, the memory layout of an allocation can be
*   described as follows:
*   
*     [User-Defined area][Object header][Actual data          ]
*     
*  The default size for this user-defined area is 0. Using this very
*  advanced feature of the YAFL runtime environment requires the
*  following:
*  
*    - If this value ought to be changed, it must happen BEFORE
*      any allocation is performed. Accordingly, one should never
*      change this value dynamically when executing a program.
*
*    - It is the user's responsibility to set this value in such
*      a way that all the system constraints are fulfilled (mostly,
*      alignment regulations)
*
*    - This prefix is transparent to the YAFL runtime environment.
*      It is only taken into account in two places: first when allocating
*      new instances, second when freeing instances as part of the garbage
*      collection process. If the user wishes to read or write this
*      memory area, he (or she) must perform the proper address computation
*      manually (First subtracting the header size, then the user-defined
*      area size.
*/

extern void set_user_prefix_size YARGS((unsigned size));
extern void * yafl_malloc YARGS((int size));
extern void   yafl_free YARGS((void *p, int size));



obj_ptr  y_sql_select_statement YARGS((obj_ptr  Y_Select,
	                               obj_ptr  Y_IntoList,
                                       obj_ptr  Y_IntoTempClause,
                                       obj_ptr  Y_ModuleName,
                                       yint     Y_LineNr,
                                       yint     Y_ColNr));
	
obj_ptr  y_sql_multi_select     YARGS((obj_ptr  Y_LeftSel,
                                       int      Y_All,
                                       obj_ptr  Y_RightSel));
	
obj_ptr  y_sql_simple_select    YARGS((obj_ptr  Y_SelectClause,
	                               obj_ptr  Y_FromList,
                                       obj_ptr  Y_WhereClause,
                                       obj_ptr  Y_GroupByList, 
                                       obj_ptr  Y_HavingClause,
                                       obj_ptr  Y_OrderByList));
	
obj_ptr  y_sql_select_clause    YARGS((int      Y_All, 
                                       int      Y_EveryColumn,
                                       obj_ptr  Y_SelectList));

obj_ptr  y_sql_select_list      YARGS((obj_ptr  Y_Item1,
                                       obj_ptr  Y_Item2));
				       
obj_ptr  y_sql_select_item      YARGS((obj_ptr  Y_TableName,
                                       obj_ptr  Y_Expression,
                                       obj_ptr  Y_DisplayLabel));
				       
obj_ptr  y_sql_from_list        YARGS((obj_ptr  Y_Item1,
                                       obj_ptr  Y_Item2));
				       
obj_ptr  y_sql_from_item        YARGS((obj_ptr  Y_TableName,
                                       obj_ptr  Y_TableAlias,
                                       int      Y_Outer,
                                       obj_ptr  Y_OuterList));
				       
obj_ptr  y_sql_group_by_list    YARGS((obj_ptr  Y_Item1,
                                       obj_ptr  Y_Item2));
				       
obj_ptr  y_sql_group_by_item    YARGS((obj_ptr  Y_ColumnName,
                                       yint 	Y_ColumnNumber));
				       				 
obj_ptr  y_sql_order_by_list    YARGS((obj_ptr  Y_Item1,
                                       obj_ptr  Y_Item2));
				       
obj_ptr  y_sql_order_by_item    YARGS((obj_ptr  Y_ColumnName,
                                       yint 	Y_ColumnNumber,
                                       int      Y_Asc));
				       			
obj_ptr  y_sql_into_temp_clause YARGS((obj_ptr  Y_TableName,
                                       int	Y_WithNoLog));
				       
obj_ptr  y_sql_insert_statement YARGS((obj_ptr  Y_TableName,
	                               obj_ptr  Y_ColumnList,
                                       obj_ptr  Y_ValueList,
                                       obj_ptr  Y_Select));
				       			   
obj_ptr  y_sql_delete_statement YARGS((obj_ptr  Y_TableName,
	                               obj_ptr  Y_Condition,
                                       obj_ptr  Y_Cursor));
				       
obj_ptr  y_sql_update_statement YARGS((obj_ptr  Y_TableName,
	                               obj_ptr  Y_SetClause,
                                       obj_ptr  Y_Condition,
                                       obj_ptr  Y_Cursor));
				       
obj_ptr  y_sql_set_clause       YARGS((int      Y_EveryColumn,
                                       obj_ptr  Y_ColumnList,
                                       obj_ptr  Y_ExprList));
				       
obj_ptr  y_sql_fetch_statement  YARGS((yint     Y_Mode,
                                       obj_ptr  Y_Cursor,
                                       yint     Y_Expr,
                                       obj_ptr  Y_VariableList));
				       
obj_ptr  y_sql_variable_list    YARGS((obj_ptr  Y_Item1,
                                       obj_ptr  Y_Item2));

obj_ptr  y_sql_variable         YARGS((minimal_dual * Y_Type,
                                       yint     Y_Level,
				                               obj_ptr  Y_Address)); 
				       
obj_ptr  y_sql_declare YARGS((int      Y_Scroll,
                              int      Y_WithHold,
                              obj_ptr  Y_Select,
                              obj_ptr  Y_ForUpdateClause,
                              obj_ptr  Y_ModuleName,
                              yint     Y_LineNr,
                              yint     Y_ColNr));
			   
obj_ptr  y_sql_for_update_clause YARGS((obj_ptr Y_ColumnList));
	       			       
obj_ptr  y_sql_normal_condition  YARGS((obj_ptr Y_FirstExpr,
                                        yint    Y_Relation,
                                        obj_ptr Y_SecondExpr));
					
obj_ptr  y_sql_between_condition YARGS((obj_ptr  Y_Expr,
                                        obj_ptr  Y_LowerExpr,
                                        obj_ptr  Y_UpperExpr,
                                        int      Y_Not));
					
obj_ptr  y_sql_in_condition      YARGS((obj_ptr  Y_Expr,
                                        obj_ptr  Y_ValueList, 
                                        int      Y_Not));
							 
obj_ptr  y_sql_like_condition    YARGS((obj_ptr  Y_ColumnName,
                                    	obj_ptr  Y_String,
                                        int      Y_Not));
					
obj_ptr  y_sql_matches_condition YARGS((obj_ptr  Y_ColumnName,
	                                obj_ptr  Y_String,
                                        int      Y_Not));
					
obj_ptr  y_sql_null_condition       YARGS((obj_ptr  Y_ColumnName,
                                           int	    Y_Not));
					
obj_ptr  y_sql_rel_select_condition YARGS((obj_ptr  Y_Expr,
                                           yint     Y_Op,
                                           yint     Y_Mode,
                                           obj_ptr  Y_Select));
					   
obj_ptr  y_sql_in_select_condition  YARGS((obj_ptr  Y_Expr,
	                                   obj_ptr  Y_Select,
                                           int      Y_Not));
					   
obj_ptr  y_sql_exists_select_condition YARGS((obj_ptr  Y_Select,
                                              int      Y_Not));

obj_ptr  y_sql_table_list              YARGS((obj_ptr  Y_Item1,
                                              obj_ptr  Y_Item2));
				 
obj_ptr  y_sql_table_name              YARGS((obj_ptr  Y_Name));

obj_ptr  y_sql_column_list             YARGS((obj_ptr  Y_Item1,
                                              obj_ptr  Y_Item2));

obj_ptr  y_sql_column_name             YARGS((obj_ptr  Y_Name));

obj_ptr  y_sql_expression              YARGS((obj_ptr  Y_FirstExpr, 
                                              yint     Y_Relation,
                                              obj_ptr  Y_SecondExpr));

obj_ptr  y_sql_function                YARGS((obj_ptr  Y_Ident,
                                              int      Y_EveryColumn,
                                              int      Y_All, 
                                              obj_ptr  Y_ParamList));

obj_ptr  y_sql_param_list              YARGS((obj_ptr  Y_Item1, 
                                              obj_ptr  Y_Item2));
								 
obj_ptr  y_sql_param                   YARGS((obj_ptr  Y_Expr));
					      			
obj_ptr  y_sql_value_list              YARGS((obj_ptr  Y_Item1,
                                              obj_ptr  Y_Item2));

obj_ptr  y_sql_integer_literal         YARGS((yint     Y_Value));

obj_ptr  y_sql_real_literal            YARGS((double   Y_Value));

obj_ptr  y_sql_char_literal            YARGS((unsigned int      Y_Value));

obj_ptr  y_sql_boolean_literal         YARGS((int      Y_Value));

obj_ptr  y_sql_string_literal          YARGS((obj_ptr  Y_Value));

obj_ptr  y_sql_void_literal            YARGS((void));

obj_ptr  y_sql_class_literal           YARGS((obj_ptr         Y_Address,
        	                              minimal_dual *  Y_Type));
					      
obj_ptr  y_sql_ext_expr_list           YARGS((obj_ptr  Y_Item1,
                                              obj_ptr  Y_Item2));
					      
obj_ptr  y_sql_ext_expression          YARGS((obj_ptr  Y_Expr,
                                              obj_ptr  Y_Select));
					      
obj_ptr  y_sql_cursor                  YARGS((obj_ptr  Y_Curs));


/* Precondition stuff */

typedef union {
               yint     the_int;
               ychar    the_char;
               obj_ptr  the_obj;
               double   the_double;
               } stack_elem;

typedef struct {
                stack_elem  *elems;
                int         *levels;
                int          max_size;
                int          size; 
                int          max_level;
                int          nb_level;
                } assert_stack;    
                
extern assert_stack  old_stack;
extern assert_stack  param_stack;

void assert_stack_push_int    YARGS((assert_stack* the_stack, yint    Val));
void assert_stack_push_obj    YARGS((assert_stack* the_stack, obj_ptr Val));
void assert_stack_push_char   YARGS((assert_stack* the_stack, ychar  Val));
void assert_stack_push_double YARGS((assert_stack* the_stack, double  Val));

obj_ptr assert_stack_pop_obj    YARGS((assert_stack* the_stack));
yint    assert_stack_pop_int    YARGS((assert_stack* the_stack));
ychar   assert_stack_pop_char   YARGS((assert_stack* the_stack));
double  assert_stack_pop_double YARGS((assert_stack* the_stack));

obj_ptr assert_stack_top_obj    YARGS((assert_stack* the_stack));
yint    assert_stack_top_int    YARGS((assert_stack* the_stack));
ychar   assert_stack_top_char   YARGS((assert_stack* the_stack));
double  assert_stack_top_double YARGS((assert_stack* the_stack));

obj_ptr assert_stack_get_obj    YARGS((assert_stack* the_stack, int offset));
yint    assert_stack_get_int    YARGS((assert_stack* the_stack, int offset));
ychar   assert_stack_get_char   YARGS((assert_stack* the_stack, int offset));
double  assert_stack_get_double YARGS((assert_stack* the_stack, int offset));

void assert_stack_push_level YARGS((assert_stack* the_stack));
void assert_stack_pop_level  YARGS((assert_stack* the_stack));

void decode_errors YARGS((char * head, char * methname));
void check_pre_cond  YARGS((obj_ptr Y_THIS, METHOD_INFO* meth));
void check_post_conditions YARGS((obj_ptr Y_THIS, METHOD_INFO*  meth));
void compute_old_expressions YARGS((obj_ptr Y_THIS, METHOD_INFO*  meth));
void attach_redefined_method YARGS((METHOD_INFO* meth));

#define TEST_BIT(Value, BitNr) (Value & (1 << BitNr) ? TRUE : FALSE)
#define SET_BIT(Value, BitNr) (Value | (1 << BitNr))


/*#ifdef YCHECK_PRE_CONDITION */
/*#undef YCHECK_PRE_CONDITION */
/*#endif*/

/*#ifdef YCHECK_POST_CONDITION */
/*#undef YCHECK_POST_CONDITION */
/*#endif*/

/*#ifdef YCHECK_CLASS_INVARIANT */
/*#undef YCHECK_CLASS_INVARIANT */
/*#endif*/

/*#ifdef YCHECK_LOOP_INVARIANT */
/*#undef YCHECK_LOOP_INVARIANT*/
/*#endif*/

#endif
