#ifndef YAFL_USR
#define YAFL_USR 1

/* 
   Place user #define's here to tune the compilation mechanism
   to a given environment 
*/

/*
#define INLINE_MEMSET 1 */
                          /* The INLINE_MEMSET define is used to replace
                             the function calls to the memset function
                             by inline code. Depending on the sophistication
                             of the underlying C compiler, it might improve
                             or degrade performance */
/**/
#define USE_STD_MALLOC 1 
/**/
                          /* The USE_STD_MALLOC define is used to force
                             the YAFL runtime to use direct calls to
                             malloc and free rather than through its
                             intermediate layer which performs various
                             optimizations (fixed allocations...) */

#define POOLSIZE (16*1024)      /* The POOLSIZE constants describes the garbage
                                   collector pool size */

#define DUAL_STACK_SIZE 2048   /* The DUAL_STACK_SIZE constants describes the
                                  dual stack size */

#define MAX_CLASSES 2048        /* Maximum number of classes known by the
                                   system */

#define MAX_MODULES 500		/* Maximum number of modules known by the
				   system */
                                  
#define SIG_VALUE 1946092651                                  
    

/* The following #define's are related to the optimized allocator
   which uses fixed allocations for all allocations under YMALLOC_THRESHOLD
   bytes, and uses standart malloc otherwise. */
   
#define YMALLOC_THRESHOLD       48
#define YMALLOC_ITEMS_PER_PAGE 512
#define YMALLOC_MAX_PAGES      4096

/* The following #define's are related to a subtle optimization which has
   only effect when the garbage collector is used in contexts where extensive
   swapping occurs. In all other cases, this mechanism induces a slight
   overhead. Undefine the HASH_PAGE_SIZE symbol to discard this behaviour.
   Note that HASH_PAGE_SIZE will always be smaller than HASH_TABLE_SIZE */

#define HASH_PAGE_SIZE  32
#define HASH_STRIP_BITS 12
#define HASH_TABLE_SIZE 4096
                         
/* The following #define is used to compute the entropy of the system 
   To avoid entropy computing, simply undefine USE_ENTROPY_TEST 
#define USE_ENTROPY_TEST */
                                                                        
/* The following define is only used when HASH_PAGE_SIZE is defined, 
   a measure of the collision distance is show after garbage collection 
#define COLLISION_TEST */
 

/* The following #define disables all the garbage collection handling code
   it should only be used for cases where one knows that there is enough
   memory to complete the job without having to free no longer usable
   allocations. Would the garbage collector be called anyway, it would
   not free any memory.
   
   Attention: this flag is only safe when used globally, that is, for an 
   entire system - runtime library included. Therefore, it is probably safer
   to use it in conjunction with the yproject utility to produce a stripped
   down version of a system, without altering other projects in any way */
/*
 define Y_DISABLE_GC 1
*/

/*
 define Y_TRACE_GC 1   
*/



/* If one wishes that the headers don't pack bits into the shortest 
   structure possible the following macro must be commented out and 
   replaced by "#define Y_PACK_MACRO(x)" that does expand to
   nothing */

#define Y_PACK_MACRO(x) : x

#endif
