#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_envi.h"

static int no_skip;
static int debug;
static int multi;
static int no_highlight;
static int force_cr;
static int width;
static int no_trap;
static int no_input;
/* caution: case is a reserved vord */
static int ycase;

int find_envi YPARAMS2(char *, name)
{
  char *p;
  assertp(name);
  p = getenv(name);
  if (p)
  {
    if (atoi(p) == 1)
      return 1;
    else
      return 0;
  }
  else
    return 0;
}


void init_dbx_envi()
{
  no_skip = find_envi("YNOSKIP");
  debug = find_envi("YDEBUG");
  multi = find_envi("YMULTI");
  no_highlight = find_envi("YNOHIGHLIGHT");
  force_cr = find_envi("YFORCECR");
  no_trap = find_envi("YNOTRAP");
  no_input = find_envi("YNOINPUT");
  ycase = find_envi("YCASE");

}


void envi_set_no_skip YPARAMS2(int, value)
{
  no_skip = value;
}

int envi_get_no_skip YPARAMS0
{
  return no_skip;
}

void envi_set_debug YPARAMS2(int, value)
{
  debug = value;
}

int envi_get_debug YPARAMS0
{
  return debug;
}

void envi_set_multi YPARAMS2(int, value)
{
  multi = value;
}

int envi_get_multi YPARAMS0
{
  return multi;
}

void envi_set_no_highlight YPARAMS2(int, value)
{
  no_highlight = value;
}

int envi_get_no_highlight YPARAMS0
{
  return no_highlight;
}

void envi_set_force_cr YPARAMS2(int, value)
{
  force_cr = value;
}

int envi_get_force_cr YPARAMS0
{
  return force_cr;
}

void envi_set_no_trap YPARAMS2(int, value)
{
  no_trap = value;
}

int envi_get_no_trap YPARAMS0
{
  return no_trap;
}

void envi_set_no_input YPARAMS2(int, value)
{
  no_input = value;
}

int envi_get_no_input YPARAMS0
{
  return no_input;
}

void envi_set_case YPARAMS2(int, value)
{
  ycase = value;
}

int envi_get_case YPARAMS0
{
  return ycase;
}

