#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_ctrl.h"
#include "dbx_out.h"
#include "dbx_envi.h"

/*
extern void yafl_terminate YPARAMS0;
*/
extern int yafl_error_code;
extern void (*err_function) YPARAMS0;
extern void (*term_function) YPARAMS0;

void dbx_yafl_err YPARAMS0;
void dbx_yafl_term YPARAMS0;
  
void dbx_yafl_init YPARAMS0
{
  static int count = 0;
  if (count == 0)
  {          
    count++;  
/* initialize every module of the runtime before entering any C function */
/* containing the traduction of YAFL code */ 
    init_dbx_rnt(); 
    err_function = dbx_yafl_err;
    term_function = dbx_yafl_term;
/* in normal mode the initialisation code of the once classes is skipped */
/* by the debugger;define YNOSKIP=1 to force entry in this code */
    if (envi_get_no_skip())
      mode_trace();
    else
      mode_end();
  }             
}

void dbx_yafl_begin YPARAMS0
{
  static int count = 0;
  if(count == 0)
  {            
    count++;
/* define YDEBUG=1 to gain control immediatly */
    if (envi_get_debug())
      mode_trace();
    else
      mode_end();
  }
} 

void dbx_yafl_err YPARAMS0
{ 
  int code;
  char a[200];
  
  code = yafl_error_code;
  if (code == YERR_ASSERT)
    crash(XFAILED_ASSERT);
  else if (code == YERR_VOID_MTH)
    crash(XFAILED_VOID_MTH);
  else if (code == YERR_VOID_OBJ)
    crash(XFAILED_VOID_OBJ);
  else if (code == YERR_BAD_CLAS)
    crash(XFAILED_BAD_CLAS);
  else if (code == YERR_VOID_ARR)
    crash(XFAILED_VOID_ARR);
  else if (code == YERR_FOR_STEP)
    crash(XFAILED_FOR_STEP);
  else if (code == YERR_IDX_ARR)
    crash(XFAILED_IDX_ARR);
  else if (code == YERR_VOID_WHAT)
    crash(XFAILED_VOID_WHAT);
  else if (code == YERR_BAD_WHAT)
    crash(XFAILED_BAD_WHAT);
  else if (code == YERR_BAD_CASE)
    crash(XFAILED_BAD_CASE);
  else if (code == YERR_DUAL_OVFL)
    crash(XFAILED_DUAL_OVFL);
  else if (code == YERR_NO_MEM)
    crash(XFAILED_NO_MEM);
  else if (code == YERR_BAD_CLONE)
    crash(XFAILED_BAD_CLONE);
  else if (code == YERR_BAD_ARRAY)
    crash(XFAILED_BAD_ARRAY);
  else if (code == YERR_VERSION)
    crash(XFAILED_VERSION);
  else if (code == YERR_BAD_ARRAY_SIZE)
    crash(XFAILED_BAD_ARRAY_SIZE);
  else if (code == YERR_PREC)
    crash(XFAILED_PREC);
  else if (code == YERR_POST)
    crash(XFAILED_POST);
  else
    {
    sprintf (a, "Unrecognized code: %d\n", code);
    emit_stdout(a);
    assert(0);
    }
}

void dbx_yafl_term YPARAMS0
{
  term_dbx_rnt();
}
