#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_modu.h"
#include "dbx_type.h"
#include "dbx_clas.h"


/* define various functions to manipulate types more cleanly */
/* a type in the debugger is in fact represented by a dual,which */
/* is a structure created by the compiler */
/* but we don't want to deal with this particularity at the interface */
/* level so these aliases functions are used instead */
 
char *type_name YPARAMS2(dbx_type *,  pt)
{
  assertp(pt); 
  return (pt->class_name); /* this field is called class_name but it is */
                           /* defined for a base type too */
}                             

int is_base YPARAMS2(dbx_type *,  pt)
{
  assertp(pt);
  return (pt->first_sig == -1); /* convention : a signature of -1 means */
}                               /* the dual of a base type */

int is_class YPARAMS2(dbx_type *,  pt) /* inverse function of the previous one */
{
  assertp(pt);
  return (pt->first_sig > 0);
}

int is_real YPARAMS2(dbx_type *,  pt) /* checks by comparing dual adresses */
{
  assertp(pt);
  return (pt == &YD_REAL);
}

int is_int YPARAMS2(dbx_type *,  pt)
{
  assertp(pt);
  return (pt == &YD_INT);
}

int is_char YPARAMS2(dbx_type *,  pt)
{
  assertp(pt);
  return (pt == &YD_CHAR);
}

int is_bool YPARAMS2(dbx_type *,  pt)
{
  assertp(pt);
  return (pt == &YD_BOOL);
}

int is_virtual YPARAMS2(dbx_type *, pt)
{
  assertp(pt);
  return (pt == &YD_VIRT);
}

/* remember that in this implementation dbx_type is just an alias */
/* for minimal_dual designed to manipulate it more cleanly */
/* from a pointer to the dual of a class gives a pointer to the */
/* dual of its superclass or NULL if root of tree */
dbx_type *inherited YPARAMS2(dbx_type *,  pt)
{
  assertp(pt);
  return(pt->inherited);
}

/* gives the type of the lowest class really present in the debugger */
/* using the information present in the dual structure to climb */
/* the class hierarchy and the indirect table to check that the */
/* corresponding dbx_class structure does exist */
  
dbx_type *find_type YPARAMS2(dbx_type *,  pt)
{  
  while (pt)
  {
    if (type_class(pt))
    {
      return(pt);
    }
    pt = inherited(pt);
  }
  return NULL;
}


/* in the new system an empty space has been reserved in the dual structure */
/* for future extensions;here this space is used to contain the reverse */
/* pointer from the dual to the dbx-class structure,rendering the previous */
/* initialization process obsolete;the pointer is now established by the */
/* add_class function of the debugger runtime */
void initialize_indirect YPARAMS0
{
}

/* the pointer is stored in the first bytes of the dummy field */  
dbx_class *type_class YPARAMS2(dbx_type *,  pt)
{
  assertp(pt);
  return *(dbx_class **)(&pt->dummy);
}

void init_dbx_type YPARAMS0
{
  initialize_indirect();
}

void term_dbx_type YPARAMS0
{
}
