#include <yafl_rnt.h>
#include <assert.h>
#include <stdio.h>

const char *INDEX_FILE_NAME = "index";

static INDEX_MODULE_LIST iml;

/**********************************************************/
void init_index_module_list YPARAMS0
    {
    char        	name[50];
    char		path[50];
    char        	yam_stat[50];
    INDEX_MODULE	*new;
    FILE 		*index;

    index=fopen(INDEX_FILE_NAME,"r");
    
    if (index!=NULL)
        {
        while (!feof(index))
            {
            fscanf(index,"%s %s %s",name,path,yam_stat);

            assert(strlen(name)!=0);
            assert(strlen(path)!=0);

            new=(INDEX_MODULE*)malloc(sizeof(INDEX_MODULE));

            assert(new!=NULL);

            new->name=(char*)malloc(strlen(name));
            assert(new->name!=NULL);
            strcpy(new->name,name);

            new->path=(char*)malloc(strlen(path));
            assert(new->path!=NULL);
            strcpy(new->path,path);

            assert(strlen(yam_stat)==1 && (yam_stat[0]=='0' || yam_stat[0]=='1'));

            if (yam_stat[0]=='0') new->to_interprete=TRUE;
            else new->to_interprete=FALSE;

            assert(new->yam_loaded==FALSE);

            new->next=iml.first;
            iml.first=new;

            if (new->next!=NULL) new->next->prec=new;
            else iml.last=new;
            }
        }    

    fclose(index);
    }

/**********************************************************/
void dump_index_module_list YPARAMS0
    {
    INDEX_MODULE *act_mod;
    char a[200];

    emit_stdout("INDEX MODULE LIST\n");
    emit_stdout("=================\n\n");

    act_mod=iml.first;

    while(act_mod!=NULL)
       {
       sprintf(a,"         NAME : %s\n",act_mod->name);
       emit_stdout(a);

       sprintf(a,"         PATH : %s\n",act_mod->path);
       emit_stdout(a);

       if (act_mod->to_interprete) emit_stdout("TO INTERPRETE : true\n");
       else emit_stdout("TO INTERPRETE : false\n");

       if (act_mod->yam_loaded) emit_stdout("YAM LOADED   : true\n\n");
       else emit_stdout("   YAM LOADED : false\n\n");

       act_mod=act_mod->next;
       }
    
    emit_stdout("\n");
    }

/*********************************************************/
INDEX_MODULE* seek_index_module YPARAMS2(char*,name)
    {
    INDEX_MODULE *result;
    char	 found;

    found=FALSE;
    result=iml.first;

    while ((result!=NULL)&&(!(found)))
        {
	found=strcmp(result->name,name);
        if (!(found)) result=result->next;
        }

    return result;
    }

/*********************************************************/
INDEX_MODULE* get_next_module_to_yam_load YPARAMS0
    {
    INDEX_MODULE *result;
    char	 found;

    result=iml.first;
    found=FALSE;

    while ((result!=NULL)&&(!(found)))
        {
        found=((result->to_interprete)&&(result->yam_loaded));
        if (!(found)) result=result->next;
        }

    return result;
    }

/*********************************************************/
char check_index_module_list_integrity YPARAMS0
    {
    INDEX_MODULE	*act_mod;
    char		result;

    act_mod=iml.first;
    result=TRUE;

    while (act_mod!=NULL && result)
        {
        result=(strlen(act_mod->name)>0);
        result=result && (strlen(act_mod->path)>0);

        if (act_mod->next!=NULL) result=result && (act_mod->next->prec==act_mod);
        if (act_mod->prec!=NULL) result=result && (act_mod->prec->next==act_mod);

        act_mod=act_mod->next;
        }

    assert(!result || act_mod==NULL); 

    return result;
    }
   
