#ifndef DBX_CTXT_H 
#define DBX_CTXT_H 1

/* !!! */
/* a context is a structure composed of two fields : the second one */
/* is a stack of frames which describes a path of exploration in the */
/* objects and arrays of the debugged program while the first one is */
/* a string giving the textual representation of this path,that is, */
/* with a dot notation denoting a field selection in an object and */
/* a bracket notation denoting an element selection in an array  */
/* they are constructed or modified simultaneously by the differents */
/* operations so they always stay coherent */

typedef struct dbx_context
               {
                 char *the_name_ptr; /* not truly a name as it changes with the
		                        operations */
                 int global;
                 dbx_class *once;
                 dbx_call *call;
                 dbx_local *local; 
		         dbx_stack *parts;
	       } dbx_context;
					  
dbx_context *new_context YARGS((void));
void dispose_context YARGS((dbx_context *pc));
void push_objarr YARGS ((dbx_context *pc,obj_ptr p));
void pop_objarr YARGS ((dbx_context *pc));	       	       
void push_object YARGS ((dbx_context *pc,obj_ptr po,dbx_class *pcl,dbx_field *pf));
void pop_object YARGS((dbx_context *pc));
void push_array YARGS((dbx_context *pc,obj_ptr pa,unsigned i));
void pop_array YARGS((dbx_context *pc));
int expand_context YARGS((dbx_context *pc));
int retract_context YARGS((dbx_context *pc));
char *context_name YARGS((dbx_context *pc));
dbx_stack *context_parts YARGS((dbx_context *pc));
int empty_context YARGS((dbx_context *pc));
int undefined_context YARGS((dbx_context *pc));
void reset_context YARGS((dbx_context *pc));
dbx_class *context_once YARGS((dbx_context *pc));
dbx_call *context_call YARGS((dbx_context *pc));
dbx_method *context_method YARGS((dbx_context *pc));
dbx_local *context_local YARGS((dbx_context *pc));
obj_ptr top_objarr YARGS((dbx_context *pc));
dbx_class *top_class YARGS((dbx_context *pc));
dbx_field *top_field YARGS((dbx_context *pc));
unsigned top_subscript YARGS((dbx_context *pc));
void change_once YARGS((dbx_context *pc,dbx_class *pcl));
void change_call YARGS((dbx_context *pc,dbx_call *pca));
void change_local YARGS((dbx_context *pc,dbx_local *pl));
void change_top_class YARGS((dbx_context *pc,dbx_class *pcl));
void change_top_field YARGS((dbx_context *pc,dbx_field *pcl));
void change_top_subscript YARGS((dbx_context *pc,unsigned i));

dbx_variable *create_variable YARGS((dbx_context *pc));	       	       

#endif

