#ifndef DBX_FRAME_H
#define DBX_FRAME_H 1

/* a frame is a structure used to remember a level of choice in the */
/* exploration process of the objects and arrays of the debugged */
/* program; it is composed of an universal pointer pointing to */
/* either an array or an object (which both have the same header */
/* structure in this implementation) and other fields which indicate */
/* the choice made;class and field are undefined in the case of an array*/
/* while subscript is undefined in the case of an object */

typedef struct dbx_frame
               {
	         obj_ptr objarr;
		 dbx_class *class; /* if object */
		 dbx_field *field; /* if object */
		 unsigned subscript; /* if array */
	       } dbx_frame;

dbx_frame *new_frame YARGS((obj_ptr objarr,
                            dbx_class *class,
			    dbx_field *field,
			    unsigned subscript));
void dispose_frame YARGS((dbx_frame *pf));
obj_ptr frame_objarr YARGS((dbx_frame *pf));
dbx_class *frame_class YARGS((dbx_frame *pf));	       	       
dbx_field *frame_field YARGS((dbx_frame *pf));
unsigned frame_subscript YARGS((dbx_frame *pf));


/* we implement a stack of frames using general-purpose lists */

typedef dbx_list dbx_stack; 

dbx_stack *new_stack YARGS((void));
void dispose_stack YARGS((dbx_stack *ps));
int empty_stack YARGS((dbx_stack *ps));
void push_frame YARGS((dbx_stack *ps,dbx_frame *pf));
void pop_frame YARGS((dbx_stack *ps));
dbx_frame *top_frame YARGS((dbx_stack *ps));

#endif
