IMPLEMENTATION MODULE Math;

INLINE
  %#include <math.h>
  %#ifdef YAFL_MICROSOFT
  %#include <float.h>
  %#endif
  END;
         
  ONCE CLASS Math;
    METHOD Sin (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = sin (Y_r);
        END;
      END Sin;
      
    METHOD Cos (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = cos (Y_r);
        END;
      END Cos;
      
    METHOD Tan (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = tan (Y_r);
        END;
      END Tan;
      
    METHOD ArcSin (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = asin (Y_r);
        END;
      END ArcSin;
      
    METHOD ArcCos (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = acos (Y_r);
        END;
      END ArcCos;
      
    METHOD ArcTan (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = atan (Y_r);
        END;
      END ArcTan;
      
    METHOD Sqrt (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = sqrt (Y_r);
        END;
      END Sqrt;
      
    METHOD Exp (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = exp (Y_r);
        END;
      END Exp;
      
    METHOD Log (r: REAL): REAL;
      BEGIN
      INLINE
        % Y_RESULT = log (Y_r);
        END;
      END Log;
      
    METHOD Power (Base, Exponent: REAL): REAL;
      VAR
        e: REAL;
      BEGIN     
      e := Exponent;
      INLINE
        % Y_RESULT = pow(Y_Base, Y_e);
        END;
      END Power;
      
    METHOD IsNaN(r: REAL): BOOLEAN;
      BEGIN
      INLINE
        %#ifdef YAFL_MICROSOFT
        % Y_RESULT = (_isnan(Y_r) || !_finite(Y_r)) ? 1 : 0;
        %#endif
        END;
      END IsNaN;
      
  END Math;

END Math;
