#!./oraperl
#
# mkdb.pl
#
# Sample oraperl program to create a new database and load data into it.
#
# Author:	Kevin Stock
# Date:		5th August 1991
#

# make sure that we really are running oraperl
die ("You should use oraperl, not perl\n") unless defined &ora_login;

# get debugging & error codes
require('oraperl.ph');

# let's see what oraperl is doing when it executes this
$ora_debug = $ODBG_EXEC | $ODBG_STRNUM | $ODBG_MALLOC;

# set these as strings to make the code more readable
$CREATE = "create table tryit (name char(10), ext number(3))";
$INSERT = "insert into tryit values (:1, :2)";
$LIST	= "select * from tryit order by name";
$DELETE	= "delete from tryit where name = :1";
$DROP	= "drop table tryit";

format top =
       Name         Ext
       ====         ===
.

format STDOUT =
       @<<<<<<<<<   @>>
       $name,       $ext
.

# function to list the database

sub list
{
	local($csr, $name, $ext);

	$- = 0;

	$csr = &ora_open($lda, $LIST)			|| die $ora_errstr;
	while (($name, $ext) = &ora_fetch($csr))
	{
		write;
	}
	die $ora_errstr if ($ora_errno != 0);
	do ora_close($csr)				|| die $ora_errstr;
}

# create the database

$lda = &ora_login("t", "kstock", "kstock")	|| die $ora_errstr;
&ora_do($lda, $CREATE)				|| die $ora_errstr;

# put some data into it

$csr = &ora_open($lda, $INSERT)			|| die $ora_errstr;
while (<DATA>)
{
	m/([a-z]+):([0-9]+)/;
	do ora_bind($csr, $1, $2);
}
do ora_close($csr)				|| die $ora_errstr;

# check the result
do list();

# remove a few lines

$csr = &ora_open($lda, $DELETE)			|| die $ora_errstr;
foreach $name ('catherine', 'angela', 'arnold', 'julia')
{
	&ora_bind($csr, $name)			|| die $ora_errstr;
}
&ora_close($csr)				|| die $ora_errstr;

# check the result
do list();

# remove the database and log out
$csr = &ora_do($lda, $DROP)			|| die $ora_errstr;
do ora_logoff($lda)				|| die $ora_errstr;

# This is the data which will go into the database
__END__
julia:292
angela:208
larry:424
catherine:201
randall:306
arnold:305
