# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

# for a description of the variables, please have a look at the
# Glossary file, as written in the Porting folder, or use the url:
# http://perl5.git.perl.org/perl.git/blob/HEAD:/Porting/Glossary

package Config;
use strict;
use warnings;
use vars '%Config';

# Skip @Config::EXPORT because it only contains %Config, which we special
# case below as it's not a function. @Config::EXPORT won't change in the
# lifetime of Perl 5.
my %Export_Cache = (myconfig => 1, config_sh => 1, config_vars => 1,
		    config_re => 1, compile_date => 1, local_patches => 1,
		    bincompat_options => 1, non_bincompat_options => 1,
		    header_files => 1);

@Config::EXPORT = qw(%Config);
@Config::EXPORT_OK = keys %Export_Cache;

# Need to stub all the functions to make code such as print Config::config_sh
# keep working

sub bincompat_options;
sub compile_date;
sub config_re;
sub config_sh;
sub config_vars;
sub header_files;
sub local_patches;
sub myconfig;
sub non_bincompat_options;

# Define our own import method to avoid pulling in the full Exporter:
sub import {
    shift;
    @_ = @Config::EXPORT unless @_;

    my @funcs = grep $_ ne '%Config', @_;
    my $export_Config = @funcs < @_ ? 1 : 0;

    no strict 'refs';
    my $callpkg = caller(0);
    foreach my $func (@funcs) {
	die qq{"$func" is not exported by the Config module\n}
	    unless $Export_Cache{$func};
	*{$callpkg.'::'.$func} = \&{$func};
    }

    *{"$callpkg\::Config"} = \%Config if $export_Config;
    return;
}

die "Perl lib version (5.16.0) doesn't match executable '$0' version ($])"
    unless $^V;

$^V eq 5.16.0
    or die "Perl lib version (5.16.0) doesn't match executable '$0' version (" .
	sprintf("v%vd",$^V) . ")";


sub FETCH {
    my($self, $key) = @_;

    # check for cached value (which may be undef so we use exists not defined)
    return exists $self->{$key} ? $self->{$key} : $self->fetch_string($key);
}

my %preconfig;
#if ($OS2::is_aout) {
#    my ($value, $v) = $Config_SH_expanded =~ m/^used_aout='(.*)'\s*$/m;
#    for (split ' ', $value) {
#        ($v) = $Config_SH_expanded =~ m/^aout_$_='(.*)'\s*$/m;
#        $preconfig{$_} = $v eq 'undef' ? undef : $v;
#    }
#}
#$preconfig{d_fork} = undef unless $OS2::can_fork; # Some funny cases can't
sub TIEHASH { bless {%preconfig} }
$preconfig{dll_name} = 'perlB0AE';

sub DESTROY { }

sub AUTOLOAD {
    require 'Config_heavy.pl';
    goto \&launcher unless $Config::AUTOLOAD =~ /launcher$/;
    die "&Config::AUTOLOAD failed on $Config::AUTOLOAD";
}

# tie returns the object, so the value returned to require will be true.
tie %Config, 'Config', {
    archlibexp => '/perl5/lib/5.16.0/os2',
    archname => 'i386-os2',
    cc => 'gcc',
    d_readlink => 'define',
    d_symlink => 'define',
    dlext => 'dll',
    dlsrc => 'dl_dlopen.xs',
    dont_use_nlink => undef,
    exe_ext => '.exe',
    inc_version_list => ' ',
    intsize => '4',
    ldlibpthname => 'LD_LIBRARY_PATH',
    libpth => 'f:/lang/gcc/usr/lib/gcc-lib/i386-pc-os2-emx/3.3.5 f:/lang/gcc/usr/lib f:/usr/lib f:/usr/dll f:/lang/emx/lib f:/lang/os2tk45/speech/lib f:/lang/os2tk45/samples/mm/lib f:/lang/os2tk45/lib f:/lang/os2tk45/som/lib F:/lang/gcc/usr/lib',
    osname => 'os2',
    osvers => '2.45',
    path_sep => ';',
    privlibexp => '/perl5/lib/5.16.0',
    scriptdir => '/perl5/bin',
    sitearchexp => '/perl5/lib/site_perl/5.16.0/os2',
    sitelibexp => '/perl5/lib/site_perl/5.16.0',
    so => 'dll',
    useithreads => undef,
    usevendorprefix => undef,
    version => '5.16.0',
};
