extproc python -x %PYTHONHOME%\fnifr.cmd
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/script/RCS/fnifr,v $
# Version:      @(#)$RCSfile: fnifr,v $ $Revision: 1.4 $
#
#############################################################################
""" The Fnorb Interface Repository. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import BOA, CORBA

# Interface Repository modules.
from Fnorb.cos.interface_repository import IFR


def main(argv):
    """ Do it! """

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # The interface repository is single-threaded!
    orb._fnorb_override_options({'Threading Model': 'Reactive'})

    # Initialise the BOA.
    boa = BOA.BOA_init(argv, BOA.BOA_ID)

    # Create the interface repository.
    ifr = IFR.IFR(argv)

    # Start the event loop.
    boa._fnorb_mainloop()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv[1:]))

#############################################################################
