/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BatchFilerImpl;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class HookedJavaFileObject
extends ForwardingJavaFileObject<JavaFileObject> {
    protected final BatchFilerImpl _filer;
    protected final String _fileName;
    private boolean _closed = false;
    private String _typeName;

    public HookedJavaFileObject(JavaFileObject javaFileObject, String string, String string2, BatchFilerImpl batchFilerImpl) {
        super(javaFileObject);
        this._filer = batchFilerImpl;
        this._fileName = string;
        this._typeName = string2;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new ForwardingOutputStream(super.openOutputStream());
    }

    @Override
    public Writer openWriter() throws IOException {
        return new ForwardingWriter(super.openWriter());
    }

    protected void closed() {
        if (!this._closed) {
            this._closed = true;
            switch (this.getKind()) {
                case SOURCE: {
                    CompilationUnit compilationUnit = new CompilationUnit(null, this._fileName, null, null, this._filer._env.shouldIgnoreOptionalProblems(this._fileName.toCharArray()), null);
                    this._filer.addNewUnit(compilationUnit);
                    break;
                }
                case CLASS: {
                    char[] cArray;
                    ReferenceBinding referenceBinding;
                    ClassFileReader classFileReader = null;
                    try {
                        classFileReader = ClassFileReader.read(this._fileName);
                    }
                    catch (ClassFormatException classFormatException) {
                        referenceBinding = this._filer._env._compiler.lookupEnvironment.getType(CharOperation.splitOn('.', this._typeName.toCharArray()));
                        if (referenceBinding != null) {
                            this._filer.addNewClassFile(referenceBinding);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (classFileReader == null || (referenceBinding = this._filer._env._compiler.lookupEnvironment.getType(CharOperation.splitOn('/', cArray = classFileReader.getName()))) == null || !referenceBinding.isValidBinding()) break;
                    if (referenceBinding.isBinaryBinding()) {
                        this._filer.addNewClassFile(referenceBinding);
                        break;
                    }
                    BinaryTypeBinding binaryTypeBinding = new BinaryTypeBinding(referenceBinding.getPackage(), classFileReader, this._filer._env._compiler.lookupEnvironment, true);
                    if (binaryTypeBinding == null) break;
                    this._filer.addNewClassFile(binaryTypeBinding);
                    break;
                }
            }
        }
    }

    private class ForwardingOutputStream
    extends OutputStream {
        private final OutputStream _os;

        ForwardingOutputStream(OutputStream outputStream) {
            this._os = outputStream;
        }

        @Override
        public void close() throws IOException {
            this._os.close();
            HookedJavaFileObject.this.closed();
        }

        @Override
        public void flush() throws IOException {
            this._os.flush();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._os.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this._os.write(byArray);
        }

        @Override
        public void write(int n) throws IOException {
            this._os.write(n);
        }

        protected Object clone() throws CloneNotSupportedException {
            return new ForwardingOutputStream(this._os);
        }

        public int hashCode() {
            return this._os.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ForwardingOutputStream forwardingOutputStream = (ForwardingOutputStream)object;
            return !(this._os == null ? forwardingOutputStream._os != null : !this._os.equals(forwardingOutputStream._os));
        }

        public String toString() {
            return "ForwardingOutputStream wrapping " + this._os.toString();
        }
    }

    private class ForwardingWriter
    extends Writer {
        private final Writer _w;

        ForwardingWriter(Writer writer2) {
            this._w = writer2;
        }

        @Override
        public Writer append(char c) throws IOException {
            return this._w.append(c);
        }

        @Override
        public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
            return this._w.append(charSequence, n, n2);
        }

        @Override
        public Writer append(CharSequence charSequence) throws IOException {
            return this._w.append(charSequence);
        }

        @Override
        public void close() throws IOException {
            this._w.close();
            HookedJavaFileObject.this.closed();
        }

        @Override
        public void flush() throws IOException {
            this._w.flush();
        }

        @Override
        public void write(char[] cArray) throws IOException {
            this._w.write(cArray);
        }

        @Override
        public void write(int n) throws IOException {
            this._w.write(n);
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            this._w.write(string, n, n2);
        }

        @Override
        public void write(String string) throws IOException {
            this._w.write(string);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this._w.write(cArray, n, n2);
        }

        protected Object clone() throws CloneNotSupportedException {
            return new ForwardingWriter(this._w);
        }

        public int hashCode() {
            return this._w.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ForwardingWriter forwardingWriter = (ForwardingWriter)object;
            return !(this._w == null ? forwardingWriter._w != null : !this._w.equals(forwardingWriter._w));
        }

        public String toString() {
            return "ForwardingWriter wrapping " + this._w.toString();
        }
    }
}

