/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class CompactConstructorDeclaration
extends ConstructorDeclaration {
    public TypeDeclaration recordDeclaration;

    public CompactConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        parser.parse(this, compilationUnitDeclaration, false);
        this.containsSwitchWithTry = parser.switchWithTry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo, int n) {
        try {
            this.scope.isCompactConstructorScope = true;
            super.analyseCode(classScope, initializationFlowContext, flowInfo, n);
        }
        finally {
            this.scope.isCompactConstructorScope = false;
        }
    }

    @Override
    protected void doFieldReachAnalysis(FlowInfo flowInfo, FieldBinding[] fieldBindingArray) {
    }

    @Override
    protected void checkAndGenerateFieldAssignment(FlowContext flowContext, FlowInfo flowInfo, FieldBinding[] fieldBindingArray) {
        this.scope.isCompactConstructorScope = false;
        if (fieldBindingArray == null) {
            return;
        }
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        for (FieldBinding statementArray2 : fieldBindingArray) {
            if (statementArray2.isStatic()) continue;
            assert (statementArray2.isFinal());
            FieldReference fieldReference = new FieldReference(statementArray2.name, 0L);
            fieldReference.receiver = new ThisReference(0, 0);
            Assignment assignment = new Assignment(fieldReference, new SingleNameReference(statementArray2.name, 0L), 0);
            assignment.resolveType(this.scope);
            assignment.analyseCode(this.scope, flowContext, flowInfo);
            assignment.bits |= 0x400;
            assert (flowInfo.isDefinitelyAssigned(statementArray2));
            arrayList.add(assignment);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Object[] objectArray = arrayList.toArray(new Statement[0]);
        if (this.statements == null) {
            this.statements = objectArray;
            return;
        }
        int n = this.statements.length;
        int n2 = objectArray.length;
        Statement[] statementArray = new Statement[n + n2];
        System.arraycopy(this.statements, 0, statementArray, 0, n);
        System.arraycopy(objectArray, 0, statementArray, n, n2);
        this.statements = statementArray;
    }
}

