/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.pushbutton;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class PushButton
extends Control {
    private Status _status;
    private ObjectProperty<Status> status;
    private boolean _toggleEnabled;
    private BooleanProperty toggleEnabled;
    private Color _color;
    private ObjectProperty<Color> color;
    private boolean keepAspect;
    private ObjectProperty<EventHandler<SelectionEvent>> onSelect = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onSelect";
        }
    };
    private ObjectProperty<EventHandler<SelectionEvent>> onDeselect = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onDeselect";
        }
    };
    private ObjectProperty<EventHandler<SelectionEvent>> onEmpty = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onEmpty";
        }
    };

    public PushButton() {
        this.getStyleClass().add((Object)"push-button");
        this.keepAspect = true;
        this._status = Status.EMPTY;
        this._toggleEnabled = true;
        this._color = Color.RED;
        this.registerListeners();
    }

    private void registerListeners() {
        this.setOnMousePressed(mouseEvent -> this.toggle());
        this.setOnTouchPressed(touchEvent -> this.toggle());
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final Status getStatus() {
        return null == this.status ? this._status : (Status)((Object)this.status.get());
    }

    public final void setStatus(Status STATUS) {
        if (null == this.status) {
            this._status = STATUS;
        } else {
            this.status.set((Object)STATUS);
        }
        if (Status.DESELECTED == STATUS) {
            this.fireSelectionEvent(new SelectionEvent(this.getStatus(), (Object)this, null, SelectionEvent.DESELECTED));
        } else if (Status.SELECTED == STATUS) {
            this.fireSelectionEvent(new SelectionEvent(this.getStatus(), (Object)this, null, SelectionEvent.SELECTED));
        } else if (Status.EMPTY == STATUS) {
            this.fireSelectionEvent(new SelectionEvent(this.getStatus(), (Object)this, null, SelectionEvent.EMPTY));
        }
    }

    public final ObjectProperty<Status> statusProperty() {
        if (null == this.status) {
            this.status = new SimpleObjectProperty((Object)this, "status", (Object)this._status);
        }
        return this.status;
    }

    public final boolean isToggleEnabled() {
        return null == this.toggleEnabled ? this._toggleEnabled : this.toggleEnabled.get();
    }

    public final void setToggleEnabled(boolean TOGGLE_ENABLED) {
        if (null == this.toggleEnabled) {
            this._toggleEnabled = TOGGLE_ENABLED;
        } else {
            this.toggleEnabled.set(TOGGLE_ENABLED);
        }
    }

    public final BooleanProperty toggleEnabledProperty() {
        if (null == this.toggleEnabled) {
            this.toggleEnabled = new SimpleBooleanProperty((Object)this, "toggleEnabled", this._toggleEnabled);
        }
        return this.toggleEnabled;
    }

    public final Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
        } else {
            this.color.set((Object)COLOR);
        }
    }

    public final ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new SimpleObjectProperty((Object)this, "ledColor", (Object)this._color);
        }
        return this.color;
    }

    public boolean isResizable() {
        return true;
    }

    private void toggle() {
        if (Status.DESELECTED == this.getStatus()) {
            this.setStatus(Status.SELECTED);
        } else if (this.isToggleEnabled() && Status.SELECTED == this.getStatus()) {
            this.setStatus(Status.DESELECTED);
        }
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onSelectProperty() {
        return this.onSelect;
    }

    public final void setOnSelect(EventHandler<SelectionEvent> value) {
        this.onSelectProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnSelect() {
        return (EventHandler)this.onSelectProperty().get();
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onDeselectProperty() {
        return this.onDeselect;
    }

    public final void setOnDeselect(EventHandler<SelectionEvent> value) {
        this.onDeselectProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnDeselect() {
        return (EventHandler)this.onDeselectProperty().get();
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onEmptyProperty() {
        return this.onEmpty;
    }

    public final void setOnEmpty(EventHandler<SelectionEvent> value) {
        this.onEmptyProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnEmpty() {
        return (EventHandler)this.onEmptyProperty().get();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = SelectionEvent.SELECTED == TYPE ? this.getOnSelect() : (SelectionEvent.DESELECTED == TYPE ? this.getOnDeselect() : (SelectionEvent.EMPTY == TYPE ? this.getOnEmpty() : null));
        if (HANDLER != null) {
            HANDLER.handle((Event)EVENT);
        }
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".css").toExternalForm();
    }

    public static class SelectionEvent
    extends Event {
        public static final EventType<SelectionEvent> SELECTED = new EventType(ANY, "selected");
        public static final EventType<SelectionEvent> DESELECTED = new EventType(ANY, "deselected");
        public static final EventType<SelectionEvent> EMPTY = new EventType(ANY, "empty");
        private Status status;

        public SelectionEvent(Status STATUS, Object SOURCE, EventTarget TARGET, EventType<SelectionEvent> EVENT_TYPE) {
            super(SOURCE, TARGET, EVENT_TYPE);
            this.status = STATUS;
        }

        public final Status getStatus() {
            return this.status;
        }
    }

    public static enum Status {
        EMPTY,
        DESELECTED,
        SELECTED;

    }
}

