/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.heatcontrol;

import eu.hansolo.enzo.heatcontrol.HeatControl;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Demo
extends Application {
    private HeatControl control;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.control = new HeatControl();
        this.control.setTargetEnabled(true);
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Demo.this.lastTimerCall + 1000000000L) {
                    if (Double.compare(Demo.this.control.getTarget(), Demo.this.control.getValue()) > 0) {
                        Demo.this.control.setValue(Demo.this.control.getValue() + 0.1);
                    } else if (Double.compare(Demo.this.control.getTarget(), Demo.this.control.getValue()) < 0) {
                        Demo.this.control.setValue(Demo.this.control.getValue() - 0.1);
                    }
                    Demo.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.getChildren().add((Object)this.control);
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Demo HeatControl");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }
}

