/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.matrixsegment.skin;

import eu.hansolo.enzo.matrixsegment.MatrixSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class MatrixSegmentSkin
extends SkinBase<MatrixSegment>
implements Skin<MatrixSegment> {
    private static final double PREFERRED_WIDTH = 71.0;
    private static final double PREFERRED_HEIGHT = 100.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static double aspectRatio;
    private Map<MatrixSegment.Dot, Region> dotMap;
    private List<Region> highlights;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Region background;
    private InnerShadow backgroundInnerShadow;
    private InnerShadow backgroundInnerHighlight;
    private InnerShadow dotInnerShadow;
    private DropShadow glow;
    private Region d57;
    private Region d47;
    private Region d37;
    private Region d27;
    private Region d17;
    private Region d56;
    private Region d46;
    private Region d36;
    private Region d26;
    private Region d16;
    private Region d55;
    private Region d45;
    private Region d35;
    private Region d25;
    private Region d15;
    private Region d54;
    private Region d44;
    private Region d34;
    private Region d24;
    private Region d14;
    private Region d53;
    private Region d43;
    private Region d33;
    private Region d23;
    private Region d13;
    private Region d52;
    private Region d42;
    private Region d32;
    private Region d22;
    private Region d12;
    private Region d51;
    private Region d41;
    private Region d31;
    private Region d21;
    private Region d11;
    private Region d57h;
    private Region d47h;
    private Region d37h;
    private Region d27h;
    private Region d17h;
    private Region d56h;
    private Region d46h;
    private Region d36h;
    private Region d26h;
    private Region d16h;
    private Region d55h;
    private Region d45h;
    private Region d35h;
    private Region d25h;
    private Region d15h;
    private Region d54h;
    private Region d44h;
    private Region d34h;
    private Region d24h;
    private Region d14h;
    private Region d53h;
    private Region d43h;
    private Region d33h;
    private Region d23h;
    private Region d13h;
    private Region d52h;
    private Region d42h;
    private Region d32h;
    private Region d22h;
    private Region d12h;
    private Region d51h;
    private Region d41h;
    private Region d31h;
    private Region d21h;
    private Region d11h;

    public MatrixSegmentSkin(MatrixSegment CONTROL) {
        super((Control)CONTROL);
        aspectRatio = 1.408450704225352;
        this.dotMap = new HashMap<MatrixSegment.Dot, Region>(35);
        this.highlights = new ArrayList<Region>(35);
        this.pane = new Pane();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((MatrixSegment)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((MatrixSegment)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((MatrixSegment)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((MatrixSegment)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((MatrixSegment)this.getSkinnable()).getPrefWidth() > 0.0 && ((MatrixSegment)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((MatrixSegment)this.getSkinnable()).setPrefSize(((MatrixSegment)this.getSkinnable()).getPrefWidth(), ((MatrixSegment)this.getSkinnable()).getPrefHeight());
            } else {
                ((MatrixSegment)this.getSkinnable()).setPrefSize(71.0, 100.0);
            }
        }
        if (Double.compare(((MatrixSegment)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((MatrixSegment)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((MatrixSegment)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((MatrixSegment)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((MatrixSegment)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((MatrixSegment)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((MatrixSegment)this.getSkinnable()).getPrefWidth() != 71.0 || ((MatrixSegment)this.getSkinnable()).getPrefHeight() != 100.0) {
            aspectRatio = ((MatrixSegment)this.getSkinnable()).getPrefHeight() / ((MatrixSegment)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.backgroundInnerShadow = new InnerShadow();
        this.backgroundInnerShadow.setOffsetY(-1.0);
        this.backgroundInnerShadow.setRadius(0.22903225806451613);
        this.backgroundInnerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.backgroundInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.backgroundInnerHighlight = new InnerShadow();
        this.backgroundInnerHighlight.setOffsetY(1.0);
        this.backgroundInnerHighlight.setRadius(0.22903225806451613);
        this.backgroundInnerHighlight.setColor(Color.rgb((int)200, (int)200, (int)200, (double)0.65));
        this.backgroundInnerHighlight.setBlurType(BlurType.TWO_PASS_BOX);
        this.backgroundInnerHighlight.setInput((Effect)this.backgroundInnerShadow);
        this.background.setEffect((Effect)this.backgroundInnerHighlight);
        this.dotInnerShadow = new InnerShadow();
        this.dotInnerShadow.setRadius(1.7750000000000001);
        this.dotInnerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.dotInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.glow = new DropShadow();
        this.glow.setInput((Effect)this.dotInnerShadow);
        this.glow.setRadius(2.2720000000000002);
        this.glow.setColor(((MatrixSegment)this.getSkinnable()).getColor());
        this.glow.setBlurType(BlurType.TWO_PASS_BOX);
        this.d57 = new Region();
        this.d57.getStyleClass().add((Object)"dot-off");
        this.d57.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D57, this.d57);
        this.d47 = new Region();
        this.d47.getStyleClass().add((Object)"dot-off");
        this.d47.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D47, this.d47);
        this.d37 = new Region();
        this.d37.getStyleClass().add((Object)"dot-off");
        this.d37.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D37, this.d37);
        this.d27 = new Region();
        this.d27.getStyleClass().add((Object)"dot-off");
        this.d27.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D27, this.d27);
        this.d17 = new Region();
        this.d17.getStyleClass().add((Object)"dot-off");
        this.d17.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D17, this.d17);
        this.d56 = new Region();
        this.d56.getStyleClass().add((Object)"dot-off");
        this.d56.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D56, this.d56);
        this.d46 = new Region();
        this.d46.getStyleClass().add((Object)"dot-off");
        this.d46.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D46, this.d46);
        this.d36 = new Region();
        this.d36.getStyleClass().add((Object)"dot-off");
        this.d36.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D36, this.d36);
        this.d26 = new Region();
        this.d26.getStyleClass().add((Object)"dot-off");
        this.d26.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D26, this.d26);
        this.d16 = new Region();
        this.d16.getStyleClass().add((Object)"dot-off");
        this.d16.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D16, this.d16);
        this.d55 = new Region();
        this.d55.getStyleClass().add((Object)"dot-off");
        this.d55.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D55, this.d55);
        this.d45 = new Region();
        this.d45.getStyleClass().add((Object)"dot-off");
        this.d45.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D45, this.d45);
        this.d35 = new Region();
        this.d35.getStyleClass().add((Object)"dot-off");
        this.d35.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D35, this.d35);
        this.d25 = new Region();
        this.d25.getStyleClass().add((Object)"dot-off");
        this.d25.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D25, this.d25);
        this.d15 = new Region();
        this.d15.getStyleClass().add((Object)"dot-off");
        this.d15.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D15, this.d15);
        this.d54 = new Region();
        this.d54.getStyleClass().add((Object)"dot-off");
        this.d54.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D54, this.d54);
        this.d44 = new Region();
        this.d44.getStyleClass().add((Object)"dot-off");
        this.d44.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D44, this.d44);
        this.d34 = new Region();
        this.d34.getStyleClass().add((Object)"dot-off");
        this.d34.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D34, this.d34);
        this.d24 = new Region();
        this.d24.getStyleClass().add((Object)"dot-off");
        this.d24.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D24, this.d24);
        this.d14 = new Region();
        this.d14.getStyleClass().add((Object)"dot-off");
        this.d14.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D14, this.d14);
        this.d53 = new Region();
        this.d53.getStyleClass().add((Object)"dot-off");
        this.d53.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D53, this.d53);
        this.d43 = new Region();
        this.d43.getStyleClass().add((Object)"dot-off");
        this.d43.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D43, this.d43);
        this.d33 = new Region();
        this.d33.getStyleClass().add((Object)"dot-off");
        this.d33.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D33, this.d33);
        this.d23 = new Region();
        this.d23.getStyleClass().add((Object)"dot-off");
        this.d23.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D23, this.d23);
        this.d13 = new Region();
        this.d13.getStyleClass().add((Object)"dot-off");
        this.d13.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D13, this.d13);
        this.d52 = new Region();
        this.d52.getStyleClass().add((Object)"dot-off");
        this.d52.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D52, this.d52);
        this.d42 = new Region();
        this.d42.getStyleClass().add((Object)"dot-off");
        this.d42.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D42, this.d42);
        this.d32 = new Region();
        this.d32.getStyleClass().add((Object)"dot-off");
        this.d32.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D32, this.d32);
        this.d22 = new Region();
        this.d22.getStyleClass().add((Object)"dot-off");
        this.d22.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D22, this.d22);
        this.d12 = new Region();
        this.d12.getStyleClass().add((Object)"dot-off");
        this.d12.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D12, this.d12);
        this.d51 = new Region();
        this.d51.getStyleClass().add((Object)"dot-off");
        this.d51.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D51, this.d51);
        this.d41 = new Region();
        this.d41.getStyleClass().add((Object)"dot-off");
        this.d41.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D41, this.d41);
        this.d31 = new Region();
        this.d31.getStyleClass().add((Object)"dot-off");
        this.d31.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D31, this.d31);
        this.d21 = new Region();
        this.d21.getStyleClass().add((Object)"dot-off");
        this.d21.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D21, this.d21);
        this.d11 = new Region();
        this.d11.getStyleClass().add((Object)"dot-off");
        this.d11.setEffect((Effect)this.dotInnerShadow);
        this.dotMap.put(MatrixSegment.Dot.D11, this.d11);
        this.d57h = new Region();
        this.d57h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d57h);
        this.d47h = new Region();
        this.d47h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d47h);
        this.d37h = new Region();
        this.d37h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d37h);
        this.d27h = new Region();
        this.d27h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d27h);
        this.d17h = new Region();
        this.d17h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d17h);
        this.d56h = new Region();
        this.d56h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d56h);
        this.d46h = new Region();
        this.d46h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d46h);
        this.d36h = new Region();
        this.d36h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d36h);
        this.d26h = new Region();
        this.d26h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d26h);
        this.d16h = new Region();
        this.d16h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d16h);
        this.d55h = new Region();
        this.d55h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d55h);
        this.d45h = new Region();
        this.d45h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d45h);
        this.d35h = new Region();
        this.d35h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d35h);
        this.d25h = new Region();
        this.d25h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d25h);
        this.d15h = new Region();
        this.d15h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d15h);
        this.d54h = new Region();
        this.d54h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d54h);
        this.d44h = new Region();
        this.d44h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d44h);
        this.d34h = new Region();
        this.d34h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d34h);
        this.d24h = new Region();
        this.d24h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d24h);
        this.d14h = new Region();
        this.d14h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d14h);
        this.d53h = new Region();
        this.d53h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d53h);
        this.d43h = new Region();
        this.d43h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d43h);
        this.d33h = new Region();
        this.d33h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d33h);
        this.d23h = new Region();
        this.d23h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d23h);
        this.d13h = new Region();
        this.d13h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d13h);
        this.d52h = new Region();
        this.d52h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d52h);
        this.d42h = new Region();
        this.d42h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d42h);
        this.d32h = new Region();
        this.d32h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d32h);
        this.d22h = new Region();
        this.d22h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d22h);
        this.d12h = new Region();
        this.d12h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d12h);
        this.d51h = new Region();
        this.d51h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d51h);
        this.d41h = new Region();
        this.d41h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d41h);
        this.d31h = new Region();
        this.d31h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d31h);
        this.d21h = new Region();
        this.d21h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d21h);
        this.d11h = new Region();
        this.d11h.getStyleClass().add((Object)"dot-highlight");
        this.highlights.add(this.d11h);
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.d57, this.d47, this.d37, this.d27, this.d17, this.d56, this.d46, this.d36, this.d26, this.d16, this.d55, this.d45, this.d35, this.d25, this.d15, this.d54, this.d44, this.d34, this.d24, this.d14, this.d53, this.d43, this.d33, this.d23, this.d13, this.d52, this.d42, this.d32, this.d22, this.d12, this.d51, this.d41, this.d31, this.d21, this.d11, this.d57h, this.d47h, this.d37h, this.d27h, this.d17h, this.d56h, this.d46h, this.d36h, this.d26h, this.d16h, this.d55h, this.d45h, this.d35h, this.d25h, this.d15h, this.d54h, this.d44h, this.d34h, this.d24h, this.d14h, this.d53h, this.d43h, this.d33h, this.d23h, this.d13h, this.d52h, this.d42h, this.d32h, this.d22h, this.d12h, this.d51h, this.d41h, this.d31h, this.d21h, this.d11h});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
        this.updateMatrix();
        this.updateMatrixColor();
        for (Region highlight : this.highlights) {
            highlight.setOpacity(((MatrixSegment)this.getSkinnable()).isHighlightsVisible() ? 1.0 : 0.0);
        }
    }

    private void registerListeners() {
        ((MatrixSegment)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((MatrixSegment)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((MatrixSegment)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((MatrixSegment)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((MatrixSegment)this.getSkinnable()).colorProperty().addListener(observable -> this.handleControlPropertyChanged("COLOR"));
        ((MatrixSegment)this.getSkinnable()).backgroundVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("BACKGROUND"));
        ((MatrixSegment)this.getSkinnable()).highlightsVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("HIGHLIGHTS"));
        ((MatrixSegment)this.getSkinnable()).characterProperty().addListener(observable -> this.handleControlPropertyChanged("CHARACTER"));
        ((MatrixSegment)this.getSkinnable()).glowEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("GLOW"));
        ((MatrixSegment)this.getSkinnable()).getStyleClass().addListener(change -> this.resize());
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            aspectRatio = ((MatrixSegment)this.getSkinnable()).getPrefHeight() / ((MatrixSegment)this.getSkinnable()).getPrefWidth();
        } else if ("COLOR".equals(PROPERTY)) {
            this.updateMatrixColor();
        } else if ("BACKGROUND".equals(PROPERTY)) {
            this.background.setOpacity(((MatrixSegment)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
        } else if ("HIGHLIGHTS".equals(PROPERTY)) {
            for (Region highlight : this.highlights) {
                highlight.setOpacity(((MatrixSegment)this.getSkinnable()).isHighlightsVisible() ? 1.0 : 0.0);
            }
        } else if ("CHARACTER".equals(PROPERTY)) {
            this.updateMatrix();
        } else if ("GLOW".equals(PROPERTY)) {
            this.updateMatrix();
        }
    }

    public void updateMatrixColor() {
        ((MatrixSegment)this.getSkinnable()).setStyle("-dot-on-color: " + MatrixSegmentSkin.colorToCss(((MatrixSegment)this.getSkinnable()).getColor()) + ";");
        this.glow.setColor(((MatrixSegment)this.getSkinnable()).getColor());
    }

    public void updateMatrix() {
        int ASCII;
        int n = ASCII = ((MatrixSegment)this.getSkinnable()).getCharacter().isEmpty() ? 20 : (int)((MatrixSegment)this.getSkinnable()).getCharacter().toUpperCase().charAt(0);
        if (((MatrixSegment)this.getSkinnable()).getCustomDotMapping().isEmpty()) {
            for (MatrixSegment.Dot dot : this.dotMap.keySet()) {
                if (((MatrixSegment)this.getSkinnable()).getDotMapping().containsKey(ASCII)) {
                    if (((MatrixSegment)this.getSkinnable()).getDotMapping().get(ASCII).contains((Object)dot)) {
                        this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"dot-on"});
                        this.dotMap.get((Object)dot).setEffect((Effect)(((MatrixSegment)this.getSkinnable()).isGlowEnabled() ? this.glow : this.dotInnerShadow));
                        continue;
                    }
                    this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"dot-off"});
                    this.dotMap.get((Object)dot).setEffect((Effect)this.dotInnerShadow);
                    continue;
                }
                this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"dot-off"});
                this.dotMap.get((Object)dot).setEffect((Effect)this.dotInnerShadow);
            }
        } else {
            for (MatrixSegment.Dot dot : this.dotMap.keySet()) {
                if (((MatrixSegment)this.getSkinnable()).getCustomDotMapping().containsKey(ASCII)) {
                    if (((MatrixSegment)this.getSkinnable()).getCustomDotMapping().get(ASCII).contains((Object)dot)) {
                        this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"dot-on"});
                        this.dotMap.get((Object)dot).setEffect((Effect)(((MatrixSegment)this.getSkinnable()).isGlowEnabled() ? this.glow : this.dotInnerShadow));
                        continue;
                    }
                    this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"dot-off"});
                    this.dotMap.get((Object)dot).setEffect((Effect)this.dotInnerShadow);
                    continue;
                }
                this.dotMap.get((Object)dot).getStyleClass().setAll((Object[])new String[]{"dot-off"});
                this.dotMap.get((Object)dot).setEffect((Effect)this.dotInnerShadow);
            }
        }
    }

    private static String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void resize() {
        this.width = ((MatrixSegment)this.getSkinnable()).getWidth();
        this.height = ((MatrixSegment)this.getSkinnable()).getHeight();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (aspectRatio * this.width > this.height) {
            this.width = 1.0 / (aspectRatio / this.height);
        } else if (1.0 / (aspectRatio / this.height) > this.width) {
            this.height = aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.background.setPrefSize(this.width, this.height);
            this.backgroundInnerShadow.setRadius(0.0025 * this.size);
            this.backgroundInnerHighlight.setRadius(0.0025 * this.size);
            this.dotInnerShadow.setRadius(0.025 * this.width);
            this.glow.setRadius(0.032 * this.width);
            double dotWidth = 0.13548387096774195 * this.width;
            double dotHeight = 0.0967741935483871 * this.height;
            for (Region dot : this.dotMap.values()) {
                dot.setPrefSize(dotWidth, dotHeight);
            }
            this.d57.setTranslateX(0.832258064516129 * this.width);
            this.d57.setTranslateY(0.880184331797235 * this.height);
            this.d47.setTranslateX(0.632258064516129 * this.width);
            this.d47.setTranslateY(0.880184331797235 * this.height);
            this.d37.setTranslateX(0.432258064516129 * this.width);
            this.d37.setTranslateY(0.880184331797235 * this.height);
            this.d27.setTranslateX(0.23225806451612904 * this.width);
            this.d27.setTranslateY(0.880184331797235 * this.height);
            this.d17.setTranslateX(0.03225806451612903 * this.width);
            this.d17.setTranslateY(0.880184331797235 * this.height);
            this.d56.setTranslateX(0.832258064516129 * this.width);
            this.d56.setTranslateY(0.7373271889400922 * this.height);
            this.d46.setTranslateX(0.632258064516129 * this.width);
            this.d46.setTranslateY(0.7373271889400922 * this.height);
            this.d36.setTranslateX(0.432258064516129 * this.width);
            this.d36.setTranslateY(0.7373271889400922 * this.height);
            this.d26.setTranslateX(0.23225806451612904 * this.width);
            this.d26.setTranslateY(0.7373271889400922 * this.height);
            this.d16.setTranslateX(0.03225806451612903 * this.width);
            this.d16.setTranslateY(0.7373271889400922 * this.height);
            this.d55.setTranslateX(0.832258064516129 * this.width);
            this.d55.setTranslateY(0.5944700460829493 * this.height);
            this.d45.setTranslateX(0.632258064516129 * this.width);
            this.d45.setTranslateY(0.5944700460829493 * this.height);
            this.d35.setTranslateX(0.432258064516129 * this.width);
            this.d35.setTranslateY(0.5944700460829493 * this.height);
            this.d25.setTranslateX(0.23225806451612904 * this.width);
            this.d25.setTranslateY(0.5944700460829493 * this.height);
            this.d15.setTranslateX(0.03225806451612903 * this.width);
            this.d15.setTranslateY(0.5944700460829493 * this.height);
            this.d54.setTranslateX(0.832258064516129 * this.width);
            this.d54.setTranslateY(0.45161290322580644 * this.height);
            this.d44.setTranslateX(0.632258064516129 * this.width);
            this.d44.setTranslateY(0.45161290322580644 * this.height);
            this.d34.setTranslateX(0.432258064516129 * this.width);
            this.d34.setTranslateY(0.45161290322580644 * this.height);
            this.d24.setTranslateX(0.23225806451612904 * this.width);
            this.d24.setTranslateY(0.45161290322580644 * this.height);
            this.d14.setTranslateX(0.03225806451612903 * this.width);
            this.d14.setTranslateY(0.45161290322580644 * this.height);
            this.d53.setTranslateX(0.832258064516129 * this.width);
            this.d53.setTranslateY(0.3087557603686636 * this.height);
            this.d43.setTranslateX(0.632258064516129 * this.width);
            this.d43.setTranslateY(0.3087557603686636 * this.height);
            this.d33.setTranslateX(0.432258064516129 * this.width);
            this.d33.setTranslateY(0.3087557603686636 * this.height);
            this.d23.setTranslateX(0.23225806451612904 * this.width);
            this.d23.setTranslateY(0.3087557603686636 * this.height);
            this.d13.setTranslateX(0.03225806451612903 * this.width);
            this.d13.setTranslateY(0.3087557603686636 * this.height);
            this.d52.setTranslateX(0.832258064516129 * this.width);
            this.d52.setTranslateY(0.16589861751152074 * this.height);
            this.d42.setTranslateX(0.632258064516129 * this.width);
            this.d42.setTranslateY(0.16589861751152074 * this.height);
            this.d32.setTranslateX(0.432258064516129 * this.width);
            this.d32.setTranslateY(0.16589861751152074 * this.height);
            this.d22.setTranslateX(0.23225806451612904 * this.width);
            this.d22.setTranslateY(0.16589861751152074 * this.height);
            this.d12.setTranslateX(0.03225806451612903 * this.width);
            this.d12.setTranslateY(0.16589861751152074 * this.height);
            this.d51.setTranslateX(0.832258064516129 * this.width);
            this.d51.setTranslateY(0.02304147465437788 * this.height);
            this.d41.setTranslateX(0.632258064516129 * this.width);
            this.d41.setTranslateY(0.02304147465437788 * this.height);
            this.d31.setTranslateX(0.432258064516129 * this.width);
            this.d31.setTranslateY(0.02304147465437788 * this.height);
            this.d21.setTranslateX(0.23225806451612904 * this.width);
            this.d21.setTranslateY(0.02304147465437788 * this.height);
            this.d11.setTranslateX(0.03225806451612903 * this.width);
            this.d11.setTranslateY(0.02304147465437788 * this.height);
            double highlightWidth = 0.07741935483870968 * this.width;
            double highlightHeight = 0.03456221198156682 * this.height;
            for (Region highlight : this.highlights) {
                highlight.setPrefSize(highlightWidth, highlightHeight);
            }
            this.d57h.setTranslateX(0.8612903225806452 * this.width);
            this.d57h.setTranslateY(0.8894009216589862 * this.height);
            this.d47h.setTranslateX(0.6612903225806451 * this.width);
            this.d47h.setTranslateY(0.8894009216589862 * this.height);
            this.d37h.setTranslateX(0.4612903225806452 * this.width);
            this.d37h.setTranslateY(0.8894009216589862 * this.height);
            this.d27h.setTranslateX(0.26129032258064516 * this.width);
            this.d27h.setTranslateY(0.8894009216589862 * this.height);
            this.d17h.setTranslateX(0.06129032258064516 * this.width);
            this.d17h.setTranslateY(0.8894009216589862 * this.height);
            this.d56h.setTranslateX(0.8612903225806452 * this.width);
            this.d56h.setTranslateY(0.7465437788018433 * this.height);
            this.d46h.setTranslateX(0.6612903225806451 * this.width);
            this.d46h.setTranslateY(0.7465437788018433 * this.height);
            this.d36h.setTranslateX(0.4612903225806452 * this.width);
            this.d36h.setTranslateY(0.7465437788018433 * this.height);
            this.d26h.setTranslateX(0.26129032258064516 * this.width);
            this.d26h.setTranslateY(0.7465437788018433 * this.height);
            this.d16h.setTranslateX(0.06129032258064516 * this.width);
            this.d16h.setTranslateY(0.7465437788018433 * this.height);
            this.d55h.setTranslateX(0.8612903225806452 * this.width);
            this.d55h.setTranslateY(0.6036866359447005 * this.height);
            this.d45h.setTranslateX(0.6612903225806451 * this.width);
            this.d45h.setTranslateY(0.6036866359447005 * this.height);
            this.d35h.setTranslateX(0.4612903225806452 * this.width);
            this.d35h.setTranslateY(0.6036866359447005 * this.height);
            this.d25h.setTranslateX(0.26129032258064516 * this.width);
            this.d25h.setTranslateY(0.6036866359447005 * this.height);
            this.d15h.setTranslateX(0.06129032258064516 * this.width);
            this.d15h.setTranslateY(0.6036866359447005 * this.height);
            this.d54h.setTranslateX(0.8612903225806452 * this.width);
            this.d54h.setTranslateY(0.4608294930875576 * this.height);
            this.d44h.setTranslateX(0.6612903225806451 * this.width);
            this.d44h.setTranslateY(0.4608294930875576 * this.height);
            this.d34h.setTranslateX(0.4612903225806452 * this.width);
            this.d34h.setTranslateY(0.4608294930875576 * this.height);
            this.d24h.setTranslateX(0.26129032258064516 * this.width);
            this.d24h.setTranslateY(0.4608294930875576 * this.height);
            this.d14h.setTranslateX(0.06129032258064516 * this.width);
            this.d14h.setTranslateY(0.4608294930875576 * this.height);
            this.d53h.setTranslateX(0.8612903225806452 * this.width);
            this.d53h.setTranslateY(0.31797235023041476 * this.height);
            this.d43h.setTranslateX(0.6612903225806451 * this.width);
            this.d43h.setTranslateY(0.31797235023041476 * this.height);
            this.d33h.setTranslateX(0.4612903225806452 * this.width);
            this.d33h.setTranslateY(0.31797235023041476 * this.height);
            this.d23h.setTranslateX(0.26129032258064516 * this.width);
            this.d23h.setTranslateY(0.31797235023041476 * this.height);
            this.d13h.setTranslateX(0.06129032258064516 * this.width);
            this.d13h.setTranslateY(0.31797235023041476 * this.height);
            this.d52h.setTranslateX(0.8612903225806452 * this.width);
            this.d52h.setTranslateY(0.17511520737327188 * this.height);
            this.d42h.setTranslateX(0.6612903225806451 * this.width);
            this.d42h.setTranslateY(0.17511520737327188 * this.height);
            this.d32h.setTranslateX(0.4612903225806452 * this.width);
            this.d32h.setTranslateY(0.17511520737327188 * this.height);
            this.d22h.setTranslateX(0.26129032258064516 * this.width);
            this.d22h.setTranslateY(0.17511520737327188 * this.height);
            this.d12h.setTranslateX(0.06129032258064516 * this.width);
            this.d12h.setTranslateY(0.17511520737327188 * this.height);
            this.d51h.setTranslateX(0.8612903225806452 * this.width);
            this.d51h.setTranslateY(0.03225806451612903 * this.height);
            this.d41h.setTranslateX(0.6612903225806451 * this.width);
            this.d41h.setTranslateY(0.03225806451612903 * this.height);
            this.d31h.setTranslateX(0.4612903225806452 * this.width);
            this.d31h.setTranslateY(0.03225806451612903 * this.height);
            this.d21h.setTranslateX(0.26129032258064516 * this.width);
            this.d21h.setTranslateY(0.03225806451612903 * this.height);
            this.d11h.setTranslateX(0.06129032258064516 * this.width);
            this.d11h.setTranslateY(0.03225806451612903 * this.height);
        }
    }
}

