/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class ParameterizedTypeBinding
extends ReferenceBinding
implements Substitution {
    protected ReferenceBinding type;
    public TypeBinding[] arguments;
    public LookupEnvironment environment;
    public char[] genericTypeSignature;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public FieldBinding[] fields;
    public ReferenceBinding[] memberTypes;
    public MethodBinding[] methods;
    protected ReferenceBinding enclosingType;

    public ParameterizedTypeBinding(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.enclosingType = referenceBinding2;
        if (!referenceBinding.hasEnclosingInstanceContext() && typeBindingArray == null && !(this instanceof RawTypeBinding)) {
            throw new IllegalStateException();
        }
        this.initialize(referenceBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
        }
        if (typeBindingArray != null) {
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (typeBindingArray[i] instanceof UnresolvedReferenceBinding) {
                    ((UnresolvedReferenceBinding)typeBindingArray[i]).addWrapper(this, lookupEnvironment);
                }
                if (!typeBindingArray[i].hasNullTypeAnnotations()) continue;
                this.tagBits |= 0x100000L;
            }
        }
        if (referenceBinding2 != null && referenceBinding2.hasNullTypeAnnotations()) {
            this.tagBits |= 0x100000L;
        }
        this.tagBits |= 0x1000000L;
        this.typeBits = referenceBinding.typeBits;
    }

    @Override
    public ReferenceBinding actualType() {
        return this.type;
    }

    @Override
    public boolean isParameterizedType() {
        return true;
    }

    public void boundCheck(Scope scope, TypeReference[] typeReferenceArray) {
        if ((this.tagBits & 0x400000L) == 0L) {
            boolean bl = false;
            TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
            if (this.arguments != null && typeVariableBindingArray != null) {
                int n = typeVariableBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    TypeConstants.BoundCheckStatus boundCheckStatus = typeVariableBindingArray[i].boundCheck(this, this.arguments[i], scope, typeReferenceArray[i]);
                    bl |= boundCheckStatus != TypeConstants.BoundCheckStatus.OK;
                    if (boundCheckStatus.isOKbyJLS() || (this.arguments[i].tagBits & 0x80L) != 0L) continue;
                    scope.problemReporter().typeMismatchError(this.arguments[i], typeVariableBindingArray[i], this.type, (ASTNode)typeReferenceArray[i]);
                }
            }
            if (!bl) {
                this.tagBits |= 0x400000L;
            }
        }
    }

    @Override
    public boolean canBeInstantiated() {
        return (this.tagBits & 0x40000000L) == 0L && super.canBeInstantiated();
    }

    @Override
    public ParameterizedTypeBinding capture(Scope scope, int n, int n2) {
        TypeBinding typeBinding;
        if ((this.tagBits & 0x40000000L) == 0L) {
            return this;
        }
        TypeBinding[] typeBindingArray = this.arguments;
        int n3 = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n3];
        ReferenceBinding referenceBinding = scope.enclosingSourceType();
        if (referenceBinding != null) {
            referenceBinding = referenceBinding.outermostEnclosingType();
        }
        CompilationUnitScope compilationUnitScope = scope.compilationUnitScope();
        CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitScope.referenceContext;
        long l = this.environment.globalOptions.sourceLevel;
        boolean bl = l >= 0x340000L;
        for (int i = 0; i < n3; ++i) {
            TypeBinding typeBinding2 = typeBindingArray[i];
            if (typeBinding2.kind() == 516) {
                typeBinding = (WildcardBinding)typeBinding2;
                if (((WildcardBinding)typeBinding).boundKind == 2 && ((WildcardBinding)typeBinding).bound.id == 1) {
                    typeBindingArray2[i] = ((WildcardBinding)typeBinding).bound;
                    continue;
                }
                if (bl) {
                    typeBindingArray2[i] = this.environment.createCapturedWildcard((WildcardBinding)typeBinding, referenceBinding, n, n2, compilationUnitDeclaration, compilationUnitScope.nextCaptureID());
                    continue;
                }
                typeBindingArray2[i] = new CaptureBinding((WildcardBinding)typeBinding, referenceBinding, n, n2, compilationUnitDeclaration, compilationUnitScope.nextCaptureID());
                continue;
            }
            typeBindingArray2[i] = typeBinding2;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment.createParameterizedType(this.type, typeBindingArray2, this.enclosingType(), this.typeAnnotations);
        for (int i = 0; i < n3; ++i) {
            typeBinding = typeBindingArray2[i];
            if (!typeBinding.isCapture()) continue;
            ((CaptureBinding)typeBinding).initializeBounds(scope, parameterizedTypeBinding);
        }
        return parameterizedTypeBinding;
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        if ((this.tagBits & 0x2000000000000000L) == 0L) {
            return this;
        }
        int n = this.arguments == null ? 0 : this.arguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            typeBindingArray[i] = this.arguments[i].uncapture(scope);
        }
        return scope.environment().createParameterizedType(this.type, typeBindingArray, (ReferenceBinding)(this.enclosingType != null ? this.enclosingType.uncapture(scope) : null), this.typeAnnotations);
    }

    @Override
    public List<TypeBinding> collectMissingTypes(List<TypeBinding> list) {
        if ((this.tagBits & 0x80L) != 0L) {
            if (this.enclosingType != null) {
                list = this.enclosingType.collectMissingTypes(list);
            }
            list = this.genericType().collectMissingTypes(list);
            if (this.arguments != null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    list = this.arguments[i].collectMissingTypes(list);
                }
            }
        }
        return list;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        TypeBinding[] typeBindingArray;
        TypeBinding[] typeBindingArray2;
        ReferenceBinding referenceBinding;
        TypeBinding typeBinding2;
        TypeBinding typeBinding3;
        if ((this.tagBits & 0x20000000L) == 0L) {
            TypeBinding typeBinding4 = typeBinding.findSuperTypeOriginatingFrom(this.type);
            if (typeBinding4 != null && typeBinding4.isRawType()) {
                inferenceContext.isUnchecked = true;
            }
            return;
        }
        if (typeBinding == TypeBinding.NULL || typeBinding.kind() == 65540) {
            return;
        }
        if (!(typeBinding instanceof ReferenceBinding)) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                typeBinding3 = this;
                typeBinding2 = typeBinding.findSuperTypeOriginatingFrom(this.type);
                if (typeBinding2 != null) break;
                return;
            }
            default: {
                typeBinding3 = this.findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding3 == null) {
                    return;
                }
                typeBinding2 = typeBinding;
            }
        }
        if ((referenceBinding = typeBinding3.enclosingType()) != null) {
            referenceBinding.collectSubstitutes(scope, typeBinding2.enclosingType(), inferenceContext, n);
        }
        if (this.arguments == null) {
            return;
        }
        switch (typeBinding3.kind()) {
            case 2052: {
                typeBindingArray2 = typeBinding3.typeVariables();
                break;
            }
            case 260: {
                typeBindingArray2 = ((ParameterizedTypeBinding)typeBinding3).arguments;
                break;
            }
            case 1028: {
                if (inferenceContext.depth > 0) {
                    inferenceContext.status = 1;
                }
                return;
            }
            default: {
                return;
            }
        }
        switch (typeBinding2.kind()) {
            case 2052: {
                typeBindingArray = typeBinding2.typeVariables();
                break;
            }
            case 260: {
                typeBindingArray = ((ParameterizedTypeBinding)typeBinding2).arguments;
                break;
            }
            case 1028: {
                if (inferenceContext.depth > 0) {
                    inferenceContext.status = 1;
                } else {
                    inferenceContext.isUnchecked = true;
                }
                return;
            }
            default: {
                return;
            }
        }
        ++inferenceContext.depth;
        int n2 = typeBindingArray2.length;
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding5 = typeBindingArray2[i];
            TypeBinding typeBinding6 = typeBindingArray[i];
            if (typeBinding5.isWildcard()) {
                typeBinding5.collectSubstitutes(scope, typeBinding6, inferenceContext, n);
                continue;
            }
            if (typeBinding6.isWildcard()) {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding6;
                if (wildcardBinding.otherBounds == null) {
                    if (n != 2) continue;
                    switch (wildcardBinding.boundKind) {
                        case 1: {
                            typeBinding5.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                            break;
                        }
                        case 2: {
                            typeBinding5.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 1);
                            break;
                        }
                    }
                    continue;
                }
            }
            typeBinding5.collectSubstitutes(scope, typeBinding6, inferenceContext, 0);
        }
        --inferenceContext.depth;
    }

    @Override
    public void computeId() {
        this.id = Integer.MAX_VALUE;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        Object object;
        ReferenceBinding referenceBinding;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && ((referenceBinding = this.enclosingType()).isParameterizedType() || referenceBinding.isRawType())) {
            object = referenceBinding.computeUniqueKey(false);
            stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
            stringBuffer.append('.').append(this.sourceName());
        } else if (this.type.isLocalType()) {
            ReferenceBinding referenceBinding2;
            object = (LocalTypeBinding)this.type;
            referenceBinding = ((NestedTypeBinding)object).enclosingType();
            while ((referenceBinding2 = referenceBinding.enclosingType()) != null) {
                referenceBinding = referenceBinding2;
            }
            cArray = referenceBinding.computeUniqueKey(false);
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('$');
            stringBuffer.append(((LocalTypeBinding)object).sourceStart);
        } else {
            object = this.type.computeUniqueKey(false);
            stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
        }
        object = null;
        if (this.arguments != null) {
            stringBuffer.append('<');
            for (TypeBinding typeBinding : this.arguments) {
                stringBuffer.append(typeBinding.computeUniqueKey(false));
                if (!(typeBinding instanceof CaptureBinding)) continue;
                object = ((CaptureBinding)typeBinding).sourceType;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(';');
        if (object != null && TypeBinding.notEquals((TypeBinding)object, this.type)) {
            stringBuffer.insert(0, "&");
            stringBuffer.insert(0, ((ReferenceBinding)object).computeUniqueKey(false));
        }
        int n = stringBuffer.length();
        cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] constantPoolName() {
        return this.type.constantPoolName();
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new ParameterizedTypeBinding(this.type, this.arguments, (ReferenceBinding)typeBinding, this.environment);
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        return new ParameterizedMethodBinding(this, methodBinding);
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.type instanceof UnresolvedReferenceBinding) {
            stringBuffer.append(this.type);
        } else {
            stringBuffer.append(this.type.sourceName());
        }
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[i].debugName());
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    @Override
    public String annotatedDebugName() {
        StringBuffer stringBuffer = new StringBuffer(super.annotatedDebugName());
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[i].annotatedDebugName());
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    @Override
    public ReferenceBinding enclosingType() {
        if (this.type instanceof UnresolvedReferenceBinding && ((UnresolvedReferenceBinding)this.type).depth() > 0) {
            ((UnresolvedReferenceBinding)this.type).resolve(this.environment, false);
        }
        return this.enclosingType;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public TypeBinding erasure() {
        return this.type.erasure();
    }

    @Override
    public ReferenceBinding upwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        TypeBinding[] typeBindingArray2 = this.arguments;
        if (typeBindingArray2 == null) {
            return this;
        }
        TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray2.length];
        int n = typeBindingArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            TypeBinding typeBinding;
            TypeBinding typeBinding2 = typeBindingArray2[i];
            int n2 = typeBinding2.kind();
            if (!typeBinding2.mentionsAny(typeBindingArray, -1)) {
                typeBindingArray3[i] = typeBinding2;
                continue;
            }
            if (n2 != 516) {
                typeBinding = typeBinding2.upwardsProjection(scope, typeBindingArray);
                object = this.type.typeVariables();
                if (object == null || ((TypeVariableBinding[])object).length == 0) {
                    return this;
                }
                TypeBinding typeBinding3 = object[i].upperBound();
                if (typeBinding.id != 1 && (typeBinding3.mentionsAny(typeBindingArray2, -1) || !typeBinding3.isSubtypeOf(typeBinding, false))) {
                    typeBindingArray3[i] = this.environment().createWildcard(this.genericType(), i, typeBinding, null, 1);
                    continue;
                }
                TypeBinding typeBinding4 = typeBinding2.downwardsProjection(scope, typeBindingArray);
                if (typeBinding4 != null) {
                    typeBindingArray3[i] = this.environment().createWildcard(this.genericType(), i, typeBinding4, null, 2);
                    continue;
                }
                typeBindingArray3[i] = this.environment().createWildcard(this.genericType(), i, null, null, 0);
                continue;
            }
            typeBinding = (WildcardBinding)typeBinding2;
            if (((WildcardBinding)typeBinding).boundKind() == 1) {
                object = ((WildcardBinding)typeBinding).bound().upwardsProjection(scope, typeBindingArray);
                typeBindingArray3[i] = this.environment().createWildcard(null, 0, (TypeBinding)object, null, 1);
                continue;
            }
            if (((WildcardBinding)typeBinding).boundKind() != 2) continue;
            object = ((WildcardBinding)typeBinding).bound().downwardsProjection(scope, typeBindingArray);
            typeBindingArray3[i] = object != null ? this.environment().createWildcard(null, 0, (TypeBinding)object, null, 2) : this.environment().createWildcard(null, 0, null, null, 0);
        }
        return this.environment.createParameterizedType(this.type, typeBindingArray3, this.enclosingType);
    }

    @Override
    public ReferenceBinding downwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        TypeBinding[] typeBindingArray2 = this.arguments;
        if (typeBindingArray2 == null) {
            return this;
        }
        TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray2.length];
        for (TypeBinding typeBinding : typeBindingArray2) {
            TypeBinding typeBinding2;
            int n = typeBinding.kind();
            if (!typeBinding.mentionsAny(typeBindingArray, -1)) {
                typeBindingArray3[var5_5] = typeBinding;
                continue;
            }
            if (n != 516) {
                return null;
            }
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            if (wildcardBinding.boundKind() == 1) {
                typeBinding2 = wildcardBinding.bound().downwardsProjection(scope, typeBindingArray);
                if (typeBinding2 != null) {
                    typeBindingArray3[var5_5] = this.environment().createWildcard(null, 0, typeBinding2, null, 1);
                    continue;
                }
                return null;
            }
            if (wildcardBinding.boundKind() == 2) {
                typeBinding2 = wildcardBinding.bound().upwardsProjection(scope, typeBindingArray);
                typeBindingArray3[var5_5] = this.environment().createWildcard(null, 0, typeBinding2, null, 2);
                continue;
            }
            return null;
        }
        return this.environment.createParameterizedType(this.type, typeBindingArray3, this.enclosingType);
    }

    @Override
    public int fieldCount() {
        return this.type.fieldCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldBinding[] fields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        try {
            FieldBinding[] fieldBindingArray = this.type.fields();
            int n = fieldBindingArray.length;
            FieldBinding[] fieldBindingArray2 = new FieldBinding[n];
            for (int i = 0; i < n; ++i) {
                fieldBindingArray2[i] = new ParameterizedFieldBinding(this, fieldBindingArray[i]);
            }
            this.fields = fieldBindingArray2;
        }
        finally {
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            this.tagBits |= 0x2000L;
        }
        return this.fields;
    }

    public ReferenceBinding genericType() {
        if (this.type instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)this.type).resolve(this.environment, false);
        }
        return this.type;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            if ((this.modifiers & 0x40000000) == 0) {
                this.genericTypeSignature = this.type.signature();
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(10);
                if (this.isMemberType() && !this.isStatic()) {
                    object = this.enclosingType();
                    char[] cArray = ((TypeBinding)object).genericTypeSignature();
                    stringBuffer.append(cArray, 0, cArray.length - 1);
                    if ((((ReferenceBinding)object).modifiers & 0x40000000) != 0) {
                        stringBuffer.append('.');
                    } else {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(this.sourceName());
                } else {
                    object = this.type.signature();
                    stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
                }
                if (this.arguments != null) {
                    stringBuffer.append('<');
                    int n = this.arguments.length;
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(this.arguments[i].genericTypeSignature());
                    }
                    stringBuffer.append('>');
                }
                stringBuffer.append(';');
                int n = stringBuffer.length();
                this.genericTypeSignature = new char[n];
                stringBuffer.getChars(0, n, this.genericTypeSignature, 0);
            }
        }
        return this.genericTypeSignature;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this.type.getAnnotations();
    }

    @Override
    public long getAnnotationTagBits() {
        return this.type.getAnnotationTagBits();
    }

    @Override
    public int getEnclosingInstancesSlotSize() {
        return this.genericType().getEnclosingInstancesSlotSize();
    }

    @Override
    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        MethodBinding methodBinding;
        block7: {
            int n;
            block6: {
                n = typeBindingArray.length;
                methodBinding = null;
                if ((this.tagBits & 0x8000L) == 0L) break block6;
                long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
                if (l < 0L) break block7;
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding2 = this.methods[i];
                    if (methodBinding2.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (TypeBinding.notEquals(typeBindingArray2[j], typeBindingArray[j])) continue block0;
                    }
                    if (methodBinding != null) {
                        return null;
                    }
                    methodBinding = methodBinding2;
                }
                break block7;
            }
            MethodBinding[] methodBindingArray = this.getMethods(TypeConstants.INIT);
            int n3 = methodBindingArray.length;
            block2: while (--n3 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n3];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    if (TypeBinding.notEquals(typeBindingArray3[i], typeBindingArray[i])) continue block2;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        return methodBinding;
    }

    @Override
    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n = typeBindingArray.length;
        boolean bl = true;
        MethodBinding methodBinding = null;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l >= 0L) {
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding2 = this.methods[i];
                    bl = false;
                    if (methodBinding2.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (TypeBinding.notEquals(typeBindingArray2[j], typeBindingArray[j])) continue block0;
                    }
                    if (methodBinding != null) {
                        return null;
                    }
                    methodBinding = methodBinding2;
                }
            }
        } else {
            MethodBinding[] methodBindingArray = this.getMethods(cArray);
            bl = methodBindingArray == Binding.NO_METHODS;
            int n3 = methodBindingArray.length;
            block2: while (--n3 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n3];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                for (int i = 0; i < n; ++i) {
                    if (TypeBinding.notEquals(typeBindingArray3[i], typeBindingArray[i])) continue block2;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        if (methodBinding != null) {
            if (methodBinding.hasSubstitutedParameters()) {
                return null;
            }
            return methodBinding;
        }
        if (bl && (this.arguments == null || this.arguments.length <= 1)) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    @Override
    public FieldBinding getField(char[] cArray, boolean bl) {
        FieldBinding fieldBinding;
        if ((this.tagBits & 0x2000L) == 0L && (this.type.tagBits & 0x1000L) != 0L && (fieldBinding = ReferenceBinding.binarySearch(cArray, this.type.unResolvedFields())) == null) {
            return null;
        }
        this.fields();
        return ReferenceBinding.binarySearch(cArray, this.fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if (this.methods != null && (l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n2 = (int)(l >> 32) - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n2];
            System.arraycopy(this.methods, n, methodBindingArray, 0, n2);
            return methodBindingArray;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] methodBindingArray = null;
        try {
            int n;
            MethodBinding[] methodBindingArray2 = this.type.getMethods(cArray);
            int n3 = methodBindingArray2.length;
            if (n3 == 0) {
                MethodBinding[] methodBindingArray3 = Binding.NO_METHODS;
                return methodBindingArray3;
            }
            methodBindingArray = new MethodBinding[n3];
            boolean bl = this.environment.usesNullTypeAnnotations();
            for (n = 0; n < n3; ++n) {
                methodBindingArray[n] = this.createParameterizedMethod(methodBindingArray2[n]);
                if (!bl) continue;
                methodBindingArray[n] = NullAnnotationMatching.checkForContradictions(methodBindingArray[n], null, null);
            }
            if (this.methods == null) {
                MethodBinding[] methodBindingArray4 = new MethodBinding[n3];
                System.arraycopy(methodBindingArray, 0, methodBindingArray4, 0, n3);
                this.methods = methodBindingArray4;
            } else {
                n = n3 + this.methods.length;
                MethodBinding[] methodBindingArray5 = new MethodBinding[n];
                System.arraycopy(methodBindingArray, 0, methodBindingArray5, 0, n3);
                System.arraycopy(this.methods, 0, methodBindingArray5, n3, this.methods.length);
                if (n > 1) {
                    ReferenceBinding.sortMethods(methodBindingArray5, 0, n);
                }
                this.methods = methodBindingArray5;
            }
            MethodBinding[] methodBindingArray6 = methodBindingArray;
            return methodBindingArray6;
        }
        finally {
            if (methodBindingArray == null) {
                methodBindingArray = Binding.NO_METHODS;
                this.methods = Binding.NO_METHODS;
            }
        }
    }

    @Override
    public int getOuterLocalVariablesSlotSize() {
        return this.genericType().getOuterLocalVariablesSlotSize();
    }

    @Override
    public boolean hasMemberTypes() {
        return this.type.hasMemberTypes();
    }

    @Override
    public boolean hasTypeBit(int n) {
        TypeBinding typeBinding = this.erasure();
        if (typeBinding instanceof ReferenceBinding) {
            return ((ReferenceBinding)typeBinding).hasTypeBit(n);
        }
        return false;
    }

    @Override
    protected boolean hasMethodWithNumArgs(char[] cArray, int n) {
        return this.type.hasMethodWithNumArgs(cArray, n);
    }

    @Override
    public boolean implementsMethod(MethodBinding methodBinding) {
        return this.type.implementsMethod(methodBinding);
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        this.type = referenceBinding;
        this.sourceName = referenceBinding.sourceName;
        this.compoundName = referenceBinding.compoundName;
        this.fPackage = referenceBinding.fPackage;
        this.fileName = referenceBinding.fileName;
        this.modifiers = referenceBinding.modifiers & 0xBFFFFFFF;
        if (typeBindingArray != null) {
            this.modifiers |= 0x40000000;
        } else if (this.enclosingType != null) {
            this.modifiers |= this.enclosingType.modifiers & 0x40000000;
            this.tagBits |= this.enclosingType.tagBits & 0x2000000020000080L;
        }
        if (typeBindingArray != null) {
            this.arguments = typeBindingArray;
            for (TypeBinding typeBinding : typeBindingArray) {
                switch (typeBinding.kind()) {
                    case 516: {
                        this.tagBits |= 0x40000000L;
                        if (((WildcardBinding)typeBinding).boundKind == 0) break;
                        this.tagBits |= 0x800000L;
                        break;
                    }
                    case 8196: {
                        this.tagBits |= 0x40800000L;
                        break;
                    }
                    default: {
                        this.tagBits |= 0x800000L;
                    }
                }
                this.tagBits |= typeBinding.tagBits & 0x2000000020000880L;
            }
        }
        this.tagBits |= referenceBinding.tagBits & 0x218000000000089CL;
        this.tagBits &= 0xFFFFFFFFFFFF5FFFL;
    }

    protected void initializeArguments() {
    }

    @Override
    void initializeForStaticImports() {
        this.type.initializeForStaticImports();
    }

    @Override
    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (ParameterizedTypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: {
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                if (TypeBinding.notEquals(this.type, parameterizedTypeBinding.type)) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? TypeBinding.notEquals(referenceBinding, (TypeBinding)typeBindingArray) : !referenceBinding.isEquivalentTo(parameterizedTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                if (this.arguments != ParameterizedSingleTypeReference.DIAMOND_TYPE_ARGUMENTS) {
                    if (this.arguments == null) {
                        return parameterizedTypeBinding.arguments == null;
                    }
                    int n = this.arguments.length;
                    typeBindingArray = parameterizedTypeBinding.arguments;
                    if (typeBindingArray == null || typeBindingArray.length != n) {
                        return false;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (this.arguments[i].isTypeArgumentContainedBy(typeBindingArray[i])) continue;
                        return false;
                    }
                }
                return true;
            }
            case 1028: {
                return TypeBinding.equalsEquals(this.erasure(), typeBinding.erasure());
            }
        }
        return TypeBinding.equalsEquals(this.erasure(), typeBinding);
    }

    @Override
    public boolean isHierarchyConnected() {
        return this.superclass != null && this.superInterfaces != null;
    }

    @Override
    public boolean isProperType(boolean bl) {
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].isProperType(bl)) continue;
                return false;
            }
        }
        return super.isProperType(bl);
    }

    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        ReferenceBinding referenceBinding = this.enclosingType;
        if (!this.isStatic() && this.enclosingType != null) {
            referenceBinding = (ReferenceBinding)this.enclosingType.substituteInferenceVariable(inferenceVariable, typeBinding);
        }
        if (this.arguments != null) {
            TypeBinding[] typeBindingArray = null;
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding2 = this.arguments[i];
                TypeBinding typeBinding3 = typeBinding2.substituteInferenceVariable(inferenceVariable, typeBinding);
                if (!TypeBinding.notEquals(typeBinding3, typeBinding2)) continue;
                if (typeBindingArray == null) {
                    typeBindingArray = new TypeBinding[n];
                    System.arraycopy(this.arguments, 0, typeBindingArray, 0, n);
                }
                typeBindingArray[i] = typeBinding3;
            }
            if (typeBindingArray != null) {
                return this.environment.createParameterizedType(this.type, typeBindingArray, referenceBinding);
            }
        } else if (TypeBinding.notEquals(referenceBinding, this.enclosingType)) {
            return this.environment.createParameterizedType(this.type, this.arguments, referenceBinding);
        }
        return this;
    }

    @Override
    public boolean isRawSubstitution() {
        return this.isRawType();
    }

    @Override
    public TypeBinding unannotated() {
        return this.hasTypeAnnotations() ? this.environment.getUnannotatedType(this) : this;
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.environment.getUnannotatedType(this.type);
        AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
        return this.environment.createParameterizedType(referenceBinding, this.arguments, this.enclosingType, annotationBindingArray);
    }

    @Override
    public int kind() {
        return 260;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceBinding[] memberTypes() {
        if (this.memberTypes == null) {
            try {
                ReferenceBinding[] referenceBindingArray = this.type.memberTypes();
                int n = referenceBindingArray.length;
                ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[n];
                for (int i = 0; i < n; ++i) {
                    referenceBindingArray2[i] = referenceBindingArray[i].isStatic() ? referenceBindingArray[i] : this.environment.createParameterizedType(referenceBindingArray[i], null, this);
                }
                this.memberTypes = referenceBindingArray2;
            }
            finally {
                if (this.memberTypes == null) {
                    this.memberTypes = Binding.NO_MEMBER_TYPES;
                }
            }
        }
        return this.memberTypes;
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (super.mentionsAny(typeBindingArray, n)) {
            return true;
        }
        if (this.arguments != null) {
            int n2 = this.arguments.length;
            for (int i = 0; i < n2; ++i) {
                if (!TypeBinding.notEquals(this.arguments[i], this) || !this.arguments[i].mentionsAny(typeBindingArray, n)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (!TypeBinding.notEquals(this.arguments[i], this)) continue;
                this.arguments[i].collectInferenceVariables(set);
            }
        }
        if (!this.isStatic() && this.enclosingType != null) {
            this.enclosingType.collectInferenceVariables(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodBinding[] methods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        try {
            MethodBinding[] methodBindingArray = this.type.methods();
            int n = methodBindingArray.length;
            MethodBinding[] methodBindingArray2 = new MethodBinding[n];
            boolean bl = this.environment.usesNullTypeAnnotations();
            for (int i = 0; i < n; ++i) {
                methodBindingArray2[i] = this.createParameterizedMethod(methodBindingArray[i]);
                if (!bl) continue;
                methodBindingArray2[i] = NullAnnotationMatching.checkForContradictions(methodBindingArray2[i], null, null);
            }
            this.methods = methodBindingArray2;
        }
        finally {
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
            this.tagBits |= 0x8000L;
        }
        return this.methods;
    }

    @Override
    public int problemId() {
        return this.type.problemId();
    }

    @Override
    public char[] qualifiedPackageName() {
        return this.type.qualifiedPackageName();
    }

    @Override
    public char[] qualifiedSourceName() {
        return this.type.qualifiedSourceName();
    }

    @Override
    public char[] readableName() {
        return this.readableName(true);
    }

    @Override
    public char[] readableName(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().readableName(bl && !this.isStatic()), this.sourceName, '.'));
        } else {
            stringBuffer.append(CharOperation.concatWith(this.type.compoundName, '.'));
        }
        if (bl && this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].readableName());
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        ReferenceBinding referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(this.type, this.environment, false);
        this.tagBits |= referenceBinding.tagBits & 0x800L;
        if (this.arguments != null) {
            int n = this.arguments.length;
            if ((this.type.tagBits & 0x80L) == 0L) {
                this.tagBits &= 0xFFFFFFFFFFFFFF7FL;
                if (this.enclosingType != null) {
                    this.tagBits |= this.enclosingType.tagBits & 0x80L;
                }
            }
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding;
                this.arguments[i] = typeBinding = BinaryTypeBinding.resolveType(this.arguments[i], this.environment, true);
                this.tagBits |= typeBinding.tagBits & 0x880L;
            }
        }
        return this;
    }

    @Override
    public char[] shortReadableName() {
        return this.shortReadableName(true);
    }

    @Override
    public char[] shortReadableName(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().shortReadableName(bl && !this.isStatic()), this.sourceName, '.'));
        } else {
            stringBuffer.append(this.type.sourceName);
        }
        if (bl && this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].shortReadableName());
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        if (bl) {
            return this.nullAnnotatedShortReadableName(compilerOptions);
        }
        return this.nullAnnotatedReadableName(compilerOptions);
    }

    @Override
    char[] nullAnnotatedReadableName(CompilerOptions compilerOptions) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, false));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else if (this.type.compoundName != null) {
            n2 = this.type.compoundName.length;
            for (n = 0; n < n2 - 1; ++n) {
                stringBuffer.append(this.type.compoundName[n]);
                stringBuffer.append('.');
            }
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.type.compoundName[n]);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.type.sourceName != null) {
                stringBuffer.append(this.type.sourceName);
            } else {
                stringBuffer.append(this.type.readableName());
            }
        }
        if (this.arguments != null && this.arguments.length > 0 && !this.isRawType()) {
            stringBuffer.append('<');
            n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].nullAnnotatedReadableName(compilerOptions, false));
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    char[] nullAnnotatedShortReadableName(CompilerOptions compilerOptions) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, true));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.type.sourceName != null) {
                stringBuffer.append(this.type.sourceName);
            } else {
                stringBuffer.append(this.type.shortReadableName());
            }
        }
        if (this.arguments != null && this.arguments.length > 0 && !this.isRawType()) {
            stringBuffer.append('<');
            int n2 = this.arguments.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].nullAnnotatedReadableName(compilerOptions, true));
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] signature() {
        if (this.signature == null) {
            this.signature = this.type.signature();
        }
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        return this.type.sourceName();
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        ParameterizedTypeBinding parameterizedTypeBinding = this;
        while (true) {
            TypeBinding typeBinding;
            TypeVariableBinding[] typeVariableBindingArray;
            int n;
            if (typeVariableBinding.rank < (n = (typeVariableBindingArray = parameterizedTypeBinding.type.typeVariables()).length) && TypeBinding.equalsEquals(typeVariableBindingArray[typeVariableBinding.rank], typeVariableBinding)) {
                if (parameterizedTypeBinding.arguments == null) {
                    parameterizedTypeBinding.initializeArguments();
                }
                if (parameterizedTypeBinding.arguments != null) {
                    if (parameterizedTypeBinding.arguments.length == 0) {
                        return typeVariableBinding;
                    }
                    typeBinding = parameterizedTypeBinding.arguments[typeVariableBinding.rank];
                    return typeVariableBinding.combineTypeAnnotations(typeBinding);
                }
            }
            if (parameterizedTypeBinding.isStatic() || !((typeBinding = parameterizedTypeBinding.enclosingType()) instanceof ParameterizedTypeBinding)) break;
            parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
        }
        return typeVariableBinding;
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            ReferenceBinding referenceBinding = this.type.superclass();
            if (referenceBinding == null) {
                return null;
            }
            this.superclass = (ReferenceBinding)Scope.substitute((Substitution)this, referenceBinding);
            this.typeBits |= this.superclass.typeBits & 0x713;
            if ((this.typeBits & 3) != 0) {
                this.typeBits |= this.applyCloseableClassWhitelists(this.environment.globalOptions);
            }
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            if (this.type.isHierarchyBeingConnected()) {
                return Binding.NO_SUPERINTERFACES;
            }
            this.superInterfaces = Scope.substitute((Substitution)this, this.type.superInterfaces());
            if (this.superInterfaces != null) {
                int n = this.superInterfaces.length;
                while (--n >= 0) {
                    this.typeBits |= this.superInterfaces[n].typeBits & 0x713;
                    if ((this.typeBits & 3) == 0) continue;
                    this.typeBits |= this.applyCloseableInterfaceWhitelists();
                }
            }
        }
        return this.superInterfaces;
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.type == unresolvedReferenceBinding) {
            this.type = referenceBinding;
            bl = true;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            if (referenceBinding2 != null) {
                ReferenceBinding referenceBinding3 = this.enclosingType = referenceBinding.isStatic() ? referenceBinding2 : (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding2);
            }
        }
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.arguments[i] != unresolvedReferenceBinding) continue;
                this.arguments[i] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                bl = true;
            }
        }
        if (bl) {
            this.initialize(this.type, this.arguments);
        }
    }

    @Override
    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        return this.genericType().syntheticEnclosingInstanceTypes();
    }

    @Override
    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.genericType().syntheticOuterLocalVariables();
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.type instanceof UnresolvedReferenceBinding) {
            stringBuffer.append(this.debugName());
        } else {
            int n;
            int n2;
            if (this.isDeprecated()) {
                stringBuffer.append("deprecated ");
            }
            if (this.isPublic()) {
                stringBuffer.append("public ");
            }
            if (this.isProtected()) {
                stringBuffer.append("protected ");
            }
            if (this.isPrivate()) {
                stringBuffer.append("private ");
            }
            if (this.isAbstract() && this.isClass()) {
                stringBuffer.append("abstract ");
            }
            if (this.isStatic() && this.isNestedType()) {
                stringBuffer.append("static ");
            }
            if (this.isFinal()) {
                stringBuffer.append("final ");
            }
            if (this.isRecord()) {
                stringBuffer.append("record ");
            } else if (this.isEnum()) {
                stringBuffer.append("enum ");
            } else if (this.isAnnotationType()) {
                stringBuffer.append("@interface ");
            } else if (this.isClass()) {
                stringBuffer.append("class ");
            } else {
                stringBuffer.append("interface ");
            }
            stringBuffer.append(this.debugName());
            stringBuffer.append("\n\textends ");
            stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
            if (this.superInterfaces != null) {
                if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    stringBuffer.append("\n\timplements : ");
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        if (n > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.superInterfaces[n] != null ? this.superInterfaces[n].debugName() : "NULL TYPE");
                    }
                }
            } else {
                stringBuffer.append("NULL SUPERINTERFACES");
            }
            if (this.enclosingType() != null) {
                stringBuffer.append("\n\tenclosing type : ");
                stringBuffer.append(this.enclosingType().debugName());
            }
            if (this.fields != null) {
                if (this.fields != Binding.NO_FIELDS) {
                    stringBuffer.append("\n/*   fields   */");
                    n2 = this.fields.length;
                    for (n = 0; n < n2; ++n) {
                        stringBuffer.append('\n').append(this.fields[n] != null ? this.fields[n].toString() : "NULL FIELD");
                    }
                }
            } else {
                stringBuffer.append("NULL FIELDS");
            }
            if (this.methods != null) {
                if (this.methods != Binding.NO_METHODS) {
                    stringBuffer.append("\n/*   methods   */");
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        stringBuffer.append('\n').append(this.methods[n] != null ? this.methods[n].toString() : "NULL METHOD");
                    }
                }
            } else {
                stringBuffer.append("NULL METHODS");
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public TypeVariableBinding[] typeVariables() {
        if (this.arguments == null) {
            return this.type.typeVariables();
        }
        return Binding.NO_TYPE_VARIABLES;
    }

    @Override
    public TypeBinding[] typeArguments() {
        return this.arguments;
    }

    @Override
    public FieldBinding[] unResolvedFields() {
        return this.fields;
    }

    @Override
    protected MethodBinding[] getInterfaceAbstractContracts(Scope scope, boolean bl, boolean bl2) throws InvalidInputException {
        if (bl) {
            TypeBinding[] typeBindingArray = this.getNonWildcardParameterization(scope);
            if (typeBindingArray == null) {
                return new MethodBinding[]{new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18)};
            }
            for (int i = 0; i < typeBindingArray.length; ++i) {
                if (!TypeBinding.notEquals(typeBindingArray[i], this.arguments[i])) continue;
                ParameterizedTypeBinding parameterizedTypeBinding = scope.environment().createParameterizedType(this.type, typeBindingArray, this.type.enclosingType());
                TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
                int n = typeVariableBindingArray.length;
                for (int j = 0; j < n; ++j) {
                    if (typeVariableBindingArray[j].boundCheck(parameterizedTypeBinding, typeBindingArray[j], scope, null).isOKbyJLS()) continue;
                    return new MethodBinding[]{new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18)};
                }
                return parameterizedTypeBinding.getInterfaceAbstractContracts(scope, bl, bl2);
            }
        }
        return super.getInterfaceAbstractContracts(scope, bl, bl2);
    }

    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl) {
        return this.getSingleAbstractMethod(scope, bl, -1, -1);
    }

    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl, int n, int n2) {
        int n3;
        int n4;
        int n5 = bl ? (n2 < 0 ? 0 : 1) : (n4 = 2);
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[n4] != null) {
                return this.singleAbstractMethod[n4];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[3];
        }
        if (!this.isValidBinding()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.genericType();
        MethodBinding methodBinding = referenceBinding.getSingleAbstractMethod(scope, bl);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            this.singleAbstractMethod[n4] = methodBinding;
            return this.singleAbstractMethod[n4];
        }
        ParameterizedTypeBinding parameterizedTypeBinding = null;
        TypeBinding[] typeBindingArray = this.arguments;
        if (bl) {
            typeBindingArray = this.getNonWildcardParameterization(scope);
            if (typeBindingArray == null) {
                this.singleAbstractMethod[n4] = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18);
                return this.singleAbstractMethod[n4];
            }
        } else if (typeBindingArray == null) {
            typeBindingArray = NO_TYPES;
        }
        if (n2 >= 0) {
            n3 = typeBindingArray.length;
            for (int i = 0; i < n3; ++i) {
                typeBindingArray[i] = typeBindingArray[i].capture(scope, n, n2);
            }
        }
        parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding, typeBindingArray, referenceBinding.enclosingType());
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n6 = typeVariableBindingArray.length;
        for (n3 = 0; n3 < n6; ++n3) {
            if (typeVariableBindingArray[n3].boundCheck(parameterizedTypeBinding, typeBindingArray[n3], scope, null).isOKbyJLS()) continue;
            this.singleAbstractMethod[n4] = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18);
            return this.singleAbstractMethod[n4];
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)parameterizedTypeBinding.findSuperTypeOriginatingFrom(methodBinding.declaringClass);
        for (MethodBinding methodBinding2 : referenceBinding2.getMethods(methodBinding.selector)) {
            if (!methodBinding2.isAbstract() || methodBinding2.redeclaresPublicObjectMethod(scope)) continue;
            if (methodBinding2.problemId() == 25) {
                methodBinding2 = ((ProblemMethodBinding)methodBinding2).closestMatch;
            }
            this.singleAbstractMethod[n4] = methodBinding2;
            break;
        }
        return this.singleAbstractMethod[n4];
    }

    public TypeBinding[] getNonWildcardParameterization(Scope scope) {
        TypeBinding[] typeBindingArray = this.arguments;
        if (typeBindingArray == null) {
            return NO_TYPES;
        }
        TypeBinding[] typeBindingArray2 = this.genericType().typeVariables();
        TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray.length];
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            if (typeBinding.kind() == 516) {
                if (typeBindingArray2[i].mentionsAny(typeBindingArray2, i)) {
                    return null;
                }
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        int n2;
                        TypeBinding[] typeBindingArray4 = wildcardBinding.otherBounds;
                        TypeBinding[] typeBindingArray5 = ((TypeVariableBinding)typeBindingArray2[i]).otherUpperBounds();
                        int n3 = 1 + (typeBindingArray4 != null ? typeBindingArray4.length : 0) + typeBindingArray5.length;
                        if (((TypeVariableBinding)typeBindingArray2[i]).firstBound != null) {
                            ++n3;
                        }
                        TypeBinding[] typeBindingArray6 = new TypeBinding[n3];
                        int n4 = 0;
                        typeBindingArray6[n4++] = wildcardBinding.bound;
                        if (typeBindingArray4 != null) {
                            for (n2 = 0; n2 < typeBindingArray4.length; ++n2) {
                                typeBindingArray6[n4++] = typeBindingArray4[n2];
                            }
                        }
                        if (((TypeVariableBinding)typeBindingArray2[i]).firstBound != null) {
                            typeBindingArray6[n4++] = ((TypeVariableBinding)typeBindingArray2[i]).firstBound;
                        }
                        for (n2 = 0; n2 < typeBindingArray5.length; ++n2) {
                            typeBindingArray6[n4++] = typeBindingArray5[n2];
                        }
                        Object[] objectArray = Scope.greaterLowerBound(typeBindingArray6, null, this.environment);
                        if (objectArray == null || objectArray.length == 0) {
                            return null;
                        }
                        if (objectArray.length == 1) {
                            typeBindingArray3[i] = objectArray[0];
                            break;
                        }
                        try {
                            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[objectArray.length];
                            System.arraycopy(objectArray, 0, referenceBindingArray, 0, objectArray.length);
                            typeBindingArray3[i] = this.environment.createIntersectionType18(referenceBindingArray);
                            break;
                        }
                        catch (ArrayStoreException arrayStoreException) {
                            scope.problemReporter().genericInferenceError("Cannot compute glb of " + Arrays.toString(objectArray), null);
                            return null;
                        }
                    }
                    case 2: {
                        typeBindingArray3[i] = wildcardBinding.bound;
                        break;
                    }
                    case 0: {
                        typeBindingArray3[i] = ((TypeVariableBinding)typeBindingArray2[i]).firstBound;
                        if (typeBindingArray3[i] != null) break;
                        typeBindingArray3[i] = ((TypeVariableBinding)typeBindingArray2[i]).superclass;
                    }
                }
                continue;
            }
            typeBindingArray3[i] = typeBinding;
        }
        return typeBindingArray3;
    }

    @Override
    public long updateTagBits() {
        if (this.arguments != null) {
            for (TypeBinding typeBinding : this.arguments) {
                this.tagBits |= typeBinding.updateTagBits();
            }
        }
        return super.updateTagBits();
    }
}

